package jp.ac.takushoku_u.cs;

/**
* BooleanMatrixNXł̓}gNX_l(boolean^)ň܂B<BR>
* ܂}gNXm̘_ZsƂł܂B
* @version 1.01
* @author } Tj(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.Matrix
* @see jp.ac.takushoku_u.cs.StringMatrix
*/
/*
* ŏIXV 2004N1102
*/
public class BooleanMatrix extends BasicMatrix{

/**
* }gNXNAƂ̒l
*/
	private static final boolean MATRIX_CLEAR_VALUE = false;

/**
* false̘̎_l
*/
	private static final boolean MATRIX_VALUE_FALSE = false;
	
/**
* true̘̎_l
*/
	private static final boolean MATRIX_VALUE_TRUE = true;


/**
* ݒ肳ĂTCỸf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
*/
	public BooleanMatrix(){
		super();
		clearMatrix();
	}

/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public BooleanMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param nameNumber sї񖼂̊Jnԍ
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public BooleanMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYATCYAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param rowName w肷s
* @param colName w肷
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  rowName ܂ colName  null ̏ꍇ
*/
	public BooleanMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		clearMatrix();
		
		//sї񖼂̃Rs[
		NameRowCopy(rowName);
		NameColCopy(colName);
	}
	
/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param originalMatrix w肷2z
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public BooleanMatrix(boolean[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param originalMatrix w肷2z
* @param nameNumber sї񖼂̊Jnԍ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public BooleanMatrix(boolean[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B
* @param originalMatrix w肷2z
* @param rowName w肷s
* @param colName w肷
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException rowName , colName ܂ originalMatrix  null ̏ꍇ
*/
	public BooleanMatrix(boolean[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//sї񖼂̃Rs[
		NameRowCopy(rowName);
		NameColCopy(colName);
	}

/**
* w肳ꂽ1_֒lݒ肵܂B
* @param row wsԍ
* @param col wԍ
* @param value ݒl
* @exception NotElementException w肵_݂Ȃꍇ
*/
	public void setCell(int row,int col,boolean value){
		if (isMatrixEntityPoint(row, col)){
			Boolean v = new Boolean(value);
			super.setCell(row,col,v);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* }gNXɑ̃}gNX̗vfAsA񖼂̑SĂRs[܂B<BR>
* Rs[̃}gNXTCYƈvȂꍇ̓Rs[̃}gNXTCYɕύXARs[s܂B
* @param originalMatrix Rs[̃}gNX
* @see #MatrixCopy(BooleanMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void MatrixCopy(BooleanMatrix originalMatrix){
		super.MatrixCopy(originalMatrix);
	}
	
/**
* wʒuŊJnwvfRs[̃}gNX̎wʒuɗvfRs[܂B<BR>
* Rs[̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɃRs[s܂B
* Rs[͈̔͂ɓĂ͂܂ȂvfƍsA񖼂͕ύX܂B
* @param originalMatrix Rs[̃}gNX
* @param baseRow Rs[̃}gNXɑ΂Rs[̍sJnʒu
* @param baseCol Rs[̃}gNXɑ΂Rs[̗Jnʒu
* @param copyRow Rs[sJnʒu
* @param copyCol Rs[Jnʒu
* @param rowLength Rs[ss̗vf
* @param colLength Rs[s̗vf
* @exception SetValueOutOfBoundsException Rs[悪݂Ȃ͈͂ɂꍇ
* @see #MatrixCopy(BooleanMatrix originalMatrix)
*/
	public void MatrixCopy(BooleanMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.MatrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				 copyCol, rowLength, colLength);
	}
	
/**
* ێꂽvfύXɃ}gNX̑傫ύX܂B
* }gNXꍇ͎w肵vf傫ȂȂ܂B
* 傫ꍇ傫ꂽ͏lŏA
* sƗ񖼂͂ꂼsԍƗԍɂȂ܂B
* @param rowLength sTCY
* @param colLength TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//}gNX̗vf
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}
	
/**
* }gNXɑ݂vfSfalseɂ܂B
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* w肳ꂽ1_̘_lԂ܂B
* @param row wsԍ
* @param col wԍ
* @return w肵_̒l
* @exception NotElementException w肳ꂽ_݂Ȃꍇ
*/
	public boolean getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			Boolean o = new Boolean(true);
			o = (Boolean)getObjectCell(row,col);
			boolean b = o.booleanValue();
			return b;
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* w肵sɂ_ltruěԂ܂B
* @param row wsԍ
* @return w肵s̍vl
* @exception NotElementException w肵s݂Ȃꍇ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public int getRowSum(int row){
		if (isRowNumber(row)){
			int val = 0;
			for (int i = 0; i < getColLength(); i++){
				if(getCell(row, i) == MATRIX_VALUE_TRUE){
				val = val + 1;
				}
			}
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* eŝꂼ̘_ltruězŕԂ܂B
* @return es̍vlz
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public int[] getRowSumArray(){
		int[] returnArray = new int[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* w肵ɂ_ltruě̍vԂ܂B
* @param col wԍ
* @return w肵̍vl
* @exception NotElementException w肵񂪑݂Ȃꍇ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public int getColSum(int col){
		if (isColNumber(col)){
			int val = 0;
			for (int i = 0; i < getRowLength(); i++){
				if(getCell(i,col) == MATRIX_VALUE_TRUE){
				val = val + 1;
				}
			}
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* êꂼ̘_ltruězŕԂ܂B
* @return e̍vlz
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public int[] getColSumArray(){
		int[] returnArray = new int[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* }gNXɑ݂vf̂Avftruełvf̐Ԃ܂B
* @return vf
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_TRUE){		//truełvf𐔂
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* BooleanMatrixMatrix^012lŕϊ܂B
* true1Afalse0Ƃ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽMatrix
* @see #toMatrix(double val)
* @see #toStringMatrix()
*/
	public Matrix toMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_FALSE){
					returnMatrix.setCell(i, j, 0);
				}
				else{
					returnMatrix.setCell(i, j, 1);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* BooleanMatrixMatrix^0val2lŕϊ܂B
* truevalAfalse0Ƃ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @param val ϊl
* @return ϊꂽMatrix
* @see #toMatrix()
* @see #toStringMatrix()
*/
	public Matrix toMatrix(double val){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_FALSE){
					returnMatrix.setCell(i, j, 0);
				}
				else{
					returnMatrix.setCell(i, j, val);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* BooleanMatrixStringMatrix^ɕϊ܂B
* true𕶎"true"ɁAfalse͕"false"ɂȂ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽMatrix
* @see #toMatrix()
* @see #toMatrix(double val)
*/
	public StringMatrix toStringMatrix(){
		StringMatrix returnMatrix = new StringMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Boolean.toString(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2̃}gNX̃TCY`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	public boolean isSameMatrixSize(BooleanMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2̃}gNX̃TCYZsƂł邩`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	private boolean isMultiplyMatrixSize(BooleanMatrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* ̃}gNXƂ̘_(And)Ԃ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getAndMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_ς߂
					returnMatrix.setCell(i, j, getCell(i,j) &
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̘_a(OR)Ԃ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getOrMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_a߂
					returnMatrix.setCell(i, j, getCell(i,j) |
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̔rI_a(eXclusive OR)Ԃ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getXOrMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩ǂ
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̔rI_a߂
					returnMatrix.setCell(i, j, getCell(i,j) ^
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̔ے(NOT)Ԃ܂B
* @return Zʂ̃}gNX
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
*/
	public BooleanMatrix getNotMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//_l̃}gNXɕϊ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ے̉Zs
					if (getCell(i,j) == MATRIX_VALUE_FALSE){
						returnMatrix.setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						returnMatrix.setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* }gNXm̐ςvZ}gNXԂ܂B<BR>
* Z }gNX ~ calculateMatrix ōs܂B
* Ԃ}gNX̃TCY͉Z̃}gNX̍sTCY~ZΏۂ̃}gNX̗TCYƂȂ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYZsȂTCY̏ꍇ
*/
	public BooleanMatrix getMultiplyMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//Zs邩ǂ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//s̏Zs
					//vZ a_i1 * a_1j + a_i2 * a_2j + c + a_in * a_nj
					boolean value = false;
					for (int k = 0; k < getColLength(); k++){
						value = (getCell(i, k) & calculateMatrix.getCell(k, j)) | value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetwƂׂvZ}gNXԂ܂B
* @param exponent ݏ̎w
* @return n}gNX
* @exception SetValueOutOfBoundsException w0ȉ̒lw肵ꍇ
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public BooleanMatrix getExponentMatrix(int exponent){
		BooleanMatrix initMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		BooleanMatrix returnMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//s񂩂ǂA܂w0ȉ̒lw肳ꂽꍇ
		if (isSquare()){
			if (exponent > 0){
			
				//̃}gNXnZ(1̏ꍇ͌̃}gNX̂܂)
				for (int i = 1; i < exponent; i++){
				
					//i悵}gNXɌ̃}gNX|Ai+1ɂ
					returnMatrix.MatrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//w0ȉ̒lw肳ꂽꍇ
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̗vfPʃ}gNXɕύX܂B
* BooleanMatrix̒Pʃ}gNX͑ΊpvfStrueł}gNXłB
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//Ίp̂true
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ̃}gNXƓTCY̒Pʃ}gNX𐶐܂B
* @return Pʍs
*/
	private BooleanMatrix getElementaryMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* }gNXאڃ}gNXƂ̉B}gNXԂ܂B
* @return B}gNX
* @exception NotSquareMatrixException }gNXsł͂Ȃꍇ
*/
	public BooleanMatrix getReachMatrix(){
		
		//s񂩂ǂ
		if (isSquare()){
		//̃}gNXאڃ}gNXƂĐ
		BooleanMatrix returnMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//PʍsƂ̘_a
		returnMatrix.MatrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1悷
		// (I + A)n-1 I͒Pʍs +͘_a
		returnMatrix.MatrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//_l̃}gNXɕϊ
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* }gNX̓]u}gNXԂ܂B
* Ԃꂽ}gNX̍sƗ񖼂͂ꂼꂪւ́is񖼂ɗ񖼂sɁjɂȂ܂B
* @return ]u}gNX
*/
	public BooleanMatrix getTransposedMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getColLength(), getRowLength(),
			getColNameArray(), getRowNameArray());
		for(int i = 0; i < returnMatrix.getRowLength(); i++){
			for(int j = 0; j < returnMatrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCell(j, i));
			}
		}
		return returnMatrix;
	}
	
/**
* }gNX̗vf2zŕԂ܂B
* @return vf2z
*/
	public boolean[][] getMatrix(){
		Boolean b[][] = new Boolean[getRowLength()][getColLength()];
		boolean bo[][] = new boolean[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				b[i][j] = (Boolean)o[i][j];
				bo[i][j] = b[i][j].booleanValue();
			}
		}
		return bo;
	}
}