package jp.ac.takushoku_u.cs;

/**
* BooleanMatrix饹Ǥϥޥȥꥯ(boolean)ǰޤ<BR>
* ޤޥȥꥯƱΤ黻ԤȤǤޤ
* @version 1.01
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.Matrix
* @see jp.ac.takushoku_u.cs.StringMatrix
*/
/*
* ǽ 2004ǯ1102
*/
public class BooleanMatrix extends BasicMatrix{

/**
* ޥȥꥯ򥯥ꥢȤ
*/
	private static final boolean MATRIX_CLEAR_VALUE = false;

/**
* falseλ
*/
	private static final boolean MATRIX_VALUE_FALSE = false;
	
/**
* trueλ
*/
	private static final boolean MATRIX_VALUE_TRUE = true;


/**
* ꤵƤ륵Υǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾Ϲֹֹꤵޤ
*/
	public BooleanMatrix(){
		super();
		clearMatrix();
	}

/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾Ϲֹֹꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public BooleanMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param nameNumber ̾̾γֹ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public BooleanMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  rowName ޤ colName  null ξ
*/
	public BooleanMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		clearMatrix();
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}
	
/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param originalMatrix ꤹ2
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public BooleanMatrix(boolean[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param originalMatrix ꤹ2
* @param nameNumber ̾̾γֹ
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public BooleanMatrix(boolean[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2󡢹̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ
* @param originalMatrix ꤹ2
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception IndexOutOfBoundsException ԡˤäζۤǡΥ
* @exception NullPointerException rowName , colName ޤ originalMatrix  null ξ
*/
	public BooleanMatrix(boolean[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}

/**
* ꤵ줿1ͤꤷޤ
* @param row ֹ
* @param col ֹ
* @param value 
* @exception NotElementException ꤷ¸ߤʤ
*/
	public void setCell(int row,int col,boolean value){
		if (isMatrixEntityPoint(row, col)){
			Boolean v = new Boolean(value);
			super.setCell(row,col,v);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* ޥȥꥯ¾Υޥȥꥯǡ̾̾Ƥ򥳥ԡޤ<BR>
* ԡΥޥȥꥯȰפʤϥԡΥޥȥꥯѹԡԤޤ
* @param originalMatrix ԡΥޥȥꥯ
* @see #MatrixCopy(BooleanMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void MatrixCopy(BooleanMatrix originalMatrix){
		super.MatrixCopy(originalMatrix);
	}
	
/**
* ֤ǳϤǤ饳ԡΥޥȥꥯλ֤Ǥ򥳥ԡޤ<BR>
* ԡ( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˥ԡԤޤ
* ԡϰϤƤϤޤʤǤȹ̾̾ѹޤ
* @param originalMatrix ԡΥޥȥꥯ
* @param baseRow ԡΥޥȥꥯФ륳ԡιԳϰ
* @param baseCol ԡΥޥȥꥯФ륳ԡ󳫻ϰ
* @param copyRow ԡԳϰ
* @param copyCol ԡ󳫻ϰ
* @param rowLength ԡԤԤǿ
* @param colLength ԡԤǿ
* @exception SetValueOutOfBoundsException ԡ褬¸ߤʤϰϤˤ
* @see #MatrixCopy(BooleanMatrix originalMatrix)
*/
	public void MatrixCopy(BooleanMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.MatrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				 copyCol, rowLength, colLength);
	}
	
/**
* ݻ줿Ǥѹ˥ޥȥꥯ礭ѹޤ
* ޥȥꥯ򾮤ϻꤷǤ礭ʬʤʤޤ
* 礭礭줿ʬϽͤǽ졢
* ̾̾Ϥ줾ֹֹˤʤޤ
* @param rowLength ԥ
* @param colLength 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//ޥȥꥯǤ
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}
	
/**
* ޥȥꥯ¸ߤǤfalseˤޤ
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* ꤵ줿1֤ͤޤ
* @param row ֹ
* @param col ֹ
* @return ꤷ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public boolean getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			Boolean o = new Boolean(true);
			o = (Boolean)getObjectCell(row,col);
			boolean b = o.booleanValue();
			return b;
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* ꤷԤˤͤtrueθĿ֤ޤ
* @param row ֹ
* @return ꤷԤι
* @exception NotElementException ꤷԤ¸ߤʤ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public int getRowSum(int row){
		if (isRowNumber(row)){
			int val = 0;
			for (int i = 0; i < getColLength(); i++){
				if(getCell(row, i) == MATRIX_VALUE_TRUE){
				val = val + 1;
				}
			}
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ƹԤΤ줾ͤtrueθĿ֤ޤ
* @return ƹԤιͤä
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public int[] getRowSumArray(){
		int[] returnArray = new int[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* ꤷˤͤtrueθĿιפ֤ޤ
* @param col ֹ
* @return ꤷι
* @exception NotElementException ꤷ¸ߤʤ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public int getColSum(int col){
		if (isColNumber(col)){
			int val = 0;
			for (int i = 0; i < getRowLength(); i++){
				if(getCell(i,col) == MATRIX_VALUE_TRUE){
				val = val + 1;
				}
			}
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* Τ줾ͤtrueθĿ֤ޤ
* @return ιͤä
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public int[] getColSumArray(){
		int[] returnArray = new int[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* ޥȥꥯ¸ߤǤΤǤtrueǤǤο֤ޤ
* @return ǿ
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_TRUE){		//trueǤǿ
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* BooleanMatrixMatrix012ͤѴޤ
* true1false0Ȥޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿Matrix
* @see #toMatrix(double value)
* @see #toStringMatrix()
*/
	public Matrix toMatrix(){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_FALSE){
					returnMatrix.setCell(i, j, 0);
				}
				else{
					returnMatrix.setCell(i, j, 1);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* BooleanMatrixMatrix0value2ͤѴޤ
* truevalfalse0Ȥޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @param value Ѵ
* @return Ѵ줿Matrix
* @see #toMatrix()
* @see #toStringMatrix()
*/
	public Matrix toMatrix(double value){
		Matrix returnMatrix = new Matrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) == MATRIX_VALUE_FALSE){
					returnMatrix.setCell(i, j, 0);
				}
				else{
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		return returnMatrix;
	}
	
/**
* BooleanMatrixStringMatrixѴޤ
* trueʸ"true"ˡfalseʸ"false"ˤʤޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿Matrix
* @see #toMatrix()
* @see #toMatrix(double value)
*/
	public StringMatrix toStringMatrix(){
		StringMatrix returnMatrix = new StringMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Boolean.toString(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2ĤΥޥȥꥯΥƱåޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	public boolean isSameMatrixSize(BooleanMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2ĤΥޥȥꥯΥ軻ԤȤǤ뤫åޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	private boolean isMultiplyMatrixSize(BooleanMatrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* ¾ΥޥȥꥯȤ(And)֤ޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getAndMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤѤ
					returnMatrix.setCell(i, j, getCell(i,j) &
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ(OR)֤ޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getOrMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¤
					returnMatrix.setCell(i, j, getCell(i,j) |
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ¾Ū(eXclusive OR)֤ޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public BooleanMatrix getXOrMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¾Ū¤
					returnMatrix.setCell(i, j, getCell(i,j) ^
						 calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯ(NOT)֤ޤ
* @return 黻̤Υޥȥꥯ
* @see #getAndMatrix(BooleanMatrix calculateMatrix)
* @see #getOrMatrix(BooleanMatrix calculateMatrix)
* @see #getXOrMatrix(BooleanMatrix calculateMatrix)
*/
	public BooleanMatrix getNotMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//ͤΥޥȥꥯѴ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//α黻Ԥ
					if (getCell(i,j) == MATRIX_VALUE_FALSE){
						returnMatrix.setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						returnMatrix.setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* ޥȥꥯƱΤѤ׻ޥȥꥯ֤ޤ<BR>
* 黻 ޥȥꥯ  calculateMatrix ǹԤޤ
* ֤ޥȥꥯΥϱ黻Υޥȥꥯιԥ߱黻оݤΥޥȥꥯ󥵥Ȥʤޤ
* @param calculateMatrix 軻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥ黻Ԥʤξ
*/
	public BooleanMatrix getMultiplyMatrix(BooleanMatrix calculateMatrix){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//ξ軻Ԥ
					//׻ a_i1 * a_1j + a_i2 * a_2j +  + a_in * a_nj
					boolean value = false;
					for (int k = 0; k < getColLength(); k++){
						value = (getCell(i, k) & calculateMatrix.getCell(k, j)) | value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetؿȤ٤׻ޥȥꥯ֤ޤ
* @param exponent ߾λؿ
* @return n򤷤ޥȥꥯ
* @exception SetValueOutOfBoundsException ؿ0ʲͤꤷ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public BooleanMatrix getExponentMatrix(int exponent){
		BooleanMatrix initMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		BooleanMatrix returnMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//󤫤ɤޤؿ0ʲͤꤵ줿
		if (isSquare()){
			if (exponent > 0){
			
				//Υޥȥꥯn軻(1ξϸΥޥȥꥯΤޤ)
				for (int i = 1; i < exponent; i++){
				
					//i褷ޥȥꥯ˸Υޥȥꥯݤi+1ˤ
					returnMatrix.MatrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//ؿ0ʲͤꤵ줿
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯǤñ̥ޥȥꥯѹޤ
* BooleanMatrixñ̥ޥȥꥯгǤtrueǤޥȥꥯǤ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//гʬΤtrue
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ΥޥȥꥯƱñ̥ޥȥꥯޤ
* @return ñ̹
*/
	private BooleanMatrix getElementaryMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* ޥȥꥯܥޥȥꥯȤβãޥȥꥯ֤ޤ
* @return ãޥȥꥯ
* @exception NotSquareMatrixException ޥȥꥯǤϤʤ
*/
	public BooleanMatrix getReachMatrix(){
		
		//󤫤ɤ
		if (isSquare()){
		//ΥޥȥꥯܥޥȥꥯȤ
		BooleanMatrix returnMatrix = new BooleanMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//ñ̹Ȥ¤
		returnMatrix.MatrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1褹
		// (I + A)n-1 Iñ̹ +
		returnMatrix.MatrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//ͤΥޥȥꥯѴ
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ޥȥꥯž֥ޥȥꥯ֤ޤ
* ֤줿ޥȥꥯι̾̾Ϥ줾줬ؤäΡʹ̾̾̾̾ˡˤˤʤޤ
* @return ž֥ޥȥꥯ
*/
	public BooleanMatrix getTransposedMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getColLength(), getRowLength(),
			getColNameArray(), getRowNameArray());
		for(int i = 0; i < returnMatrix.getRowLength(); i++){
			for(int j = 0; j < returnMatrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCell(j, i));
			}
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯǤ2֤ޤ
* @return Ǥ2
*/
	public boolean[][] getMatrix(){
		Boolean b[][] = new Boolean[getRowLength()][getColLength()];
		boolean bo[][] = new boolean[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				b[i][j] = (Boolean)o[i][j];
				bo[i][j] = b[i][j].booleanValue();
			}
		}
		return bo;
	}
}