package jp.ac.takushoku_u.cs;

/**
* TaskSequence饹ϳؽˡԤΥ饹Ǥ<BR>
* 󲽤Ԥ˲۹ܤɬפǤ깽¤ξǤäƤ⡢
* ưŪ˲۹ܤͿ󲽤ԤȤǤޤ
* ۹ܤ0ܤ0ܤͿ졢̾̾Ϥ`Dummy'Ȥʤޤ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1116
*/
public class TaskSequence{
	
/**
* 󲽤Ԥܥޥȥꥯ(۹ܤʤ)
*/
	private Matrix baseMatrix;
/**
* 󲽤Ԥܥޥȥꥯ(۹)
*/	
	private Matrix matrix;
	
/**
* ۹ܤͿѿ
*/
	private boolean giveDummy = false;
	
/**
* եν
*/
	private static final double TASK_SEQUENCE_ALPHA = 0.5;
	
/**
* ١ν
*/
	private static final double TASK_SEQUENCE_BETA = 0.5;
	
/**
* ͭޤ뤳Ȥ򼨤
*/
	private static final double TASK_SEQUENCE_TRUE = 1.0;
	
/**
* ͭޤʤȤ򼨤
*/
	private static final double TASK_SEQUENCE_FALSE = 0.0;
	
/**
* ޥȥꥯν
*/
	private static final int TASK_SEQUENCE_MATRIX_SIZE = 5;
	
/**
* ǥեȤꤵƤͤǷ󲽤Ԥܥޥȥꥯꤷޤ
*/
	public TaskSequence(){
		baseMatrix = new Matrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
		matrix = new Matrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
	}
	
/**
* 󲽤Ԥܥޥȥꥯꤷޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
*/
	public TaskSequence(Matrix adjacencyMatrix){
		baseMatrix = new Matrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		matrix = new Matrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		setMatrix(adjacencyMatrix);
	}
	
	
/**
* ܥޥȥꥯ֤ޤ
* @return ܥޥȥꥯ
* @see #getDummyMatrix()
*/
	public Matrix getMatrix(){
		return baseMatrix;
	}
	
/**
* ۹ܹߤܥޥȥꥯ֤ޤ
* ۹ܤͿʤȤ褤ܥޥȥꥯξgetMatrix()Ʊޥȥꥯ֤ޤ
* @return ۹ܤͿܥޥȥꥯ
* @see #getMatrix()
*/
	public Matrix getDummyMatrix(){
		return matrix;
	}
	
/**
* ãޥȥꥯޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ãޥȥꥯ
*/
	public Matrix getReachMatrix(){
		return getReachMatrix(matrix);
	}
	
/**
* ܥޥȥꥯãޥȥꥯޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @return ãޥȥꥯ
*/
	private Matrix getReachMatrix(Matrix adjacencyMatrix){
		Matrix returnMatrix = new Matrix(adjacencyMatrix.getRowLength(),
			adjacencyMatrix.getColLength(), adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		return adjacencyMatrix.getReachMatrix();
	}
	
/**
* ޥȥꥯޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ޥȥꥯ
*/
	public Matrix getFMatrix(){
		Matrix reachMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.MatrixCopy(getReachMatrix(matrix));
		
		return getFMatrix(reachMatrix);
	}
	
/**
* ãޥȥꥯޥȥꥯޤ
* @param ãޥȥꥯ
* @return ޥȥꥯ
*/
	private Matrix getFMatrix(Matrix reachMatrix){
		Matrix returnMatrix = new Matrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		Matrix TMatrix = new Matrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.MatrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.MatrixCopy(TMatrix.getMultiplyMatrix(reachMatrix));
		return returnMatrix;
	}
	
/**
* ɸޥȥꥯޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ɸޥȥꥯ
*/
	public Matrix getGMatrix(){
		Matrix reachMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.MatrixCopy(getReachMatrix(matrix));
		
		return getGMatrix(reachMatrix);
	}
	
/**
* ãޥȥꥯɸޥȥꥯޤ
* @param ãޥȥꥯ
* @return ɸޥȥꥯ
*/
	private Matrix getGMatrix(Matrix reachMatrix){
		Matrix returnMatrix = new Matrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		Matrix TMatrix = new Matrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.MatrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.MatrixCopy(reachMatrix.getMultiplyMatrix(TMatrix));
		return returnMatrix;
	}
	
/**
* ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ҡޥȥꥯ
*/
	public Matrix getCoherenceMatrix(){
		Matrix FMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Matrix GMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.MatrixCopy(getFMatrix());
		GMatrix.MatrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix);
	}
	
/**
* ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @param alpha ե
* @param beta ١
* @return ҡޥȥꥯ
*/
	public Matrix getCoherenceMatrix(double alpha, double beta){
		Matrix FMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Matrix GMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.MatrixCopy(getFMatrix());
		GMatrix.MatrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix, alpha, beta);
	}
	
/**
* ޥȥꥯȹɸޥȥꥯ饳ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* @param FMatrix ޥȥꥯ
* @param GMatrix ɸޥȥꥯ
* @return ҡޥȥꥯ
* 
*/
	private Matrix getCoherenceMatrix(Matrix FMatrix, Matrix GMatrix){
		return FMatrix.getAddMatrix(GMatrix);
	}
	
/**
* ޥȥꥯȹɸޥȥꥯ饳ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* @param FMatrix ޥȥꥯ
* @param GMatrix ɸޥȥꥯ
* @param alpha ե
* @param beta ١
* @return ҡޥȥꥯ
* 
*/
	private Matrix getCoherenceMatrix(Matrix FMatrix, Matrix GMatrix, double alpha, double beta){
		Matrix Fm = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Matrix Gm = new Matrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Fm.MatrixCopy(FMatrix.getTimesMatrix(alpha));
		Gm.MatrixCopy(GMatrix.getTimesMatrix(beta));
		return Fm.getAddMatrix(Gm);
	}
	
/**
* 󲽤줿ֹ֤ޤ
* եȥ١ͤϥǥեͤȤʤޤ
* @return 󲽤줿Ǽ
*/
	public int[] getTaskSequenceArray(){
		return getTaskSequenceArray(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* 󲽤줿ֹ֤ޤ
* ȤϷ󲽤줿ܥޥȥꥯιֹǤ
* @param alpha ե
* @param beta ١
* @return 󲽤줿Ǽ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public int[] getTaskSequenceArray(double alpha, double beta){
		
		//եȥ١Ŭɤ
		if(isNormalIndex(alpha, beta)){
			
			//ãޥȥꥯ
			Matrix reachMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			reachMatrix.MatrixCopy(getReachMatrix(matrix));
			
			//ҡޥȥꥯ
			Matrix CMatrix = new Matrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			CMatrix.MatrixCopy(getCoherenceMatrix(alpha, beta));
			
			//̤֤
			int[] returnArray;
			
			//ǽܤä
				boolean[] el = new boolean[reachMatrix.getRowLength()];
			
			//۹ܤꤷ
			if(isDummy()){
				returnArray = new int[reachMatrix.getRowLength()-1];
				
				//
				int item = 0;
				
				//ܤ򤹤
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength() -1; i++){
					if(el[i]){
						item = i;
					}
				}
				
				//¤
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//󲽤򤹤
				for(int i = 0;i < reachMatrix.getRowLength()-1; i++){
					
					//򤵤Ƥܤ鼡򤹤ܤõ
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item -1;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			
			//۹ܤ̵
			else{
				returnArray = new int[reachMatrix.getRowLength()];
				
				//
				int item = 0;
				
				//ܤ򤹤
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength(); i++){
					if(el[i]){
						item = i;
					}
				}
				returnArray[0] = item;
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//󲽤򤹤
				for(int i = 1;i < reachMatrix.getRowLength(); i++){
					
					//򤵤Ƥܤ鼡򤹤ܤõ
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			return returnArray;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* 󲽤줿ֹSequence֤ޤ
* եȥ١ͤϥǥեͤˤʤޤ
* @return 󲽤줿Ǽ
*/
	public Sequence getTaskSequence(){
		return getTaskSequence(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* 󲽤줿ֹSequence֤ޤ
* @param alpha ե
* @param beta ١
* @return 󲽤줿Ǽ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public Sequence getTaskSequence(double alpha, double beta){
		
		//եȥ١Ŭɤ
		if(isNormalIndex(alpha, beta)){
			Sequence seq = new Sequence(getTaskSequenceArray(alpha, beta));
			for(int i = 0; i < seq.getLength(); i++){
				seq.setItemName(i, baseMatrix.getRowName(seq.getItem(i)));
			}
			return seq;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* ãޥȥꥯ¾ǤزãǤ뤬¾Ǥ餽ǤؤϲãǤϤʤǤõޤ
* ̤ϥǿboolean֤ޤ
* @param reachMatrix ãޥȥꥯ
* @return ̤
*/
	private boolean[] getReachElement(Matrix reachMatrix){
		boolean[] returnArray = new boolean[reachMatrix.getRowLength()];
		for(int i = 0; i < reachMatrix.getRowLength(); i++){
			int count = 0;
			for(int j = 0; j < reachMatrix.getColLength(); j++){
				if(reachMatrix.getCell(j,i) == TASK_SEQUENCE_TRUE){
					count++;
				}
			}
			
			if(count == 1){
				returnArray[i] = true;
			}
			else{
				returnArray[i] = false;
			}
		}
		
		return returnArray;
	}
	
/**
* ǽܤä󤫤򤵤ܤõޤ
* @param item 򤹤
* @param choiceArray ǽܤä
* @param coherenceMatrix ҡޥȥꥯ
* @return 򤵤
*/
	private int getItemNumber(int item, boolean[] choiceArray, Matrix coherenceMatrix){
		int itemNumber = 0;
		double val = Double.NEGATIVE_INFINITY;
		for(int i = 0; i < choiceArray.length; i++){
			if(choiceArray[i] && coherenceMatrix.getCell(item, i) > val){
				val = coherenceMatrix.getCell(item, i);
				itemNumber = i;
			}
		}
		
		return itemNumber;
	}
	
/**
* եȥ١ͤŬɤåޤ
* @param alpha ե
* @param beta ١
* @return ͤŬǤtrue
*/
	private boolean isNormalIndex(double alpha, double beta){
		boolean condition = (Math.abs(alpha) + Math.abs(beta) == 1.0);
		boolean condition2 = ((0.0 <= Math.abs(alpha)) && (Math.abs(alpha) <= 1.0));
		boolean condition3 = ((0.0 <= Math.abs(beta)) && (Math.abs(beta) <= 1.0));
		return condition && condition2 && condition3;
	}
	
/**
* ۹ܤɬפɤåޤ
* @param adjacencyMatrix Ĵ٤ܥޥȥꥯ
* @return ۹ܤɬפǤtrue
*/
	private boolean needDummy(Matrix adjacencyMatrix){
		Matrix RMatrix = new Matrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength(),
			adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		RMatrix.MatrixCopy(adjacencyMatrix.getReachMatrix());
		
		boolean[] el = new boolean[RMatrix.getRowLength()];
		System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
		int count = 0;
		for(int i = 0; i < el.length; i++){
			if(el[i]){
				count++;
			}
		}
		
		//ܤ1Ķ
		return count > 1;
	}
	
/**
* ܥޥȥꥯꤷޤ
* @param m ꤹܥޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
*/
	public void setMatrix(Matrix m){
		if(m.isSquare()){
		baseMatrix.MatrixCopy(m);
		setDummy();
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ۹ܤꤷޤ
*/
	private void setDummy(){
		matrix.MatrixCopy(baseMatrix);
		if(needDummy(baseMatrix)){
			giveDummy = true;
			matrix.reSizeMatrix(baseMatrix.getRowLength()+1, baseMatrix.getColLength()+1);
			matrix.MatrixMove(0, 0, 1, 1, baseMatrix.getRowLength(), baseMatrix.getColLength());
			matrix.rowNameMove(0, 1, baseMatrix.getRowLength());
			matrix.colNameMove(0, 1, baseMatrix.getColLength());
			matrix.setRowName(0, "Dummy");
			matrix.setColName(0, "Dummy");
			
			Matrix RMatrix = new Matrix(baseMatrix.getRowLength(), baseMatrix.getColLength(),
				baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
			RMatrix.MatrixCopy(baseMatrix.getReachMatrix());
			
			for(int i = 0; i < matrix.getColLength(); i++){
				matrix.setCell(i, 0, TASK_SEQUENCE_FALSE);
			}
			
			boolean[] el = new boolean[RMatrix.getRowLength()];
			System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
			for(int i = 1; i < el.length+1; i++){
				if(el[i-1]){
					matrix.setCell(0, i, TASK_SEQUENCE_TRUE);
				}
				else{
					matrix.setCell(0, i, TASK_SEQUENCE_FALSE);
				}
			}
		}
		else{
			giveDummy = false;
		}
	}
	
/**
* ۹ܤꤷ֤ޤ
* @return ۹ܤꤷtrue
*/
	public boolean isDummy(){
		return giveDummy;
	}
	
/**
* ͤޤ
* ֤ͤϺɸǤ
* @return 
*/
	private int getRegular(){
		Matrix reachMatrix = new Matrix();
		reachMatrix.MatrixCopy(matrix.getReachMatrix());
		double max = 0.0;
		int maxIndex = 0;
		double count = 0.0;
		for(int i = 0; i < matrix.getColLength(); i++){
			count = reachMatrix.getColSum(i);
			if(count > max){
				maxIndex = i;
				max = count;
			}
		}
		return (int)count;
	}
}