package jp.ac.takushoku_u.cs;

/**
* ArithmeticMatrixNXłdouble^̗vf}gNX܂B<BR>
* }gNX̓̕f[^sƗ񖼂tĕێł悤ɂȂ܂B
* ܂}gNXm̉ZsƂł܂B<BR>
* @version 1.3
* @author } Tj(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.BooleanMatrix
* @see jp.ac.takushoku_u.cs.StringMatrix
*/
/*
* ŏIXV 2004N1124
*/
public class ArithmeticMatrix extends Matrix{
	
/**
* }gNXNAƂ̒lB
*/
	private static final double MATRIX_CLEAR_VALUE = 0.0;
	
/**
* False鎞̘_lB
*/
	private static final double MATRIX_VALUE_FALSE = 0.0;
	
/**
* True鎞̘_lB
*/
	private static final double MATRIX_VALUE_TRUE = 1.0;


/**
* ݒ肳ĂTCỸf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
*/
	public ArithmeticMatrix(){
		super();
		clearMatrix();
	}

/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public ArithmeticMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* ꂽ2z͑S0ŏ܂B
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param nameNumber sї񖼂̊Jnԍ
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public ArithmeticMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYATCYAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param rowName w肷s
* @param colName w肷
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  rowName ܂ colName  null ̏ꍇ
*/
	public ArithmeticMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		clearMatrix();
		
		//sї񖼂̃Rs[
		nameRowCopy(rowName);
		nameColCopy(colName);
	}
	
/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param originalMatrix w肷2z
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public ArithmeticMatrix(double[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param originalMatrix w肷2z
* @param nameNumber sї񖼂̊Jnԍ
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public ArithmeticMatrix(double[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B
* @param originalMatrix w肷2z
* @param rowName w肷s
* @param colName w肷
* @exception IndexOutOfBoundsException Rs[ɂĔz̋Ezf[^̃ANZXꍇ
* @exception NullPointerException  rowName , colName ܂ originalMatrix  null ̏ꍇ
*/
	public ArithmeticMatrix(double[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//sї񖼂̃Rs[
		nameRowCopy(rowName);
		nameColCopy(colName);
	}

/**
* ێꂽvfύXɃ}gNX̑傫ύX܂B
* }gNXꍇ͎w肵vf傫ȂȂ܂B
* 傫ꍇ傫ꂽ͏lŏA
* sƗ񖼂͂ꂼsԍƗԍɂȂ܂B
* @param rowLength sTCY
* @param colLength TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//}gNX̗vf
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}
	
/**
* w肳ꂽ1_֒lݒ肵܂B
* @param row wsԍ
* @param col wԍ
* @param value ݒl
* @exception NotElementException w肵_݂Ȃꍇ
*/
	public void setCell(int row,int col,double value){
		if (isMatrixEntityPoint(row, col)){
			Double d = new Double(value);
			super.setCell(row, col, d);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* }gNXɑ̃}gNX̗vfAsA񖼂̑SĂRs[܂B<BR>
* Rs[̃}gNXTCYƈvȂꍇ̓Rs[̃}gNXTCYɕύXARs[s܂B
* @param originalMatrix Rs[̃}gNX
* @see #matrixCopy(ArithmeticMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(ArithmeticMatrix originalMatrix){
		super.matrixCopy(originalMatrix);
	}
	
/**
* wʒuŊJnwvfRs[̃}gNX̎wʒuɗvfRs[܂B<BR>
* Rs[̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɃRs[s܂B
* Rs[͈̔͂ɓĂ͂܂ȂvfƍsA񖼂͕ύX܂B
* @param originalMatrix Rs[̃}gNX
* @param baseRow Rs[̃}gNXɑ΂Rs[̍sJnʒu
* @param baseCol Rs[̃}gNXɑ΂Rs[̗Jnʒu
* @param copyRow Rs[sJnʒu
* @param copyCol Rs[Jnʒu
* @param rowLength Rs[ss̗vf
* @param colLength Rs[s̗vf
* @exception SetValueOutOfBoundsException Rs[悪݂Ȃ͈͂ɂꍇ
* @see #matrixCopy(ArithmeticMatrix originalMatrix)
*/
	public void matrixCopy(ArithmeticMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.matrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				copyCol, rowLength, colLength);
	}
	
/**
* }gNXɑ݂vfS0ɂ܂B
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* w肳ꂽ1_̒lԂ܂B
* @param row wsԍ
* @param col wԍ
* @return w肵_̒l
* @exception NotElementException w肳ꂽ_݂Ȃꍇ
*/
	public double getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			Double d = new Double(0.0);
			d = (Double)getObjectCell(row,col);
			double b = d.doubleValue();
			return b;
			//return matrix[row][col];
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* w肵sɂl̍vԂ܂B
* @param row wsԍ
* @return w肵s̍vl
* @exception NotElementException w肵s݂Ȃꍇ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double getRowSum(int row){
		if (isRowNumber(row)){
			double val = 0.0;
			for (int i = 0; i < getColLength(); i++){
				val = getCell(row, i) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* eŝꂼ̍vzŕԂ܂B
* @return es̍vlz
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public double[] getRowSumArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* w肵ɂl̍vԂ܂B
* @param col wԍ
* @return w肵̍vl
* @exception NotElementException w肵񂪑݂Ȃꍇ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public double getColSum(int col){
		if (isColNumber(col)){
			double val = 0.0;
			for (int i = 0; i < getRowLength(); i++){
				val = getCell(i, col) + val;
			}
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* êꂼ̍vzŕԂ܂B
* @return e̍vlz
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double[] getColSumArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* w肵sɂl̕ςԂ܂B
* @param row wsԍ
* @return w肵s̕ϒl
* @exception NotElementException w肵s݂Ȃꍇ
* @see #getColAverage(int col)
* @see #getRowAverageArray()
*/
	public double getRowAverage(int row){
		if (isRowNumber(row)){
			double val;
			val = getRowSum(row) / getColLength();
			return val;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* eŝꂼ̕ςzŕԂ܂B
* @return es̕ϒlz
* @see #getColAverageArray()
* @see #getRowAverage(int row)
*/
	public double[] getRowAverageArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowAverage(i);
		}
		return returnArray;
	}
	
/**
* w肵ɂl̕ςԂ܂B
* @param col wԍ
* @return w肵̕ϒl
* @exception NotElementException w肳ꂽ񂪑݂Ȃꍇ
* @see #getRowAverage(int row)
* @see #getColAverageArray()
*/
	public double getColAverage(int col){
		if (isColNumber(col)){
			double val;
			val = getColSum(col) / getRowLength();
			return val;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* êꂼ̕ςzŕԂ܂B
* @return e̕ϒlz
* @see #getRowAverageArray()
* @see #getColAverage(int col)
*/
	public double[] getColAverageArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColAverage(i);
		}
		return returnArray;
	}
	
/**
* }gNX̗vfɂlőlԂ܂B
* @return vfɂől
*/
	public double getMaxCell(){
		double maxValue;
		maxValue = getCell(0,0);		//l
		for (int i = 0; i < getRowLength(); i++){		//ől𒲂ׂ
			for (int j = 0; j < getColLength(); j++){
				if (maxValue < getCell(i,j)){
					maxValue = getCell(i, j);
				}
			}
		}
		return maxValue;
	}
	
/**
* }gNXɑ݂vf̂Avf0𒴂vf̐Ԃ܂B
* @return vf
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) > 0){		//0𒴂vf𐔂
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* }gNX̗vf012lɕϊ܂B
* 0ȉ̐0ɁA0z鐔1ɕϊ܂B
*/
	public void convertLogicMatrix(){
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) <= 0){
					setCell(i, j, MATRIX_VALUE_FALSE);
				}
				else{
					setCell(i, j, MATRIX_VALUE_TRUE);
				}
			}
		}
	}

/**
* ArithmeticMatrixBooleanMatrix^ɕϊ܂B
* 0ȉ̐falseɁA0z鐔trueƂ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽ}gNX
* @see #toBooleanMatrix(double value)
* @see #toStringMatrix()
*/
	public BooleanMatrix toBooleanMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					if (getCell(i, j) <= 0){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* ArithmeticMatrixBooleanMatrix^ɕϊ܂B
* l value ȉ̐falseɁA value z鐔trueƂ܂B<BR>
* AAl0̏ꍇ́A0falseɁA0ȊO̐trueƂ܂B
* 0ȉ̐falseƂꍇtoBooleanMatrix()𗘗pĂB
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @param value l
* @return ϊꂽ}gNX
* @see #toBooleanMatrix()
* @see #toStringMatrix()
*/
	public BooleanMatrix toBooleanMatrix(double value){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if(value != 0){
					if (getCell(i, j) <= value){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
				else{
					if (getCell(i, j) == value){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
			}
		}
		return returnMatrix;
	}
	
/**
* ArithmeticMatrixStringMatrix^ɕϊ܂B
* evf̒l̂܂ܕƂ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽMatrix
* @see #toBooleanMatrix()
* @see #toBooleanMatrix(double value)
*/
	public StringMatrix toStringMatrix(){
		StringMatrix returnMatrix = new StringMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Double.toString(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2̃}gNX̃TCY`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	public boolean isSameMatrixSize(ArithmeticMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2̃}gNX̃TCYZsƂł邩`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	private boolean isMultiplyMatrixSize(ArithmeticMatrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* ̃}gNXƂ̘_(And)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getAndMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_ς߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) &
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̘_a(OR)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getOrMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̘_a߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) |
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ̃}gNXƂ̔rI_a(eXclusive OR)Ԃ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYقȂꍇ
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getXOrMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//Zs邩ǂ
		if (isSameMatrixSize(calculateMatrix)){
			
			//_l̃}gNXɕϊ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//vfm̔rI_a߂
					returnMatrix.setCell(i, j, (int) getCell(i,j) ^
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̔ے(NOT)Ԃ܂B<BR>
* ̉ZsꍇconvertLogicMatrix\bhs܂B
* @return Zʂ̃}gNX
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
*/
	public ArithmeticMatrix getNotMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//_l̃}gNXɕϊ
		convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ے̉Zs
					if (getCell(i,j) > 0){
						returnMatrix.setCell(i, j, 0);
					}
					else{
						returnMatrix.setCell(i, j, 1);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* }gNXvalue{}gNXԂ܂B
* }gNX̑SĂ̗vfɑ΂āAvalue{}gNXԂ܂B
* @param value |鐔
* @return value{ꂽ}gNX
* @see #getMultiplyMatrix(ArithmeticMatrix calculateMatrix)
*/
	public ArithmeticMatrix getTimesMatrix(double value){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for(int i = 0; i < getRowLength(); i++){
			for(int j = 0; j < getColLength(); j++){
				double v = value * getCell(i, j);
				returnMatrix.setCell(i, j, v);
			}
		}
		return returnMatrix;
	}
	
/**
* }gNXm̘avZ}gNXԂ܂B<BR>
* Ԃ}gNX̍sƗ񖼂̓}gNXƓ̂ƂȂ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYvȂꍇ
*/
	public ArithmeticMatrix getAddMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//Zs邩ǂ
		if (isSameMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					double value = 0.0;
					value = getCell(i, j) + calculateMatrix.getCell(i, j);
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* }gNXm̐ςvZ}gNXԂ܂B<BR>
* Z }gNX ~ calculateMatrix ōs܂B
* Ԃ}gNX̃TCY͉Z̃}gNX̍sTCY~ZΏۂ̃}gNX̗TCYƂȂ܂B
* @param calculateMatrix ZΏۂ̃}gNX
* @return Zʂ̃}gNX
* @exception DisagreementMatrixSizeException Zs2̃}gNX̃TCYZsȂTCY̏ꍇ
* @see #getTimesMatrix(double value)
*/
	public ArithmeticMatrix getMultiplyMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//Zs邩ǂ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//s̏Zs
					//vZ a_i1 * a_1j + a_i2 * a_2j + c + a_in * a_nj
					double value = 0.0;
					for (int k = 0; k < getColLength(); k++){
							value = getCell(i, k) * calculateMatrix.getCell(k, j) + value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//ZsȂꍇ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetwƂׂvZ}gNXԂ܂B
* @param exponent ݏ̎w
* @return n}gNX
* @exception SetValueOutOfBoundsException w0ȉ̒lw肵ꍇ
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public ArithmeticMatrix getExponentMatrix(int exponent){
		ArithmeticMatrix initMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//s񂩂ǂA܂w0ȉ̒lw肳ꂽꍇ
		if (isSquare()){
			if (exponent > 0){
			
				//̃}gNXnZ(1̏ꍇ͌̃}gNX̂܂)
				for (int i = 1; i < exponent; i++){
				
					//i悵}gNXɌ̃}gNX|Ai+1ɂ
					returnMatrix.matrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//w0ȉ̒lw肳ꂽꍇ
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* }gNX̗vfPʃ}gNXɕύX܂B
* @exception NotSquareMatrixException }gNXsłȂꍇ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//Ίp̂1
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//}gNXsłȂꍇ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ̃}gNXƓTCY̒Pʃ}gNXԂ܂B
* @return Pʍs
*/
	private ArithmeticMatrix getElementaryMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* }gNXאڃ}gNXƂ̉B}gNXԂ܂B<BR>
* ̉Z𐳏ɍsꍇconvertLogicMatrix\bhs܂B
* @return B}gNX
* @exception NotSquareMatrixException }gNXsł͂Ȃꍇ
* @see #convertLogicMatrix()
*/
	public ArithmeticMatrix getReachMatrix(){
		
		//s񂩂ǂ
		if (isSquare()){
		//̃}gNXאڃ}gNXƂĐ
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//_l̃}gNXɕϊ
		returnMatrix.convertLogicMatrix();
		
		//PʍsƂ̘_a
		returnMatrix.matrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1悷
		// (I + A)n-1 I͒Pʍs +͘_a
		returnMatrix.matrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//_l̃}gNXɕϊ
		returnMatrix.convertLogicMatrix();
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* }gNX̓]u}gNXԂ܂B
* Ԃꂽ}gNX̍sƗ񖼂͂ꂼꂪւ́is񖼂ɗ񖼂sɁjɂȂ܂B
* @return ]u}gNX
*/
	public ArithmeticMatrix getTransposedMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getColLength(), getRowLength(),
			getColNameArray(), getRowNameArray());
		for(int i = 0; i < returnMatrix.getRowLength(); i++){
			for(int j = 0; j < returnMatrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCell(j, i));
			}
		}
		return returnMatrix;
	}
	
/**
* }gNX̗vf2zŕԂ܂B
* @return vf2z
*/
	public double[][] getMatrix(){
		Double d[][] = new Double[getRowLength()][getColLength()];
		double dou[][] = new double[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				d[i][j] = (Double)o[i][j];
				dou[i][j] = d[i][j].doubleValue();
			}
		}
		return dou;
	}
	
}