package jp.ac.takushoku_u.cs;

/**
* TaskSequenceNX͊wKۑn񉻖@s߂̃NXłB<BR>
* n񉻂sꍇɉzڂKvłۑ\̏ꍇłĂA
* Iɉzڂt^An񉻂sƂł܂B
* zڂ0sڂ0ڂɕt^AsƗ񖼂͂`Dummy'ƂȂ܂B
* @version 1.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1124
*/
public class TaskSequence{
	
/**
* n񉻂sאڃ}gNX(zڂȂ)
*/
	private ArithmeticMatrix baseMatrix;
/**
* n񉻂sאڃ}gNX(zڕt)
*/	
	private ArithmeticMatrix matrix;
	
/**
* zڂt^ϐ
*/
	private boolean giveDummy = false;
	
/**
* At@̏l
*/
	private static final double TASK_SEQUENCE_ALPHA = 0.5;
	
/**
* x[^̏l
*/
	private static final double TASK_SEQUENCE_BETA = 0.5;
	
/**
* L}邱Ƃ萔
*/
	private static final double TASK_SEQUENCE_TRUE = 1.0;
	
/**
* L}ȂƂ萔
*/
	private static final double TASK_SEQUENCE_FALSE = 0.0;
	
/**
* }gNX̏l
*/
	private static final int TASK_SEQUENCE_MATRIX_SIZE = 5;
	
/**
* ftHgŐݒ肳ĂlŌn񉻂sאڃ}gNXݒ肵܂B
*/
	public TaskSequence(){
		baseMatrix = new ArithmeticMatrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
		matrix = new ArithmeticMatrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
	}
	
/**
* n񉻂sאڃ}gNXݒ肵܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException אڃ}gNXsł͂Ȃꍇ
*/
	public TaskSequence(ArithmeticMatrix adjacencyMatrix){
		baseMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		matrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		setMatrix(adjacencyMatrix);
	}
	
	
/**
* ̗אڃ}gNXԂ܂B
* @return אڃ}gNX
* @see #getDummyMatrix()
*/
	public ArithmeticMatrix getMatrix(){
		return baseMatrix;
	}
	
/**
* zڍ݂̗אڃ}gNXԂ܂B
* zڂt^ȂƂ悢אڃ}gNX̏ꍇgetMatrix()Ɠ}gNXԂ܂B
* @return zڂt^אڃ}gNX
* @see #getMatrix()
*/
	public ArithmeticMatrix getDummyMatrix(){
		return matrix;
	}
	
/**
* B}gNX߂܂B
* zڂKvȗאڃ}gNXݒ肵ꍇAzڍ݂̃}gNXԂ܂B
* @return B}gNX
*/
	public ArithmeticMatrix getReachMatrix(){
		return getReachMatrix(matrix);
	}
	
/**
* אڃ}gNXB}gNX߂܂B
* @param adjacencyMatrix אڃ}gNX
* @return B}gNX
*/
	private ArithmeticMatrix getReachMatrix(ArithmeticMatrix adjacencyMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(),
			adjacencyMatrix.getColLength(), adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		return adjacencyMatrix.getReachMatrix();
	}
	
/**
* O񐫃}gNX߂܂B
* zڂKvȗאڃ}gNXݒ肵ꍇAzڍ݂̃}gNXԂ܂B
* @return O񐫃}gNX
*/
	public ArithmeticMatrix getFMatrix(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.matrixCopy(getReachMatrix(matrix));
		
		return getFMatrix(reachMatrix);
	}
	
/**
* B}gNX獇O񐫃}gNX߂܂B
* @param B}gNX
* @return O񐫃}gNX
*/
	private ArithmeticMatrix getFMatrix(ArithmeticMatrix reachMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		ArithmeticMatrix TMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.matrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.matrixCopy(TMatrix.getMultiplyMatrix(reachMatrix));
		return returnMatrix;
	}
	
/**
* ڕW}gNX߂܂B
* zڂKvȗאڃ}gNXݒ肵ꍇAzڍ݂̃}gNXԂ܂B
* @return ڕW}gNX
*/
	public ArithmeticMatrix getGMatrix(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.matrixCopy(getReachMatrix(matrix));
		
		return getGMatrix(reachMatrix);
	}
	
/**
* B}gNX獇ڕW}gNX߂܂B
* @param B}gNX
* @return ڕW}gNX
*/
	private ArithmeticMatrix getGMatrix(ArithmeticMatrix reachMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		ArithmeticMatrix TMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.matrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.matrixCopy(reachMatrix.getMultiplyMatrix(TMatrix));
		return returnMatrix;
	}
	
/**
* Rq[X}gNX߂܂B
* ԂRq[X}gNX́AO񐫃}gNX + ڕW}gNXłB
* zڂKvȗאڃ}gNXݒ肵ꍇAzڍ݂̃}gNXԂ܂B
* @return Rq[X}gNX
*/
	public ArithmeticMatrix getCoherenceMatrix(){
		ArithmeticMatrix FMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix GMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.matrixCopy(getFMatrix());
		GMatrix.matrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix);
	}
	
/**
* Rq[X}gNX߂܂B
* ԂRq[X}gNX́AO񐫃}gNX + ڕW}gNXłB
* zڂKvȗאڃ}gNXݒ肵ꍇAzڍ݂̃}gNXԂ܂B
* @param alpha At@̒l
* @param beta x[^̒l
* @return Rq[X}gNX
*/
	public ArithmeticMatrix getCoherenceMatrix(double alpha, double beta){
		ArithmeticMatrix FMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix GMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.matrixCopy(getFMatrix());
		GMatrix.matrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix, alpha, beta);
	}
	
/**
* O񐫃}gNXƍڕW}gNXRq[X}gNX߂܂B
* ԂRq[X}gNX́AO񐫃}gNX + ڕW}gNXłB
* @param FMatrix O񐫃}gNX
* @param GMatrix ڕW}gNX
* @return Rq[X}gNX
* 
*/
	private ArithmeticMatrix getCoherenceMatrix(ArithmeticMatrix FMatrix, ArithmeticMatrix GMatrix){
		return FMatrix.getAddMatrix(GMatrix);
	}
	
/**
* O񐫃}gNXƍڕW}gNXRq[X}gNX߂܂B
* ԂRq[X}gNX́AO񐫃}gNX + ڕW}gNXłB
* @param FMatrix O񐫃}gNX
* @param GMatrix ڕW}gNX
* @param alpha At@̒l
* @param beta x[^̒l
* @return Rq[X}gNX
* 
*/
	private ArithmeticMatrix getCoherenceMatrix(ArithmeticMatrix FMatrix, ArithmeticMatrix GMatrix, double alpha, double beta){
		ArithmeticMatrix Fm = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix Gm = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Fm.matrixCopy(FMatrix.getTimesMatrix(alpha));
		Gm.matrixCopy(GMatrix.getTimesMatrix(beta));
		return Fm.getAddMatrix(Gm);
	}
	
/**
* n񉻂ꂽۑԍzŕԂ܂B
* At@ƃx[^̒l̓ftHglƂȂ܂B
* @return n񉻂ꂽi[z
*/
	public int[] getTaskSequenceArray(){
		return getTaskSequenceArray(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* n񉻂ꂽۑԍzŕԂ܂B
* z̒g͌n񉻂ꂽאڃ}gNX̍sԍłB
* @param alpha At@̒l
* @param beta x[^̒l
* @return n񉻂ꂽi[z
* @exception SetValueOutOfBoundsException At@ƃx[^̒lsłꍇ
*/
	public int[] getTaskSequenceArray(double alpha, double beta){
		
		//At@ƃx[^͓Kǂ
		if(isNormalIndex(alpha, beta)){
			
			//B}gNX
			ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			reachMatrix.matrixCopy(getReachMatrix(matrix));
			
			//Rq[X}gNX
			ArithmeticMatrix CMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			CMatrix.matrixCopy(getCoherenceMatrix(alpha, beta));
			
			//ʂԂz
			int[] returnArray;
			
			//I\ڂz
				boolean[] el = new boolean[reachMatrix.getRowLength()];
			
			//zڂݒ肵ꍇ
			if(isDummy()){
				returnArray = new int[reachMatrix.getRowLength()-1];
				
				//I
				int item = 0;
				
				//ڂI
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength() -1; i++){
					if(el[i]){
						item = i;
					}
				}
				
				//\珜O
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//n񉻂
				for(int i = 0;i < reachMatrix.getRowLength()-1; i++){
					
					//IĂ鍀ڂ玟ɑI鍀ڂT
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item -1;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			
			//zڂ̖ꍇ
			else{
				returnArray = new int[reachMatrix.getRowLength()];
				
				//I
				int item = 0;
				
				//ڂI
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength(); i++){
					if(el[i]){
						item = i;
					}
				}
				returnArray[0] = item;
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//n񉻂
				for(int i = 1;i < reachMatrix.getRowLength(); i++){
					
					//IĂ鍀ڂ玟ɑI鍀ڂT
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			return returnArray;
		}
		else{		//G[̏ꍇ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* n񉻂ꂽۑԍSequenceŕԂ܂B
* At@ƃx[^̒l̓ftHglɂȂ܂B
* @return n񉻂ꂽi[z
*/
	public Sequence getTaskSequence(){
		return getTaskSequence(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* n񉻂ꂽۑԍSequenceŕԂ܂B
* @param alpha At@̒l
* @param beta x[^̒l
* @return n񉻂ꂽi[z
* @exception SetValueOutOfBoundsException At@ƃx[^̒lsłꍇ
*/
	public Sequence getTaskSequence(double alpha, double beta){
		
		//At@ƃx[^͓Kǂ
		if(isNormalIndex(alpha, beta)){
			Sequence seq = new Sequence(getTaskSequenceArray(alpha, beta));
			for(int i = 0; i < seq.getLength(); i++){
				seq.setItemName(i, baseMatrix.getRowName(seq.getItem(i)));
			}
			return seq;
		}
		else{		//G[̏ꍇ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* B}gNX瑼̗vf։Bł邪A̗vf炻̗vfւ͉Bł͂ȂvfT܂B
* ʂ̓TCYvfboolean^̔zŕԂ܂B
* @param reachMatrix B}gNX
* @return ʂ̔z
*/
	private boolean[] getReachElement(ArithmeticMatrix reachMatrix){
		boolean[] returnArray = new boolean[reachMatrix.getRowLength()];
		for(int i = 0; i < reachMatrix.getRowLength(); i++){
			int count = 0;
			for(int j = 0; j < reachMatrix.getColLength(); j++){
				if(reachMatrix.getCell(j,i) == TASK_SEQUENCE_TRUE){
					count++;
				}
			}
			
			if(count == 1){
				returnArray[i] = true;
			}
			else{
				returnArray[i] = false;
			}
		}
		
		return returnArray;
	}
	
/**
* I\ڂz񂩂I鍀ڂT܂B
* @param item I鍀
* @param choiceArray I\ڂz
* @param coherenceMatrix Rq[X}gNX
* @return I鍀
*/
	private int getItemNumber(int item, boolean[] choiceArray, ArithmeticMatrix coherenceMatrix){
		int itemNumber = 0;
		double val = Double.NEGATIVE_INFINITY;
		for(int i = 0; i < choiceArray.length; i++){
			if(choiceArray[i] && coherenceMatrix.getCell(item, i) > val){
				val = coherenceMatrix.getCell(item, i);
				itemNumber = i;
			}
		}
		
		return itemNumber;
	}
	
/**
* At@ƃx[^̒lKǂ`FbN܂B
* @param alpha At@̒l
* @param beta x[^̒l
* @return lKłtrue
*/
	private boolean isNormalIndex(double alpha, double beta){
		boolean condition = (Math.abs(alpha) + Math.abs(beta) == 1.0);
		boolean condition2 = ((0.0 <= Math.abs(alpha)) && (Math.abs(alpha) <= 1.0));
		boolean condition3 = ((0.0 <= Math.abs(beta)) && (Math.abs(beta) <= 1.0));
		return condition && condition2 && condition3;
	}
	
/**
* zڂKvǂ`FbN܂B
* @param adjacencyMatrix ׂאڃ}gNX
* @return zڂKvłtrue
*/
	private boolean needDummy(ArithmeticMatrix adjacencyMatrix){
		ArithmeticMatrix RMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength(),
			adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		RMatrix.matrixCopy(adjacencyMatrix.getReachMatrix());
		
		boolean[] el = new boolean[RMatrix.getRowLength()];
		System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
		int count = 0;
		for(int i = 0; i < el.length; i++){
			if(el[i]){
				count++;
			}
		}
		
		//ڂ1𒴂ꍇ
		return count > 1;
	}
	
/**
* אڃ}gNXݒ肵܂B
* @param m ݒ肷אڃ}gNX
* @exception NotSquareMatrixException אڃ}gNXsł͂Ȃꍇ
*/
	public void setMatrix(ArithmeticMatrix m){
		if(m.isSquare()){
		baseMatrix.matrixCopy(m);
		setDummy();
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* zڂݒ肵܂B
*/
	private void setDummy(){
		matrix.matrixCopy(baseMatrix);
		if(needDummy(baseMatrix)){
			giveDummy = true;
			matrix.reSizeMatrix(baseMatrix.getRowLength()+1, baseMatrix.getColLength()+1);
			matrix.matrixMove(0, 0, 1, 1, baseMatrix.getRowLength(), baseMatrix.getColLength());
			matrix.rowNameMove(0, 1, baseMatrix.getRowLength());
			matrix.colNameMove(0, 1, baseMatrix.getColLength());
			matrix.setRowName(0, "Dummy");
			matrix.setColName(0, "Dummy");
			
			ArithmeticMatrix RMatrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength(),
				baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
			RMatrix.matrixCopy(baseMatrix.getReachMatrix());
			
			for(int i = 0; i < matrix.getColLength(); i++){
				matrix.setCell(i, 0, TASK_SEQUENCE_FALSE);
			}
			
			boolean[] el = new boolean[RMatrix.getRowLength()];
			System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
			for(int i = 1; i < el.length+1; i++){
				if(el[i-1]){
					matrix.setCell(0, i, TASK_SEQUENCE_TRUE);
				}
				else{
					matrix.setCell(0, i, TASK_SEQUENCE_FALSE);
				}
			}
		}
		else{
			giveDummy = false;
		}
	}
	
/**
* zڂݒ肵Ԃ܂B
* @return zڂݒ肵ꍇtrue
*/
	public boolean isDummy(){
		return giveDummy;
	}
	
/**
* Kl߂܂B
* Ԃl͍ő̖ڕWۑ萔łB
* @return Kl
*/
	private int getRegular(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		double max = 0.0;
		int maxIndex = 0;
		double count = 0.0;
		for(int i = 0; i < matrix.getColLength(); i++){
			count = reachMatrix.getColSum(i);
			if(count > max){
				maxIndex = i;
				max = count;
			}
		}
		return (int)count;
	}
}