package jp.ac.takushoku_u.cs;
import java.util.Set;
import java.util.Iterator;

/**
* LFTAnalysisNXLFT͂s߂̃NXłB<BR>
* ܂ÃNX𗘗pאڃ}gNXɂ}̏dvxvfΏW߂邱Ƃł܂B
* @version 1.3.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1206
*/
public class LFTAnalysis{
	
/**
* ҂̃}gNXێ}gNX
*/
	private BooleanMatrix teacherMatrix;
	
/**
* wK҂̃}gNXێ}gNX
*/
	private BooleanMatrix studentMatrix;
	
/**
* L}ꍇ\萔
*/
	private static final int LFT_EDGE_INT_TRUE = 1;
	
/**
* L}ꍇ\萔
*/
	private static final boolean LFT_EDGE_TRUE = true;
	
/**
* L}ꍇ\萔
*/
	private static final String LFT_EDGE_STRING_TRUE = "1";
	
/**
* L}Ȃꍇ\萔
*/
	private static final int LFT_EDGE_INT_FALSE = 0;
	
/**
* L}Ȃꍇ\萔
*/
	private static final boolean LFT_EDGE_FALSE = false;
	
/**
* L}Ȃꍇ\萔
*/
	private static final String LFT_EDGE_STRING_FALSE = "0";
	
/**
* ꏏɂ}gNXŋ҂̃}gNXɂ̂ݎ}ꍇ\萔
*/
	private static final int LFT_EDGE_TEACHER = 3;
	
/**
* ꏏɂ}gNXŋ҂̃}gNXɂ̂ݎ}ꍇ\萔
*/
	private static final String LFT_EDGE_STRING_TEACHER = "T";
	
/**
* ꏏɂ}gNXŊwK҂̃}gNXɂ̂ݎ}ꍇ\萔
*/
	private static final int LFT_EDGE_STUDENT = 4;
	
/**
* ꏏɂ}gNXŊwK҂̃}gNXɂ̂ݎ}ꍇ\萔
*/
	private static final String LFT_EDGE_STRING_STUDENT = "S";
	
/**
* }gNXTCỸftHgl
*/
	private static final int LFT_MATRIX_VALUE = 5;
	
/**
* ݒ肳ĂftHg̃TCYŕ͂s}gNXݒ肵܂B<BR>
* ҂ƊwKҗ̃}gNX̗vf͑S0ƂȂ܂B
*/
	public LFTAnalysis(){
		BooleanMatrix baseTeacherMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		BooleanMatrix baseStudentMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix);
		
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXݒ肵܂B<BR>
* wK҂̃}gNX͋҂̃}gNXTCYƓŁAvf͑S0ƂȂ܂B<BR>
* ҂̃}gNX͐słKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	public LFTAnalysis(BooleanMatrix baseTeacherMatrix){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix);
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXݒ肵܂B<BR>
* ҂̃}gNXƊwK҂̃}gNXTCYvA҂ƂsłKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param baseStudentMatrix wK҂̃}gNX
* @exception NotSquareMatrixException ҂܂͊wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public LFTAnalysis(BooleanMatrix baseTeacherMatrix, BooleanMatrix baseStudentMatrix){
		
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix);
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXݒ肵܂B<BR>
* wK҂̃}gNX͋҂̃}gNXTCYƓŁAvf͑S0ƂȂ܂B<BR>
* ҂̃}gNX͐słKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXݒ肵܂B<BR>
* ҂̃}gNXƊwK҂̃}gNXTCYvA҂ƂsłKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param baseStudentMatrix wK҂̃}gNX
* @exception NotSquareMatrixException ҂܂͊wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, ArithmeticMatrix baseStudentMatrix){
		
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix.toBooleanMatrix());
	}
	
/**
* ҂̃}gNXݒ肵܂B<BR>
* wK҂̃}gNX͋҂̃}gNXTCYƓŁAvf͑S0ƂȂ܂B<BR>
* ҂̃}gNX͐słKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param value BooleanMatrixɕϊۂ̂l
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, double value){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXݒ肵܂B<BR>
* ҂̃}gNXƊwK҂̃}gNXTCYvA҂ƂsłKv܂B
* @param baseTeacherMatrix ҂̃}gNX
* @param baseStudentMatrix wK҂̃}gNX
* @param value BooleanMatrixɕϊۂ̂l
* @exception NotSquareMatrixException ҂܂͊wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, ArithmeticMatrix baseStudentMatrix, double value){
		
		//҂̃}gNXݒ肷
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//wK҂̃}gNXݒ肷
		setStudentMatrix(baseStudentMatrix.toBooleanMatrix());
	}
	
/**
* ގxԂ܂B
* @return ގx
*/
	public double getResemble(){
		double denominator = 0.0; //(OR)
		double numerator = 0.0; //q(AND)
		
		//vf΂߂}gNX
		BooleanMatrix pairTeacherMatrix = new BooleanMatrix(getElement(), getElement());
		BooleanMatrix pairStudentMatrix = new BooleanMatrix(getElement(), getElement());
		
		//B}gNX
		BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
		reachTeacherMatrix.matrixCopy(getReachTeacherMatrix());
		BooleanMatrix reachStudentMatrix = new BooleanMatrix();
		reachStudentMatrix.matrixCopy(getReachStudentMatrix());
		
		//vZߒŎgp}gNX
		BooleanMatrix resultMatrix = new BooleanMatrix(getElement(), getElement());
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				
				//҂̃}gNXł2vfԂɎ}΂̗vfԂ̗vfΏW߂
				if (teacherMatrix.getCell(i, j) == true){
				pairTeacherMatrix.matrixCopy(getPairMatrix(reachTeacherMatrix, i, j));
				}
				
				//}ȂΗvfΏW͋W
				else{
					pairTeacherMatrix.clearMatrix();
				}
				
				//wK҂̃}gNXł2vfԂɎ}΂̗vfԂ̗vfΏW߂
				if (studentMatrix.getCell(i, j) == true){
				pairStudentMatrix.matrixCopy(getPairMatrix(reachStudentMatrix, i, j));
				}
				
				//}ȂΗvfΏW͋W
				else{
					pairStudentMatrix.clearMatrix();
				}
				
				//̌vZ
				resultMatrix.matrixCopy(pairTeacherMatrix.getOrMatrix(pairStudentMatrix));
				denominator = resultMatrix.getElement() + denominator;
				
				//q̌vZ
				resultMatrix.matrixCopy(pairTeacherMatrix.getAndMatrix(pairStudentMatrix));
				numerator = resultMatrix.getElement() + numerator;
			}
		}
		
		return numerator / denominator;
	}
	
/**
* BxԂ܂B
* @return Bx
*/
	public double getAttainment(){
		return Math.sqrt(getResemble()) * 100;
	}

/**
* 2_Ԃɂ鋳҂ƊwK҂̎}̏ԂԂ܂B
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇ3A
* wK҂̃}gNX݂̂Ɏ}ꍇ4܂B
* @param baseMatrix r̃}gNX
* @param compareMatrix r}gNX
* @param Ij L}̎n_
* @param Ik L}̏I_
* @return }̏
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException 2̃}gNXTCYvȂꍇ
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getBlendMatrix()
*/
	private int getBlendEdge(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				int value;
				if (baseMatrix.isMatrixEntityPoint(Ij, Ik) && compareMatrix.isMatrixEntityPoint(Ij, Ik)){
					if (baseMatrix.getCell(Ij, Ik) == compareMatrix.getCell(Ij, Ik)){
							if(baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
								value = LFT_EDGE_INT_TRUE;
							}
							else{
								value = LFT_EDGE_INT_FALSE;
							}
						}
						else if (baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE &&
							compareMatrix.getCell(Ij, Ik) == LFT_EDGE_FALSE){
							value = LFT_EDGE_TEACHER;
						}
						else{
							value = LFT_EDGE_STUDENT;
						}
					return value;
				}
				else{
					throw new NotElementException("point(" + Ij + "," + Ik + ")");
				}
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* 2_Ԃɂ鋳҂ƊwK҂̎}̏ԂԂ܂B
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇTA
* wK҂̃}gNX݂̂Ɏ}ꍇS܂B
* @param baseMatrix r̃}gNX
* @param compareMatrix r}gNX
* @param Ij L}̎n_
* @param Ik L}̏I_
* @return }̏
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException 2̃}gNXTCYvȂꍇ
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getBlendStringMatrix()
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
	public String getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				String st;
				if (baseMatrix.isMatrixEntityPoint(Ij, Ik) && compareMatrix.isMatrixEntityPoint(Ij, Ik)){
					if (baseMatrix.getCell(Ij,Ik) == compareMatrix.getCell(Ij, Ik)){
							if(baseMatrix.getCell(Ij,Ik) == LFT_EDGE_TRUE){
								st = LFT_EDGE_STRING_TRUE;
							}
							else{
								st = LFT_EDGE_STRING_FALSE;
							}
						}
						else if (baseMatrix.getCell(Ij,Ik) == LFT_EDGE_TRUE &&
							compareMatrix.getCell(Ij,Ik) == LFT_EDGE_FALSE){
							st = LFT_EDGE_STRING_TEACHER;
						}
						else{
							st = LFT_EDGE_STRING_STUDENT;
						}
					return st;
				}
				else{
					throw new NotElementException("point(" + Ij + "," + Ik + ")");
				}
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* w肵2̗אڃ}gNXꏏɂ}gNXԂ܂B<BR>
* ǂ}0Aǂ}1AbaseMatrixŎw肵}gNX݂̂Ɏ}ꍇ3A
* compareMatrixŎw肵}gNXɂ݂̂Ɏ}ꍇ4܂B
* ꏏɂ}gNX̍sƗ񖼂baseMatrixŎw肵}gNXƓɂȂ܂B
* @param baseMatrix r̃}gNX
* @param compareMatrix r}gNX
* @return ꏏɂ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException 2̃}gNXTCYvȂꍇ
*/
	private ArithmeticMatrix getBlendMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getElement(), getElement(),
					baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
				
				for (int i = 0; i < getElement(); i++){
					for (int j = 0; j < getElement(); j++){
						returnMatrix.setCell(i, j, getBlendEdge(baseMatrix, compareMatrix, i ,j));
					}
				}
				return returnMatrix;
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* w肵2̗אڃ}gNXꏏɂ}gNXԂ܂B<BR>
* ǂ}0Aǂ}1AbaseMatrixŎw肵}gNX݂̂Ɏ}ꍇTA
* compareMatrixŎw肵}gNXɂ݂̂Ɏ}ꍇS܂B
* ꏏɂ}gNX̍sƗ񖼂baseMatrixŎw肵}gNXƓɂȂ܂B
* @param baseMatrix r̃}gNX
* @param compareMatrix r}gNX
* @return ꏏɂ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException 2̃}gNXTCYvȂꍇ
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix()
*/
	public StringMatrix getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				StringMatrix returnMatrix = new StringMatrix(getElement(), getElement(),
					baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
				
				for (int i = 0; i < getElement(); i++){
					for (int j = 0; j < getElement(); j++){
						returnMatrix.setCell(i, j, getBlend(baseMatrix, compareMatrix, i, j));
					}
				}
				return returnMatrix;
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXꏏɂ}gNXԂ܂B<BR>
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇ3A
* wK҂̃}gNX݂̂Ɏ}ꍇ4܂B
* ꏏɂ}gNX̍sƗ񖼂͋҂̃}gNXƓɂȂ܂B
* @return ꏏɂ}gNX
*/
	private ArithmeticMatrix getBlendMatrix(){
		return getBlendMatrix(teacherMatrix, studentMatrix);
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNXꏏɂ}gNXԂ܂B<BR>
* ǂ}0Aǂ}1A҂̃}gNX݂̂Ɏ}ꍇTA
* wK҂̃}gNX݂̂Ɏ}ꍇS܂B
* ꏏɂ}gNX̍sƗ񖼂͋҂̃}gNXƓɂȂ܂B
* @return ꏏɂ}gNX
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
	public StringMatrix getBlendStringMatrix(){
		return getBlendStringMatrix(teacherMatrix, studentMatrix);
	}
	
/**
* אڃ}gNXɂvfԂ̗vfΏW߂܂B
* @param nextMatrix ׂאڃ}gNX
* @param Ij L}̎n_
* @param Ik L}̐̏I_
* @return ǂ̗vfԂvf΂}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public BooleanMatrix getElementPairMatrix(BooleanMatrix nextMatrix, int Ij, int Ik){
		if(nextMatrix.isSquare()){
			if (nextMatrix.isMatrixEntityPoint(Ij, Ik)){
				
				//B}gNX𐶐
				BooleanMatrix lookMatrix = new BooleanMatrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
					nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
				lookMatrix.matrixCopy(nextMatrix.getReachMatrix());
				
				BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(), lookMatrix.getColLength(), 
					lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
				
				//}݂邩ǂ
				if (nextMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
					returnMatrix.matrixCopy(getPairMatrix(lookMatrix, Ij, Ik));
				}
				return returnMatrix;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* אڃ}gNXɂvfԂ̗vfΏW߂܂B
* @param nextMatrix ׂאڃ}gNX
* @param Ij L}̎n_
* @param Ik L}̐̏I_
* @return vfΏWƂȂ}̏W
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public EdgeSet getElementPairSet(BooleanMatrix nextMatrix, int Ij, int Ik){
		if(nextMatrix.isSquare()){
			if (nextMatrix.isMatrixEntityPoint(Ij, Ik)){
				
				//B}gNX𐶐
				BooleanMatrix lookMatrix = new BooleanMatrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
					nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
				lookMatrix.matrixCopy(nextMatrix.getReachMatrix());
				
				EdgeSet edgeHash = new EdgeSet();
				
				//}݂邩ǂ
				if (nextMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
					for (int i = 0; i < lookMatrix.getRowLength(); i++){
						for (int j = 0; j < lookMatrix.getColLength(); j++){
							if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
								edgeHash.add(new Edge(i,j));
							}
						}
					}
				}
				return edgeHash;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* B}gNXɂvfԂ̗vfΏW߂܂B<BR>
* אڃ}gNX狁߂̂ɔׁA2vfԂאڂĂ邩ۏ؂Ȃ߁A
* ̃\bhgpꍇ̗͂vfԓmאڂĂ邱Ƃ`FbNKv܂B
* @param lookMatrix ׂB}gNX
* @param Ij L}̗̌vfԍ
* @param Ik L}̗̐vfԍ
* @return ǂ̗vfԂvf΂}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	private BooleanMatrix getPairMatrix(BooleanMatrix lookMatrix, int Ij, int Ik){
		if(lookMatrix.isSquare()){
			if (lookMatrix.isMatrixEntityPoint(Ij, Ik)){
				BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(),lookMatrix.getColLength(), 
					lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
				for (int i = 0; i < lookMatrix.getRowLength(); i++){
					for (int j = 0; j < lookMatrix.getColLength(); j++){
						if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
							returnMatrix.setCell(i, j, LFT_EDGE_TRUE);
						}
						else{
							returnMatrix.setCell(i, j, LFT_EDGE_FALSE);
						}
					}
				}
				return returnMatrix;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* }gNXɑ݂}̏dvx߂܂B
* @param baseMatrix dvx߂Ώۂ̗אڃ}gNX
* @return }̏dvxi[}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public ArithmeticMatrix getImportantEdgeMatrix(BooleanMatrix baseMatrix){
		if(baseMatrix.isSquare()){
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength(),
				baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
			
			for (int i = 0;i < baseMatrix.getRowLength(); i++){
				for (int j = 0; j < baseMatrix.getColLength(); j++){
					returnMatrix.setCell(i, j, getImportantEdge(baseMatrix, i, j));
				}
			}
			return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* }gNX2ڊԂ̎}̏dvxԂ܂B
* @param baseMatrix dvx߂}gNX
* @param Ij L}̎n_ƂȂ鍀Ij
* @param Ik L}̏I_ƂȂ鍀Ik
* @return w肵ڊԂ̏dvx
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public double getImportantEdge(BooleanMatrix baseMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare()){
			BooleanMatrix temporaryMatrix = new BooleanMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
			double cont = Math.floor(getElement() / 2) * Math.floor((getElement() + 1) / 2);
			double value = 0.0;
			
			//}݂邩ǂ
			if (baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
				temporaryMatrix.matrixCopy(getElementPairMatrix(baseMatrix, Ij, Ik));
				value = temporaryMatrix.getElement();
				value = value / cont;
			}
			return value;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ҂̃}gNXɂw肵}̏dvxԂ܂B
* @param Ij L}̎n_
* @param Ik L}̏I_
* @return dvx
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getImportantEdgeStudent(int Ij, int Ik)
* @see #getEdgeTeacherMatrix()
*/
	public double getImportantEdgeTeacher(int Ij, int Ik){
		if (teacherMatrix.isMatrixEntityPoint(Ij, Ik)){
			return getImportantEdge(teacherMatrix, Ij, Ik);
		}
		else{
			throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* ҂̎}̏dvx߂}gNXԂ܂B
* @return dvx߂}gNX
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
	public ArithmeticMatrix getEdgeTeacherMatrix(){
		return getImportantEdgeMatrix(teacherMatrix);
	}
	
/**
* wK҂̃}gNXɂw肵}̏dvxԂ܂B
* @param Ij L}̎n_
* @param Ik L}̏I_
* @return dvx
* @exception NotElementException w肵vfԍ݂Ȃꍇ
* @see #getEdgeTeacherMatrix()
* @see #getImportantEdgeStudent(int Ij, int Ik)
*/
	public double getImportantEdgeStudent(int Ij, int Ik){
		if (studentMatrix.isMatrixEntityPoint(Ij, Ik)){
			return getImportantEdge(studentMatrix, Ij, Ik);
		}
		else{
			throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* wK҂̎}̏dvx߂}gNXԂ܂B
* @return dvx߂}gNX
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
	public ArithmeticMatrix getEdgeStudentMatrix(){
		return getImportantEdgeMatrix(studentMatrix);
	}
	
/**
* ҂̃}gNXԂ܂B
* @return ҂̃}gNX
* @see #getStudentMatrix()
*/
	public BooleanMatrix getTeacherMatrix(){
		return teacherMatrix;
	}
	
/**
* wK҂̃}gNXԂ܂B
* @return wK҂̃}gNX
* @see #getTeacherMatrix()
*/
	public BooleanMatrix getStudentMatrix(){
		return studentMatrix;
	}
	
/**
* ҂̉B}gNXԂ܂B
* @return ҂̉B}gNX
* @see #getReachStudentMatrix()
*/
	public BooleanMatrix getReachTeacherMatrix(){
		BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
		reachTeacherMatrix.matrixCopy(teacherMatrix.getReachMatrix());
		return reachTeacherMatrix;
	}
	
/**
* wK҂̉B}gNXԂ܂B
* @return wK҂̉B}gNX
* @see #getReachTeacherMatrix()
*/
	public BooleanMatrix getReachStudentMatrix(){
		BooleanMatrix reachStudentMatrix = new BooleanMatrix();
		reachStudentMatrix.matrixCopy(studentMatrix.getReachMatrix());
		return reachStudentMatrix;
	}
	
/**
* }gNXɂvf(s܂͗)Ԃ܂B
* @return vf
*/
	public int getElement(){
		return teacherMatrix.getRowLength();
	}
	
/**
* ҂̃}gNXɂL}̐Ԃ܂B
* @return ҂̃}gNXɂL}̐
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getTeacherEdge(){
		return teacherMatrix.getElement();
	}
	
/**
* wK҂̃}gNXɂL}̐Ԃ܂B
* @return wK҂̃}gNXɂL}̐
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getStudentEdge(){
		return studentMatrix.getElement();
	}
	
/**
* ҂̃}gNXƊwK҂̃}gNX̂ǂ炩ɂł݂L}̐Ԃ܂B
* @return ǂ炩ɂłL}̐
* @see #getAccordEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getTotelEdge(){
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		return mixMatrix.getElement();
	}
	
/**
* ҂̃}gNXɂ̂ݑ݂L}̐Ԃ܂B
* @return ҂̃}gNXɂ̂ݑ݂L}̐
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getTeacherOnlyEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_TEACHER){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* wK҂̃}gNXɂ̂ݑ݂L}̐Ԃ܂B
* @return wK҂̃}gNXɂ̂ݑ݂L}̐
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getStudentOnlyEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_STUDENT){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ҂̃}gNXɂwK҂̃}gNXɂ݂L}̐Ԃ܂B
* @return ҂ɂL}̐
* @see #getTotelEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getAccordEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_INT_TRUE){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ҂̃}gNXݒ肵܂B
* @param baseTeacherMatrix ݒ鋳҂̃}gNX
* @exception NotSquareMatrixException ҂̃}gNXsł͂Ȃꍇ
*/
	private void setTeacherMatrix(BooleanMatrix baseTeacherMatrix){
		if (baseTeacherMatrix.isSquare()){
			teacherMatrix = new BooleanMatrix();
			teacherMatrix.matrixCopy(baseTeacherMatrix);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* wK҂̃}gNXݒ肵܂B<BR>
* wK҂̃}gNX͐słA҂̃}gNXƃTCYvKv܂B
* @param baseStudentMatrix ݒwK҂̃}gNX
* @exception NotSquareMatrixException wK҂̃}gNXsł͂Ȃꍇ
* @exception DisagreementMatrixSizeException ҂̃}gNXƊwK҂̃}gNXTCYvȂꍇ
*/
	public void setStudentMatrix(BooleanMatrix baseStudentMatrix){
		if (baseStudentMatrix.isSquare()){
			if (teacherMatrix.isSameMatrixSize(baseStudentMatrix)){
				studentMatrix = new BooleanMatrix();
				studentMatrix.matrixCopy(baseStudentMatrix);
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
}