package jp.ac.takushoku_u.cs;

/**
* SPTableNXS-P\쐬sNXłB
* @version 1.1.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1206
*/
public class SPTable{
	
/**
* SP\쐬Õf[^ێ}gNXB
*/
	private ArithmeticMatrix matrix;
	
/**
* בւA̍s͉͌sڂłsԍێzB
*/
	private int[] baseRow;
	
/**
* בւA̗͉͌ڂłԍێzB
*/
	private int[] baseCol;
	
/** 
* Ӄ}[N\p̒萔ŁAӃ}[No͂鐳̔̒lB
*/
	private static final double SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 = 0.85;
	
/**
* Ӄ}[N\p̒萔ŁAӃ}[N``!''o͂Ȃ΂ȂȂӌWl\B
*/
	private static final double SPTABLE_CAUTION_MARK_CAUTION_VALUE1 = 0.5;
	
/**
* Ӄ}[N\p̒萔ŁAӃ}[N``!!''o͂Ȃ΂ȂȂӌWl\B
*/
	private static final double SPTABLE_CAUTION_MARK_CAUTION_VALUE2 = 0.75;
	
/**
* Ӄ}[N̕\Ȃ萔\B
*/
	private static final int SPTABLE_CAUTION_MARK_NON = 0;
	
/**
* Ӄ}[N̕\Ȃ\B
*/
	private static final String SPTABLE_CAUTION_MARK_NONSTRING = "";
	
/**
* Ӄ}[N``!''萔\B
*/
	private static final int SPTABLE_CAUTION_MARK_ONE = 1;
	
/**
* Ӄ}[N``!''\\B
*/
	private static final String SPTABLE_CAUTION_MARK_ONESTRING = "!";
	
/**
* Ӄ}[N''!!``萔\B
*/
	private static final int SPTABLE_CAUTION_MARK_TWO = 2;
	
/**
* Ӄ}[N''!!``\\B
*/
	private static final String SPTABLE_CAUTION_MARK_TWOSTRING = "!!";
	
/**
* }gNXTCỸftHglB
*/
	private static final int SPTABLE_MATRIX_VALUE = 5;
	
	
/**
* ݒ肳ĂftHg̃TCYŕ͂s}gNXݒ肵A͂s܂B<BR>
* }gNX̗vf͑S0ƂȂ܂B
*/
	public SPTable(){
		ArithmeticMatrix baseMatrix = new ArithmeticMatrix(SPTABLE_MATRIX_VALUE, SPTABLE_MATRIX_VALUE);
		setSPMatrix(baseMatrix);
	}
	
/**
* S-P\쐬}gNXݒ肵͂s܂B
* @param baseMatrix SP\쐬}gNX
*/
	public SPTable(ArithmeticMatrix baseMatrix){
		setSPMatrix(baseMatrix);
	}
	
/**
* S-P\Ԃ܂B
* @return S-P\
* @see #getSPFullMatrix()
*/
	public ArithmeticMatrix getSPMatrix(){
		baseRow = arrangeArray(matrix.getRowSumArray());
		baseCol = arrangeArray(matrix.getColSumArray());
		
		ArithmeticMatrix changeMatrix = new ArithmeticMatrix();
		changeMatrix.matrixCopy(matrix);
		changeMatrix.matrixCopy(getStudentChangeMatrix(matrix, baseRow));
		changeMatrix.matrixCopy(getProblemChangeMatrix(changeMatrix, baseCol));
		
		//בւʂS-P\ɒǉ
		for (int i = 0; i < changeMatrix.getRowLength(); i++){
			changeMatrix.setRowName(i, matrix.getRowName(baseRow[i]));
		}
		for (int j = 0; j < changeMatrix.getColLength(); j++){
			changeMatrix.setColName(j, matrix.getColName(baseCol[j]));
		}
		
		return changeMatrix;
	}
		
/**
* ӌWl܂߂S-P\Ԃ܂B<BR>
* }gNXɐAҐAAӌWlAӃ}[N܂܂܂B
* S-P\쐬Õ}gNXɔ׃TCY4sA4񕪑傫ȂĂ܂B
* Ӄ}[N͐ŕ\A`!'`1'A`!!'`2'ƂȂ܂B
* @return ӌWl܂߂S-P\
* @see #getSPMatrix()
* @see #getSPStringMatrix()
*/
	public ArithmeticMatrix getSPFullMatrix(){
		String rowName[] = new String[matrix.getRowLength()+4];
		String colName[] = new String[matrix.getColLength()+4];
		
		System.arraycopy(matrix.getRowNameArray(), 0, rowName, 0, matrix.getRowLength());
		System.arraycopy(matrix.getColNameArray(), 0, colName, 0, matrix.getColLength());
		rowName[matrix.getRowLength()] = "Ґ";
		rowName[matrix.getRowLength()+1] = "";
		rowName[matrix.getRowLength()+2] = "ӌW";
		rowName[matrix.getRowLength()+3] = "Ӄ}[N";
		
		colName[matrix.getColLength()] = "";
		colName[matrix.getColLength()+1] = "";
		colName[matrix.getColLength()+2] = "ӌW";
		colName[matrix.getColLength()+3] = "Ӄ}[N";
		
		ArithmeticMatrix spFullMatrix = new ArithmeticMatrix(matrix.getRowLength()+4,matrix.getColLength()+4, rowName, colName);
		ArithmeticMatrix spMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength());
		spMatrix.matrixCopy(getSPMatrix());
		
		//S-P\̃Rs[
		spFullMatrix.matrixCopy(spMatrix, 0, 0, 0, 0, spMatrix.getRowLength(), spMatrix.getColLength());
		
		//k̏
		for(int i = 0; i < spMatrix.getRowLength(); i++){
			spFullMatrix.setRowName(i, spMatrix.getRowName(i));		//kRs[
			spFullMatrix.setCell(i,matrix.getColLength(),getStudentSum(getBaseRow(i)));		//
			spFullMatrix.setCell(i,matrix.getColLength()+1,getStudentAverage(getBaseRow(i)));		//ϐ
			spFullMatrix.setCell(i,matrix.getColLength()+2,getStudentAttentionCoefficient(getBaseRow(i)));		//ӌW
			spFullMatrix.setCell(i,matrix.getColLength()+3, getStudentAttentionNumber(getBaseRow(i)));		//Ӄ}[N
		}
		
		//葤̏
		for(int j = 0; j < spMatrix.getColLength(); j++){
			spFullMatrix.setColName(j, spMatrix.getColName(j));		//薼Rs[
			spFullMatrix.setCell(matrix.getRowLength(), j,getProblemSum(getBaseCol(j)));		//Ґ
			spFullMatrix.setCell(matrix.getRowLength()+1, j,getProblemAverage(getBaseCol(j)));		//ϐ
			spFullMatrix.setCell(matrix.getRowLength()+2, j,getProblemAttentionCoefficient(getBaseCol(j)));		//ӌW
			spFullMatrix.setCell(matrix.getRowLength()+3, j,getProblemAttentionNumber(getBaseCol(j)));		//Ӄ}[N
		}
		
		//Ŝ̕ϐ̒ǉ
		spFullMatrix.setCell(getStudentNumber()+1, getProblemNumber()+1, getAverage());
		return spFullMatrix;
	}
	
/**
* ӌWl܂߂S-P\Ԃ܂B<BR>
* }gNXɐAҐAAӌWlAӃ}[N܂܂܂B
* S-P\쐬Õ}gNXɔ׃TCY4sA4񕪑傫ȂĂ܂B
* Ӄ}[N`!'`!!'ŕ\܂B
* @return ӌWl܂߂S-P\
* @see #getSPMatrix()
* @see #getSPFullMatrix()
*/
	public StringMatrix getSPStringMatrix(){
		String rowName[] = new String[matrix.getRowLength()+4];
		String colName[] = new String[matrix.getColLength()+4];
		
		System.arraycopy(matrix.getRowNameArray(), 0, rowName, 0, matrix.getRowLength());
		System.arraycopy(matrix.getColNameArray(), 0, colName, 0, matrix.getColLength());
		rowName[matrix.getRowLength()] = "Ґ";
		rowName[matrix.getRowLength()+1] = "";
		rowName[matrix.getRowLength()+2] = "ӌW";
		rowName[matrix.getRowLength()+3] = "Ӄ}[N";
		
		colName[matrix.getColLength()] = "";
		colName[matrix.getColLength()+1] = "";
		colName[matrix.getColLength()+2] = "ӌW";
		colName[matrix.getColLength()+3] = "Ӄ}[N";
		
		StringMatrix spFullMatrix = new StringMatrix(matrix.getRowLength()+4,matrix.getColLength()+4, rowName, colName);
		ArithmeticMatrix spMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength());
		spMatrix.matrixCopy(getSPMatrix());
		
		//S-P\̃Rs[
		spFullMatrix.matrixCopy(spMatrix, 0, 0, 0, 0, spMatrix.getRowLength(), spMatrix.getColLength());
		
		//k̏
		for(int i = 0; i < spMatrix.getRowLength(); i++){
			spFullMatrix.setRowName(i, spMatrix.getRowName(i));		//kRs[
			spFullMatrix.setCell(i,matrix.getColLength(),getStudentSum(getBaseRow(i))+"");		//
			spFullMatrix.setCell(i,matrix.getColLength()+1,getStudentAverage(getBaseRow(i))+"");		//ϐ
			spFullMatrix.setCell(i,matrix.getColLength()+2,getStudentAttentionCoefficient(getBaseRow(i))+"");		//ӌW
			spFullMatrix.setCell(i,matrix.getColLength()+3, getStudentAttentionMark(getBaseRow(i)));		//Ӄ}[N
		}
		
		//葤̏
		for(int j = 0; j < spMatrix.getColLength(); j++){
			spFullMatrix.setColName(j, spMatrix.getColName(j));		//薼Rs[
			spFullMatrix.setCell(matrix.getRowLength(), j,getProblemSum(getBaseCol(j))+"");		//Ґ
			spFullMatrix.setCell(matrix.getRowLength()+1, j,getProblemAverage(getBaseCol(j))+"");		//ϐ
			spFullMatrix.setCell(matrix.getRowLength()+2, j,getProblemAttentionCoefficient(getBaseCol(j))+"");		//ӌW
			spFullMatrix.setCell(matrix.getRowLength()+3, j,getProblemAttentionMark(getBaseCol(j)));		//Ӄ}[N
		}
		
		//Ŝ̕ϐ̒ǉ
		spFullMatrix.setCell(getStudentNumber()+1, getProblemNumber()+1, getAverage()+"");
		return spFullMatrix;
	}
	
/**
* (܂͐Ґ)̑ɕבւ܂B
* @param totalArray ek()̐ꂽz
* @return בւz͌̉Ԗڂɂ܂
*/
	private int[] arrangeArray(double[] totalArray){
		int number; //ő̍sԍێ
		int[] returnArray = new int[totalArray.length];
		
		//PI@Ń\[g
		for (int i = 0; i < totalArray.length; i++){
			number = i;
			for (int j = 0; j < totalArray.length; j++){ 
				if (totalArray[number] < (int)totalArray[j]){
					number = j;
				}
			}
			totalArray[number] = -1;
			returnArray[i] = number;
		}
		return returnArray;
	}
	
/**
* ̑ɕבւ}gNXԂ܂B
* @param baseMatrix ͌̃}gNX
* @param row sԍ𐳓̑ɕבւz
* @return בւ}gNX
*/
	private ArithmeticMatrix getStudentChangeMatrix(ArithmeticMatrix baseMatrix,int[] row){
		ArithmeticMatrix rowChangeMatrix = new ArithmeticMatrix();
		rowChangeMatrix.matrixCopy(baseMatrix);
		int max = (int) baseMatrix.getRowSum(row[0]); //̎̐(i[̍ŏl)
		max++;
		int roop = 1; //lĂ邩
		for (int i = 0; i < baseMatrix.getRowLength(); i++){
			
			//vf̊i[
			for (int j = 0; j < baseMatrix.getColLength(); j++){
				rowChangeMatrix.setCell(i, j, baseMatrix.getCell(row[i], j));
			}
			
			//i[œ̐̐kȂꍇ
			if (max > baseMatrix.getRowSum(row[i])){
				roop = 1;
				max = (int)baseMatrix.getRowSum(row[i]);
			}
			//̐ꍇ
			else{
				roop++;
				int compareI = i; //rۂi̒l
				for (int k = 1; k < roop; k++){
					//2҂rTurȅꍇ͌s
					if (compareStudent(baseMatrix, row[compareI-1], row[compareI])){
						//̍sԍi[ž
						int temp = row[compareI];
						row[compareI] = row[compareI-1];
						row[compareI-1] = temp;
						
						//vf̌
						for (int m = 0; m < baseMatrix.getColLength(); m++){
							rowChangeMatrix.setCell(compareI-1, m, baseMatrix.getCell(row[compareI-1], m));
							rowChangeMatrix.setCell(compareI, m, baseMatrix.getCell(row[compareI], m));
						}
						compareI--;
					}
					else{
						//[v𔲂
						k = roop;
					}
				}
			}
		}
		return rowChangeMatrix;
	}
	
/**
* Ґ̑ɕבւ}gNXԂ܂B
* @param baseMatrix ҂̑ɕבւI}gNX
* @param col ԍ𐳓Ґ̑ɕבւz
* @return בւ}gNX
*/
	private ArithmeticMatrix getProblemChangeMatrix(ArithmeticMatrix baseMatrix,int[] col){
		ArithmeticMatrix colChangeMatrix = new ArithmeticMatrix();
		colChangeMatrix.matrixCopy(baseMatrix);
		int max = (int) baseMatrix.getColSum(col[0]); //̎̐(i[̍ŏl)
		max++;
		int roop = 1; //lĂ邩
		for (int i = 0; i < baseMatrix.getColLength(); i++){
			
			//vf̊i[
			for (int j = 0; j < baseMatrix.getRowLength(); j++){
				colChangeMatrix.setCell(j, i, baseMatrix.getCell(j, col[i]));
			}
			
			//i[œ̐Ґ̖肪Ȃꍇ
			if (max > baseMatrix.getColSum(col[i])){
				roop = 1;
				max = (int) baseMatrix.getColSum(col[i]);
			}
			//̐Ґꍇ
			else{
				roop++;
				int compareI = i; //rۂi̒l
				for (int k = 1; k < roop; k++){
					//2҂rTurȅꍇ͌s
					if (compareProblem(baseMatrix, col[compareI-1], col[compareI])){
						//̍sԍi[ž
						int temp = col[compareI];
						col[compareI] = col[compareI-1];
						col[compareI-1] = temp;
						
						//vf̌
						for (int m = 0; m < baseMatrix.getRowLength(); m++){
							colChangeMatrix.setCell(m, compareI-1, baseMatrix.getCell(m, col[compareI-1]));
							colChangeMatrix.setCell(m, compareI, baseMatrix.getCell(m, col[compareI]));
						}
						compareI--;
					}
					else{
						//[v𔲂
						k = roop;
					}
				}
			}
		}
		return colChangeMatrix;
	}
	
/**
* ̐̐kmr܂B
* @param baseMatrix ւsÕ}gNX
* @param studentA r鐶kԍ1
* @param studentB r鐶kԍ2
* @return rʂ k1 < k2 ̎ True A k1 >= k2 ̎ False Ԃ܂
*/
	private boolean compareStudent(ArithmeticMatrix baseMatrix, int studentA, int studentB){
		int studentATotal = 0; //k̖̑
		int studentBTotal = 0;
		for (int i = 0; i < baseMatrix.getColLength(); i++){
			studentATotal = (int) baseMatrix.getCell(studentA, i) * 
				(int) baseMatrix.getColSum(i) + studentATotal;
			studentBTotal = (int) baseMatrix.getCell(studentB, i) * 
				(int) baseMatrix.getColSum(i) + studentBTotal;
		}
		return studentATotal < studentBTotal;
	}
/**
* ̐Ґ̖蓯mr܂B
* @param baseMatrix ւsÕ}gNX
* @param problemA rԍ1
* @param problemB rԍ2
* @return rʂ 1 < 2 ̎ True A 1 >= 2 ̎ False Ԃ܂
*/
	private boolean compareProblem(ArithmeticMatrix baseMatrix, int problemA, int problemB){
		int problemATotal = 0; //Ă̑Ґ
		int problemBTotal = 0;
		for (int i = 0; i < baseMatrix.getRowLength(); i++){
			problemATotal = (int) baseMatrix.getCell(i, problemA) * 
				(int) baseMatrix.getRowSum(i) + problemATotal;
			problemBTotal = (int) baseMatrix.getCell(i, problemB) * 
				(int) baseMatrix.getRowSum(i) + problemBTotal;
		}
		return problemATotal < problemBTotal;
	}
	
/**
* w肵wK(s)̐Ԃ܂B
* @param row w肵wK҂̕בւO̍sԍ
* @return w肵wK҂̐
* @exception NotElementException w肵wK҂݂Ȃꍇ
* @see #getProblemSum(int col)

*/
	public int getStudentSum(int row){
		if (matrix.isRowNumber(row)){
			return (int)matrix.getRowSum(row);
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* w肵()̐ҐԂ܂B
* w肷̕בւO̗ԍ
* @return w肵̐Ґ
* @exception NotElementException w肵肪݂Ȃꍇ
* @see #getStudentSum(int row)
*/
	public int getProblemSum(int col){
		if (matrix.isColNumber(col)){
			return (int)matrix.getColSum(col);
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* SȐzԂ܂B
* z̗vfԍS-P\ɂsԍɑΉĂ܂B
* i[ꂽlSȐ̂E̗ԍ܂B
* @return SȐz
* @see #getPArray()
*/
	public int[] getSArray(){
		int sArray[] = new int[getStudentNumber()];
		for (int i = 0; i < getStudentNumber(); i++){
			sArray[i] = (int) matrix.getRowSum(getBaseRow(i));
		}
		return sArray;
	}
	
/**
* PȐzԂ܂B
* z̗vfԍS-P\ɂԍɑΉĂ܂B
* i[ꂽlPȐ̒̍sԍ܂B
* @return PȐz
* @see #getSArray()
*/
	public int[] getPArray(){
		int pArray[] = new int[getProblemNumber()];
		for (int i = 0; i < getProblemNumber(); i++){
			pArray[i] = (int) matrix.getColSum(getBaseCol(i));
		}
		return pArray;
	}
	
/**
* w肵wK(s)̐Ԃ܂B
* @param row w肷wK҂̕בւO̍sԍ
* @return w肵wK҂̕ϐ
* @exception NotElementException w肵wK҂݂Ȃꍇ
* @see #getProblemAverage(int col)
*/
	public double getStudentAverage(int row){
		if (matrix.isRowNumber(row)){
			return getStudentSum(row) * 1.0 / getProblemNumber() * 100.0;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
/**
* w肵()̐Ԃ܂B
* @param col w肷̕בւO̗ԍ
* @return w肵̕ϐ
* @exception NotElementException w肵肪݂Ȃꍇ
* @see #getStudentAverage(int row)
*/
	public double getProblemAverage(int col){
		if (matrix.isColNumber(col)){
			return getProblemSum(col) * 1.0 / getStudentNumber() * 100.0;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* kŜ̕ϐԂ܂B
* @return ϐ
* @see #getProblemAverage()
* @see #getAverage()
*/
	public double getStudentAverage(){
		double value = 0.0;
		for (int i = 0; i < getStudentNumber(); i++){
			value = getStudentSum(i) + value;
		}
		return value / getStudentNumber();
	}
	
/**
* Ŝ̕ϐҐԂ܂B
* @return ϐҐ
* @see #getStudentAverage()
* @see #getAverage()
*/
	public double getProblemAverage(){
		double value = 0.0;
		for (int i = 0; i < getProblemNumber(); i++){
			value = getProblemSum(i) + value;
		}
		return value / getProblemNumber();
	}
	
/**
* S-P\Ŝ̕ϐԂ܂B
* @return ϐ
* @see #getStudentAverage()
* @see #getProblemAverage()
*/
	public double getAverage(){
		double value = 0.0;
		for (int i = 0; i < getStudentNumber(); i++){
			value = getStudentSum(i) + value;
		}
		return value * 100 / (getStudentNumber() * getProblemNumber());
	}
	
/**
* w肵wK(s)̒ӌWԂ܂B
* @param row w肷wK҂̕בւO̍sԍ
* @return w肵wK҂̒ӌW
* @exception NotElementException w肵wK҂݂Ȃꍇ
* @see #getProblemAttentionCoefficient(int col)
*/
	public double getStudentAttentionCoefficient(int row){
		if (matrix.isRowNumber(row)){
		
		//SȐ̎
		int sArray[] = new int[getStudentNumber()];
		System.arraycopy(getSArray(), 0, sArray, 0, getStudentNumber());
		
		//kSiSȐ獶``0''ɑΉ̐Ґ̘a
		double zeroProblem;
		
		//kSiSȐE``1''ɑΉ̐Ґ̘a
		double oneProblem;
		
		//kSiSȐ獶̖̐Ґ̘a
		double leftProblem;
		
		//߂l
		double value;
			
			//0̏ꍇ(ٓ_)
			if (getStudentSum(row) == 0.0){
				value = 1.0;
			}
			
			//S␳̏ꍇ
			else if (getStudentSum(row) == getProblemNumber()){
				value = 0.0;
			}
			else{
				zeroProblem = 0.0;
				oneProblem = 0.0;
				leftProblem = 0.0;
				
				//SȐ獶
				for (int j = 0; j < sArray[getSPRow(row)]; j++){
					if (matrix.getCell(row, getBaseCol(j)) == 0){
						zeroProblem = getProblemSum(getBaseCol(j)) + zeroProblem;
					}
					leftProblem = getProblemSum(getBaseCol(j)) + leftProblem;
				}
				
				//SȐE
				for (int k = sArray[getSPRow(row)]; k < getProblemNumber(); k++){
					if (matrix.getCell(row, getBaseCol(k)) == 1){
						oneProblem = getProblemSum(getBaseCol(k)) + oneProblem;
					}
				}
				
				//ӌW̌vZ
				value = (zeroProblem - oneProblem) / 
					(leftProblem - getStudentSum(row) * getProblemAverage());
			}
		return value;
	}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* w肵()̒ӌWԂ܂B
* @param col w肷̕בւO̗ԍ
* @return w肵̒ӌW
* @exception NotElementException w肵肪݂Ȃꍇ
* @see #getStudentAttentionCoefficient(int row)
*/
	public double getProblemAttentionCoefficient(int col){
		if (matrix.isColNumber(col)){
		
		//PȐ̎
		int pArray[] = new int[getProblemNumber()];
		System.arraycopy(getPArray(), 0, pArray, 0, getProblemNumber());
		
		//IiPȐ``0''ɑΉ鐶k̘̐a
		double zeroStudent;
		
		//IiPȐ牺``1''ɑΉ鐶k̘̐a
		double oneStudent;
		
		//IiPȐ̐k̐҂̘a
		double upStudent;
		
		//߂l
		double value;
			
			//Ґ0̏ꍇ(ٓ_)
			if (getProblemSum(col) == 0.0){
				value = 1.0;
			}
			
			//S̏ꍇ
			else if (getProblemSum(col) == getStudentNumber()){
				value = 0.0;
			}
			else{
				zeroStudent = 0.0;
				oneStudent = 0.0;
				upStudent = 0.0;
				
				//PȐ
				for (int j = 0; j < pArray[getSPCol(col)]; j++){
					if (matrix.getCell(getBaseRow(j), col) == 0){
						zeroStudent = getStudentSum(getBaseRow(j)) + zeroStudent;
					}
					upStudent = getStudentSum(getBaseRow(j)) + upStudent;
				}
				
				//PȐ艺
				for (int k = pArray[getSPCol(col)]; k < getStudentNumber(); k++){
					if (matrix.getCell(getBaseRow(k), col) == 1){
						oneStudent = getStudentSum(getBaseRow(k)) + oneStudent;
					}
				}
				
				//ӌW̌vZ
				value = (zeroStudent - oneStudent) / 
					(upStudent - getProblemSum(col) * getStudentAverage());
			}
			return value;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* wK҂̒Ӄ}[NԂ܂B
* @param row w肷wK҂̕בւO̍sԍ
* @return w肵wK҂̒Ӄ}[N
* @exception NotElementException w肵wK҂݂Ȃꍇ
* @see #getProblemAttentionMark(int col)
* @see #getStudentAttentionNumber(int row)
*/
	public String getStudentAttentionMark(int row){
		if (matrix.isRowNumber(row)){
		
		//ӌW
		double attention = getStudentAttentionCoefficient(row);
		
		//߂l
		String mark;
			if (getStudentAverage(row) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWOSTRING;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONESTRING;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NONSTRING;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NONSTRING;
			}
			return mark;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ̒Ӄ}[NԂ܂B
* @param col w肷̕בւO̗ԍ
* @return w肵̒Ӄ}[N
* @exception NotElementException w肵肪݂Ȃꍇ
* @see #getStudentAttentionMark(int row)
* @see #getProblemAttentionNumber(int col)
*/
	public String getProblemAttentionMark(int col){
		if (matrix.isColNumber(col)){
		//ӌW
		double attention = getProblemAttentionCoefficient(col);
		
		//߂l
		String mark;
		
			if (getProblemAverage(col) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWOSTRING;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONESTRING;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NONSTRING;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NONSTRING;
			}
			return mark;
	}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* wK҂̒Ӄ}[NԂ܂B
* }[NȂ̏ꍇ0A`!'̏ꍇ1A`!!'̏ꍇ2Ŏ܂B
* @param row w肷wK҂̕בւO̍sԍ
* @return w肵wK҂̒Ӄ}[N
* @exception NotElementException w肵wK҂݂Ȃꍇ
* @see #getProblemAttentionNumber(int col)
* @see #getStudentAttentionMark(int row)
*/
	public int getStudentAttentionNumber(int row){
		if (matrix.isRowNumber(row)){
		//ӌW
		double attention = getStudentAttentionCoefficient(row);
		
		//߂l
		int mark;
			if (getStudentAverage(row) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWO;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONE;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NON;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NON;
			}
			return mark;
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* ̒Ӄ}[NԂ܂B
* }[NȂ̏ꍇ0A`!'̏ꍇ1A`!!'̏ꍇ2Ŏ܂B
* @param col w肷̕בւO̗ԍ
* @return w肵̒Ӄ}[N
* @exception NotElementException w肵肪݂Ȃꍇ
* @see #getStudentAttentionNumber(int row)
* @see #getProblemAttentionMark(int col)
*/
	public int getProblemAttentionNumber(int col){
		if (matrix.isColNumber(col)){
		//ӌW
		double attention = getProblemAttentionCoefficient(col);
		
		//߂l
		int mark;
		
			if (getProblemAverage(col) < SPTABLE_CAUTION_MARK_SCORE_AVERAGE1 * 100){
				if (SPTABLE_CAUTION_MARK_CAUTION_VALUE2 <= attention){
					mark = SPTABLE_CAUTION_MARK_TWO;
				}
				else if (SPTABLE_CAUTION_MARK_CAUTION_VALUE1 <= attention){
					mark = SPTABLE_CAUTION_MARK_ONE;
				}
				else{
					mark = SPTABLE_CAUTION_MARK_NON;
				}
			}
			else{
				mark = SPTABLE_CAUTION_MARK_NON;
			}
			return mark;
		}
		else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* S-P\쐬Õ}gNXԂ܂B
* @return S-P\쐬Õ}gNX
*/
	public ArithmeticMatrix getBaseSPMatrix(){
		return matrix;
	}
	
/**
* S-P\ɑ݂wKҐ(s)Ԃ܂B
* @return wKҐ
* @see #getProblemNumber()
*/
	public int getStudentNumber(){
		return matrix.getRowLength();
	}
	
/**
* S-P\ɑ݂萔()Ԃ܂B
* @return 萔
* @see #getStudentNumber()
*/
	public int getProblemNumber(){
		return matrix.getColLength();
	}
	
/**
* w肵sS-P\쐬Õ}gNXł͉sڂɂA̍sԍԂ܂B
* @param row S-P\ɂsԍ
* @return ̕\ɂsԍ
* @exception NotElementException w肳ꂽsԍ݂Ȃꍇ
* @see #getBaseCol(int col)
* @see #getBaseRowArray()
*/
	public int getBaseRow(int row){
		if (matrix.isRowNumber(row)){ //}gNX͈͓̔ǂ𒲂ׂ
		return baseRow[row];
		}
		else{
			throw new NotElementException("row("+ row +")");
		}
	}
	
/**
* S-P\쐬Õ}gNXł͉sڂɂA̍sԍzԂ܂B
* @return sԍ̓z
* @see #getBaseColArray()
* @see #getBaseRow(int row)
*/
	public int[] getBaseRowArray(){
		return baseRow;
	}
	
/**
* w肵S-P\쐬Õ}gNXł͉ڂɂA̗ԍԂ܂B
* @param col S-P\ɂԍ
* @return ̕\ɂԍ
* @exception NotElementException w肳ꂽԍ݂Ȃꍇ
* @see #getBaseRow(int row)
* @see #getBaseColArray()
*/
	public int getBaseCol(int col){
		if (matrix.isColNumber(col)){ //}gNX͈͓̔ǂ𒲂ׂ
		return baseCol[col];
		}
			else{
			throw new NotElementException("col("+ col +")");
		}
	}
	
/**
* S-P\쐬Õ}gNXł͉ڂɂA̗ԍzԂ܂B
* @return ԍ̓z
* @see #getBaseRowArray()
* @see #getBaseCol(int col)
*/
	public int[] getBaseColArray(){
		return baseCol;
	}
	
/**
* w肵sS-P\쐬̃}gNXł͉sڂɂ邩AsԍԂ܂B
* @param row ̕\ɂsԍ
* @return S-P\ɂsԍ
* @exception NotElementException w肳ꂽsԍ݂Ȃꍇ
*/
	private int getSPRow(int row){
		if (matrix.isRowNumber(row)){ //}gNX͈͓̔ǂ𒲂ׂ
			for(int i = 0; i < getStudentNumber(); i++){
				if(row == baseRow[i]){
					return i;
				}
			}
		}
			throw new NotElementException("row("+ row +")");
	}
	
/**
* w肵S-P\쐬̃}gNXł͉ڂɂ邩AԍԂ܂B
* @param col ̕\ɂԍ
* @return S-P\ɂԍ
* @exception NotElementException w肳ꂽԍ݂Ȃꍇ
*/
	private int getSPCol(int col){
		if (matrix.isColNumber(col)){ //}gNX͈͓̔ǂ𒲂ׂ
			for(int i = 0; i < getProblemNumber(); i++){
				if(col == baseCol[i]){
					return i;
				}
			}
		}
			throw new NotElementException("col("+ col +")");
	}
	
/**
* S-P\쐬Õ}gNXݒ肵܂B
* @param baseMatrix ݒs}gNX
*/
	private void setBaseMatrix(ArithmeticMatrix baseMatrix){
		matrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.matrixCopy(baseMatrix);
	}
	
/**
* בւO̍sԍێz𐶐܂B
* @param baseMatrix ͑Ώۂ̃}gNX
*/
	private void setBaseRow(ArithmeticMatrix baseMatrix){
		baseRow = new int[baseMatrix.getRowLength()];
	}
	
/**
* בւO̗ԍێz𐶐܂B
* @param baseMatrix ͑Ώۂ̃}gNX
*/
	private void setBaseCol(ArithmeticMatrix baseMatrix){
		baseCol = new int[baseMatrix.getColLength()];
	}
	
/**
* S-P\쐬錳ƂȂ}gNXݒ肵AS-P\쐬܂B
* @param baseMatrix 쐬sƂȂ}gNX
*/
	public void setSPMatrix(ArithmeticMatrix baseMatrix){
		setBaseMatrix(baseMatrix);
		setBaseRow(matrix);
		setBaseCol(matrix);
	}
	
/**
* S-P\쐬錳ƂȂ}gNX̗vfC܂B
* @param row Cvf̍s
* @param col Cvf̗
* @param value Cl
* @exception NotElementException w肵vf݂Ȃꍇ
* @see #setSPMatrix(ArithmeticMatrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			matrix.setCell(row, col, value);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
}