package jp.ac.takushoku_u.cs;

/**
* SequenceNX͌n񉻂ꂽێNXłB
* n񏇂ƂĕێĂԍ͗אڃ}gNXɂۂ̍s܂͗ԍłB
* @version 1.01
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1206
*/
public class Sequence{
	
/**
* n񏇂ێz
*/
	private int[] queue;
	
/**
* n񂳂ꂽvfɕtĂ閼Oێz
*/
	private String[] queueName;
	
/**
* vf0Sequence𐶐܂B
* O͔zԍŐݒ肳܂B
*/
	public Sequence(){
		setLength(0);
		setItemNameNumber();
	}
	
/**
* vfvolumeSequence𐶐܂B
* O͔zԍŐݒ肳܂B
* @param volume vf
* @exception NegativeSequenceSizeException ̃TCYSequence𐶐悤Ƃꍇ
*/
	public Sequence(int volume){
		setLength(volume);
		setItemNameNumber();
	}
	
/**
* w肵zvfƂĎSequence𐶐܂B
* O͔zԍŐݒ肳܂B
* @param baseArray vfɂz
*/
	public Sequence(int[] baseArray){
		setLength(baseArray.length);
		System.arraycopy(baseArray, 0, queue, 0, baseArray.length);
		setItemNameNumber();
	}
	
/**
* w肵zvfїvfƂĎSequence𐶐܂B
* @param baseArray vfɂz
* @param baseNameArray vfɂz
* @exception IndexOutOfBoundsException z̃Rs[ɂĔz̋Ezf[^̃ANZXꍇ
*/
	public Sequence(int[] baseArray, String[] baseNameArray){
		//if(baseArray.length == baseNameArray.length)
		setLength(baseArray.length);
		System.arraycopy(baseArray, 0, queue, 0, baseArray.length);
		System.arraycopy(baseNameArray, 0, queueName, 0, baseNameArray.length);
	}
	
	
/**
* w肳ꂽԍ̗vfԂ܂B
* @param index w肷ԍ
* @return vf
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public int getItem(int index){
		if(isSequenceEntityPoint(index)){
			return queue[index];
		}
		else{
			throw new NotElementException("index(" + index + ")");
		}
	}
	
/**
* w肵ԍɗvfݒ肵܂B
* @param index w肷ԍ(Sequqncȅ)
* @param number w肷vf
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public void setItem(int index, int number){
		if(isSequenceEntityPoint(index)){
			queue[index] = number;
		}
		else{
			throw new NotElementException("index(" + index + ")");
		}
	}
	
/**
* w肳ꂽԍ̗vfԂ܂B
* @param index w肷ԍ
* @return vf
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public String getItemName(int index){
		if(isSequenceEntityPoint(index)){
			return queueName[index];
		}
		else{
			throw new NotElementException("index(" + index + ")");
		}
	}
	
/**
* w肵ԍɗvfݒ肵܂B
* @param index w肷ԍ(Sequqncȅ)
* @param name w肷vf
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public void setItemName(int index, String name){
		if(isSequenceEntityPoint(index)){
			queueName[index] = name;
		}
		else{
			throw new NotElementException("index(" + index + ")");
		}
	}
	
/**
* w肵vf̔ԍ()Ԃ܂B
* @param element w肵vf
* @return ԍ
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public int getNumber(int element){
		for(int i = 0; i < getLength(); i++){
			if(getItem(i) == element){
				return i;
			}
		}
	
		throw new NotElementException("element(" + element + ")");
	}
	
/**
* w肵vf̔ԍ()Ԃ܂B
* @param element w肵vf
* @return ԍ
* @exception NotElementException w肵vf݂Ȃꍇ
*/
	public int getNumberName(String element){
		for(int i= 0; i < getLength(); i++){
			if(getItemName(i).equals(element)){
				return i;
			}
		}
	
		throw new NotElementException("element(" + element + ")");
	}
	
/**
* SequenceɑSequenceRs[܂B
* @param copySequence Rs[Sequence
*/
	public void sequenceCopy(Sequence copySequence){
		if(copySequence.getLength() != getLength()){
			setLength(copySequence.getLength());
		}
		for(int i = 0; i < copySequence.getLength(); i++){
			setItem(i , copySequence.getItem(i));
			setItemName(i , copySequence.getItemName(i));
		}
	}
	
/**
* Ozɔzԍݒ肵܂B<BR>
* zԍ0n܂邽߁A0珇ɐݒ肳܂B 
*/
	public void setItemNameNumber(){
		for (int i = 0; i < getLength(); i++){
			setItemName(i, i +"");
		}
	}
	
/**
* Ozstartn܂ԍݒ肵܂B<BR>
* @param start ŏ̖Otԍ
*/
	public void setItemNameNumber(int start){
		for (int i = 0; i < getLength(); i++){
			setItemName(i, i + start +"");
		}
	}
	
/**
* SequencẽTCYԂ܂B
* @return TCY
*/
	public int getLength(){
		return queue.length;
	}
	
/**
* SequencẽTCYݒ肵܂B
* @param volume w肷TCY
* @exception NegativeSequenceSizeException ̃TCYSequence𐶐悤Ƃꍇ
*/
	public void setLength(int volume){
		if(volume >= 0){
			queue = new int[volume];
			queueName = new String[volume];
		}
		else{
			throw new NegativeSequenceSizeException();
		}
	}
	
/**
* w肳ꂽvf݂邩`FbN܂B
* @param index w肷vf
* @return ݂ true
*/
	public boolean isSequenceEntityPoint(int index){
		return (0 <= index) && (index < getLength());
	}
	
/**
* vfƂĎw肵vfɕ̐Ȃ`FbN܂B
*/
	private boolean isPositive(int[] array){
		boolean flag = true;
		for(int i= 0; i < array.length; i++){
			if(array[i] < 0){
				flag = false;
			}
		}
		return flag;
	}
/**
* vfƂĎw肵vfɓԍȂ`FbN܂B
*/
	private boolean isSameItem(int[] array){
		boolean flag = true;
		for(int i = 0; i < array.length; i++){
			for(int j = 0; j < array.length; j++){
				if(i != j && array[i] == array[j]){
					flag = false;
				}
			}
		}
		return flag;
	}
}