package jp.ac.takushoku_u.cs;

/**
* IRSAnalysisNXIRS͂s߂̃NXłB
* @version 1.1.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1206
*/
public class IRSAnalysis{

/**
* ͌̃}gNXێ}gNXB
*/
	private ArithmeticMatrix matrix;
	
/**
* lێϐB
*/
	private double thresholdValue;
	
/**
* }gNX̑傫̏lB
*/
	private static final int IRSANALYSIS_MATRIX_VALUE = 5;

/**
* l̏lB
*/
	private static final double IRSANALYSIS_THRESHOLD = 0.5;

/**
* IRS}gNXIRSOt}gNXɓl(֘AꍇjB
*/
	private static final int IRSANALYSIS_SEQUENCE_TRUE = 1;

/**
* IRS}gNXIRSOt}gNXɓl(֘AȂꍇjB
*/
	private static final int IRSANALYSIS_SEQUENCE_FALSE = 0;

	
/**
* ݒ肳ĂftHg̃TCYŕ͂s}gNXݒ肵܂B
*/
	public IRSAnalysis(){
		ArithmeticMatrix baseMatrix = new ArithmeticMatrix(IRSANALYSIS_MATRIX_VALUE,IRSANALYSIS_MATRIX_VALUE);		//}gNX̍쐬
		setMatrix(baseMatrix);		//}gNX̐
		matrix.clearMatrix();		//}gNX̗vf
		setThreshold(IRSANALYSIS_THRESHOLD);		//l̐ݒ
	}
	
/**
* ɕ͑Ώۂ̃}gNXݒ肵܂B
* l̓ftHglŐݒ肳܂B
* @param baseMatrix ͑Ώۂ̃}gNX
*/
	public IRSAnalysis(ArithmeticMatrix baseMatrix){
		setMatrix(baseMatrix);
		setThreshold(IRSANALYSIS_THRESHOLD);
	}
	
/**
* ɕ͑Ώۂ̃}gNXƂlݒ肵܂B
* @param baseMatrix ͑Ώۂ̃}gNX
* @param threshold ݒ肷邵l
*/
	public IRSAnalysis(ArithmeticMatrix baseMatrix, double threshold){
		setMatrix(baseMatrix);
		setThreshold(threshold);
	}
	
/**
* ͑ΏۂƂĐݒ肳Ă}gNXԂ܂B
* @return ͑Ώۂ̃}gNX
*/
	public ArithmeticMatrix getMatrix(){
		return matrix;
	}
	
/**
* IRS}gNXԂ܂B
* @return IRS}gNX
*/
	public ArithmeticMatrix getIRSMatrix(){
		
		//W}gNX̎
		ArithmeticMatrix coefficientMatrix = new ArithmeticMatrix();
		coefficientMatrix.matrixCopy(getCoefficientMatrix());
		
		ArithmeticMatrix irsMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		int value;
		for (int i = 0; i <  irsMatrix.getRowLength(); i++){
			for (int j = 0; j <  irsMatrix.getColLength(); j++){
				if (thresholdValue <= coefficientMatrix.getCell(i, j)){	//邩ǂ0,1ݒ肷
					value = IRSANALYSIS_SEQUENCE_TRUE;
				}
				else{
					value = IRSANALYSIS_SEQUENCE_FALSE;
				}
				irsMatrix.setCell(i, j, value);
			}
		}
		return irsMatrix;
	}
	
/**
* W}gNX߂܂B
* @return W}gNX
*/
	public ArithmeticMatrix getCoefficientMatrix(){
		ArithmeticMatrix coefficientMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		for (int i = 0; i < coefficientMatrix.getRowLength(); i++){
			for (int j = 0; j < coefficientMatrix.getColLength(); j++){
				coefficientMatrix.setCell(i, j, getCoefficient(i, j));
			}
		}
		return coefficientMatrix;
	}
	
/**
* 鍀IjƍIkԂ̓xz\߂܂B
* @param Ij Ij
* @param Ik Ik
* @return Ij獀Ikւ̓xz\
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	public ArithmeticMatrix getFrequencyMatrix(int Ij, int Ik){
		if (matrix.isColNumber(Ij) && matrix.isColNumber(Ik)){
		ArithmeticMatrix returnTable = new ArithmeticMatrix(2,2);	//0,12l̂
		returnTable.clearMatrix();
		for (int i = 0; i < matrix.getRowLength(); i++){		//xz\̍쐬
			double value = returnTable.getCell((int) matrix.getCell(i, Ij),
				(int) matrix.getCell(i, Ik)) +1;
			returnTable.setCell((int) matrix.getCell(i, Ij),
				(int) matrix.getCell(i, Ik), value);
		}
		 return returnTable;
			}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* Ij獀Ikւ̏W߂܂B
* @param Ij Ij
* @param Ik Ik
* @return Ij獀Ikւ̏W
* @exception NotElementException w肵vfԍ݂Ȃꍇ
*/
	private double getCoefficient(int Ij, int Ik){
		
		if (matrix.isColNumber(Ij) && matrix.isColNumber(Ik)){
			double value;
			ArithmeticMatrix frequencyMatrix = new ArithmeticMatrix(2,2);
			frequencyMatrix = getFrequencyMatrix(Ij, Ik);	//xz\߂
			
			//W߂
			value = (frequencyMatrix.getCell(0,1) * (frequencyMatrix.getRowSum(0) +
			frequencyMatrix.getRowSum(1))) / (frequencyMatrix.getRowSum(0) * frequencyMatrix.getColSum(1));
			return 1 - value;
		}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* IRSOt̃XPg}gNXԂ܂B
* @return XPg}gNX
*/
	public ArithmeticMatrix getSkeletonMatrix(){
		
		//IRS}gNX̎
		ArithmeticMatrix irsMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		irsMatrix.matrixCopy(getIRSMatrix());
		
		//XPg}gNX̐
		ArithmeticMatrix SkeletonMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		
		//Lvf̎
		int[] order = new int[matrix.getColLength()];
		System.arraycopy(getGraphElementArray(), 0, order, 0, order.length);
		SkeletonMatrix.clearMatrix();
		
		for (int i = 0; i < SkeletonMatrix.getRowLength(); i++){
			int searchRow = order[i];	 //ۂɌssiϒl̒Ⴂ̗vfj
			int branchCount = 0;		//̗vf瑼̗vfɂ}`
			boolean isUnder = true;		//̗vf蕽ϒl(ɔzu)vf

			for (int j = SkeletonMatrix.getRowLength() - 1; j >= 0; j--){
				int searchCol = order[j];	//ۂɌsivfj

				if (searchRow == searchCol){		//vf𒲂ׂ悤ƂĂ邩
					isUnder = false;
					branchCount = 0;		//x
				}
				else{
				//̗vfƏ֌W邩ǂ
					if (irsMatrix.getCell(searchRow, searchCol) == IRSANALYSIS_SEQUENCE_TRUE){

						// }`ł邩
						// 1.̗vf蕽ϒlvfĂ邩
						// 2.̗vf瑼̗vfɎ}܂`ĂȂ
						// 3.̗vf̗vf}`Ă邩 
						if ((branchCount == 0) || (isUnder)||
							(SkeletonMatrix.getCell(searchCol,searchRow) == IRSANALYSIS_SEQUENCE_TRUE)){
								SkeletonMatrix.setCell(searchRow, searchCol, IRSANALYSIS_SEQUENCE_TRUE);
									
								//ꕽϓ_łȂꍇ͎}`JE^i߂
								if(matrix.getColAverage(searchRow) != matrix.getColAverage(searchCol)){
									branchCount = branchCount + 1;
								}
						}
						else{		//̗vfɎ}`ĂꍇAǂ̗vfɎ}`T
							int counter = 0;	//JE^[
							for (int k = irsMatrix.getRowLength() - 1; k > j; k--){
								
								//`}̗̐vf璲ׂĂvfɊ֘AȂ
								if ((SkeletonMatrix.getCell(searchRow, order[k]) == IRSANALYSIS_SEQUENCE_TRUE) &&
									(irsMatrix.getCell(order[k], searchCol) == IRSANALYSIS_SEQUENCE_FALSE)){
										counter = counter + 1;		//Ȃꍇ̓JE^[𑝂₷
								}
								
								//܂͓ꕽϓ_̏ꍇ
								//else if(matrix.getColAverage(order[k]) == matrix.getColAverage(searchRow)){
									//counter = counter + 1;
								//}
							}

							//`SĂ̑̎}̐悩炻̗vf֏֘AȂꍇ͎}`
							if (branchCount == counter){
								SkeletonMatrix.setCell(searchRow, searchCol, IRSANALYSIS_SEQUENCE_TRUE);
								
								//ꕽϓ_łȂꍇ͎}`JE^i߂
								if(matrix.getColAverage(searchRow) != matrix.getColAverage(searchCol)){
										branchCount = branchCount + 1;
								}
							}
						}
					}
				}
			}
		}
		return SkeletonMatrix;
	}
	
/**
* eڂ̕]蕽ϒl̔zԂ܂B
* @return ϒl̔z񂪓z
*/
	public double[] getGraphAverageArray(){
		double[]  returnArray = new double[matrix.getColLength()];		//eڂ̕ϒli[
		System.arraycopy(matrix.getColAverageArray(), 0, returnArray, 0, returnArray.length);
		return returnArray;
	}

/**
* ڂOt`ɕבւڔԍ̔zԂ܂B
* ϐ̒Ⴂɍڔԍוς܂B
* @return Ot`ɕ׊ԍiځjz
*/
	public int[] getGraphElementArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//eڂ̕ϒli[
		int[] returnArray = new int[matrix.getColLength()];		//ϕ]l̒Ⴂɕׂ̗ԍiځj
		System.arraycopy(getGraphAverageArray(), 0, averageRating, 0, averageRating.length);
		
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];		//l
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){		//rs
				if (minAverage > averageRating[j]){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = Integer.MAX_VALUE;	 //rΏۂ͂
			returnArray[i] = minNumber;
		}
		return returnArray;
	}
	
/**
* lԂ܂B
* @return l
*/
	public double getThreshold(){
		return thresholdValue;
	}

/**
* IRS͂̑ΏۂƂȂ}gNXݒ肵܂B
* @param baseMatrix ݒ肷镪͑Ώۂ̃}gNX
*/
	public void setMatrix(ArithmeticMatrix baseMatrix){
		matrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.matrixCopy(baseMatrix);		//}gNX̐ݒ
	}
	
/**
* IRS͂̑ΏۂƂȂ}gNX̗vfC܂B
* @param row Cvf̍s
* @param col Cvf̗
* @param value Cl
* @exception NotElementException w肵vf݂Ȃꍇ
* @see #setMatrix(ArithmeticMatrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			matrix.setCell(row, col, value);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* lݒ肵܂B<BR>
* l01܂ł̊ԂŐݒ肵܂B
* @param threshold ݒ肷邵l
* @exception SetValueOutOfBoundsException lݒł͈͊Ȍꍇ
*/
	public void setThreshold(double threshold){
		if(isThreshold(threshold)){
			thresholdValue = threshold;
		}
		else{		//G[̏ꍇ
			throw new SetValueOutOfBoundsException("Threshold(" + threshold + ")");
		}
	}
	
/**
* l͈͓`FbN܂B
* @param checkThreshold `FbN邵l
* @return l͈͓łtrueA͈͊OłfalseԂ܂
*/
	private boolean isThreshold(double checkThreshold){
		return ((0 <= checkThreshold) && (checkThreshold <= 1));
	}

}