package jp.ac.takushoku_u.cs;

/**
* ArithmeticMatrix饹ǤdoubleǤĥޥȥꥯ򰷤ޤ<BR>
* ޥȥꥯʬϥǡ̾̾դݻǤ褦ˤʤޤ
* ޤޥȥꥯƱΤα黻ԤȤǤޤ<BR>
* @version 1.3.1
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.BooleanMatrix
* @see jp.ac.takushoku_u.cs.StringMatrix
*/
/*
* ǽ 2004ǯ1209
*/
public class ArithmeticMatrix extends Matrix{
	
/**
* ޥȥꥯ򥯥ꥢȤ͡
*/
	private static final double MATRIX_CLEAR_VALUE = 0.0;
	
/**
* False͡
*/
	private static final double MATRIX_VALUE_FALSE = 0.0;
	
/**
* True͡
*/
	private static final double MATRIX_VALUE_TRUE = 1.0;


/**
* ꤵƤ륵Υǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾Ϲֹֹꤵޤ
*/
	public ArithmeticMatrix(){
		super();
		clearMatrix();
	}

/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾Ϲֹֹꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public ArithmeticMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* 줿20ǽޤ
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param nameNumber ̾̾γֹ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public ArithmeticMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException  rowName ޤ colName  null ξ
*/
	public ArithmeticMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		
		clearMatrix();
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}
	
/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param originalMatrix ꤹ2
* @exception NullPointerException  originalMatrix  null ξ
*/
	public ArithmeticMatrix(double[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param originalMatrix ꤹ2
* @param nameNumber ̾̾γֹ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public ArithmeticMatrix(double[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2󡢹̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ
* @param originalMatrix ꤹ2
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException  rowName , colName ޤ originalMatrix  null ξ
*/
	public ArithmeticMatrix(double[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}

/**
* ݻ줿Ǥѹ˥ޥȥꥯ礭ѹޤ
* ޥȥꥯ򾮤ϻꤷǤ礭ʬʤʤޤ
* 礭礭줿ʬϽ0ǽ졢
* ̾̾Ϥ줾ֹֹˤʤޤ
* @param rowLength ԥ
* @param colLength 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//ޥȥꥯǤ
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}
	
/**
* ꤵ줿1ͤꤷޤ
* @param row ֹ
* @param col ֹ
* @param value 
* @exception NotElementException ꤷ¸ߤʤ
*/
	public void setCell(int row,int col,double value){
		if (isMatrixEntityPoint(row, col)){
			Double d = new Double(value);
			super.setCell(row, col, d);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* ޥȥꥯ¾Υޥȥꥯǡ̾̾Ƥ򥳥ԡޤ<BR>
* ԡΥޥȥꥯȰפʤϥԡΥޥȥꥯѹԡԤޤ
* @param originalMatrix ԡΥޥȥꥯ
* @see #matrixCopy(ArithmeticMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(ArithmeticMatrix originalMatrix){
		super.matrixCopy(originalMatrix);
	}
	
/**
* ֤ǳϤǤ饳ԡΥޥȥꥯλ֤Ǥ򥳥ԡޤ<BR>
* ԡ( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˥ԡԤޤ
* ԡϰϤƤϤޤʤǤȹ̾̾ѹޤ
* @param originalMatrix ԡΥޥȥꥯ
* @param baseRow ԡΥޥȥꥯФ륳ԡιԳϰ
* @param baseCol ԡΥޥȥꥯФ륳ԡ󳫻ϰ
* @param copyRow ԡԳϰ
* @param copyCol ԡ󳫻ϰ
* @param rowLength ԡԤԤǿ
* @param colLength ԡԤǿ
* @exception SetValueOutOfBoundsException ԡ褬¸ߤʤϰϤˤ
* @see #matrixCopy(ArithmeticMatrix originalMatrix)
*/
	public void matrixCopy(ArithmeticMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.matrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				copyCol, rowLength, colLength);
	}
	
/**
* ޥȥꥯ¸ߤǤ0ˤޤ
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* ꤵ줿1֤ͤޤ
* @param row ֹ
* @param col ֹ
* @return ꤷ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public double getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			Double d = new Double(0.0);
			d = (Double)getObjectCell(row,col);
			double b = d.doubleValue();
			return b;
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* ꤷԤˤͤιפ֤ޤ
* @param row ֹ
* @return ꤷԤι
* @exception NotItemException ꤷԤ¸ߤʤ
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double getRowSum(int row){
		if (isRowNumber(row)){
			double val = 0.0;
			for (int i = 0; i < getColLength(); i++){
				val = getCell(row, i) + val;
			}
			return val;
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* ƹԤΤ줾ιפ֤ޤ
* @return ƹԤιͤä
* @see #getColSumArray()
* @see #getRowSum(int row)
*/
	public double[] getRowSumArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowSum(i);
		}
		return returnArray;
	}
	
/**
* ꤷˤͤιפ֤ޤ
* @param col ֹ
* @return ꤷι
* @exception NotItemException ꤷ¸ߤʤ
* @see #getRowSum(int row)
* @see #getColSumArray()
*/
	public double getColSum(int col){
		if (isColNumber(col)){
			double val = 0.0;
			for (int i = 0; i < getRowLength(); i++){
				val = getCell(i, col) + val;
			}
			return val;
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* Τ줾ιפ֤ޤ
* @return ιͤä
* @see #getColSum(int col)
* @see #getRowSumArray()
*/
	public double[] getColSumArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColSum(i);
		}
		return returnArray;
	}
	
/**
* ꤷԤˤͤʿѤ֤ޤ
* @param row ֹ
* @return ꤷԤʿ
* @exception NotItemException ꤷԤ¸ߤʤ
* @see #getColAverage(int col)
* @see #getRowAverageArray()
*/
	public double getRowAverage(int row){
		if (isRowNumber(row)){
			double val;
			val = getRowSum(row) / getColLength();
			return val;
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* ƹԤΤ줾ʿѤ֤ޤ
* @return ƹԤʿͤä
* @see #getColAverageArray()
* @see #getRowAverage(int row)
*/
	public double[] getRowAverageArray(){
		double[] returnArray = new double[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowAverage(i);
		}
		return returnArray;
	}
	
/**
* ꤷˤͤʿѤ֤ޤ
* @param col ֹ
* @return ꤷʿ
* @exception NotItemException ꤵ줿¸ߤʤ
* @see #getRowAverage(int row)
* @see #getColAverageArray()
*/
	public double getColAverage(int col){
		if (isColNumber(col)){
			double val;
			val = getColSum(col) / getRowLength();
			return val;
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* Τ줾ʿѤ֤ޤ
* @return ʿͤä
* @see #getRowAverageArray()
* @see #getColAverage(int col)
*/
	public double[] getColAverageArray(){
		double[] returnArray = new double[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColAverage(i);
		}
		return returnArray;
	}
	
/**
* ޥȥꥯǤˤ֤ͤͤޤ
* @return ˤ
*/
	public double getMaxCell(){
		double maxValue;
		maxValue = getCell(0,0);		//
		for (int i = 0; i < getRowLength(); i++){		//ͤĴ٤
			for (int j = 0; j < getColLength(); j++){
				if (maxValue < getCell(i,j)){
					maxValue = getCell(i, j);
				}
			}
		}
		return maxValue;
	}
	
/**
* ޥȥꥯ¸ߤǤΤǤ0ĶǤο֤ޤ
* @return ǿ
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) > 0){		//0Ķǿ
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* ޥȥꥯǤ012ͤѴޤ
* 0ʲο0ˡ0ۤ1Ѵޤ
*/
	public void convertLogicMatrix(){
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) <= 0){
					setCell(i, j, MATRIX_VALUE_FALSE);
				}
				else{
					setCell(i, j, MATRIX_VALUE_TRUE);
				}
			}
		}
	}

/**
* ArithmeticMatrixBooleanMatrixѴޤ
* 0ʲοfalseˡ0ۤtrueȤޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿ޥȥꥯ
* @see #toBooleanMatrix(double value)
* @see #toStringMatrix()
*/
	public BooleanMatrix toBooleanMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					if (getCell(i, j) <= 0){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* ArithmeticMatrixBooleanMatrixѴޤ
*  value ʲοfalseˡ value ۤtrueȤޤ<BR>
* âͤ0ξϡ0falseˡ0ʳοtrueȤޤ
* 0ʲοfalseȤtoBooleanMatrix()ѤƤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @param value 
* @return Ѵ줿ޥȥꥯ
* @see #toBooleanMatrix()
* @see #toStringMatrix()
*/
	public BooleanMatrix toBooleanMatrix(double value){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if(value != 0){
					if (getCell(i, j) <= value){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
				else{
					if (getCell(i, j) == value){
						returnMatrix.setCell(i, j, false);
					}
					else{
						returnMatrix.setCell(i, j, true);
					}
				}
			}
		}
		return returnMatrix;
	}
	
/**
* ArithmeticMatrixStringMatrixѴޤ
* Ǥͤ򤽤ΤޤʸȤޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿Matrix
* @see #toBooleanMatrix()
* @see #toBooleanMatrix(double value)
*/
	public StringMatrix toStringMatrix(){
		StringMatrix returnMatrix = new StringMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Double.toString(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2ĤΥޥȥꥯΥƱåޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	public boolean isSameMatrixSize(ArithmeticMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* 2ĤΥޥȥꥯΥ軻ԤȤǤ뤫åޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	private boolean isMultiplyMatrixSize(ArithmeticMatrix compareMatrix){
		return getColLength() == compareMatrix.getRowLength();
	}
	
/**
* ¾ΥޥȥꥯȤ(And)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getAndMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤѤ
					returnMatrix.setCell(i, j, (int) getCell(i,j) &
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ(OR)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getOrMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¤
					returnMatrix.setCell(i, j, (int) getCell(i,j) |
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ¾ΥޥȥꥯȤ¾Ū(eXclusive OR)֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @param calculateMatrix 黻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥۤʤ
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getNotMatrix()
*/
	public ArithmeticMatrix getXOrMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isSameMatrixSize(calculateMatrix)){
			
			//ͤΥޥȥꥯѴ
			convertLogicMatrix();
			calculateMatrix.convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//ƱΤ¾Ū¤
					returnMatrix.setCell(i, j, (int) getCell(i,j) ^
						(int) calculateMatrix.getCell(i,j));
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯ(NOT)֤ޤ<BR>
* α黻ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @return 黻̤Υޥȥꥯ
* @see #convertLogicMatrix()
* @see #getAndMatrix(ArithmeticMatrix calculateMatrix)
* @see #getOrMatrix(ArithmeticMatrix calculateMatrix)
* @see #getXOrMatrix(ArithmeticMatrix calculateMatrix)
*/
	public ArithmeticMatrix getNotMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		
		//ͤΥޥȥꥯѴ
		convertLogicMatrix();
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//α黻Ԥ
					if (getCell(i,j) > 0){
						returnMatrix.setCell(i, j, 0);
					}
					else{
						returnMatrix.setCell(i, j, 1);
					}
				}
			}
		return returnMatrix;
	}
	
/**
* ޥȥꥯvalueܤޥȥꥯ֤ޤ
* ޥȥꥯƤǤФơvalueܤޥȥꥯ֤ޤ
* @param value ݤ
* @return valueܤ줿ޥȥꥯ
* @see #getMultiplyMatrix(ArithmeticMatrix calculateMatrix)
*/
	public ArithmeticMatrix getTimesMatrix(double value){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for(int i = 0; i < getRowLength(); i++){
			for(int j = 0; j < getColLength(); j++){
				double v = value * getCell(i, j);
				returnMatrix.setCell(i, j, v);
			}
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯƱΤ¤׻ޥȥꥯ֤ޤ<BR>
* ֤ޥȥꥯι̾̾ϥޥȥꥯƱΤȤʤޤ
* @param calculateMatrix ûоݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥפʤ
*/
	public ArithmeticMatrix getAddMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isSameMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					double value = 0.0;
					value = getCell(i, j) + calculateMatrix.getCell(i, j);
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* ޥȥꥯƱΤѤ׻ޥȥꥯ֤ޤ<BR>
* 黻 ޥȥꥯ  calculateMatrix ǹԤޤ
* ֤ޥȥꥯΥϱ黻Υޥȥꥯιԥ߱黻оݤΥޥȥꥯ󥵥Ȥʤޤ
* @param calculateMatrix 軻оݤΥޥȥꥯ
* @return 黻̤Υޥȥꥯ
* @exception DisagreementMatrixSizeException 黻Ԥ2ĤΥޥȥꥯΥ黻Ԥʤξ
* @see #getTimesMatrix(double value)
*/
	public ArithmeticMatrix getMultiplyMatrix(ArithmeticMatrix calculateMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), calculateMatrix.getColLength(),
			getRowNameArray(), calculateMatrix.getColNameArray());
		
		//黻Ԥ뤫ɤ
		if (isMultiplyMatrixSize(calculateMatrix)){
			for (int i = 0; i < returnMatrix.getRowLength(); i++){
				for (int j = 0; j < returnMatrix.getColLength(); j++){
					
					//ξ軻Ԥ
					//׻ a_i1 * a_1j + a_i2 * a_2j +  + a_in * a_nj
					double value = 0.0;
					for (int k = 0; k < getColLength(); k++){
							value = getCell(i, k) * calculateMatrix.getCell(k, j) + value;
					}
					returnMatrix.setCell(i, j, value);
				}
			}
		}
		
		//黻Ԥʤ
		else{
			throw new DisagreementMatrixSizeException();
		}
			return returnMatrix;
	}
	
/**
* exponetؿȤ٤׻ޥȥꥯ֤ޤ
* @param exponent ߾λؿ
* @return n򤷤ޥȥꥯ
* @exception SetValueOutOfBoundsException ؿ0ʲͤꤷ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public ArithmeticMatrix getExponentMatrix(int exponent){
		ArithmeticMatrix initMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//󤫤ɤޤؿ0ʲͤꤵ줿
		if (isSquare()){
			if (exponent > 0){
			
				//Υޥȥꥯn軻(1ξϸΥޥȥꥯΤޤ)
				for (int i = 1; i < exponent; i++){
				
					//i褷ޥȥꥯ˸Υޥȥꥯݤi+1ˤ
					returnMatrix.matrixCopy(returnMatrix.getMultiplyMatrix(initMatrix));
				}
			}
			
			//ؿ0ʲͤꤵ줿
			else{
				throw new SetValueOutOfBoundsException("exponent(" + exponent + ")");
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯǤñ̥ޥȥꥯѹޤ
* @exception NotSquareMatrixException ޥȥꥯǤʤ
*/
	public void createElementaryMatrix(){
		if (isSquare()){
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					
					//гʬΤ1
					if (i == j){
						setCell(i, j, MATRIX_VALUE_TRUE);
					}
					else{
						setCell(i, j, MATRIX_VALUE_FALSE);
					}
				}
			}
		}
		
		//ޥȥꥯǤʤ
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ΥޥȥꥯƱñ̥ޥȥꥯ֤ޤ
* @return ñ̹
*/
	private ArithmeticMatrix getElementaryMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		returnMatrix.createElementaryMatrix();
		return returnMatrix;
	}
	
/**
* ޥȥꥯܥޥȥꥯȤβãޥȥꥯ֤ޤ<BR>
* α黻˹ԤäconvertLogicMatrix᥽åɤ¹Ԥޤ
* @return ãޥȥꥯ
* @exception NotSquareMatrixException ޥȥꥯǤϤʤ
* @see #convertLogicMatrix()
*/
	public ArithmeticMatrix getReachMatrix(){
		
		//󤫤ɤ
		if (isSquare()){
		//ΥޥȥꥯܥޥȥꥯȤ
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getMatrix(), getRowNameArray(), getColNameArray());
		
		//ͤΥޥȥꥯѴ
		returnMatrix.convertLogicMatrix();
		
		//ñ̹Ȥ¤
		returnMatrix.matrixCopy(returnMatrix.getOrMatrix(getElementaryMatrix()));
		
		//n-1褹
		// (I + A)n-1 Iñ̹ +
		returnMatrix.matrixCopy(returnMatrix.getExponentMatrix(getRowLength() - 1));
		
		//ͤΥޥȥꥯѴ
		returnMatrix.convertLogicMatrix();
		return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ޥȥꥯž֥ޥȥꥯ֤ޤ
* ֤줿ޥȥꥯι̾̾Ϥ줾줬ؤäΡʹ̾̾̾̾ˡˤˤʤޤ
* @return ž֥ޥȥꥯ
*/
	public ArithmeticMatrix getTransposedMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getColLength(), getRowLength(),
			getColNameArray(), getRowNameArray());
		for(int i = 0; i < returnMatrix.getRowLength(); i++){
			for(int j = 0; j < returnMatrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCell(j, i));
			}
		}
		return returnMatrix;
	}
	
/**
* ޥȥꥯǤ2֤ޤ
* @return Ǥ2
*/
	public double[][] getMatrix(){
		Double d[][] = new Double[getRowLength()][getColLength()];
		double dou[][] = new double[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				d[i][j] = (Double)o[i][j];
				dou[i][j] = d[i][j].doubleValue();
			}
		}
		return dou;
	}
	
}