package jp.ac.takushoku_u.cs;
import java.util.Set;
import java.util.Iterator;

/**
* LFTAnalysis饹LFTʬϤԤΥ饹Ǥ<BR>
* ޤΥ饹Ѥܥޥȥꥯˤޤν٤н뤳ȤǤޤ
* @version 1.3.1
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1206
*/
public class LFTAnalysis{
	
/**
* ԤΥޥȥꥯݻޥȥꥯ
*/
	private BooleanMatrix teacherMatrix;
	
/**
* ؽԤΥޥȥꥯݻޥȥꥯ
*/
	private BooleanMatrix studentMatrix;
	
/**
* ͭޤɽ
*/
	private static final int LFT_EDGE_INT_TRUE = 1;
	
/**
* ͭޤɽ
*/
	private static final boolean LFT_EDGE_TRUE = true;
	
/**
* ͭޤɽ
*/
	private static final String LFT_EDGE_STRING_TRUE = "1";
	
/**
* ͭޤʤɽ
*/
	private static final int LFT_EDGE_INT_FALSE = 0;
	
/**
* ͭޤʤɽ
*/
	private static final boolean LFT_EDGE_FALSE = false;
	
/**
* ͭޤʤɽ
*/
	private static final String LFT_EDGE_STRING_FALSE = "0";
	
/**
* ˤޥȥꥯǶԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_EDGE_TEACHER = 3;
	
/**
* ˤޥȥꥯǶԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final String LFT_EDGE_STRING_TEACHER = "T";
	
/**
* ˤޥȥꥯǳؽԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final int LFT_EDGE_STUDENT = 4;
	
/**
* ˤޥȥꥯǳؽԤΥޥȥꥯˤΤ߻ޤɽ
*/
	private static final String LFT_EDGE_STRING_STUDENT = "S";
	
/**
* ޥȥꥯΥǥե
*/
	private static final int LFT_MATRIX_VALUE = 5;
	
/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷޤ<BR>
* ԤȳؽξΥޥȥꥯǤ0Ȥʤޤ
*/
	public LFTAnalysis(){
		BooleanMatrix baseTeacherMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		BooleanMatrix baseStudentMatrix = new BooleanMatrix(LFT_MATRIX_VALUE, LFT_MATRIX_VALUE);
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix);
		
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(BooleanMatrix baseTeacherMatrix){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix);
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(BooleanMatrix baseTeacherMatrix, BooleanMatrix baseStudentMatrix){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix);
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, ArithmeticMatrix baseStudentMatrix){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix.toBooleanMatrix());
	}
	
/**
* ԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯ϶ԤΥޥȥꥯƱǡǤ0Ȥʤޤ<BR>
* ԤΥޥȥꥯǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param value BooleanMatrixѴݤΤ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, double value){
		BooleanMatrix baseStudentMatrix =
		new BooleanMatrix(baseTeacherMatrix.getRowLength(), baseTeacherMatrix.getColLength(),
			baseTeacherMatrix.getRowNameArray(), baseTeacherMatrix.getColNameArray());
			
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯꤷޤ<BR>
* ԤΥޥȥꥯȳؽԤΥޥȥꥯפξԤȤǤɬפޤ
* @param baseTeacherMatrix ԤΥޥȥꥯ
* @param baseStudentMatrix ؽԤΥޥȥꥯ
* @param value BooleanMatrixѴݤΤ
* @exception NotSquareMatrixException ԤޤϳؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public LFTAnalysis(ArithmeticMatrix baseTeacherMatrix, ArithmeticMatrix baseStudentMatrix, double value){
		
		//ԤΥޥȥꥯꤹ
		setTeacherMatrix(baseTeacherMatrix.toBooleanMatrix());
			
		//ؽԤΥޥȥꥯꤹ
		setStudentMatrix(baseStudentMatrix.toBooleanMatrix());
	}
	
/**
* ٤֤ޤ
* @return 
*/
	public double getResemble(){
		double denominator = 0.0; //ʬ(OR)
		double numerator = 0.0; //ʬ(AND)
		
		//Фޥȥꥯ
		BooleanMatrix pairTeacherMatrix = new BooleanMatrix(getElement(), getElement());
		BooleanMatrix pairStudentMatrix = new BooleanMatrix(getElement(), getElement());
		
		//ãޥȥꥯ
		BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
		reachTeacherMatrix.matrixCopy(getReachTeacherMatrix());
		BooleanMatrix reachStudentMatrix = new BooleanMatrix();
		reachStudentMatrix.matrixCopy(getReachStudentMatrix());
		
		//׻ǻѤޥȥꥯ
		BooleanMatrix resultMatrix = new BooleanMatrix(getElement(), getElement());
		for (int i = 0; i < getElement(); i++){
			for (int j = 0; j < getElement(); j++){
				
				//ԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
				if (teacherMatrix.getCell(i, j) == true){
				pairTeacherMatrix.matrixCopy(getPairMatrix(reachTeacherMatrix, i, j));
				}
				
				//ޤʤн϶
				else{
					pairTeacherMatrix.clearMatrix();
				}
				
				//ؽԤΥޥȥꥯǤ2Ǵ֤˻ޤФǴ֤н
				if (studentMatrix.getCell(i, j) == true){
				pairStudentMatrix.matrixCopy(getPairMatrix(reachStudentMatrix, i, j));
				}
				
				//ޤʤн϶
				else{
					pairStudentMatrix.clearMatrix();
				}
				
				//ʬη׻
				resultMatrix.matrixCopy(pairTeacherMatrix.getOrMatrix(pairStudentMatrix));
				denominator = resultMatrix.getElement() + denominator;
				
				//ʬҤη׻
				resultMatrix.matrixCopy(pairTeacherMatrix.getAndMatrix(pairStudentMatrix));
				numerator = resultMatrix.getElement() + numerator;
			}
		}
		
		return numerator / denominator;
	}
	
/**
* ã٤֤ޤ
* @return ã
*/
	public double getAttainment(){
		return Math.sqrt(getResemble()) * 100;
	}

/**
* 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ޤξ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getBlendMatrix()
*/
	private int getBlendEdge(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				int value;
				if (baseMatrix.isMatrixEntityPoint(Ij, Ik) && compareMatrix.isMatrixEntityPoint(Ij, Ik)){
					if (baseMatrix.getCell(Ij, Ik) == compareMatrix.getCell(Ij, Ik)){
							if(baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
								value = LFT_EDGE_INT_TRUE;
							}
							else{
								value = LFT_EDGE_INT_FALSE;
							}
						}
						else if (baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE &&
							compareMatrix.getCell(Ij, Ik) == LFT_EDGE_FALSE){
							value = LFT_EDGE_TEACHER;
						}
						else{
							value = LFT_EDGE_STUDENT;
						}
					return value;
				}
				else{
					throw new NotElementException("point(" + Ij + "," + Ik + ")");
				}
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* 2֤ˤ붵ԤȳؽԤλޤξ֤֤ޤ
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤT
* ؽԤΥޥȥꥯΤߤ˻ޤSޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ޤξ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getBlendStringMatrix()
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
	public String getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				String st;
				if (baseMatrix.isMatrixEntityPoint(Ij, Ik) && compareMatrix.isMatrixEntityPoint(Ij, Ik)){
					if (baseMatrix.getCell(Ij,Ik) == compareMatrix.getCell(Ij, Ik)){
							if(baseMatrix.getCell(Ij,Ik) == LFT_EDGE_TRUE){
								st = LFT_EDGE_STRING_TRUE;
							}
							else{
								st = LFT_EDGE_STRING_FALSE;
							}
						}
						else if (baseMatrix.getCell(Ij,Ik) == LFT_EDGE_TRUE &&
							compareMatrix.getCell(Ij,Ik) == LFT_EDGE_FALSE){
							st = LFT_EDGE_STRING_TEACHER;
						}
						else{
							st = LFT_EDGE_STRING_STUDENT;
						}
					return st;
				}
				else{
					throw new NotElementException("point(" + Ij + "," + Ik + ")");
				}
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ꤷ2Ĥܥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1baseMatrixǻꤷޥȥꥯΤߤ˻ޤ3
* compareMatrixǻꤷޥȥꥯˤΤߤ˻ޤ4ޤ
* ˤޥȥꥯι̾̾baseMatrixǻꤷޥȥꥯƱˤʤޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @return ˤޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
*/
	private ArithmeticMatrix getBlendMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getElement(), getElement(),
					baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
				
				for (int i = 0; i < getElement(); i++){
					for (int j = 0; j < getElement(); j++){
						returnMatrix.setCell(i, j, getBlendEdge(baseMatrix, compareMatrix, i ,j));
					}
				}
				return returnMatrix;
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ꤷ2Ĥܥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1baseMatrixǻꤷޥȥꥯΤߤ˻ޤT
* compareMatrixǻꤷޥȥꥯˤΤߤ˻ޤSޤ
* ˤޥȥꥯι̾̾baseMatrixǻꤷޥȥꥯƱˤʤޤ
* @param baseMatrix ӸΥޥȥꥯ
* @param compareMatrix Ӥޥȥꥯ
* @return ˤޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException 2ĤΥޥȥꥯפʤ
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix()
*/
	public StringMatrix getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix){
		if(baseMatrix.isSquare() && compareMatrix.isSquare()){
			if (baseMatrix.isSameMatrixSize(compareMatrix)){
				StringMatrix returnMatrix = new StringMatrix(getElement(), getElement(),
					baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
				
				for (int i = 0; i < getElement(); i++){
					for (int j = 0; j < getElement(); j++){
						returnMatrix.setCell(i, j, getBlend(baseMatrix, compareMatrix, i, j));
					}
				}
				return returnMatrix;
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤ3
* ؽԤΥޥȥꥯΤߤ˻ޤ4ޤ
* ˤޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @return ˤޥȥꥯ
*/
	private ArithmeticMatrix getBlendMatrix(){
		return getBlendMatrix(teacherMatrix, studentMatrix);
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯˤޥȥꥯ֤ޤ<BR>
* ɤޤ̵0ɤޤ1ԤΥޥȥꥯΤߤ˻ޤT
* ؽԤΥޥȥꥯΤߤ˻ޤSޤ
* ˤޥȥꥯι̾̾϶ԤΥޥȥꥯƱˤʤޤ
* @return ˤޥȥꥯ
* @see #getBlend(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix, int Ij, int Ik)
* @see #getBlendStringMatrix(BooleanMatrix baseMatrix, BooleanMatrix compareMatrix)
*/
	public StringMatrix getBlendStringMatrix(){
		return getBlendStringMatrix(teacherMatrix, studentMatrix);
	}
	
/**
* ܥޥȥꥯ򸵤ˤǴ֤нޤ
* @param nextMatrix Ĵ٤ܥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return ɤǴ֤Фޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public BooleanMatrix getElementPairMatrix(BooleanMatrix nextMatrix, int Ij, int Ik){
		if(nextMatrix.isSquare()){
			if (nextMatrix.isMatrixEntityPoint(Ij, Ik)){
				
				//ãޥȥꥯ
				BooleanMatrix lookMatrix = new BooleanMatrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
					nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
				lookMatrix.matrixCopy(nextMatrix.getReachMatrix());
				
				BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(), lookMatrix.getColLength(), 
					lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
				
				//ޤ¸ߤ뤫ɤ
				if (nextMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
					returnMatrix.matrixCopy(getPairMatrix(lookMatrix, Ij, Ik));
				}
				return returnMatrix;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ܥޥȥꥯ򸵤ˤǴ֤нޤ
* @param nextMatrix Ĵ٤ܥޥȥꥯ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return нȤʤޤν
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public EdgeSet getElementPairSet(BooleanMatrix nextMatrix, int Ij, int Ik){
		if(nextMatrix.isSquare()){
			if (nextMatrix.isMatrixEntityPoint(Ij, Ik)){
				
				//ãޥȥꥯ
				BooleanMatrix lookMatrix = new BooleanMatrix(nextMatrix.getRowLength(), nextMatrix.getColLength(),
					nextMatrix.getRowNameArray(), nextMatrix.getColNameArray());
				lookMatrix.matrixCopy(nextMatrix.getReachMatrix());
				
				EdgeSet edgeHash = new EdgeSet();
				
				//ޤ¸ߤ뤫ɤ
				if (nextMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
					for (int i = 0; i < lookMatrix.getRowLength(); i++){
						for (int j = 0; j < lookMatrix.getColLength(); j++){
							if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
								edgeHash.add(new Edge(i,j));
							}
						}
					}
				}
				return edgeHash;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ãޥȥꥯ򸵤ˤǴ֤нޤ<BR>
* ܥޥȥꥯΤ١2Ǵ֤ܤƤ뤫ݾڤʤᡢ
* Υ᥽åɤѤϤǴƱΤܤƤ뤳Ȥåɬפޤ
* @param lookMatrix Ĵ٤ãޥȥꥯ
* @param Ij ͭޤθֹ
* @param Ik ͭޤֹ
* @return ɤǴ֤Фޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	private BooleanMatrix getPairMatrix(BooleanMatrix lookMatrix, int Ij, int Ik){
		if(lookMatrix.isSquare()){
			if (lookMatrix.isMatrixEntityPoint(Ij, Ik)){
				BooleanMatrix returnMatrix = new BooleanMatrix(lookMatrix.getRowLength(),lookMatrix.getColLength(), 
					lookMatrix.getRowNameArray(), lookMatrix.getColNameArray());
				for (int i = 0; i < lookMatrix.getRowLength(); i++){
					for (int j = 0; j < lookMatrix.getColLength(); j++){
						if (lookMatrix.getCell(i, Ij) && lookMatrix.getCell(Ik, j) == LFT_EDGE_TRUE){
							returnMatrix.setCell(i, j, LFT_EDGE_TRUE);
						}
						else{
							returnMatrix.setCell(i, j, LFT_EDGE_FALSE);
						}
					}
				}
				return returnMatrix;
			}
			else{
				throw new NotElementException("point(" + Ij + "," + Ik + ")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ޥȥꥯ¸ߤޤν٤ޤ
* @param baseMatrix ٤оݤܥޥȥꥯ
* @return ޤν٤Ǽޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public ArithmeticMatrix getImportantEdgeMatrix(BooleanMatrix baseMatrix){
		if(baseMatrix.isSquare()){
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength(),
				baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
			
			for (int i = 0;i < baseMatrix.getRowLength(); i++){
				for (int j = 0; j < baseMatrix.getColLength(); j++){
					returnMatrix.setCell(i, j, getImportantEdge(baseMatrix, i, j));
				}
			}
			return returnMatrix;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ޥȥꥯ2ܴ֤λޤν٤֤ޤ
* @param baseMatrix ٤ޥȥꥯ
* @param Ij ͭޤλȤʤIj
* @param Ik ͭޤνȤʤIk
* @return ꤷܴ֤ν
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public double getImportantEdge(BooleanMatrix baseMatrix, int Ij, int Ik){
		if(baseMatrix.isSquare()){
			BooleanMatrix temporaryMatrix = new BooleanMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
			double cont = Math.floor(getElement() / 2) * Math.floor((getElement() + 1) / 2);
			double value = 0.0;
			
			//ޤ¸ߤ뤫ɤ
			if (baseMatrix.getCell(Ij, Ik) == LFT_EDGE_TRUE){
				temporaryMatrix.matrixCopy(getElementPairMatrix(baseMatrix, Ij, Ik));
				value = temporaryMatrix.getElement();
				value = value / cont;
			}
			return value;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getImportantEdgeStudent(int Ij, int Ik)
* @see #getEdgeTeacherMatrix()
*/
	public double getImportantEdgeTeacher(int Ij, int Ik){
		if (teacherMatrix.isMatrixEntityPoint(Ij, Ik)){
			return getImportantEdge(teacherMatrix, Ij, Ik);
		}
		else{
			throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* Ԥλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
	public ArithmeticMatrix getEdgeTeacherMatrix(){
		return getImportantEdgeMatrix(teacherMatrix);
	}
	
/**
* ؽԤΥޥȥꥯˤꤷޤν٤֤ޤ
* @param Ij ͭޤλ
* @param Ik ͭޤν
* @return 
* @exception NotElementException ꤷֹ椬¸ߤʤ
* @see #getEdgeTeacherMatrix()
* @see #getImportantEdgeStudent(int Ij, int Ik)
*/
	public double getImportantEdgeStudent(int Ij, int Ik){
		if (studentMatrix.isMatrixEntityPoint(Ij, Ik)){
			return getImportantEdge(studentMatrix, Ij, Ik);
		}
		else{
			throw new NotElementException("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* ؽԤλޤν٤᤿ޥȥꥯ֤ޤ
* @return ٤᤿ޥȥꥯ
* @see #getEdgeStudentMatrix()
* @see #getImportantEdgeTeacher(int Ij, int Ik)
*/
	public ArithmeticMatrix getEdgeStudentMatrix(){
		return getImportantEdgeMatrix(studentMatrix);
	}
	
/**
* ԤΥޥȥꥯ֤ޤ
* @return ԤΥޥȥꥯ
* @see #getStudentMatrix()
*/
	public BooleanMatrix getTeacherMatrix(){
		return teacherMatrix;
	}
	
/**
* ؽԤΥޥȥꥯ֤ޤ
* @return ؽԤΥޥȥꥯ
* @see #getTeacherMatrix()
*/
	public BooleanMatrix getStudentMatrix(){
		return studentMatrix;
	}
	
/**
* Ԥβãޥȥꥯ֤ޤ
* @return Ԥβãޥȥꥯ
* @see #getReachStudentMatrix()
*/
	public BooleanMatrix getReachTeacherMatrix(){
		BooleanMatrix reachTeacherMatrix = new BooleanMatrix();
		reachTeacherMatrix.matrixCopy(teacherMatrix.getReachMatrix());
		return reachTeacherMatrix;
	}
	
/**
* ؽԤβãޥȥꥯ֤ޤ
* @return ؽԤβãޥȥꥯ
* @see #getReachTeacherMatrix()
*/
	public BooleanMatrix getReachStudentMatrix(){
		BooleanMatrix reachStudentMatrix = new BooleanMatrix();
		reachStudentMatrix.matrixCopy(studentMatrix.getReachMatrix());
		return reachStudentMatrix;
	}
	
/**
* ޥȥꥯˤǿ(Ԥޤ)֤ޤ
* @return ǿ
*/
	public int getElement(){
		return teacherMatrix.getRowLength();
	}
	
/**
* ԤΥޥȥꥯˤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getTeacherEdge(){
		return teacherMatrix.getElement();
	}
	
/**
* ؽԤΥޥȥꥯˤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getStudentEdge(){
		return studentMatrix.getElement();
	}
	
/**
* ԤΥޥȥꥯȳؽԤΥޥȥꥯΤɤ餫ˤǤ¸ߤͭޤο֤ޤ
* @return ɤ餫ˤǤ⤢ͭޤο
* @see #getAccordEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getTotelEdge(){
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		return mixMatrix.getElement();
	}
	
/**
* ԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getTeacherEdge()
* @see #getStudentOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getTeacherOnlyEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_TEACHER){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ؽԤΥޥȥꥯˤΤ¸ߤͭޤο֤ޤ
* @return ؽԤΥޥȥꥯˤΤ¸ߤͭޤο
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getTotelEdge()
* @see #getAccordEdge()
*/
	public int getStudentOnlyEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_STUDENT){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ԤΥޥȥꥯˤؽԤΥޥȥꥯˤ¸ߤͭޤο֤ޤ
* @return ξԤˤͭޤο
* @see #getTotelEdge()
* @see #getTeacherEdge()
* @see #getStudentEdge()
* @see #getTeacherOnlyEdge()
* @see #getStudentOnlyEdge()
*/
	public int getAccordEdge(){
		int count = 0;
		ArithmeticMatrix mixMatrix = new ArithmeticMatrix(getElement(), getElement());
		mixMatrix.matrixCopy(getBlendMatrix());
		for (int i = 0; i < mixMatrix.getRowLength(); i++){
			for (int j = 0; j < mixMatrix.getColLength(); j++){
				if (mixMatrix.getCell(i, j) == LFT_EDGE_INT_TRUE){
					count = count + 1;
				}
			}
		}
		return count;
	}
	
/**
* ԤΥޥȥꥯꤷޤ
* @param baseTeacherMatrix 򤹤붵ԤΥޥȥꥯ
* @exception NotSquareMatrixException ԤΥޥȥꥯǤϤʤ
*/
	private void setTeacherMatrix(BooleanMatrix baseTeacherMatrix){
		if (baseTeacherMatrix.isSquare()){
			teacherMatrix = new BooleanMatrix();
			teacherMatrix.matrixCopy(baseTeacherMatrix);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ؽԤΥޥȥꥯꤷޤ<BR>
* ؽԤΥޥȥꥯǤꡢԤΥޥȥꥯȥפɬפޤ
* @param baseStudentMatrix 򤹤ؽԤΥޥȥꥯ
* @exception NotSquareMatrixException ؽԤΥޥȥꥯǤϤʤ
* @exception DisagreementMatrixSizeException ԤΥޥȥꥯȳؽԤΥޥȥꥯפʤ
*/
	public void setStudentMatrix(BooleanMatrix baseStudentMatrix){
		if (baseStudentMatrix.isSquare()){
			if (teacherMatrix.isSameMatrixSize(baseStudentMatrix)){
				studentMatrix = new BooleanMatrix();
				studentMatrix.matrixCopy(baseStudentMatrix);
			}
			else{
				throw new DisagreementMatrixSizeException();
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
}