package jp.ac.takushoku_u.cs;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Iterator;

/**
* MathEdge饹EdgeSetα黻ѥ饹Ǥ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.Edge
* @see jp.ac.takushoku_u.cs.EdgeSet
*/
/*
* ǽ 2004ǯ1214
*/
public class MathEdge{
	
/**
* 󥹥ȥ饯
*/
	private MathEdge(){}
	
/**
* setAsetBѽ(AND)֤ޤ
* @param setA 黻EdgeSet
* @param setB 黻EdgeSet
* @return 2Ĥѽ
*/
	public static EdgeSet getAndEdge(EdgeSet setA, EdgeSet setB){
		EdgeSet returnSet = new EdgeSet();
		
		Iterator i = setA.iterator();
    	while(i.hasNext()){
    		Edge ed = (Edge)i.next();
    		Iterator j = setB.iterator();
    		while(j.hasNext()){
    			Edge ef = (Edge)j.next();
    			if(ed.isSameEdge(ef)){
    				returnSet.add(new Edge(ed.getBegin(), ed.getEnd()));
    			}
    		}
    	}
		
		return returnSet;
	}
	
/**
* setAsetB½(OR)֤ޤ
* @param setA 黻EdgeSet
* @param setB 黻EdgeSet
* @return 2Ĥ½
*/
	public static EdgeSet getOrEdge(EdgeSet setA, EdgeSet setB){
		EdgeSet returnSet = new EdgeSet();
		
		Iterator i = setA.iterator();
    	while(i.hasNext()){
    		Edge ed = (Edge)i.next();
    		returnSet.add(new Edge(ed.getBegin(), ed.getEnd()));
    	}
    		
    	Iterator j = setB.iterator();
    	while(j.hasNext()){
    		Edge ef = (Edge)j.next();
    		returnSet.add(new Edge(ef.getBegin(), ef.getEnd()));
    	}
		
		return returnSet;
	}
	
/**
* setAޤsetB줫ˤʤǤν(XOR)֤ޤ
* @param setA 黻EdgeSet
* @param setB 黻EdgeSet
* @return 2Ĥ¾Ū¤ν
*/
	public static EdgeSet getXOrEdge(EdgeSet setA, EdgeSet setB){
		EdgeSet returnSet = new EdgeSet();
		
		Iterator i = setA.iterator();
    	while(i.hasNext()){
    		Edge ed = (Edge)i.next();
    		
    		Iterator j = setB.iterator();
    		boolean flag = true;
    		while(j.hasNext()){
    			Edge ef = (Edge)j.next();
    			if(ed.isSameEdge(ef)){
    				flag = false;
    			}
    		}
    		if(flag){
    			returnSet.add(new Edge(ed.getBegin(), ed.getEnd()));
    		}
    	}
		
		i = setB.iterator();
    	while(i.hasNext()){
    		Edge ed = (Edge)i.next();
    		
    		Iterator j = setA.iterator();
    		boolean flag = true;
    		while(j.hasNext()){
    			Edge ef = (Edge)j.next();
    			if(ed.isSameEdge(ef)){
    				flag = false;
    			}
    		}
    		if(flag){
    			returnSet.add(new Edge(ed.getBegin(), ed.getEnd()));
    		}
    	}
		
		return returnSet;
	}
	
/**
* setAˤ¸ߤʤǤν()֤ޤ
* @param setA 黻EdgeSet
* @param setB 黻EdgeSet
* @return setAˤ¸ߤʤǤν
*/
	public static EdgeSet getSubEdge(EdgeSet setA, EdgeSet setB){
		EdgeSet returnSet = new EdgeSet();
		
		Iterator i = setA.iterator();
    	while(i.hasNext()){
    		Edge ed = (Edge)i.next();
    		
    		Iterator j = setB.iterator();
    		boolean flag = true;
    		while(j.hasNext()){
    			Edge ef = (Edge)j.next();
    			if(ed.isSameEdge(ef)){
    				flag = false;
    			}
    		}
    		if(flag){
    			returnSet.add(new Edge(ed.getBegin(), ed.getEnd()));
    		}
    	}
		
		return returnSet;
	}
}