package jp.ac.takushoku_u.cs;

/**
* SSAnalysis饹SSʬϤ׻뤿Υ饹Ǥ<BR>
* 1nޤǤnʳΥ󥱡ȥǡʬϤ뤳ȤǤޤ
* @version 1.2
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1124
*/
public class SSAnalysis{

/**
* ʬϸΥޥȥꥯݻޥȥꥯ
*/
	private ArithmeticMatrix matrix;

/**
* 󥱡Ȥηݻѿ
*/
	private int scaleType;

/**
* ɾκͤݻѿ
*/
	private int valueRating;

/**
* ͤݻѿ
*/
	private double thresholdValue;

/**
* 󥱡ȤηIˤɽ
*/
	private static final int SSANALYSIS_SCALE_TYPE_ASCENDING = 1;

/**
* 󥱡ȤηIIˤɽ
*/
	private static final int SSANALYSIS_SCALE_TYPE_MIDDLE = 2;

/**
* 󥱡ȤηIIIˤɽ
*/
	private static final int SSANALYSIS_SCALE_TYPE_NONSORT = 3;

/**
* ޥȥꥯ礭ν͡
*/
	private static final int SSANALYSIS_MATRIX_VALUE = 5;

/**
* ͤν͡
*/
	private static final double SSANALYSIS_THRESHOLD = 0.93;

/**
* ɾͤκͤν͡
*/
	private static final int SSANALYSIS_VALUE_RANGE = 1;

/**
* 󥱡Ȥην͡
*/
	private static final int SSANALYSIS_SCALE_TYPE = SSANALYSIS_SCALE_TYPE_ASCENDING;

/**
* SSޥȥꥯȥȥޥȥꥯ(Ϣˡ
*/
	private static final int SSANALYSIS_SEQUENCE_TRUE = 1;

/**
* SSޥȥꥯȥȥޥȥꥯ(Ϣʤˡ
*/
	private static final int SSANALYSIS_SEQUENCE_FALSE = 0;

/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷޤ<BR>
* ʬϤԤޥȥꥯǤ0ˡ󥱡ȤηI
* ɾκͤϥޥȥꥯκͤˡͤϥǥեͤȤʤޤ
*/
	public SSAnalysis(){
		ArithmeticMatrix baseMatrix = new ArithmeticMatrix(SSANALYSIS_MATRIX_VALUE,SSANALYSIS_MATRIX_VALUE);		//ޥȥꥯκ
		setMatrix(baseMatrix);		//ޥȥꥯ
		setScale(SSANALYSIS_SCALE_TYPE);		//󥱡Ȥη
		matrix.clearMatrix();		//ޥȥꥯǤ
		setRating(SSANALYSIS_VALUE_RANGE);		//ɾκͤ
		setThreshold(SSANALYSIS_THRESHOLD);		//ͤ
	}

/**
* 򸵤ʬϤԤޥȥꥯꤷޤ<BR>
* 󥱡ȤηIɾκͤϥޥȥꥯκͤˡͤϥǥեȤȤʤޤ
* @param baseMatrix ʬϤԤޥȥꥯ
*/
	public SSAnalysis(ArithmeticMatrix baseMatrix){
		setMatrix(baseMatrix);
		setScale(SSANALYSIS_SCALE_TYPE);
		setRating((int) matrix.getMaxCell());
		setThreshold(SSANALYSIS_THRESHOLD);
	}

/**
* 򸵤ʬϤԤޥȥꥯȥ󥱡Ȥηꤷޤ<BR>
* ɾκͤϥޥȥꥯκͤˡͤϥǥեȤȤʤޤ
* @param baseMatrix ʬϤԤޥȥꥯ
* @param scale 󥱡Ȥη
* @exception SetValueOutOfBoundsException 󥱡ȤηǤ
*/
	public SSAnalysis(ArithmeticMatrix baseMatrix, int scale){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating((int) matrix.getMaxCell());
		setThreshold(SSANALYSIS_THRESHOLD);
	}

/**
* 򸵤ʬϤԤޥȥꥯ󥱡Ȥηͤꤷޤ<BR>
* ɾκͤϥޥȥꥯκͤȤʤޤ
* @param baseMatrix ʬϤԤޥȥꥯ
* @param scale 󥱡Ȥη
* @param threshold 
* @exception SetValueOutOfBoundsException 󥱡ȤηǤ硢ͤǤϰϳξ
*/
	public SSAnalysis(ArithmeticMatrix baseMatrix, int scale, double threshold){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating((int) matrix.getMaxCell());
		setThreshold(threshold);
	}

/**
* 򸵤ʬϤԤޥȥꥯ󥱡Ȥη͡ɾκͤꤷޤ<BR>
* ɾκͤꤷͤȥޥȥꥯκͤΤ줫礭Ȥʤޤ
* @param baseMatrix ʬϤԤޥȥꥯ
* @param scale 󥱡Ȥη
* @param threshold 
* @param rating ɾκ
* @exception SetValueOutOfBoundsException 󥱡ȤηǤ硢ޤϤͤǤϰϳξ
*/
	public SSAnalysis(ArithmeticMatrix baseMatrix, int scale, double threshold, int rating){
		setMatrix(baseMatrix);
		setScale(scale);
		setRating(rating);
		setThreshold(threshold);
	}


/**
* SSޥȥꥯ֤ޤ
* @return SSޥȥꥯ
* @see #getCoefficientMatrix()
* @see #getSkeletonMatrix()
*/
	public ArithmeticMatrix getSSMatrix(){
		
		//֤SSޥȥꥯ
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(), 
			matrix.getColNameArray(), matrix.getColNameArray());
		
		//ޡ˷ɽ
		ArithmeticMatrix coefficientMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength());
		coefficientMatrix.matrixCopy(getCoefficientMatrix());
		
		int value;
		for (int i = 0; i <  matrix.getColLength(); i++){
			for (int j = 0; j <  matrix.getColLength(); j++){
				if (thresholdValue <= coefficientMatrix.getCell(i, j)){	//뤫ɤĴ0,1ꤹ
					value = SSANALYSIS_SEQUENCE_TRUE;
				}
				else{
					value = SSANALYSIS_SEQUENCE_FALSE;
				}
				returnMatrix.setCell(i, j, value);
			}
		}
		return returnMatrix;
	}

/**
* ޡɽޥȥꥯ֤ޤ
* @return ɽޥȥꥯ
* @see #getSSMatrix()
* @see #getSkeletonMatrix()
*/
	public ArithmeticMatrix getCoefficientMatrix(){
		
		//֤ޡɽ
		 ArithmeticMatrix returnMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
		 	matrix.getColNameArray(), matrix.getColNameArray());
		
		for (int i = 0; i < matrix.getColLength(); i++){
			for (int j = 0; j < matrix.getColLength(); j++){
				returnMatrix.setCell(i, j, getCoefficient(i, j));
			}
		}
		return returnMatrix;
	}

/**
* IjIkؤνޡޤ
* @param Ij Ij
* @param Ik Ik
* @return IjIkؤν
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public double getCoefficient(int Ij, int Ik){
		if (matrix.isMatrixEntityPoint(Ij, Ik)){
			double value = 0;
			if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I
				value = getAscendingCoefficient(Ij, Ik);
			}
			else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){	//II
				value = getMiddleCoefficient(Ij, Ik);
			}
			else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){	//III
				value = getNonSortCoefficient(Ij, Ik);
			}
			else{		//ǥե
				value = getAscendingCoefficient(Ij, Ik);
			}
			return value;
		}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* IjȹIk֤ٿʬɽޤ
* @param Ij Ij
* @param Ik Ik
* @return IjIkؤٿʬɽ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public ArithmeticMatrix getFrequencyMatrix(int Ij, int Ik){
		if (matrix.isMatrixEntityPoint(Ij, Ik)){
			
			//֤ٿʬɽ
			ArithmeticMatrix returnTable = new ArithmeticMatrix(getMaxValue(), getMaxValue());
			returnTable.clearMatrix();
			for (int i = 0; i < matrix.getRowLength(); i++){		//ٿʬɽκ
				double value = returnTable.getCell((int) matrix.getCell(i, Ij) -1,
					(int) matrix.getCell(i, Ik) -1) +1;
				returnTable.setCell((int) matrix.getCell(i, Ij) -1,
					(int) matrix.getCell(i, Ik) -1, value);
			}
			 return returnTable;
		}
		else{		//ꤷǤ¸ߤʤ
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* Iνޤ
* @param Ij Ij
* @param Ik Ik
* @return IjIkؤν
*/
	private double getAscendingCoefficient(int Ij, int Ik){
		double value = 0;
		ArithmeticMatrix frequencyMatrix = new ArithmeticMatrix(getMaxValue(), getMaxValue());
		frequencyMatrix = getFrequencyMatrix(Ij, Ik);	//ٿʬɽ

		for (int i = 1; i <= ( frequencyMatrix.getRowLength() - 1); i++){	//
			for (int j=i+1; j <=  frequencyMatrix.getColLength(); j++){
				value = (j - i) * frequencyMatrix.getCell(j-1, i-1) + value;
			}
		}
		value = 1 - value / (matrix.getRowLength() * ( frequencyMatrix.getColLength() - 1));
		return value;
	}

/**
* IIνޤ
* @param Ij Ij
* @param Ik Ik
* @return IJؤν
*/
	private double getMiddleCoefficient(int Ij, int Ik){
		double value = 0;
		double centerRating = (getMaxValue() + 1) / 2;		//ɾ
		double numeratorU = (matrix.getRowLength() *
			(getMaxValue() - 1) * (getMaxValue() - 1)) / 4;	//ʬ
		double gravity;		//Ť((r-m0)^2-(q-m0)^2)
		ArithmeticMatrix frequencyMatrix = new ArithmeticMatrix(getMaxValue(), getMaxValue());
		frequencyMatrix = getFrequencyMatrix(Ij, Ik);		//ٿʬɽ

		for (int i = 1; i <= getMaxValue(); i++){		//
			for (int j = 1; j <= getMaxValue(); j++){
				if (Math.abs(i - centerRating) > Math.abs(j - centerRating)){
					gravity = ((i - centerRating) * (i - centerRating)) -
					((j - centerRating) * (j - centerRating));
					value = ((gravity * frequencyMatrix.getCell(j-1, i-1)) / numeratorU) + value;
				}
			}
		}
		value = 1- value;
		return value;
	}

/**
* IIIޤ
* @param Ij Ij
* @param Ik Ik
* @return IJؤ
*/
	private double getNonSortCoefficient(int Ij, int Ik){
		double value = 0;

		//ʬκd0
		double numeratorD = ((matrix.getRowLength() * matrix.getRowLength()) *
			(getMaxValue() - 1)) / (2 * getMaxValue());
		ArithmeticMatrix frequencyMatrix = new ArithmeticMatrix(getMaxValue(), getMaxValue());
		frequencyMatrix.matrixCopy(getFrequencyMatrix(Ij, Ik));	//ٿʬɽ

		for (int i = 1; i <= getMaxValue(); i++){		//
			for (int j = 1; j <= getMaxValue(); j++){
				for (int k = 1; k <= getMaxValue(); k++){
					if (j != k){		//r!=r'ʤ
						value = (frequencyMatrix.getCell(j, i) *
							frequencyMatrix.getCell(k, i)) + value;
					}
				}
			}
		}
		value = 1 - (value / numeratorD);
		return value;
	}

/**
* SSդΥȥޥȥꥯ֤ޤ
* ΥޥȥꥯSSդݤܥޥȥꥯɽޤ
* @return ȥޥȥꥯ
* @see #getSSMatrix()
* @see #getCoefficientMatrix()
*/
	public ArithmeticMatrix getSkeletonMatrix(){
		ArithmeticMatrix SkeletonMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		
		int[] highOrder = new int[matrix.getColLength()];
		System.arraycopy(getGraphElementArray(), 0, highOrder, 0, highOrder.length);
		SkeletonMatrix.clearMatrix();
		
		//SSޥȥꥯ
		ArithmeticMatrix ssMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength());
		ssMatrix.matrixCopy(getSSMatrix());
		
		for (int i = 0; i < SkeletonMatrix.getRowLength(); i++){
			int searchRow = highOrder[i];	 //ºݤ˸Ԥԡʿɾͤι⤤ǡ
			int branchCount = 0;		//Ǥ¾ǤˤĻޤ
			boolean isUnder = true;		//Ǥɾͤ㤤Ǥ򸡺椫

			for (int j = SkeletonMatrix.getRowLength() - 1; j >= 0; j--){
				int searchCol = highOrder[j];	//ºݤ˸Ԥǡ

				if (searchRow == searchCol){		//ƱǤĴ٤褦ȤƤ뤫
					isUnder = false;
					branchCount = 0;		//⤦ٽ
				}
				else{
				//¾ǤȽط뤫ɤ
					if (ssMatrix.getCell(searchRow, searchCol) == SSANALYSIS_SEQUENCE_TRUE){

						/*
						* ޤǤ뤫
						* 1.̤Ǥɾͤ㤤Ǥ򸡺Ƥ뤫
						* 2.Ǥ¾Ǥ˻ޤޤƤʤ
						* 3.ǤǤޤƤ뤫 
						*/
						if ((branchCount == 0) || (isUnder)||
								(SkeletonMatrix.getCell(searchCol,searchRow) ==
									SSANALYSIS_SEQUENCE_TRUE)){
							SkeletonMatrix.setCell
										(searchRow, searchCol, SSANALYSIS_SEQUENCE_TRUE);
							branchCount = branchCount + 1;
							}
						else{		//¾Ǥ˻ޤƤ硢ɤǤ˻ޤõ
							int counter = 0;	//󥿡
							for (int k = ssMatrix.getRowLength() - 1; k > j; k--){
								
								//ޤǤ鸡ԤäƤǤؽϢƤλޤˤƤʤõ
								if ((SkeletonMatrix.getCell(searchRow, highOrder[k]) ==
										SSANALYSIS_SEQUENCE_TRUE) &&
									(ssMatrix.getCell(highOrder[k], searchCol) ==
											SSANALYSIS_SEQUENCE_FALSE)){
										counter = counter + 1;		//ʤϥ󥿡䤹
									}
							}

							//Ƥ¾λޤ褫餽ǤؽϢʤϻޤ
							if (branchCount == counter){
								SkeletonMatrix.setCell
									(searchRow, searchCol, SSANALYSIS_SEQUENCE_TRUE);
								branchCount = branchCount + 1;
							}
						}
					}
				}
			}
		}
		return SkeletonMatrix;
	}

/**
* ܤ򥰥դ¤ؤֹ֤ޤ
* @return դ¤ٴֹʹܡˤä
* @see #getGraphHeightArray()
*/
	public int[] getGraphElementArray(){

		if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I
			return getAscendingGraphArray();
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){		//II
			return getMiddleGraphArray();
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){		//III
			return getNonSortGraphArray();
		}
		else{		//ʤ
			return getAscendingGraphArray();
		}
	}

/**
* SSդݤνļȤʤƹܤ֤ͤޤ
* @return ƹܤνļȤʤͤ
* @see #getGraphElementArray()
*/
	public double[] getGraphHeightArray(){
		double[] returnArray = new double[matrix.getColLength()];

		if (getScaleType() == SSANALYSIS_SCALE_TYPE_ASCENDING){		//I
			System.arraycopy(getAscendingAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_MIDDLE){	//II
			System.arraycopy(getMiddleAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		else if (getScaleType() == SSANALYSIS_SCALE_TYPE_NONSORT){	//III
			System.arraycopy(getNonSortCategoryArray(), 0, returnArray, 0, returnArray.length);
		}
		else{		//ǥե
			System.arraycopy(getAscendingAverageArray(), 0, returnArray, 0, returnArray.length);
		}
		return returnArray;
	}

/**
* ƹܤɾʿ֤ͤޤ<BR>
* IʬϤκݤ˻Ѥޤ
* @return ʿͤä
*/
	private double[] getAscendingAverageArray(){
		double[]  returnArray = new double[matrix.getColLength()];		//ƹܤʿͤǼ
		System.arraycopy(matrix.getColAverageArray(), 0, returnArray, 0, returnArray.length);
		return returnArray;
	}

/**
* ܤ򥰥դ¤ؤֹ֤ޤ<BR>
* ʿɾͤι⤤˹ֹ¤Ѥޤ
* IʬϤκݤѤޤ
* @return դ¤ٴֹʹܡˤä
*/
	private int[] getAscendingGraphArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//ƹܤʿͤǼ
		int[] returnArray = new int[matrix.getColLength()];		//ʿɾͤι⤤¤٤ֹʹܡˤ
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		
		for (int i = 0; i < averageRating.length; i++){
			double maxAverage = averageRating[0];		//
			int maxNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){		//ӤԤ
				if (maxAverage < averageRating[j]){
					maxAverage = averageRating[j];
					maxNumber = j;
				}
			}
			averageRating[maxNumber] = 0;	 //оݤϤ
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}

/**
* ɾͤ鳰Ƥٹɽޥȥꥯ֤ޤ<BR>
* IIʬϤκݤѤޤ
* @return ΥޥȥꥯǤͤͤäޥȥꥯ
*/
	private ArithmeticMatrix getMiddleMomentMatrix(){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(),
			matrix.getColNameArray());
		double centerRating = (getMaxValue() + 1) / 2;		//ɾ
		for (int i = 0; i < matrix.getRowLength(); i++){
			for (int j = 0; j < matrix.getColLength(); j++){
				returnMatrix.setCell(i, j, Math.abs(matrix.getCell(i, j) - centerRating));
			}
		}
		return returnMatrix;
	}

/**
* ɾͤ鳰Ƥ֤ͤޤ<BR>
* IIʬϤκݤѤޤ
* @return ͤͤä
*/
	private double[] getMiddleAverageArray(){
		ArithmeticMatrix calculationMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(), matrix.getRowNameArray(),
			matrix.getColNameArray());
		calculationMatrix.matrixCopy(getMiddleMomentMatrix());
		return calculationMatrix.getColAverageArray();
	}

/**
* ܤ򥰥դ¤ؤֹ֤ޤ
* IIʬϤκݤѤޤ
* @return դ¤ٴֹʹܡˤä
*/
	private int[] getMiddleGraphArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//ƹܤ鳰줿ͤǼ
		int[] returnArray = new int[matrix.getColLength()];	//줿ͤʤ¤٤ֹʹܡˤ
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];	//
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){  //ӤԤ
				if (averageRating[j] < minAverage){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = getMaxValue() * matrix.getRowLength(); //оݤϤ
			returnArray[i] = minNumber;
		}
		return returnArray;
	}

/**
* ƹܤͭƥ꡼᤿֤ޤ<BR>
* IIIʬϤκݤѤޤ
* @return ͭƥ꡼ä
*/
	private double[] getNonSortCategoryArray(){
		double[] returnArray = new double[matrix.getColLength()];
		ArithmeticMatrix frequencyTable = new ArithmeticMatrix(getMaxValue(), getMaxValue());

		for (int i = 0; i < matrix.getColLength(); i++){		//ͭƥ꡼
			double value = 0;
			frequencyTable.matrixCopy(getFrequencyMatrix(i,i));
			for (int j = 0; j < getMaxValue(); j++){
				value = (frequencyTable.getCell(j,j) / matrix.getRowLength())
				* (frequencyTable.getCell(j,j) / matrix.getRowLength()) + value;
			}
			returnArray[i] = 1 / value;
		}
		return returnArray;
	}

/**
* ܤ򥰥դ¤ؤֹ֤ޤ<BR>
* IIIʬϤκݤѤޤ
* @return դ¤ٴֹʹܡˤä
*/
	private int[] getNonSortGraphArray(){
		int[] returnArray = new int[matrix.getColLength()];

		double[]  averageRating = new double[matrix.getColLength()];		//ƹܤͭƥ꡼ͤǼ
		System.arraycopy(getGraphHeightArray(), 0, averageRating, 0, averageRating.length);
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];	//
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){  //ӤԤ
				if(averageRating[j] < minAverage){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = getMaxValue() * matrix.getRowLength(); //оݤϤ
			returnArray[i] = minNumber;
		}
		return returnArray;
	}

/**
* ʬϤԤΥޥȥꥯ֤ޤ
* @return ʬϤԤθΥޥȥꥯ
*/
	public ArithmeticMatrix getMatrix(){
		return matrix;
	}

/**
* 󥱡Ȥη֤ޤ
* @return 󥱡Ȥη
*/
	public int getScaleType(){
		return scaleType;
	}

/**
* ɾκ֤ͤޤ
* @return ɾκ
*/
	public int getMaxValue(){
		return valueRating;
	}

/**
* ֤ͤޤ
* @return 
*/
	public double getThreshold(){
		return thresholdValue;
	}

/**
* SSʬϤоݤȤʤޥȥꥯꤷޤ
* @param baseMatrix ꤹʬоݤΥޥȥꥯ
* @see #setElement(int row, int col, int value)
*/
	public void setMatrix(ArithmeticMatrix baseMatrix){
		matrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.matrixCopy(baseMatrix);		//ޥȥꥯ
	}

/**
* SSʬϤоݤȤʤޥȥꥯǤޤ
* @param row Ǥι
* @param col Ǥ
* @param value 
* @exception NotElementException ꤷǤ¸ߤʤ
* @see #setMatrix(ArithmeticMatrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			matrix.setCell(row, col, value);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* ͤꤷޤ<BR>
* ͤ01ޤǤδ֤ꤷޤ
* @param threshold ꤹ뤷
* @exception SetValueOutOfBoundsException ͤǤϰϳξ
*/
	public void setThreshold(double threshold){
		if(isThreshold(threshold)){
			thresholdValue = threshold;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("Threshold(" + threshold + ")");
		}
	}


/**
* 󥱡Ȥηꤷޤ<BR>
* 󥱡Ȥη 1  2  3 Τ줫ꤷޤ
* @param scale ꤹ륢󥱡Ȥη
* @exception SetValueOutOfBoundsException 󥱡ȤηǤ
*/
	private void setScale(int scale){
		if (isScale(scale)){
			scaleType = scale;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("scale(" + scale + ")");
		}
	}

/**
* ɾκͤꤷޤ<BR>
* ꤹͤʬоݤȤʤ븵ΥޥȥꥯǤˤͤ礭Ϻͤꤷޤ<BR>
* κݺͤ¿Ǥϡʲڤ夲ˤޤ
* @param rating ꤹɾκ
*/
	private void setRating(int rating){
		if (isRating(rating)){
			valueRating = rating;
		}
		else{		//顼ξ
			valueRating = (int)Math.ceil(matrix.getMaxCell());
		}
	}

/**
* 󥱡Ȥηåޤ
* @param checkScale å륢󥱡Ȥη
* @return 󥱡ȤηǤtrueϰϳǤfalse֤ޤ
*/
	private boolean isScale(int checkScale){
		return ((checkScale == SSANALYSIS_SCALE_TYPE_ASCENDING) ||
			(checkScale == SSANALYSIS_SCALE_TYPE_MIDDLE) ||
		(checkScale == SSANALYSIS_SCALE_TYPE_NONSORT));
	}

/**
* ͤϰ⤫åޤ
* @param checkThreshold å뤷
* @return ͤϰǤtrueϰϳǤfalse֤ޤ
*/
	private boolean isThreshold(double checkThreshold){
		return ((0 <= checkThreshold) && (checkThreshold <= 1));
	}

/**
* ɾκͤʬϤԤޥȥꥯǤκͤ礭åޤ
* @param checkRating å뤷
* @return ɾκͤ礭true򡢾false֤ޤ
*/
	private boolean isRating(int checkRating){
		return (matrix.getMaxCell() <= checkRating);
	}

}