package jp.ac.takushoku_u.cs;

/**
* ArrangePointNX̓Ot̗vfzu(`Wʒu)ԂNXłB<br>
* zőo̎}̂Ȃ̃Ot(אڃ}gNX)܂B
* gpRXgN^ɂĂ͊eڂzu郌xƃxł̈ʒu
* (ڊԂ̏㉺эE֌W̏)KvƂȂ܂B
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0301
*/
public class ArrangePoint{
	
/**
* אڃ}gNX
*/
	private BooleanMatrix matrix;
	
/**
* B}gNX
*/
	private BooleanMatrix reachMatrix;
	
/**
* ő僌x(x0n܂邽ߎۂ̃x͍ő僌x+1)
*/
	private int maxLevel;
	
/**
* ő剡
*/
	private int maxWide;
	
/**
* `vf
*/
	private int elementNumber;
	
/**
* `惌xz(z񐔂͗vf)
*/
	private int[] paintLevel;
	
/**
* ꃌxł̕`ʒu
*/
	private int[] paintNumber;
	
/**
* z(z񐔂̓x)
*/
	private int[] paintWide;
	
/**
* evfx,yW
*/
	private int[][] paintPoint;
	
/**
* RXgN^𔲂ǂ
*/
	private boolean isCon = false;
	
/**
* `悷Ƃ1ubN̑傫
*/
	private int blockSize = 50;
	
	
/**
* vf̂Ȃאڃ}gNXݒ肵܂B
*/
	public ArrangePoint(){
		BooleanMatrix mat = new BooleanMatrix();
		setPaintArray();
		point();
		isCon = true;
	}
	
/**
* אڃ}gNXݒ肵A`ʒu߂܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix){
		setMatrix(adjacencyMatrix);
		setPaintArray();
		point();
		isCon = true;
	}
	
/**
* אڃ}gNXƃxݒ肵A`ʒu߂܂B
* @param adjacencyMatrix אڃ}gNX
* @param levelArray evfǂ̃xɔzu邩xԍi[z
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
* @see jp.ac.takushoku_u.cs.LFGPoint
* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintLevel()
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix, int[] levelArray){
		setMatrix(adjacencyMatrix);
		setPaintArray(levelArray);
		point();
		isCon = true;
	}
	
/**
* אڃ}gNXƃxAꃌx̗vfԂł̔zuݒ肵A`ʒu߂܂B
* NXjp.ac.takushoku_u.cs.IMMethod 𗘗pꍇ͂̃RXgN^p܂B
* @param adjacencyMatrix אڃ}gNX
* @param levelArray evfǂ̃xɔzu邩xԍi[z
* @param wideArray evf𓯈ꃌx̂ǂɔzu邩i[z
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
* @see jp.ac.takushoku_u.cs.IMMethod
* @see jp.ac.takushoku_u.cs.IMMethod#getPaintLevel()
* @see jp.ac.takushoku_u.cs.IMMethod#getPaintWideNumber()
* @see jp.ac.takushoku_u.cs.LFGPoint
* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintLevel()
	* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintWideNumber()
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix, int[] levelArray, int[] wideArray){
		setMatrix(adjacencyMatrix);
		setPaintArray(levelArray, wideArray);
		point();
		isCon = true;
	}
	
	
/**
* `Wʒu̔z߂܂B
*/
	private void point(){
		int center = (maxWide+1) * blockSize / 2;
		
		//exŊɕ`vfJEg܂B
		int[] countArray = new int [maxLevel+1];
		
		//Z^O
		for(int i = 0; i <= maxLevel; i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		
		//evfxWyW߂܂
		for(int i = 0; i < elementNumber; i++){
			//
			if(paintWide[paintLevel[i]]%2 == 0){
				if(paintNumber[i] > paintWide[paintLevel[i]] / 2){
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i] + 1) * blockSize;
				}
				else{
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i]) * blockSize;
				}
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i]) * blockSize;
			}
			
			//yW̍
			paintPoint[i][1] = (paintLevel[i]+1) * blockSize;
		}
	}
	
/**
* ǂɔzu邩W(x,y)w肵zԂ܂B
* ̔z񂪕`WʒuƂȂ܂B
* @return Ww肵z
*/
	public int[][] getPointArray(){
		point();
		return paintPoint;
	}
	
/**
* `sۂ̍ő僌xԂ܂B
* @return ő僌x
*/
	public int getMaxLevel(){
		return maxLevel;
	}
	
/**
* `sۂ̍ڂ̍ő剡Ԃ܂B
* ő剡͓ꃌxɂčڐԑƂȂ܂B
* @return ő剡
*/
	public int getMaxWide(){
		return maxWide;
	}
	
/**
* `vf(ڐ)Ԃ܂B
* @return vf
*/
	public int getElementNumber(){
		return elementNumber;
	}
	
/**
* Ot`ۂ̊evf̃xzƂĕԂ܂B
* @return xi[z
*/
	public int[] getPaintLevel(){
		return paintLevel;
	}
	
/**
* Ot`ۂ̓ꃌxł̈ʒuԍzƂĕԂ܂B
* z͓ꃌxŔԍڂ̕荶ɕ`Ƃ܂B
* @return ʒui[z
*/
	public int[] getPaintWideNumber(){
		return paintNumber;
	}
	
/**
* ex̉ێzԂ܂B
* evf͂̍ڔԍ̃xɉɂڂ`悷邩܂B
* @return ̔z
*/
	public int[] getPaintWide(){
		return paintWide;
	}
	
/**
* ő僌xT܂B
* @param levelArray xz
* @return ő僌x
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ő剡T܂B
* @param levelArray xz
* @return ő剡
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* w肵x̉T܂B
* @param level w肷郌x
* @param levelArray xz
* @parama NumberArray xłǂɔzu邩i[z
* @return 
*/
	private int getColLevel(int level, int[] levelArray, int[] numberArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level && count < numberArray[i]){
				count = numberArray[i];
			}
		}
		
		return count;
	}
	
/**
* אڃ}gNXݒ肵܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public void setMatrix(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			if(isCon){
				setPaintArray();
			}
		}
		else{
			throw new NotSquareMatrixException("row("+ adjacencyMatrix.getRowLength() +
				"),col("+adjacencyMatrix.getColLength()+")");
		}
	}
	
/**
* `̂߂̔zݒ肵܂B
*/
	private void setPaintArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getLevelArray(), 0, returnArray, 0, matrix.getRowLength());
		
		setPaintArray(returnArray);
	}
	
/**
* Ot`ۂ̃xzƂĕԂ܂B
* @return xi[z
*/
	private int[] getLevelArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//z̏
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//[g߂
		for(int i = 0; i < returnArray.length; i++){
			if(matrix.getRowSum(i) == 0){
				returnArray[i] = 0;
			}
		}
		
		boolean flag = true;
		
		//xi[
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//x肵ĂȂ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//}̗̐vf̓x肵Ă邩
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//[g̈ʒuύX
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* `̂߂̔zݒ肵܂B
* @param levelArray evfǂ̃xɔzu邩xԍi[z
*/
	private void setPaintArray(int[] levelArray){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getWideNumber(levelArray), 0, returnArray, 0, matrix.getRowLength());
		setPaintArray(levelArray, returnArray);
	}
	
/**
* exł̔zuzƂĕԂ܂B
* @param levelArray xi[z
* @return zui[z
*/
	private int[] getWideNumber(int[] levelArray){
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* `̂߂̔zݒ肵܂B
* @param levelArray evfǂ̃xɔzu邩xԍi[z
* @param wideArray evf𓯈ꃌx̂ǂɔzu邩ʒuԍi[z
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
*/
	public void setPaintArray(int[] levelArray, int[] wideArray){
		if(matrix.getRowLength() == levelArray.length){
			maxLevel = getRowMaxLevel(levelArray);
			maxWide = getColMaxLevel(levelArray);
			elementNumber = levelArray.length;
			
			paintLevel = new int[levelArray.length];
			System.arraycopy(levelArray, 0, paintLevel, 0, levelArray.length);
			
			paintNumber = new int[wideArray.length];
			System.arraycopy(wideArray, 0, paintNumber, 0, wideArray.length);
			
			paintWide = new int[maxLevel+1];
			for(int i = 0; i <= maxLevel; i++){
				paintWide[i] = getColLevel(i, levelArray, wideArray);
			}
			
			paintPoint = new int[elementNumber][2];
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+levelArray.length+")");
		}
	}
	
}