package jp.ac.takushoku_u.cs;
import javax.swing.JFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;

/**
* GraphpaintNX̓Ot`悷邽߂̃NXłB
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.ArrangePoint
* @see jp.ac.takushoku_u.cs.SSGraphPoint
*/
/*
* ŏIXV 2005N0301
*/
public class GraphPaint extends JFrame{
	
/**
* אڃ}gNX
*/
	private BooleanMatrix matrix;
	
/**
* B}gNX
*/
	private BooleanMatrix reachMatrix;
	
/**
* ő僌x(x0n܂邽ߎۂ̃x͍ő僌x+1)
*/
	private int maxLevel;
	
/**
* ő剡
*/
	private int maxWide;
	
/**
* `vf
*/
	private int elementNumber;
	
/**
* `惌xz(z񐔂͗vf)
*/
	private int[] paintLevel;
	
/**
* ꃌxł̕`ʒu
*/
	private int[] paintNumber;
	
/**
* z(z񐔂̓x)
*/
	private int[] paintWide;
	
/**
* evfx,yW
*/
	private int[][] paintPoint;
	
/**
* Otɕ`vf̃TCY
*/
	private int elmentSize = 20;
	
/**
* 1vf̃ubN
*/
	private int elementBlock = 50;
	
/**
* RXgN^𔲂ǂ
*/
	private boolean isCon = false;
	
/**
* t[xl
*/
	private int xp;
/**
* t[yl
*/
	private int yp;
	
/**
* `悷c̍ől
*/
	private double maxValue = Double.NaN;
	
/**
* c̖ڐ`搔
*/
	private int scale = 10;
	
/**
* obNJ[
*/
	private Color bkColor = Color.white;
	
/**
* ̐F
*/
	private Color arColor = Color.red;
	
/**
* c̐F
*/
	private Color rowColor = Color.magenta;
	
/**
* c̖ڐ̐F
*/
	private Color rowNumberColor = Color.darkGray;
	
/**
* `悷vf̐F
*/
	private Color elColor = Color.cyan;
	
/**
* vf̔ԍ̐F
*/
	private Color elNumberColor = Color.black;
	
	
/**
* vf̂Ȃאڃ}gNXݒ肵A`s܂B
*/
	public GraphPaint(){
		super("");
		BooleanMatrix mat = new BooleanMatrix();
		setMatrix(mat);
		setPaintArray();
		setPointArray();
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = (maxWide+1)*elementBlock;
		yp = (maxLevel+2)*elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* אڃ}gNXݒ肵A`s܂B
* zŁAo̎}ȂOtȊO͓ۏႳ܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix){
		super("LFG");
		setMatrix(adjacencyMatrix);
		setPaintArray();
		setPointArray();
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = (maxWide+1)*elementBlock;
		yp = (maxLevel+2)*elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}

/**
* אڃ}gNXƃxAWʒuݒ肵A`s܂B
* LFGۑnOtƂ`悷邽߂̔zŁAo̎}ȂA
* cɃxȊO̒lƂȂOt`悷邽߂̃RXgN^łB
* @param adjacencyMatrix אڃ}gNX
* @param pointArray vf̔zuWi[z
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
* @see jp.ac.takushoku_u.cs.ArrangePoint
* @see jp.ac.takushoku_u.cs.ArrangePoint#getPointArray()
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix, int[][] pointArray){
		super("LFG");
		setMatrix(adjacencyMatrix);
		setPointArray(pointArray);
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = getMaxXPoint(pointArray) + elementBlock;
		yp = getMaxYPoint(pointArray) + elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* אڃ}gNXƃxAWʒuݒ肵A`s܂B
* c̐ݒ肪KvłOtASSOt`߂̃RXgN^łB
* ̃RXgN^pƏc`悳܂B
* @param adjacencyMatrix אڃ}gNX
* @param pointArray vf̔zuWi[z
* @param max c̍ől
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
* @see jp.ac.takushoku_u.cs.SSGraphPoint
* @see jp.ac.takushoku_u.cs.SSGraphPoint#getPointArray()
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix, int[][] pointArray, double max){
		super("SSGraph");
		setMatrix(adjacencyMatrix);
		setPointArray(pointArray);
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = getMaxXPoint(pointArray) + elementBlock;
		yp = 700;//((getMaxYPoint(pointArray) / elementBlock)+2) * elementBlock;
		maxValue = max;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* Ot`悵܂B
*/
	public void paint(Graphics g){
		
		//c`悵܂
		if(!Double.isNaN(maxValue)){
			
			//`F̐ݒ
			g.setColor(rowColor);
			
			//c̕`
			g.drawLine(elementBlock*4/5, elementBlock+elmentSize/2, elementBlock*4/5, (yp - elementBlock)+elmentSize/2);
			
			//c̊Ԋu
			int interval;
			if((yp * 1.0 - elementBlock) % (scale+1.0) >= (scale+1.0) / 2.0 ){
				interval = (yp - elementBlock) / (scale+1);
			}
			else{
				interval = (yp - elementBlock) / (scale+1) + 1;
			}
			for(int i = 0; i <= scale; i++){
				g.setColor(rowColor);
				g.drawLine(elementBlock*3/5,interval * i + (elementBlock + elmentSize/2),
					elementBlock*4/5,interval * i + (elementBlock + elmentSize/2));
				
				//l
				g.setColor(rowNumberColor);
				g.drawString(""+(maxValue - (maxValue*i) / scale ), elementBlock*1 / 10,
					interval * i + (elementBlock + elmentSize/2));
			}
			System.out.println();
		}
		
		
		//evf`悵܂
		for(int i = 0; i < matrix.getRowLength(); i++){
			g.setColor(elColor);
			g.fillOval(paintPoint[i][0], paintPoint[i][1], elmentSize, elmentSize); //(x,y,傫,傫)
			g.setColor(elNumberColor);
			if(i < 10){
				g.drawString(i+"",paintPoint[i][0]+(elmentSize/4),paintPoint[i][1]+(elmentSize*3/4));
			}
			else{
				g.drawString(i+"",paintPoint[i][0]+(elmentSize/10),paintPoint[i][1]+(elmentSize*3/4));
			}
		}
		
		
		//e}`悵܂
		for(int i = 0; i < matrix.getRowLength(); i++){
			g.setColor(arColor);
			for(int j = 0; j < matrix.getColLength(); j++){
				if(matrix.getCell(i,j)){
					
					//̕`
					//x0 n_xW,n_yW
					//x1 I_xW,y1 I_yW,arrow ̒
					int x0, y0, x1, y1;
					
					//ォ牺ֈƂ
					if(paintPoint[j][1] > paintPoint[i][1]){
						x0 = paintPoint[i][0] + elmentSize / 2;
						y0 = paintPoint[i][1] + elmentSize;
						x1 = paintPoint[j][0] + elmentSize / 2;
						y1 = paintPoint[j][1];
					}
					//xɈƂ
					else if(paintPoint[j][1] == paintPoint[i][1]){
						if(paintPoint[j][0] >= paintPoint[i][0]){
							x0 = paintPoint[i][0] + elmentSize;
							y0 = paintPoint[i][1] + elmentSize / 2;
							x1 = paintPoint[j][0];
							y1 = paintPoint[j][1] + elmentSize / 2;
						}
						else{
							x0 = paintPoint[i][0];
							y0 = paintPoint[i][1] + elmentSize / 2;
							x1 = paintPoint[j][0] + elmentSize;
							y1 = paintPoint[j][1] + elmentSize / 2;
						}
					}
					//ȊO
					else{
						x0 = paintPoint[i][0] + elmentSize / 2;
						y0 = paintPoint[i][1];
						x1 = paintPoint[j][0] + elmentSize / 2;
						y1 = paintPoint[j][1] + elmentSize;
					}
					
					int arrow = 7;
					double theta;
					
					//`x,y
					int x,y;
					double dt = Math.PI / 6.0;
					theta = Math.atan2((double)(y1-y0),(double)(x1-x0));
					g.drawLine(x0,y0,x1,y1);
					x = x1-(int)(arrow*Math.cos(theta-dt));
					y = y1-(int)(arrow*Math.sin(theta-dt));
					g.drawLine(x1,y1,x,y);
					x = x1-(int)(arrow*Math.cos(theta+dt));
					y = y1-(int)(arrow*Math.sin(theta+dt));
					g.drawLine(x1,y1,x,y);
				}
			}
		}
	}
	
	
/**
* ő僌xԂ܂B
* @param levelArray xz
* @return ő僌x
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ő剡Ԃ܂B
* @param levelArray xz
* @return ő剡
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* w肵x̉T܂B
* @param level w肷郌x
* @param levelArray xz
* @return 
*/
	private int getColLevel(int level, int[] levelArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level){
				count++;
			}
		}
		
		return count;
	}
	
/**
* `sOtאڃ}gNXƂĐݒ肵܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public void setMatrix(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			if(isCon){
				setPaintArray();
			}
		}
		else{
			throw new NotSquareMatrixException("row("+ adjacencyMatrix.getRowLength() +
				"),col("+adjacencyMatrix.getColLength()+")");
		}
	}
	
/**
* `̂߂̔zݒ肵܂B
* ͗אڃ}gNX玩Ő܂B
*/
	private void setPaintArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getLevelArray(), 0, returnArray, 0, matrix.getRowLength());
		setPaintArray(returnArray);
	}
	
/**
* Ot`ۂ̃xzƂĕԂ܂B
* @return xi[z
*/
	private int[] getLevelArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//z̏
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//[g߂
		for(int i = 0; i < returnArray.length; i++){
			if(matrix.getRowSum(i) == 0){
				returnArray[i] = 0;
			}
		}
		
		boolean flag = true;
		
		//xi[
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//x肵ĂȂ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//}̗̐vf̓x肵Ă邩
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//[g̈ʒuύX
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* `̂߂̔zݒ肵܂B
* @param levelArray evfǂ̃xɔzu邩xԍi[z
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
*/
	public void setPaintArray(int[] levelArray){
		if(matrix.getRowLength() == levelArray.length){
			maxLevel = getRowMaxLevel(levelArray);
			maxWide = getColMaxLevel(levelArray);
			elementNumber = levelArray.length;
			
			paintLevel = new int[levelArray.length];
			System.arraycopy(levelArray, 0, paintLevel, 0, levelArray.length);
			paintWide = new int[maxLevel+1];
			for(int i = 0; i <= maxLevel; i++){
				paintWide[i] = getColLevel(i, levelArray);
			}
			setPointArray();
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+levelArray.length+")");
		}
	}
	
/**
* `ʒuŵ߂̔zݒ肵܂B
* ͗אڃ}gNX玩Ő܂B
*/
	private void setPointArray(){
		paintPoint = new int[elementNumber][2];
		setPaint();
	}
	
/**
* `ʒuŵ߂̔zݒ肵܂B
* @param pointArray ʒuz
*/
	public void setPointArray(int[][] pointArray){
		if(matrix.getRowLength() == pointArray.length){
			paintPoint = new int[pointArray.length][2];
			for(int i = 0; i < pointArray.length; i++){
				System.arraycopy(pointArray[i], 0, paintPoint[i], 0, pointArray[i].length); 
			}
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+pointArray.length+")");
		}
	}
	
/**
* `ʒuݒ肵܂B
*/
	private void setPaint(){
		//exŊɕ`vfJEg܂B
		int[] countArray = new int [maxLevel+1];
		for(int i = 0; i <= maxLevel; i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		
		//evfxWyW߂܂
		for(int i = 0; i < elementNumber; i++){
				
			//
			if(paintWide[paintLevel[i]]%2 == 0){
				if(countArray[paintLevel[i]]+1 == maxWide/2+1){
					countArray[paintLevel[i]]++;
				}
				paintPoint[i][0] = (countArray[paintLevel[i]] + 1) * elementBlock;
				countArray[paintLevel[i]]++;
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + 1) * elementBlock;
				countArray[paintLevel[i]]++;
			}
			
			//yW̍
			paintPoint[i][1] = (paintLevel[i]+1) * elementBlock;
		}
	}
	
/**
* `񂩂x̍ől߂܂B
* @param pointArray ʒuz
*/
	private int getMaxXPoint(int[][] pointArray){
		int max = -1;
		for(int i = 0; i < pointArray.length; i++){
			if(pointArray[i][0] > max){
				max = pointArray[i][0];
			}
		}
		return max;
	}
	
/**
* `񂩂y̍ől߂܂B
* @param pointArray ʒuz
*/
	private int getMaxYPoint(int[][] pointArray){
		int max = -1;
		for(int i = 0; i < pointArray.length; i++){
			if(pointArray[i][1] > max){
				max = pointArray[i][1];
			}
		}
		return max;
	}
	
/**
* `悳L}̐FύX܂B
* ݒ肵Ȃꍇ̓ftHgF(red)ƂȂ܂B
* @param c ݒ肷F
*/
	public void setArrowColor(Color c){
		arColor = c;
		repaint();
	}
	
/**
* c̐FύX܂B
* ݒ肵Ȃꍇ̓ftHgF(magenta)ƂȂ܂B
* @param c ݒ肷F
*/
	public void setRowLineColor(Color c){
		rowColor = c;
		repaint();
	}
	
/**
* c̖ڐ(l)̐FύX܂B
* ݒ肵Ȃꍇ̓ftHgF(darkGray)ƂȂ܂B
* @param c ݒ肷F
*/
	public void setRowLineNumberColor(Color c){
		rowNumberColor = c;
		repaint();
	}
	
/**
* `悷vf̐FύX܂B
* ݒ肵Ȃꍇ̓ftHgF(cyan)ƂȂ܂B
* @param c ݒ肷F
*/
	public void setElementColor(Color c){
		elColor = c;
		repaint();
	}
	
/**
* vf̔ԍ̐FύX܂B
* ݒ肵Ȃꍇ̓ftHgF(black)ƂȂ܂B
* @param c ݒ肷F
*/
	public void setElementNumberColor(Color c){
		elNumberColor = c;
		repaint();
	}
	
}