package jp.ac.takushoku_u.cs;

/**
* IMMethodNXIM@pēꃌx̔zu肷NXłB
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0302
*/
public class IMMethod{
	
/**
* אڃ}gNX
*/
	private BooleanMatrix matrix;
	
/**
* B}gNX
*/
	private BooleanMatrix reachMatrix;
	
/**
* [gƂ鍀
*/
	private int rootItem = -1;

/**
* vf̂Ȃאڃ}gNXݒ肵܂B
*/
	public IMMethod(){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
	}
	
/**
* אڃ}gNXOt`߂̃x(cA)߂܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXłȂꍇ
*/
	public IMMethod(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
/**
* Ot`ۂ̃xzƂĕԂ܂B
* @return xi[z
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//z̏
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//[g߂
		if(rootItem == -1){
			for(int i = 0; i < returnArray.length; i++){
				if(matrix.getRowSum(i) == 0){
					returnArray[i] = 0;
				}
			}
		}
		else{
			returnArray[rootItem] = 0;
		}
		
		boolean flag = true;
		
		//xi[
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//x肵ĂȂ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//}̗̐vf̓x肵Ă邩
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//[g̈ʒuύX
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* IM@𗘗pċ߂exł̔zuzƂĕԂ܂B
* ꃌxł͗vf̔ԍ̂قǍɕ`悳܂B
* @return zui[z
*/
	public int[] getPaintWideNumber(){
		return getPaintWideNumber(getPaintLevel());
	}
	
/**
* IM@𗘗pċ߂exł̔zuzƂĕԂ܂B
* ꃌxł͗vf̔ԍ̂قǍɕ`悳܂B
* @param levelArray `sevf̃xi[z
* @return zui[z
*/
	public int[] getPaintWideNumber(int[] levelArray){
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = Integer.MAX_VALUE;//(int)Double.NaN;
		}
		
		//ő僌x
		int maxWide = getRowMaxLevel(levelArray);
		
		//݂܂łɂ̃x͂vf`
		int[] elementWide = new int[maxWide + 1];
		for(int i = 0; i < elementWide.length; i++){
			elementWide[i] = 0;
		}
		
		//eڂ̏dvx߂z
		double[] impotant = new double[returnArray.length];
		System.arraycopy(getImportantItemArray(matrix), 0, impotant, 0, impotant.length);
		
		//ɑI\ȍڂ̔z
		boolean[] nextChoice = new boolean[returnArray.length];
		
		//I\ڂꍇ̌ƂȂ鍀ڂ̔z
		boolean[] choice = new boolean[returnArray.length];
		
		//Ot
		BooleanMatrix sectionGraph = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		sectionGraph.clearMatrix();
		
		//I
		int nextItem = getMaxItem(impotant);
		returnArray[nextItem] = 0;		//Sɔzu
		elementWide[levelArray[nextItem]]++;
		
		//̍ڂI
		int secondItem = getMaxItem(matrix, impotant, nextItem);
		returnArray[secondItem] = 0;		//Sɔzu
		elementWide[levelArray[secondItem]]++;
		
		//Ot̍쐬
		if(matrix.getCell(nextItem, secondItem)){
			sectionGraph.setCell(nextItem, secondItem, true);
		}
		else{
			sectionGraph.setCell(secondItem, nextItem, true);
		}
		
		//(3Ԗ)ɑI\ȍڂ̍쐬
		for(int i = 0; i < nextChoice.length; i++){
			
			//2vfɗאڂvfT
			if(i != nextItem && i != secondItem && 
				(matrix.getCell(i, nextItem) || matrix.getCell(nextItem, i) ||
					matrix.getCell(i, secondItem) || matrix.getCell(secondItem, i))){
						nextChoice[i] = true;
			}
			else{
				nextChoice[i] = false;
			}
		}
		
		//[v(3Ԗڂ̗vfȍ~I)
		for(int k = 2; k < levelArray.length; k++){
			
			//dvxłڂ̔z
			System.arraycopy(getMaxItemArray(nextChoice, impotant), 0, choice, 0, choice.length);
			
			//ɓdvxڂȂ
			int num = 0;
			if(isATrue(choice)){
				for(int i = 0; i < choice.length; i++){
					if(choice[i]){
						num = i;
					}
				}
			}
			
			//܂Ȃꍇ
			else{
				
				//OtG'ɗאڂvfvfI郁\bh
				num = getChoiceElement(choice, levelArray, returnArray, sectionGraph);
			}
			
			//zu肷(zu鍀ڂnum)
			//Sɔzułꍇ
			if(elementWide[levelArray[num]] == 0){
				returnArray[num] = 0;
				elementWide[levelArray[num]]++;
			}
			else{
				returnArray[num] = getPoint(num, levelArray, maxWide, returnArray, sectionGraph, matrix);
				elementWide[levelArray[num]]++;
			}
			
			//Ot
			for(int i = 0; i < sectionGraph.getRowLength(); i++){
				if(sectionGraph.getRowSum(i) > 0 || sectionGraph.getColSum(i) > 0){
					if(matrix.getCell(i, num)){
						sectionGraph.setCell(i, num, true);
					}
					else if(matrix.getCell(num, i)){
						sectionGraph.setCell(num, i, true);
					}
				}
			}
			
			//zuڂƗאڂ鍀ڂT
			nextChoice[num] = false;
			for(int i = 0; i < nextChoice.length; i++){
				if(sectionGraph.getRowSum(i) > 0 || sectionGraph.getColSum(i) > 0){
					for(int j = 0; j < matrix.getRowLength(); j++){
						if(i != j && (matrix.getCell(i, j) || matrix.getCell(j, i)) &&
						(sectionGraph.getRowSum(j) == 0 && sectionGraph.getColSum(j) == 0)){
							nextChoice[j] = true;
						}
					}
				}
			}
			
		//[vI
		}
		
		//returnArray0n܂̂ɕς
		System.arraycopy(getWideArray(levelArray, maxWide, returnArray), 0, returnArray, 0, returnArray.length);
		
		return returnArray;
	}
	
/**
* ő僌xT܂B
* @param levelArray xz
* @return ő僌x
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* w肳ꂽڂ̏dvxԂ܂B<br>
* ł̏dvx͍itemɗאڂSĂ̗vfiɑ΂āAI(v_item, v_i) = N[A(v_item)]*N[R(v_i)]<br>
* (AAv_itemv_it̏ꍇ)߁ASđ̂ɂȂ܂B
* ŁAN[]͂̏W̗vfAA͐sWAR͉BWƂȂ܂B
* @param baseMatrix dvx߂}gNX
* @param item w肷鍀
* @return w肵ڂ̏dvx
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public double getImportantItem(BooleanMatrix baseMatrix, int item){
		if(baseMatrix.isSquare()){
			BooleanMatrix temporaryMatrix = new BooleanMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
			temporaryMatrix.matrixCopy(baseMatrix.getReachMatrix());
			double value = 0.0;
			
			for(int i = 0; i < baseMatrix.getRowLength(); i++){
				
				//I(v_i, v_item)߂
				if(baseMatrix.getCell(i, item)){
					value = temporaryMatrix.getColSum(i) * temporaryMatrix.getRowSum(item) + value;
				}
				
				//I(v_item, v_i)߂
				if(baseMatrix.getCell(item, i)){
					value = temporaryMatrix.getColSum(item) * temporaryMatrix.getRowSum(i) + value;
				}
			}
			return value;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* Sڂ̏dvxzŕԂ܂B
* @param baseMatrix dvx߂}gNX
* @return dvxi[z
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	public double[] getImportantItemArray(BooleanMatrix baseMatrix){
		if(baseMatrix.isSquare()){
			double[] returnArray = new double[baseMatrix.getRowLength()];
			for(int i = 0; i < baseMatrix.getRowLength(); i++){
				returnArray[i] = getImportantItem(baseMatrix, i);
			}
			return returnArray;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* z̒gőłvf̔ԍԂ܂B
* @param lookArray Tz
* @return ő̍ڔԍ
*/
	private int getMaxItem(double[] lookArray){
		int value = 0;
		double max;
		max = lookArray[0];
		for(int i = 1; i < lookArray.length; i++){
			if(max < lookArray[i]){
				max = lookArray[i];
				value = i;
			}
		}
		return value;
	}
	
/**
* w肵vfƗאڂȂ̂̂z̒gőłvf̔ԍԂ܂B
* @param baseMatrix אڃ}gNX
* @param lookArray Tz
* @param item w肷鍀
* @return ő̍ڔԍ
*/
	private int getMaxItem(BooleanMatrix baseMatrix, double[] lookArray, int item){
		int value = 0;
		double max;
		max = 0.0;
		for(int i = 0; i < lookArray.length; i++){
			if(i != item && max < lookArray[i] &&(baseMatrix.getCell(i, item) || baseMatrix.getCell(item, i))){
				max = lookArray[i];
				value = i;
			}
		}
		return value;
	}
	
/**
* I\ڂ̂Az̒gőłvfzŕԂ܂B
* @param choiceArray I\ڂz
* @param lookArray Tz
* @return őƂȂi[z
*/
	private boolean[] getMaxItemArray(boolean[] choiceArray, double[] lookArray){
		boolean[] returnArray = new boolean[choiceArray.length];
		double max = 0.0;
		
		//ől̒T
		for(int i = 0; i < lookArray.length; i++){
			if(choiceArray[i] && lookArray[i] > max){
				max = lookArray[i];
			}
		}
		
		//őlStrueɂ
		for(int i = 0; i < lookArray.length; i++){
			if(choiceArray[i] && lookArray[i] == max){
				returnArray[i] = true;
			}
			else{
				returnArray[i] = false;
			}
		}
		
		return returnArray;
	}
	
/**
* _^ztruě1ǂT܂B
* @param lookArray Tz
* @return true1ł΁A true
*/
	private boolean isATrue(boolean[] lookArray){
		int count = 0;
		for(int i = 0; i < lookArray.length; i++){
			if(lookArray[i]){
				count++;
			}
		}
		
		return count == 1;
	}
	
/**
* IłvfꍇɑIvfIт܂B
* @param choiceArray IƂȂvfz
* @param levelArray evf̃xi[ꂽz
* @param wideArray ɔzu肵z
* @param partMatrix Ot
* @return vfԍ
*/
	private int getChoiceElement(boolean[] choiceArray, int[] levelArray, int[] wideArray, BooleanMatrix partMatrix){
		
		//1.Sɋ߂zułvfI
		int number = -1;
		int value = Integer.MAX_VALUE;
		for(int i =0; i < choiceArray.length; i++){
			if(choiceArray[i]){
				if(getArrangePoint(i, levelArray, wideArray) < value){
					number = i;
					value = getArrangePoint(i, levelArray, wideArray);
				}
			}
		}
		
		//Iڂr
		for(int i = 0; i < choiceArray.length; i++){
			if(choiceArray[i] && getArrangePoint(i, levelArray, wideArray) > value){
				choiceArray[i] = false;
			}
		}
		
		//I\ڂ1ǂ
		if(!isATrue(choiceArray)){
		
			//2.Otɗאڂvf̂I
			//3.ꂩ̗vfI(̏ꍇ͗vfԍ̏)
			number = 0;
			value = 0;
			for(int i =0; i < choiceArray.length; i++){
				
				//אڂĂ𐔂
				int count = 0;
				if(choiceArray[i]){
					for(int j = 0; j < choiceArray.length; j++){
						if(1 != j &&(matrix.getCell(i , j) || matrix.getCell(j, i))){
							boolean flag = true;
							for(int k = 0; k < choiceArray.length && flag; k++){
								if(partMatrix.getCell(j ,k) || partMatrix.getCell(k ,j)){
									flag = false;
								}
							}
							if(!flag){
								count++;
							}
						}
					}
				}
				if(count > value){
					number = i;
					value = count;
				}
				
			}
		}
		else{
			for(int i = 0;i < choiceArray.length; i++){
				if(choiceArray[i]){
					number = i;
				}
			}
		}
		
		return number;
	}
	
/**
* w肵vfS炢߂ɔzuł邩Ԃ܂B
* @param item w肷vf
* @param levelArray evf̃xi[ꂽz
* @param wideArray ɔzu肵z
* @return zułԍ(SȂ0)
*/
	private int getArrangePoint(int item, int[] levelArray, int[] wideArray){
		int max = 0;
		int min = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(i != item && levelArray[i] == levelArray[item]){
				if(wideArray[i] != Integer.MAX_VALUE){
					if(wideArray[i] >= 0){
						if(wideArray[i] > max){
							max = wideArray[i];
						}
					}
					else{
						if(wideArray[i] < min){
							min = wideArray[i];
						}
					}
				}
			}
		}
		
		if(Math.abs(max) > Math.abs(min)){
			return Math.abs(min);
		}
		else{
			return Math.abs(max);
		}
	}
	
/**
* SɔzułȂꍇE[[̂ǂɔzu邩肵܂B
* @param item zusvf
* @param levelArray evf̃xi[ꂽz
* @param maxLevel ő僌x
* @param wideArray ɔzu肵z
* @param partMatrix Ot
* @param graph ̃Ot
* @return `sꏊ(Ȃ΍AȂΉE)
*/
	private int getPoint(int item, int[] levelArray, int maxLevel, int[] wideArray, BooleanMatrix partMatrix, BooleanMatrix graph){
		int returnValue;
		int left = 0;
		int right = 0;
		
		//1.G'̍ō[܂͍ŉE[̗vfƗאڂvfقɔzu
		for(int i = 0; i <= maxLevel; i++){
			int max = 0;
			int maxElement = 0;
			int min = 0;
			int minElement = 0;
			
			//ŉE[ƍō[̒T
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i && wideArray[j] != Integer.MAX_VALUE &&
				(partMatrix.getRowSum(j) > 0 || partMatrix.getColSum(j) > 0)){
					if(wideArray[j] >= max){
						max = wideArray[j];
						maxElement = j;
					}
					if(wideArray[j] <= min){
						min = wideArray[j];
						minElement = j;
					}
				}
				
			}
			
			//OtƗאڂĂ邩
			if((graph.getCell(item, maxElement) || graph.getCell(maxElement, item))&&
			(partMatrix.getRowSum(maxElement) > 0 || partMatrix.getColSum(maxElement) > 0)){
				right++;
			}
			
			if((graph.getCell(item, minElement) || graph.getCell(minElement, item)) && 
			(partMatrix.getRowSum(minElement) > 0 || partMatrix.getColSum(minElement) > 0)){
				left++;
			}
		}
		
		//̂̕ōɔzu
		if(left > right){
			int min = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
					if(wideArray[j] < min){
						min = wideArray[j];
					}
				}
			}
			returnValue = min - 1;
		}
		
		//Ê̕ŉEɔzu
		else if(right > left){
			int max = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
					if(wideArray[j] > max){
						max = wideArray[j];
					}
				}
			}
			returnValue = max + 1;
		}
		
		//2.ꍇG'֗L}`悵ƂEƍŎ}̒̑aقɔzu
		else{
			left = 0;
			right = 0;
			
			for(int i = 0; i < levelArray.length; i++){
				if((graph.getCell(item, i) || graph.getCell(i, item)) &&
				(partMatrix.getRowSum(i) > 0)){
					
					if(wideArray[i] >= 0){
							right = right + Math.abs(levelArray[i] - levelArray[item]);
						}
						else if(wideArray[i] <= 0){
							left = left +  Math.abs(levelArray[i] - levelArray[item]);
						}
					
				}
			}
			
			//̂̕ōɔzu
			if(left < right){
				int min = 0;
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
						if(wideArray[j] < min){
							min = wideArray[j];
						}
					}
				}
				returnValue = min - 1;
			}
			
			//Ê̕ŉEɔzu
			else if(right < left){
				int max = 0;
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
						if(wideArray[j] > max){
							max = wideArray[j];
						}
					}
				}
				returnValue = max + 1;
			}
			
			//3.G'̉EƍŏȂvf̑ɔzu
			else{
				right = 0;
				left = 0;
				for(int i = 0; i < levelArray.length; i++){
					if((partMatrix.getRowSum(i) > 0 || partMatrix.getColSum(i) > 0) 
						&& wideArray[i] != Integer.MAX_VALUE){
						if(wideArray[i] > 0){
							right++;
						}
						else if(wideArray[i] < 0){
							left++;
						}
					}
				}
				
				//E̗vf̂ōɔzu
				if(left < right){
					int min = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] < min){
								min = wideArray[j];
							}
						}
					}
					returnValue = min - 1;
				}
				
				//̗vf̂ŉEɔzu
				else if(right < left){
					int max = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] > max){
								max = wideArray[j];
							}
						}
					}
					returnValue = max + 1;
				}
				
				//4.EꂩɔzuB̏ꍇ͉E
				else{
					//returnValue = 1;
					int max = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] > max){
								max = wideArray[j];
							}
						}
					}
					returnValue = max + 1;
				}
			}
		}
		
		return returnValue;
	}
	
/**
* ꃌx̔zu1n܂zƂĕԂ܂B
* ASɍEΏ̂ƂȂ悤ɔzu܂B
* ̂1Ȃꍇ܂B(Eꍇ)
* @param levelArray evf̃xi[ꂽz
* @param maxLevel ő僌x
* @param wideArray ɔzu肵z
* @retrun ɔzu肵zCz
*/
	private int[] getWideArray(int[] levelArray, int maxLevel, int[] wideArray){
		
		
		for(int i = 0; i <= maxLevel; i++){
			
			//ex̍ŏlAőlT
			int min = Integer.MAX_VALUE;
			int max = Integer.MIN_VALUE;
			
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					if(wideArray[j] < min){
						min = wideArray[j];
					}
					if(wideArray[j] > max){
						max = wideArray[j];
					}
				}
				
			}
			
			//EƂ
			//Ƃ
			if(Math.abs(max) <= Math.abs(min)){
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == i){
						wideArray[j] = wideArray[j] + Math.abs(min) + 1;
					}
				}
			}
			//EƂ
			else if(Math.abs(max) > Math.abs(min)){
				int sa = Math.abs(max) - Math.abs(min);
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == i){
						wideArray[j] = wideArray[j] + Math.abs(min) + sa + 1;
					}
				}
			}
		}
		
		return wideArray;
	}
	
}