package jp.ac.takushoku_u.cs;

/**
* LFGpointNXLFG`悷ۂ̔zux肷NXłB
* ꃌxł̔zúAvfԍ̏̂珇ɍzu܂B
* ̂߁ÃNXpĕ`sꍇL}̌Nꍇ܂B
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0301
*/
public class LFGPoint{
	
/**
* אڃ}gNX
*/
	private BooleanMatrix matrix;
	
/**
* [gƂ鍀
*/
	private int rootItem = -1;

/**
* vf̂Ȃאڃ}gNXݒ肵܂B
*/
	public LFGPoint(){
		matrix = new BooleanMatrix();
	}
	
/**
* אڃ}gNXOt`߂̃x(cA)߂܂B
* @param adjacencyMatrix אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXłȂꍇ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* אڃ}gNXOt`߂̃x(cA)߂܂B
* @param adjacencyMatrix אڃ}gNX
* @param top [g̗vf
* @exception NotSquareMatrixException ݒ肵}gNXłȂꍇ
* @exception NegativeValueException [g̗vfɕw肵ꍇ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix, int top){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			if(top < 0){
				matrix.matrixCopy(adjacencyMatrix);
				top = rootItem;
			}
			else{
				throw new NegativeValueException("top("+top+")");
			}
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* אڃ}gNXƏc񂩂Ot`߂̃x̃O[v()߂܂B
* @param adjacencyMatrix אڃ}gNX
* @param averageArray c
* @exception NotSquareMatrixException ݒ肵}gNXłȂꍇ
*/
	public LFGPoint(BooleanMatrix adjacencyMatrix, double[] averageArray){
		matrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			
			double max = Double.NEGATIVE_INFINITY;
			int item = -1;
			for(int i = 0; i < averageArray.length; i++){
				if(averageArray[i] > max){
					max = averageArray[i];
					item = i;
				}
			}
			rootItem = item;
			
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
/**
* Ot`ۂ̃xzƂĕԂ܂B
* @return xi[z
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//z̏
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//[g߂
		if(rootItem == -1){
			for(int i = 0; i < returnArray.length; i++){
				if(matrix.getRowSum(i) == 0){
					returnArray[i] = 0;
				}
			}
		}
		else{
			returnArray[rootItem] = 0;
		}
		
		boolean flag = true;
		
		//xi[
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//x肵ĂȂ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//}̗̐vf̓x肵Ă邩
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//[g̈ʒuύX
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* exł̔zuzƂĕԂ܂B
* @return zui[z
*/
	public int[] getPaintWideNumber(){
		int[] levelArray = new int[matrix.getRowLength()];
		System.arraycopy(getPaintLevel(), 0, levelArray, 0, matrix.getRowLength());
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* exł̔zuzƂĕԂ܂B
* @param levelArray xi[z
* @return zui[z
*/
	public int[] getPaintWideNumber(int[] levelArray){
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* ő僌xT܂B
* @param levelArray xz
* @return ő僌x
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ݒ肳ꂽc񂩂ɕ`߂܂B
* @param averageArray c
* @return vfォ`ɍڔԍёւzB
*/
	private int[] getGraphArray(double[] averageArray){
		int[] returnArray = new int[matrix.getColLength()];		//ϕ]l̍ɕׂ̗ԍiځj
		
		for (int i = 0; i < averageArray.length; i++){
			double maxAverage = averageArray[0];		//l
			int maxNumber = 0;
			for (int j = 1; j <  averageArray.length; j++){		//rs
				if (maxAverage < averageArray[j]){
					maxAverage = averageArray[j];
					maxNumber = j;
				}
			}
			averageArray[maxNumber] = Double.NEGATIVE_INFINITY;	 //rΏۂ͂
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}
}