package jp.ac.takushoku_u.cs;

/**
* MatrixNX2z̎ۂ̗vfAsƗ񖼂ێ܂B<BR>
* @version 1.1.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2004N1211
*/
public class Matrix {

/**
* s̃TCYێϐ
*/
    private int matrixRowSize;
	
/**
* ̃TCYێϐ
*/
	private int matrixColSize;

/**
* si[pz
*/
	private String[ ] matrixRowName;

/**
* 񖼊i[pz
*/
	private String[ ] matrixColName;
	
/**
* f[^ۑp2z
*/
	private Object[ ][ ] matrix;
	
/**
* 2z̃ftHglisTCYj
*/
	private static final int MATRIX_INIT_ROW_SIZE = 5;
	
/**
* 2z̃ftHgliTCYj
*/
	private static final int MATRIX_INIT_COL_SIZE = 5;


/**
* ݒ肳ĂTCY̍sA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
*/
	public Matrix(){
		setSizeMatrix(MATRIX_INIT_ROW_SIZE,MATRIX_INIT_COL_SIZE);
		setRowNameNumber();
		setColNameNumber();
	}

/**
* w肳ꂽsTCYƗTCYɍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX𐶐悤Ƃꍇ
*/
	public Matrix(int rowSize, int colSize){
		setSizeMatrix(rowSize,colSize);
		setRowNameNumber();
		setColNameNumber();
	}
	
/**
* w肳ꂽsTCYƗTCYɍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param nameNumber sї񖼂̊Jnԍ
* @exception NegativeMatrixSizeException ̃TCỸ}gNX𐶐悤Ƃꍇ
*/
	public Matrix(int rowSize, int colSize, int nameNumber){
		setSizeMatrix(rowSize,colSize);
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}

/**
* w肳ꂽsTCYATCYAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑S0ŏ܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param rowName w肷s
* @param colName w肷
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
* @exception DisagreementArraySizeException }gNX̎w肵TCYƍsA񖼗p̔zƃTCYقȂꍇ
* @exception NullPointerException  rowName ܂ colName  null ̏ꍇ
*/
	public Matrix(int rowSize, int colSize, String[] rowName, String[] colName){
		if(isSameArraySize(rowSize, rowName) && isSameArraySize(colSize, colName)){
			setSizeMatrix(rowSize,colSize);
			
			//sї񖼂̃Rs[
			nameRowCopy(rowName);
			nameColCopy(colName);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param originalMatrix w肷2z
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public Matrix(Object[][] originalMatrix){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		setRowNameNumber();
		setColNameNumber();
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param originalMatrix w肷2z
* @param nameNumber sї񖼂̊Jnԍ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public Matrix(Object[][] originalMatrix, int nameNumber){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B
* @param originalMatrix w肷2z
* @param rowName w肷s
* @param colName w肷
* @exception DisagreementArraySizeException }gNX̎w肵TCYƍsA񖼗p̔zƃTCYقȂꍇ
* @exception NullPointerException  rowName , colName ܂ originalMatrix  null ̏ꍇ
*/
	public Matrix(Object[][] originalMatrix, String[] rowName, String[] colName){
		if(isSameArraySize(originalMatrix, rowName, colName)){
			setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
			
			//}gNX̃Rs[
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					setCell(i, j, originalMatrix[i][j]);
				}
			}
			
			//sї񖼂̃Rs[
			nameRowCopy(rowName);
			nameColCopy(colName);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}

/**
* w肵zsƂă}gNXɃRs[܂B
* @param rowName Rs[̍sz
* @exception DisagreementArraySizeException }gNX̃TCYƍsp̔zƃTCYقȂꍇ
* @exception NullPointerException rowName  null ̏ꍇ
*/
	public void nameRowCopy(String rowName[]){
		
		//TCYmF܂
		if (getRowLength() == rowName.length){
		
		//Rs[܂
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* w肵z񖼂Ƃă}gNXɃRs[܂B
* @param colName Rs[̗񖼔z
* @exception DisagreementArraySizeException }gNX̃TCYƍsp̔zƃTCYقȂꍇ
* @exception NullPointerException colName  null ̏ꍇ
*/
	public void nameColCopy(String colName[]){
		
		//TCYmFAvȂꍇ̓TCYύX܂
		if (getColLength() == colName.length){
		
		//Rs[܂
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
			}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* }gNXɑ̃}gNX̗vfAsA񖼂̑SĂRs[܂B<BR>
* Rs[̃}gNXTCYƈvȂꍇ̓Rs[̃}gNXTCYɕύXARs[s܂B
* @param originalMatrix Rs[̃}gNX
* @see #matrixCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(Matrix originalMatrix){
		
		//TCYmFAvȂꍇ̓TCYύX܂
		if ((getRowLength() != originalMatrix.getRowLength()) ||
			(getColLength() != originalMatrix.getColLength())){
				setSizeMatrix(originalMatrix.getRowLength(), originalMatrix.getColLength());
		}
		
		//Rs[܂
			for (int i = 0; i < getRowLength(); i++){
				setRowName(i, originalMatrix.getRowName(i));
				for (int j = 0; j < getColLength(); j++){
					if (i == 0){
						setColName(j, originalMatrix.getColName(j));
					}
					setCell(i, j, originalMatrix.getObjectCell(i, j));
				}
			}
	}
	
/**
* wʒuŊJnwvfRs[̃}gNX̎wʒuɗvfRs[܂B<BR>
* Rs[̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɃRs[s܂B
* Rs[͈̔͂ɓĂ͂܂ȂvfƍsA񖼂͕ύX܂B
* @param originalMatrix Rs[̃}gNX
* @param baseRow Rs[̃}gNXɑ΂Rs[̍sJnʒu
* @param baseCol Rs[̃}gNXɑ΂Rs[̗Jnʒu
* @param copyRow Rs[sJnʒu
* @param copyCol Rs[Jnʒu
* @param rowLength Rs[ss̗vf
* @param colLength Rs[s̗vf
* @exception SetValueOutOfBoundsException Rs[悪݂Ȃ͈͂ɂꍇ
* @see #matrixCopy(Matrix originalMatrix)
*/
	public void matrixCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
		
		//Rs[̃TCYmF܂
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(originalMatrix.getRowLength() >= (rowLength + baseRow)) &&
			(originalMatrix.getColLength() >= (colLength + baseCol))){
			for (int i = 0; i < rowLength; i++){
				for (int j = 0; j < colLength; j++){
					setCell(i + copyRow, j + copyCol, 
						originalMatrix.getObjectCell(i + baseRow, j + baseCol));
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* w肵͈͂ɂvfړ܂B
* ړ̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɈړs܂B
* sA񖼂͕ύX܂B
* ܂ړ̗vf̒l͏㏑Aړ̗vf̒l͕ύX܂B
* @param baseRow ړ̗vfɑ΂ړsJnʒu
* @param baseCol ړ̗vfɑ΂ړJnʒu
* @param copyRow ړvf̍sJnʒu
* @param copyCol ړvf̗Jnʒu
* @param rowLength ړss̗vf
* @param colLength ړs̗vf
* @exception SetValueOutOfBoundsException ړ悪݂Ȃ͈͂ɂꍇ
*/
	public void matrixMove(int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			
		//Rs[̃TCYmF܂
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(getRowLength() >= (rowLength + baseRow)) &&
			(getColLength() >= (colLength + baseCol))){
				
				//Rs[ÕIuWFNg̕ێ
				Object[][] o = new Object[getRowLength()][getColLength()];
				for(int i = 0; i < getRowLength(); i++){
					for(int j = 0; j < getColLength(); j++){
						o[i][j] = getObjectCell(i, j);
					}
				}
				
			for (int i = 0; i < rowLength; i++){
				for (int j = 0; j < colLength; j++){
					setCell(i + copyRow, j + copyCol, o[i + baseRow][j + baseCol]);
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* w肵͈͂ɂsړ܂B
* ړ̗vf baseRow Ŏw肳ꂽvfJnʒuƂArowLength s
* vf copyRow w肳vfn܂vfɈړs܂B
* ܂ړ̗vf̖O͏㏑Aړ̗vf̖O͕ύX܂B
* @param baseRow ړ̗vfɑ΂ړsJnʒu
* @param copyRow ړvf̍sJnʒu
* @param rowLength ړss̗vf
* @exception SetValueOutOfBoundsException ړ悪݂Ȃ͈͂ɂꍇ
*/
	public void rowNameMove(int baseRow, int copyRow, int rowLength){
			
		//Rs[̃TCYmF܂
		if ((getRowLength() - copyRow >= rowLength) &&
			(getRowLength() >= (rowLength + baseRow))){
				
			//Rs[ÕIuWFNg̕ێ
			String[] s = getRowNameArray();
			for (int i = 0; i < rowLength; i++){
				setRowName(i + copyRow, s[i + baseRow]);
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* w肵͈͂ɂ񖼂ړ܂B
* ړ̗vf baseCol Ŏw肳ꂽvfJnʒuƂA colLength 񕪂
* vf copyCol w肳vfn܂vfɈړs܂B
* ܂ړ̗vf̗񖼂͏㏑Aړ̗vf̗񖼂͕ύX܂B
* @param baseCol ړ̗vfɑ΂ړJnʒu
* @param copyCol ړvf̗Jnʒu
* @param colLength ړs̗vf
* @exception SetValueOutOfBoundsException ړ悪݂Ȃ͈͂ɂꍇ
*/
	public void colNameMove(int baseCol, int copyCol, int colLength){
			
		//Rs[̃TCYmF܂
		if ((getColLength() - copyCol >= colLength) &&
			(getColLength() >= (colLength + baseCol))){
				
			//Rs[ÕIuWFNg̕ێ
			String[] s = getColNameArray();
			for (int j = 0; j < colLength; j++){
				setColName(j + copyCol, s[j + baseCol]);
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ێꂽvfύXɃ}gNX̑傫ύX܂B
* }gNXꍇ͎w肵vf傫ȂȂ܂B
* 傫ꍇ傫ꂽ͉܂B
* @param rowLength sTCY
* @param colLength TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		
		
		int r = getRowLength();
		int c = getColLength();
		Object[][] o = getObjectMatrix();
		String[] sr = getRowNameArray();
		String[] sc = getColNameArray();
		setSizeMatrix(rowLength, colLength);
		
		int row;
		int col;
		if(r>=rowLength){
			row = rowLength;
		}
		else{
			row = r;
		}
		if(c>=colLength){
			col = colLength;
		}
		else{
			col = c;
		}
		
		//}gNX̗vf߂
		for (int i = 0; i < row; i++){
			setRowName(i, sr[i]);
			for (int j = 0; j < col; j++){
				if(i == 0){
					setColName(j, sc[j]);
				}
				setCell(i, j, o[i][j]);
			}
		}
		
	}
	
/**
* ws̍st܂B
* @param row wsԍ
* @param rowName s
* @exception NotItemException w肳ꂽs݂Ȃꍇ
* @see #setColName(int col,String colName)
*/
	public void setRowName(int row,String rowName){
		if (isRowNumber(row)){
			matrixRowName[row] = rowName;
		}
		else{
			throw new NotItemException("row("+ row + ")");
		}
	}
	
/**
* w̗񖼂t܂B
* @param col wԍ
* @param colName s
* @exception NotItemException w肳ꂽ񂪑݂Ȃꍇ
* @see #setRowName(int row,String rowName)
*/
	public void setColName(int col,String colName){
		if (isColNumber(col)){
			matrixColName[col] = colName;
		}
		else{
			throw new NotItemException("col("+ col+")");
		}
	}
	
/**
* }gNX̍sTCYԂ܂B
* @return sTCY
* @see #getColLength()
*/
	public int getRowLength(){
		return matrixRowSize;
	}
	
/**
* }gNX̗TCYԂ܂B
* @return TCY
* @see #getRowLength()
*/
	public int getColLength(){
		return matrixColSize;
	}

	
/**
* w肵s̍sԂ܂B
* @param  row ws
* @return ws̍s
* @exception NotItemException w肳ꂽs݂Ȃꍇ
* @see #getColName(int col)
* @see #getRowNameArray()
*/
	public String getRowName(int row){
		if (isRowNumber(row)){
			return matrixRowName[row];
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* }gNXɂSĂ̍szŕԂ܂B
* @return s̓z
* @see #getColNameArray()
* @see #getRowName(int row)
*/
	public String[] getRowNameArray(){
		String[] returnArray = new String[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowName(i);
		}
		return returnArray;
	}
	
/**
* w肵̍sԂ܂B
* @param  col w
* @return ws̗
* @exception NotItemException w肳ꂽ񂪑݂Ȃꍇ
* @see #getRowName(int row)
* @see #getColNameArray()
*/
	public String getColName(int col){
		if (isColNumber(col)){
			return matrixColName[col];
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* }gNXɂSĂ̗񖼂zŕԂ܂B
* @return 񖼂̓z
* @see #getRowNameArray()
* @see #getColName(int col)
*/
	public String[] getColNameArray(){
		String[] returnArray = new String[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColName(i);
		}
		return returnArray;
	}
	
/**
* w肵s̍sԍԂ܂B
* @param rowName ws
* @return ws̍sԍ
* @exception NotItemException w肳ꂽs݂Ȃꍇ
* @see #getColNumber(String colName)
*/
	public int getRowNumber(String rowName){
		for (int i = 0; i < getRowLength(); i++){
			if (rowName.equals(matrixRowName[i])){
				return i;
			}
		}
		
		//݂Ȃꍇ
		throw new NotItemException("rowName(" + rowName + ")");
	}
	
/**
* w肵񖼂̗ԍԂ܂B
* @param colName w
* @return ws̗ԍ
* @exception NotItemException w肵񖼂݂Ȃꍇ
* @see #getRowNumber(String rowName)
*/
	public int getColNumber(String colName){
		for (int i = 0; i < getColLength(); i++){
			if (colName.equals(matrixColName[i])){
				return i;
			}
		}
		
		//݂Ȃꍇ
		throw new NotItemException("colName(" + colName + ")");
	}
	
/**
* }gNXɎw肵vf݂邩`FbN܂B
* @param row wsԍ
* @param col wԍ
* @return ̃}gNXɎw肵vf݂trueA݂ȂfalseԂ܂B
*/
	public boolean isMatrixEntityPoint(int row, int col){
		return ((0 <= row && row < this.getRowLength()) &&
			(0 <= col && col < this.getColLength()));
	}

/**
* }gNXɎw肵sԍ݂邩`FbN܂B
* @param row wsԍ
* @return ̃}gNXɎw肵sԍ݂trueA݂ȂfalseԂ܂B
*/
	public boolean isRowNumber(int row){
		return ((0 <= row) && (row < this.getRowLength()));
	}
	
/**
* }gNXɎw肵ԍ݂邩`FbN܂B
* @param col wԍ
* @return ̃}gNXɎw肵ԍ݂trueA݂ȂfalseԂ܂B
*/
	public boolean isColNumber(int col){
		return ((0 <= col) && (col < this.getColLength()));
	}
	
/**
* 2vf̑傫ύX܂B
* @param rowSize sTCY
* @param colSize TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	private void setSizeMatrix(int rowSize, int colSize){
		
		//TCY͕ł͂Ȃ
		if((rowSize >= 0) && ( colSize >= 0)){
			setSizeRow(rowSize);
			setSizeCol(colSize);
			matrix = new Object[rowSize][colSize];
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* 2vf̍s̑傫ύX܂B
* @param rowSize sTCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	private void setSizeRow(int rowSize){
		
		//TCY͕ł͂Ȃ
		if(rowSize >= 0){
			matrixRowSize = rowSize;		//sTCY̐
			matrixRowName = new String[matrixRowSize];		//sz̐
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* 2vf̗̑傫ύX܂B
* @param colSize TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX𐶐悤Ƃꍇ
*/
	private void setSizeCol(int colSize){
		
		//TCY͕ł͂Ȃ
		if(colSize >= 0){
			matrixColSize = colSize;		//TCY̐
			matrixColName = new String[matrixColSize];		//񖼔z̐
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* szɍsԍsƂĐݒ肵܂B<BR>
* sԍ0n܂邽߁A0珇ɍssԍԍƂȂ܂B 
* @see #setColNameNumber()
* @see #setRowNameNumber(int start)
*/
	public void setRowNameNumber(){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i +"");
		}
	}
	
/**
* szstartn܂ԍsƂĐݒ肵܂B
* @param start ŏ̍sԍ
* @see #setColNameNumber(int start)
* @see #setRowNameNumber()
*/
	public void setRowNameNumber(int start){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i + start +"");
		}
	}
	
/**
* 񖼂zɗԍ񖼂ƂĐݒ肵܂B<BR>
* ԍ0n܂邽߁A0珇ɗ񖼂ԍԍƂȂ܂B 
* @see #setRowNameNumber()
* @see #setColNameNumber(int start)
*/
	public void setColNameNumber(){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i +"");
		}
	}
	
/**
* 񖼂zstartn܂ԍ񖼂ƂĐݒ肵܂B
* @param start ŏ̗񖼔ԍ
* @see #setRowNameNumber(int start)
* @see #setColNameNumber()
*/
	public void setColNameNumber(int start){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i + start +"");
		}
	}
	
/**
* ̃}gNXs񂩃`FbN܂B
* @return sȂtrueAႤꍇfalseԂ܂B
*/
	public boolean isSquare(){
		return getRowLength() == getColLength();
	}
	
/**
* w肳ꂽ1_֒lݒ肵܂B
* @param row wsԍ
* @param col wԍ
* @param value ݒl
* @exception NotElementException w肵_݂Ȃꍇ
*/
	public void setCell(int row,int col, Object value){
		if (isMatrixEntityPoint(row, col)){
			matrix[row][col] = value;
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* w肳ꂽ1_̒lԂ܂B
* @param row wsԍ
* @param col wԍ
* @return w肵_̒l
* @exception NotElementException w肳ꂽ_݂Ȃꍇ
*/
	public Object getObjectCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			return matrix[row][col];
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* vf2zŕԂ܂B
* @return vf2z
*/
	public Object[][] getObjectMatrix(){
		return matrix;
	}
	
/**
* OƂĎw肳ꂽO̔z͎w肳ꂽTCYƈvĂ邩`FbN܂B
* @param value w肵TCY
* @param name w肵z
* @return TCYł true
*/
	private boolean isSameArraySize(int value, String[] name){
		return name.length == value;
	}
	
/**
* OƂĎw肳ꂽzƗvfƂĎw肳ꂽ2z̃TCYvĂ邩`FbN܂B
* @param array w肵vf̔z
* @param rowName w肵s̔z
* @param colName w肵񖼂̔z
* @return TCYł true
*/
	private boolean isSameArraySize(Object[][] array, String[] rowName, String[] colName){
		return array.length == rowName.length && array[0].length == colName.length;
	}
}