package jp.ac.takushoku_u.cs;

/**
* RangeNX͔͈͂ێ邽߂̃NXłB
* őlсAŏl NaN() łꍇ́u݂ԂȂv\܂B
* @version 1.0.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0107
*/
public class Range{
	
/**
* őlێ܂B
*/
	private double maxValue;
/**
* ŏlێ܂B
*/
	private double minValue;
/**
* ől͔͈͂Ɋ܂܂邩܂B
*/
	private boolean includeMax;
/**
* ŏl͔͈͂Ɋ܂܂邩܂B
*/
	private boolean includeMin;
/**
* ݂ԂȂǂ܂B
*/
	private boolean empty = false;
	
/**
* ݂ԂȂ̂Ƃ̍őlB
*/
	private static final double EMPTY_MAX = Double.NaN;
/**
* ݂ԂȂ̂Ƃ̍ŏlB
*/
	private static final double EMPTY_MIN = Double.NaN;
	
/**
* ݂Ԃ Range ݒ肵܂B
*/
	public Range(){
		createEmpty();
	}
	
/**
* Ԃݒ肵 Range ݒ肵܂B[͋ԂɊ܂܂܂B<BR>
* ŏlƍől̂ꂩNaNłꍇ́u݂ԂȂvƂȂ܂B
* @param min ŏl
* @param max ől
* @exception IllegalRelationValuesException őlƍŏl̊֌WقȂꍇ
*/
	public Range(double min, double max){
		
		if(isExistRange(min, max)){
			setMax(max);
			setMin(min);
			setEmpty(false);
			setHasMax(true);
			setHasMin(true);
		}
		else if(Double.isNaN(min) || Double.isNaN(max)){
			createEmpty();
		}
		else{
			throw new IllegalRelationValuesException("min,max("+min+","+max+")");
		}
	}
	
/**
* Ԃݒ肵 Range ݒ肵܂B<BR>
* ŏlƍől̂ꂩNaNłꍇ́u݂ԂȂvƂȂ܂B
* @param min ŏl
* @param max ől
* @param isIncludeMin ŏlԓɊ܂ނ
* @param isIncludeMax őlԓɊ܂ނ
* @exception IllegalRelationValuesException őlƍŏl̊֌WقȂꍇ
*/
	public Range(double min, double max, boolean isIncludeMin, boolean isIncludeMax){
		
		if(isExistRange(min, max)){
			setMax(max);
			setMin(min);
			setEmpty(false);
			if(max != min){
				setHasMax(isIncludeMax);
				setHasMin(isIncludeMin);
			}
			else{
				setHasMax(true);
				setHasMin(true);
			}
		}
		else if(Double.isNaN(min) || Double.isNaN(max)){
			createEmpty();
		}
		else{
			throw new IllegalRelationValuesException("min,max("+ min +","+ max +")");
		}
	}
	
/**
* Ԃ̍őlԂ܂B<BR>
* u݂ԂȂv̏ꍇNaNԂ܂B
* @return ől
*/
	public double getMax(){
		return maxValue;
	}
	
/**
* Ԃ̍ŏlԂ܂B<BR>
* u݂ԂȂv̏ꍇNaNԂ܂B
* @return ŏl
*/
	public double getMin(){
		return minValue;
	}
	
/**
* ől͋ԂɊ܂ނԂ܂B
* @return ԂɊ܂܂ true
*/
	public boolean hasMax(){
		return includeMax;
	}
	
/**
* ŏl͋ԂɊ܂ނԂ܂B
* @return ԂɊ܂܂ true
*/
	public boolean hasMin(){
		return includeMin;
	}
	
/**
* ݂ԂȂǂԂ܂B
* @return ݂ԂȂȂ true
*/
	public boolean isEmpty(){
		return empty;
	}
	
/**
* őlƍŏlǂԂ܂B
* @return őlƍŏl true
*/
	public boolean isSame(){
		return getMax() == getMin();
	}
	
/**
* w肵lԂɊ܂܂Ă邩`FbN܂B
* @param value w肵l
* @return w肵l܂܂Ă true
*/
	public boolean hasValue(double value){
		boolean bo;
		if(isEmpty()){
			bo = false;
		}
		else if(getMin() < value && value < getMax()){
			bo = true;
		}
		else if(getMin() == value && hasMin()){
			bo = true;
		}
		else if(getMax() == value && hasMax()){
			bo = true;
		}
		else if(value == 0.0 && (getMin() == -0.0 || getMax() == -0.0)){
			bo = true;
		}
		else{
			bo = false;
		}
		return bo;
	}
	
/**
* RangeRs[܂B
* @param copy Rs[Range
*/
	public void rangeCopy(Range copy){
		if(copy.isEmpty()){
			setMax(EMPTY_MAX);
			setMin(EMPTY_MIN);
			setEmpty(true);
			setHasMax(true);
			setHasMin(true);
		}
		else{
			setMax(copy.getMax());
			setMin(copy.getMin());
			setEmpty(copy.isEmpty());
			setHasMax(copy.hasMax());
			setHasMin(copy.hasMin());
		}
	}
	
/**
* Range m̐(AND)Ԃ܂B<BR>
* 2 Range ̏dȂĂԂԂ܂B
* ԂdȂȂꍇ́Aꂩł݂ԂȂłꍇ́Au݂ԂȂvԂ܂B
* @param ran r Range
* @return AND Range
*/
	public Range getAndRange(Range ran){
		double max;
		double min;
		boolean inMax;
		boolean inMin;
		
		//ŴƂ
		if(isEmpty() || ran.isEmpty()){
			return new Range();
		}
		
		//őlݒ
		if(getMax() > ran.getMax()){
			max = ran.getMax();
			inMax = ran.hasMax();
		}
		else if(getMax() < ran.getMax()){
			max = getMax();
			inMax = hasMax();
		}
		else if(hasMax() && ran.hasMax()){
			max = getMax();
			inMax = hasMax();
		}
		else{
			max = getMax();
			inMax = false;
		}
		
		//ŏlݒ
		if(getMin() < ran.getMin()){
			min = ran.getMin();
			inMin = ran.hasMin();
		}
		else if(getMin() > ran.getMin()){
			min = getMin();
			inMin = hasMin();
		}
		else if(hasMin() && ran.hasMin()){
			min = getMin();
			inMin = hasMin();
		}
		else{
			min = getMin();
			inMin = false;
		}
		
		//lݒ
		if(max > min){
			return new Range(min, max, inMin, inMax);
		}
		else if(max == min){
			return new Range(min, max, true, true);
		}
		return new Range();
	}
	
/**
* őlݒ肵܂B
* @param max ݒ肷ől
*/
	private void setMax(double max){
		maxValue = max;
	}
	
/**
* ŏlݒ肵܂B
* @param min ݒ肷ŏl
*/
	private void setMin(double min){
		minValue = min;
	}
	
/**
* ݂ԂȂ̘_lݒ肵܂B
* @param emp ݂ԂȂȂ true
*/
	private void setEmpty(boolean emp){
		empty = emp;
	}
	
/**
* ől͋ԂɊ܂ނݒ肵܂B
* @param isInclude ԂɊ܂ޏꍇ true
*/
	private void setHasMax(boolean isInclude){
		includeMax = isInclude;
	}
	
/**
* ŏl͋ԂɊ܂ނݒ肵܂B
* @param isInclude ԂɊ܂ޏꍇ true
*/
	private void setHasMin(boolean isInclude){
		includeMin = isInclude;
	}
	
/**
* Range𑶍݂ԂȂŐݒ肵܂B
*/
	private void createEmpty(){
		setMax(EMPTY_MAX);
		setMin(EMPTY_MIN);
		setEmpty(true);
		setHasMax(true);
		setHasMin(true);
	}
	
/**
* ŏlƍől͈̔͂Ă邩`FbN܂B
* @param min ŏl
* @param max ől
* @return Ԃ݂ꍇ true
*/
	private boolean isExistRange(double min, double max){
		return (min <= max);
	}
	
}