package jp.ac.takushoku_u.cs;

/**
* SSGraphPointNXSSOt`߂̍W߂邽߂̃NXłB
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0301
*/
public class SSGraphPoint{
	
/**
* אڃ}gNX
*/
	private BooleanMatrix matrix;
	
/**
* B}gNX
*/
	private BooleanMatrix reachMatrix;
	
/**
* ő僌x(ő啽ϕ]l)
*/
	private double maxLevel;
	
/**
* `vf
*/
	private int elementNumber;
	
/**
* zuxz(z񐔂͗vf)
*/
	private int[] paintLevel;
	
/**
* clz
*/
	private double[] heigthNumber;
	
/**
* `揇z
*/
	private int[] paintNumber;
	
/**
* z(z񐔂̓x)
*/
	private int[] paintWide;
	
/**
* ꃌxł̕`ʒu
*/
	private int[] paintWideNumber;
	
/**
* evfx,yW
*/
	private int[][] paintPoint;
	
/**
* `悷vf̑傫
*/
	private int elementSize = 20;
	
/**
* `悷Ƃ1ubN̑傫
*/
	private int blockSize = 50;
	
/**
* t[̃TCY(y)
*/
	private int flameSize = 700;
	
	
/**
* vf̂ȂXPg}gNXݒ肵܂B
*/
	public SSGraphPoint(){
		BooleanMatrix mat = new BooleanMatrix();
		setMatrix(mat);
	}
	
/**
* XPg}gNXݒ肵A`ʒu߂܂B
* @param skeletonMatrix XPg}gNX
* @param maxValue ]̍ől
* @param heightArray Ot`ɕבւz
* @param averageArray Ot̏c(ϕ]l)
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(BooleanMatrix skeletonMatrix, double maxValue, int[] heightArray, double[] averageArray){
		setMatrix(skeletonMatrix);
		setAverageArray(averageArray);
		setHeightArray(heightArray);
		setMaxValue(maxValue);
	}
	
/**
* XPg}gNXݒ肵A`ʒu߂܂B
* @param skeletonMatrix XPg}gNX
* @param maxValue ]̍ől
* @param heightArray Ot`ɕבւz
* @param averageArray Ot̏c(ϕ]l)
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(ArithmeticMatrix skeletonMatrix, double maxValue, int[] heightArray, double[] averageArray){
		setMatrix(skeletonMatrix.toBooleanMatrix());
		setAverageArray(averageArray);
		setHeightArray(heightArray);
		setMaxValue(maxValue);
	}
	
/**
* XPg}gNXݒ肵A`ʒu߂܂B
* @param skeletonMatrix XPg}gNX
* @param maxValue ]̍ől
* @param averageArray Ot̏c(ϕ]l)
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(BooleanMatrix skeletonMatrix, double maxValue, double[] averageArray){
		setMatrix(skeletonMatrix);
		setAverageArray(averageArray);
		setHeightArray(getGraphArray(averageArray));
		setMaxValue(maxValue);
	}
	
/**
* XPg}gNXݒ肵A`ʒu߂܂B
* @param skeletonMatrix XPg}gNX
* @param maxValue ]̍ől
* @param averageArray Ot̏c(ϕ]l)
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public SSGraphPoint(ArithmeticMatrix skeletonMatrix, double maxValue, double[] averageArray){
		setMatrix(skeletonMatrix.toBooleanMatrix());
		setAverageArray(averageArray);
		setHeightArray(getGraphArray(averageArray));
		setMaxValue(maxValue);
	}

	
/**
* Ot`ۂ̊evf̃xzƂĕԂ܂B
* @return xi[z(z̑傫͕`sڐ)
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//z̏
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		boolean flag = true;
		
		//xi[
		int level = 0;
		int count = 0;
		for(int i = 0; i < returnArray.length; i++){
			int lookElement = paintNumber[i];
			returnArray[lookElement] = level;
			
			//ꃌxɕ`łȂ΁A
			//̗vfɓB}̖{𐔂
			if(count == 0){
				for(int j = i + 1; j < returnArray.length; j++){
					if(matrix.getCell(paintNumber[j] , lookElement)){
						count++;
					}
				}
				level++;
				count--;
			}
			else if(i < returnArray.length-1 &&(!matrix.getCell(paintNumber[i+1],paintNumber[i]) ||
				(matrix.getCell(paintNumber[i+1],paintNumber[i])&&matrix.getCell(paintNumber[i],paintNumber[i+1])))){
				count--;
			}
		}
		
		//[g̈ʒuύX
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int countA = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(countA < returnArray[j]){
							countA = returnArray[j];
						}
					}
				}
				returnArray[i] = countA - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* ǂɔzu邩W(x,y)w肵zԂ܂B
* @return Ww肵z
*/
	public int[][] getPointArray(){
		paintLevel = new int[elementNumber];
		System.arraycopy(getPaintLevel(), 0, paintLevel, 0, elementNumber);
		getPaintWide();
		getPaintWideNumber();
		int maxWide = getColMaxLevel(paintLevel);
		
		int center = (maxWide+1) * blockSize / 2;
		
		//exŊɕ`vfJEg܂B
		int[] countArray = new int [getRowMaxLevel(getPaintLevel())+1];
		
		//Z^O
		for(int i = 0; i <= getRowMaxLevel(getPaintLevel()); i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		//yW̊Ԋu
			double interval;
			
			//ϕ]l̊Ԋu߂܂B
			if(getRowMaxLevel(getPaintLevel()) <= flameSize - blockSize){
				interval = (flameSize - blockSize*2) / maxLevel;
			}
			else{
				interval = maxLevel / (flameSize - blockSize*2);
			}
		
		
		//evfxWyW߂܂
		for(int i = 0; i < elementNumber; i++){
			//
			if(paintWide[paintLevel[i]] % 2 == 0){
				if(paintWideNumber[i] > paintWide[paintLevel[i]] / 2){
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i] + 1) * blockSize;
				}
				else{
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i]) * blockSize;
				}
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + paintWideNumber[i]) * blockSize;
			}
			
			
			//yW
			paintPoint[i][1] = (int)((flameSize - blockSize)- heigthNumber[i] * interval);
				
		}
		
		//yWڋ߂ꍇ
		for(int i = 0; i < paintPoint.length; i++){
			for(int j = 0; j < paintPoint.length; j++){
				if(i != j && paintPoint[j][1] >= paintPoint[i][1] &&
				paintPoint[j][1] <= paintPoint[i][1] + elementSize && paintPoint[j][0] == paintPoint[i][0]){
					paintPoint[j][0] = paintPoint[i][0] + blockSize / 2;
					
				}
			}
		}
		
		return paintPoint;
	}
	
/**
* XPg}gNXݒ肵܂B
* @param skeletonMatrix XPg}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getSkeletonMatrix()
*/
	public void setMatrix(BooleanMatrix skeletonMatrix){
		if(skeletonMatrix.isSquare()){
			matrix = new BooleanMatrix();
			reachMatrix = new BooleanMatrix();
			matrix.matrixCopy(skeletonMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			elementNumber = skeletonMatrix.getRowLength();
			paintPoint = new int[elementNumber][2];
		}
		else{
			throw new NotSquareMatrixException("row("+ skeletonMatrix.getRowLength() +
				"),col("+skeletonMatrix.getColLength()+")");
		}
	}
	
/**
* ő]l(Ot̏c̍ől)ݒ肵܂B
* ݒ肳Ăeڂ̕ϕ]lႢlݒ肳ꂽꍇA
* ő̕]lƂȂ܂B
* @param max ő]l
* @see jp.ac.takushoku_u.cs.SSAnalysis#getMaxValue()
*/
	public void setMaxValue(double max){
		maxLevel = max;
		double maxValue = max;
		for(int i = 0; i < heigthNumber.length; i++){
			if(heigthNumber[i] > max){
				maxValue = heigthNumber[i];
			}
		}
	}
	
/**
* eڂ̕ϕ]l(cl)ݒ肵܂B
* @param averageArray ϕ]l
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphHeightArray()
*/
	public void setAverageArray(double[] averageArray){
		if(matrix.getRowLength() == averageArray.length){
			heigthNumber = new double[averageArray.length];
			System.arraycopy(averageArray, 0, heigthNumber, 0, averageArray.length);
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+averageArray.length+")");
		}
	}
	
/**
* ڂOt`ɕבւzݒ肵܂B
* @param heightArray Ot`ɍڂבւz
* @exception DisagreementArraySizeException }gNXƔz̃TCYvȂꍇ
* @see jp.ac.takushoku_u.cs.SSAnalysis#getGraphElementArray()
*/
	public void setHeightArray(int[] heightArray){
		if(matrix.getRowLength() == heightArray.length){
			paintNumber = new int[heightArray.length];
			System.arraycopy(heightArray, 0, paintNumber, 0, heightArray.length);
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
			"),array("+heightArray.length+")");
		}
	}
	
/**
* ݒ肳ꂽc񂩂ɕ`߂܂B
* @param averageArray c
* @return vfォ`ɍڔԍёւzB
*/
	private int[] getGraphArray(double[] averageArray){
		int[] returnArray = new int[matrix.getColLength()];		//ϕ]l̍ɕׂ̗ԍiځj
		
		for (int i = 0; i < averageArray.length; i++){
			double maxAverage = averageArray[0];		//l
			int maxNumber = 0;
			for (int j = 1; j <  averageArray.length; j++){		//rs
				if (maxAverage < averageArray[j]){
					maxAverage = averageArray[j];
					maxNumber = j;
				}
			}
			averageArray[maxNumber] = Double.NEGATIVE_INFINITY;	 //rΏۂ͂
			returnArray[i] = maxNumber;
		}
		return returnArray;
	}
	
/**
* ő剡T܂B
* @param levelArray xz
* @return ő剡
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* exł̔zuzƂĕԂ܂B
* @return zui[z
*/
	private int[] getWidePointArray(){
		int[] levelArray = new int[matrix.getRowLength()];
		System.arraycopy(getPaintLevel(), 0, levelArray, 0, matrix.getRowLength());
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* ő僌xT܂B
* @param levelArray xz
* @return ő僌x
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* w肵x̉T܂B
* @param level w肷郌x
* @param levelArray xz
* @return 
*/
	private int getColLevel(int level, int[] levelArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level){
				count++;
			}
		}
		
		return count;
	}
	
/**
* Ot`ۂ̓ꃌxł̈ʒuԍzƂĕԂ܂B
* l̂قǁÃxł͍ɕ`s܂B
* @return ʒui[z(z̑傫͕`sڐ)
*/
	public int[] getPaintWideNumber(){
		paintWideNumber = new int[elementNumber];
		System.arraycopy(getWidePointArray(), 0, paintWideNumber, 0, elementNumber);
		return paintWideNumber;
	}
	
/**
* ex̉ێzԂ܂B
* @return ̔z
*/
	public int[] getPaintWide(){
		paintWide = new int[getRowMaxLevel(getPaintLevel())+1];
			for(int i = 0; i <= getRowMaxLevel(getPaintLevel()); i++){
				paintWide[i] = getColLevel(i, getPaintLevel());
		}
		return paintWide;
	}
	
}