package jp.ac.takushoku_u.cs;

/**
* StringMatrixNXł͕vfɂ}gNX܂B
* ɏo͂̂߂Ɉ܂B
* @version 1.1.1
* @author } Tj(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.ArithmeticMatrix
* @see jp.ac.takushoku_u.cs.BooleanMatrix
*/
/*
* ŏIXV 2004N1209
*/
public class StringMatrix extends Matrix{

/**
* }gNXNAƂ̒l
*/
	private static final String MATRIX_CLEAR_VALUE = "";

/**
* l
*/
	private static final String MATRIX_VALUE_FALSE = "";


/**
* ݒ肳ĂTCỸf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
*/
	public StringMatrix(){
		super();
		clearMatrix();
	}

/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public StringMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYƗTCYɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param nameNumber sї񖼂̊Jnԍ
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public StringMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* w肳ꂽsTCYATCYAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* ꂽ2z͑Sfalseŏ܂B
* @param rowSize w肷sTCY
* @param colSize w肷TCY
* @param rowName w肷s
* @param colName w肷
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
* @exception DisagreementArraySizeException }gNX̎w肵TCYƍsA񖼗p̔zƃTCYقȂꍇ
* @exception NullPointerException  rowName ܂ colName  null ̏ꍇ
*/
	public StringMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		clearMatrix();
		
		//sї񖼂̃Rs[
		nameRowCopy(rowName);
		nameColCopy(colName);
	}
	
/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐܂B<BR>
* sƗ񖼂͍sԍƗԍŐݒ肳܂B
* @param originalMatrix w肷2z
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public StringMatrix(String[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zɃf[^ۑp2zƍsA񖼂z𐶐A
* w肳ꂽԍ珇ɍsƗ񖼂܂B<BR>
* sƗ񖼂 nameNumber Ŏw肳ꂽԍ珇ɐݒ肳܂B
* @param originalMatrix w肷2z
* @param nameNumber sї񖼂̊Jnԍ
* @exception NullPointerException  originalMatrix  null ̏ꍇ
*/
	public StringMatrix(String[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* w肳ꂽ2zAsA񖼂Ƀf[^ۑp2zƍsA񖼂z𐶐܂B
* @param originalMatrix w肷2z
* @param rowName w肷s
* @param colName w肷
* @exception DisagreementArraySizeException }gNX̎w肵TCYƍsA񖼗p̔zƃTCYقȂꍇ
* @exception NullPointerException rowName , colName ܂ originalMatrix  null ̏ꍇ
*/
	public StringMatrix(String[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//}gNX̃Rs[
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//sї񖼂̃Rs[
		nameRowCopy(rowName);
		nameColCopy(colName);
	}

/**
* ێꂽvfύXɃ}gNX̑傫ύX܂B
* }gNXꍇ͎w肵vf傫ȂȂ܂B
* 傫ꍇ傫ꂽ͏lŏA
* sƗ񖼂͂ꂼsԍƗԍɂȂ܂B
* @param rowLength sTCY
* @param colLength TCY
* @exception NegativeMatrixSizeException ̃TCỸ}gNX悤Ƃꍇ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//}gNX̗vf
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}

/**
* w肳ꂽ1_֒lݒ肵܂B
* @param row wsԍ
* @param col wԍ
* @param ch ݒl
* @exception NotElementException w肵_݂Ȃꍇ
*/
	public void setCell(int row,int col,String ch){
		if (isMatrixEntityPoint(row, col)){
			super.setCell(row,col,ch);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* }gNXɑ̃}gNX̗vfAsA񖼂̑SĂRs[܂B<BR>
* Rs[̃}gNXTCYƈvȂꍇ̓Rs[̃}gNXTCYɕύXARs[s܂B
* @param originalMatrix Rs[̃}gNX
* @see #matrixCopy(StringMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(StringMatrix originalMatrix){
		super.matrixCopy(originalMatrix);
	}
	
/**
* wʒuŊJnwvfRs[̃}gNX̎wʒuɗvfRs[܂B<BR>
* Rs[̗vf( baseRow , baseCol )Ŏw肳ꂽvfJnʒuƂArowLength s colLength 񕪂
* vf( copyRow , copyCol )w肳vfn܂vfɃRs[s܂B
* Rs[͈̔͂ɓĂ͂܂ȂvfƍsA񖼂͕ύX܂B
* @param originalMatrix Rs[̃}gNX
* @param baseRow Rs[̃}gNXɑ΂Rs[̍sJnʒu
* @param baseCol Rs[̃}gNXɑ΂Rs[̗Jnʒu
* @param copyRow Rs[sJnʒu
* @param copyCol Rs[Jnʒu
* @param rowLength Rs[ss̗vf
* @param colLength Rs[s̗vf
* @exception SetValueOutOfBoundsException Rs[悪݂Ȃ͈͂ɂꍇ
* @see #matrixCopy(StringMatrix originalMatrix)
*/
	public void matrixCopy(StringMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.matrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				copyCol, rowLength, colLength);
	}
	
/**
* }gNXɑ݂vfSĂ""܂B
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* w肳ꂽ1_̒lԂ܂B
* @param row wsԍ
* @param col wԍ
* @return w肵_̒l
* @exception NotElementException w肳ꂽ_݂Ȃꍇ
*/
	public String getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			String s = (String)getObjectCell(row,col);
			return s;
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* }gNXɑ݂vf̂Avf󔒂łȂvf̐Ԃ܂B
* @return vf
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) != MATRIX_VALUE_FALSE){
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* StringMatrixMatrix^ɕϊ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽMatrix
* @exception EduNumberFormatException 񂪍\͉\ double l܂܂Ȃꍇ
* @see #toBooleanMatrix()
*/
	public ArithmeticMatrix toArithmeticMatrix(){
		try{
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
				getRowNameArray(), getColNameArray());
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
						returnMatrix.setCell(i, j, Double.valueOf(getCell(i, j)));
					
				}
			}
			return returnMatrix;
		}
		catch(NumberFormatException e){
			throw new EduNumberFormatException();
		}
	}
	
/**
* StringMatrixBooleanMatrix^ɕϊ܂B
* "true"ɓ(啶Ə͋ʂȂ)ꍇtrueɁAȊO̕falseɂȂ܂B
* ϊꂽ}gNXɂ͍sƗ񖼂͈p܂B
* @return ϊꂽMatrix
* @see #toArithmeticMatrix()
*/
	public BooleanMatrix toBooleanMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Boolean.valueOf(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2̃}gNX̃TCY`FbN܂B
* @param compareMatrix ׂ}gNX
* @return TCYłTrueAႤꍇFalseԂ܂B
*/
	public boolean isSameMatrixSize(StringMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* }gNX̗vf2zŕԂ܂B
* @return vf2z
*/
	public String[][] getMatrix(){
		String st[][] = new String[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				st[i][j] = (String)o[i][j];
			}
		}
		return st;
	}
}