package jp.ac.takushoku_u.cs;
import java.util.Stack;

/**
* TaskSequenceMatrixNX͌n񌋉ʂSċ߂邽߂̃NXłB
* n񌋉ʂ̓}gNXŕԂAesꂼ1̌n񌋉ʂƂȂĂ܂B
* ̂߁AԂ}gNX̑傫́An񌋉ʁ~nsڐ ƂȂ܂B
* @version 1.0
* @author } Tj(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.TaskSequence
*/
/*
* ŏIXV 2005N0208
*/
public final class TaskSequenceMatrix{
	
/**
* RXgN^
*/
	private TaskSequenceMatrix(){
	}
	
/**
* n񌋉ʂSċ߂}gNXԂ܂B
* }gNX̒g͗אڃ}gNX̗ԍ(n񉻂sڔԍ)A
* }gNX̗ԍ̏قnsɓ܂B
* @param adjacencyMatrix n񉻂sאڃ}gNX
* @param alpha w肷At@̒l
* @param beta w肷x[^̒l
* @return n񌋉ʂێ}gNX
* @exception NotSquareMatrixException אڃ}gNXsł͂Ȃꍇ
* @exception SetValueOutOfBoundsException At@ƃx[^̒lsłꍇ
*/
	public static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix adjacencyMatrix, double alpha, double beta){
		TaskSequence ts = new TaskSequence(adjacencyMatrix);
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getTaskMatrix(adjacencyMatrix, alpha, beta, ts.getTaskSequence(alpha, beta),
			ts.isDummy() ,ts.getDivergenceMatrix()));
		
		//0Ȃsr
		boolean isIn[] = new boolean[mat.getRowLength()];
		for(int i = 0; i < mat.getRowLength(); i++){
			int count = 0;
			for(int j = 0; j < mat.getColLength(); j++){
				if(mat.getCell(i, j) == 0){
					count++;
				}
			}
			if(count > 1){
				isIn[i] = false;
			}
			
			//0łȂs
			else{
				isIn[i] = true;
			}
		}
		
		//0̍s𖄂߂
		int number = -1;
		int counter = 0;
		for(int i = 0; i < isIn.length; i++){
			if(isIn[i]){
				number++;
				counter++;
				if(number != i){
					for(int j = 0; j < mat.getColLength(); j++){
						mat.setCell(number, j, mat.getCell(i,j));
						mat.setCell(i, j, 0);
					}
					isIn[i] = false;
					i = number + 1;
				}
			}
		}
		
		//TCY
		mat.reSizeMatrix(counter, mat.getColLength());
		mat.setRowNameNumber();
		mat.setColNameNumber();
		
		return mat;
	}
	
	
/**
* n񌋉ʂSċ߂}gNXStringMatrixŕԂ܂B
* }gNX̒g͗אڃ}gNXŎw肵(n񉻂sږ)A
* }gNX̗ԍ̏nsɓ܂B
* @param adjacencyMatrix n񉻂sאڃ}gNX
* @param alpha w肷At@̒l
* @param beta w肷x[^̒l
* @return n񌋉ʂێ}gNX
* @exception NotSquareMatrixException אڃ}gNXsł͂Ȃꍇ
* @exception SetValueOutOfBoundsException At@ƃx[^̒lsłꍇ
*/
	public static final StringMatrix getTaskStringMatrix(ArithmeticMatrix adjacencyMatrix, double alpha, double beta){
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getTaskMatrix(adjacencyMatrix, alpha, beta));
		StringMatrix returnMatrix = new StringMatrix(mat.getRowLength(), mat.getColLength());
		
		for(int i = 0; i < mat.getRowLength(); i++){
			for(int j = 0; j < mat.getColLength(); j++){
				returnMatrix.setCell(i, j, adjacencyMatrix.getColName((int)mat.getCell(i, j)));
			}
		}
		
		return returnMatrix;
	}
	
/**
* n񌋉ʂSċ߂܂B
* @param matrix n񉻂s}gNX
* @param alpha w肷At@̒l
* @param beta w肷x[^̒l
* @param seq n񉻂sn
* @param du nsۂɃ_~[tǂ
* @param trMatrix _ێ}gNX
* @return n񌋉ʂ̃}gNX
*/
		private static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix matrix, double alpha, double beta,
			Sequence seq, boolean du, BooleanMatrix trMatrix){
			
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(1, matrix.getColLength());
			Stack st = new Stack();
				
			//Dz
			int[] ar = new int[0];
				
			//ꎟۑpz
			int[] tmp = new int[matrix.getRowLength() * matrix.getRowLength()];
				
			//dvfrDz
			int[] tar = new int[0];
			TaskSequence tsq = new TaskSequence(matrix);
			
			//n񏇂}gNXɓ
			for(int i = 0; i < seq.getLength(); i++){
				returnMatrix.setCell(0, i, seq.getItem(i));
			}
			
			for(int i = 0; i < trMatrix.getRowLength(); i++){
				for(int j = 0; j < trMatrix.getColLength(); j++){
					if(trMatrix.getCell(i, j)){
						if(du){
							st.push(new Edge(i-1, j-1));
						}
						else{
							st.push(new Edge(i, j));
						}
					}
				}
			}
			
			while(!st.empty()){
				
				//X^bNlo
				Edge ed = new Edge();
				ed = (Edge)st.pop();
				
				//Dz𐶐
				int element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element + 2];
				System.arraycopy(tmp,0,ar,0,element);
				
				//DzɃX^bN̒l
				ar[element] = ed.getEnd();
				ar[element+1] = ed.getBegin();
				
				//dvfr
				int k = 0;
				for(int i=0; i < ar.length; i++){
					boolean flag = true;
					for(int j = i+1; j < ar.length; j++){
						if(ar[i] == ar[j]){
							flag = false;
						}
					}
					if(flag){
						tmp[k] = ar[i];
						k++;
					}
				}
				
				//n񉻂sۂ̗Dz𐶐
				tar = new int[k];
				System.arraycopy(tmp,0,tar,0,k);
				
				//n񉻂s(ċA)
				tsq.setPriorityOrder(tar);
				ArithmeticMatrix mat = new ArithmeticMatrix();
				mat.matrixCopy(getTaskMatrix(matrix, alpha, beta, 
					tsq.getTaskSequence(alpha, beta), tsq.isDummy(), tsq.getDivergenceMatrix(), ar));
				
				//n񌋉ʂ
				int size = returnMatrix.getRowLength();
				int tsize = size;
				returnMatrix.reSizeMatrix(size + mat.getRowLength(), returnMatrix.getColLength());
				for(int i = 0; i < mat.getRowLength();i++){
					boolean flagB = true;
					for(int ia = 0; ia < size && flagB; ia++){
						boolean flagC = true;
						for(int ib = 0; ib < returnMatrix.getColLength() && flagC; ib++){
							if(returnMatrix.getCell(ia,ib) != mat.getCell(i,ib)){
								flagC = false;
							}
						}
						
						//flagCtrueȂ瓯n񂪂łɂ
						if(flagC){
							flagB = false;
						}
					}
					
					//n񌋉ʂ͔r
					if(flagB){
						for(int j = 0; j < mat.getColLength(); j++){
							returnMatrix.setCell(size + i, j, mat.getCell(i,j));
						}
						tsize++;
					}
				}
				
				returnMatrix.reSizeMatrix(tsize+1, returnMatrix.getColLength());
				
				//Dz񂩂2vf폜
				element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element - 2];
				System.arraycopy(tmp,0,ar,0,element - 2);
				
			}
			return returnMatrix;
			
		}
	
/**
* n񌋉ʂSċ߂܂B
* @param matrix n񉻂s}gNX
* @param alpha w肷At@̒l
* @param beta w肷x[^̒l
* @param seq n񉻂sn
* @param du nsۂɃ_~[tǂ
* @param trMatrix _ێ}gNX
* @param ar D揇ێz
* @return n񌋉ʂ̃}gNX
*/
		private static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix matrix, double alpha, double beta,
			Sequence seq, boolean du, BooleanMatrix trMatrix, int[] ar){
			
			
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(1, matrix.getColLength());
			Stack st = new Stack();
				
			//ꎟۑpz
			int[] tmp = new int[matrix.getRowLength() * matrix.getRowLength()];
			int[] tar = new int[0];
			TaskSequence tsq = new TaskSequence(matrix);
			
			//n񏇂}gNXɓ
			for(int i = 0; i < seq.getLength(); i++){
				returnMatrix.setCell(0, i, seq.getItem(i));
			}
			
			for(int i = 0; i < trMatrix.getRowLength(); i++){
				for(int j = 0; j < trMatrix.getColLength(); j++){
					if(trMatrix.getCell(i, j)){
						boolean flagA = true;
						
						//Dzɂvf͏O
						for(int n = 0; n < ar.length; n = n + 2){
							if(ar[n] == j && ar[n+1] == i && !du){
								flagA = false;
							}
							else if(ar[n] == j-1 && ar[n+1] == i-1 && du){
								flagA = false;
							}
						}
						if(flagA){
							if(du){
								st.push(new Edge(i-1, j-1));
							}
							else{
								st.push(new Edge(i, j));
							}
						}
					}
				}
			}
			
			while(!st.empty()){
				
				//X^bNlo
				Edge ed = new Edge();
				ed = (Edge)st.pop();
				
				//Dz𐶐
				int element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element + 2];
				System.arraycopy(tmp,0,ar,0,element);
				
				//DzɃX^bN̒l
				ar[element] = ed.getEnd();
				ar[element+1] = ed.getBegin();
				
				//dvfr
				int k = 0;
				for(int i=0; i < ar.length; i++){
					boolean flag = true;
					for(int j = i+1; j < ar.length; j++){
						if(ar[i] == ar[j]){
							flag = false;
						}
					}
					if(flag){
						tmp[k] = ar[i];
						k++;
					}
				}
				
				//n񉻂sۂ̗Dz𐶐
				tar = new int[k];
				System.arraycopy(tmp,0,tar,0,k);
				
				//n񉻂s(ċA)
				tsq.setPriorityOrder(tar);
				ArithmeticMatrix mat = new ArithmeticMatrix();
				mat.matrixCopy(getTaskMatrix(matrix, alpha, beta, 
					tsq.getTaskSequence(alpha, beta), tsq.isDummy(), tsq.getDivergenceMatrix(), ar));
				
				
				//n񌋉ʂ
				int size = returnMatrix.getRowLength();
				int tsize = size;
				
				returnMatrix.reSizeMatrix(size + mat.getRowLength(), returnMatrix.getColLength());
				
				for(int i = 0; i < mat.getRowLength();i++){
					
					boolean flagB = true;
					
					for(int ia = 0; ia < size && flagB; ia++){
						boolean flagC = true;
						for(int ib = 0; ib < returnMatrix.getColLength() && flagC; ib++){
							if(returnMatrix.getCell(ia,ib) != mat.getCell(i,ib)){
								flagC = false;
							}
						}
						
						//flagCtrueȂ瓯n񂪂łɂ
						if(flagC){
							flagB = false;
						}
					}
					
					//n񌋉ʂ͔r
					if(flagB){
						for(int j = 0; j < mat.getColLength(); j++){
							returnMatrix.setCell(size + i, j, mat.getCell(i,j));
						}
						tsize++;
					}
				}
				
				returnMatrix.reSizeMatrix(tsize+1, returnMatrix.getColLength());
				
				//Dz񂩂2vf폜
				element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element - 2];
				System.arraycopy(tmp,0,ar,0,element - 2);
				
			}
			return returnMatrix;
			
		}
}