package jp.ac.takushoku_u.cs;
import java.util.Set;
import java.util.Iterator;
import java.util.TreeSet;

/**
* TaskSequencePresumptionNX͌n񉻂ꂽۑ肩A
* ڕWwq׃At@ƑOwq׃x[^̎肤͈͂𐄒肷邽߂̃NXłB<br>
* {NX̃hLgł́A<br>
* At@Ɋւ(1)Af(v_i-1,v_i)-s_a*s_b*g(v_i-1,v_i)-f(v_i-1,v_j)+s_a*s_b*g(v_i-1,v_j)<br>
* (2)As_b*g(v_i-1,v_j)-s_b*g(v_i-1,v_i)<br>
* x[^Ɋւ(1)Ag(v_i-1,v_i)-s_a*s_b*f(v_i-1,v_i)-g(v_i-1,v_j)+s_a*s_b*f(v_i-1,v_j)<br>
* (2)As_a*f(v_i-1,v_j)-s_a*f(v_i-1,v_i)<br>
* Ƃ܂B
* @version 1.0.1
* @author } Tj(Kasajima Hiroshi)
*/
/*
* ŏIXV 2005N0107
*/
public class TaskSequencePresumption extends TaskSequence{
	
/**
* sn
*/
	private Sequence series;
	
/**
* nsOt
*/
	private ArithmeticMatrix matrix;
	
/**
* ̗L[l
*/
	private double POSITIVE_NOT_ZERO = Double.MIN_VALUE;
	
/**
* ̗L[l
*/
	private double NEGATIVE_NOT_ZERO = Double.MIN_VALUE * -1.0;
	
/**
* pX̔ʒ萔
*/
	private double PULSE_NUMBER = 1.0E-16d;
	
	
/**
* snƂėvf0̌nݒ肵܂B
*/
	public TaskSequencePresumption(){
		series = new Sequence();
		matrix = new ArithmeticMatrix();
		setGraph(matrix);
		setSequence(series);
		
		//TaskSequenceɐݒ肷
		setMatrix(matrix);
	}
	
/**
* אڃ}gNXƐsnݒ肵܂B
* @param preSequence ݒ肷n
* @param graph n񉻂sOt
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
* @exception DisagreementSequenceSizeException }gNXSequencẽTCYvȂꍇ
*/
	public TaskSequencePresumption(Sequence preSequence, ArithmeticMatrix graph){
		series = new Sequence();
		matrix = new ArithmeticMatrix();
		setGraph(graph);
		setSequence(preSequence);
		
		//TaskSequenceɐݒ肷
		setMatrix(graph);
	}
	
	
/**
* یɂ鐄肳ꂽAt@̋Ԃ̏WԂ܂B
* @param k ی
* @return 肵Ԃ̏W
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getBetaRangeSet(int k)
*/
	public RangeSet getAlphaRangeSet(int k){
		if(inQuadrant(k)){
			//vZʂ Range
			Range ra = new Range();
			
			//ʈꎞێp Range
			Range ran = new Range();
			
			//Wێ RangeSet
			RangeSet hashSet = new RangeSet();
			
			//I\ڂz
			boolean[] el = new boolean[series.getLength()];
			
			for(int i = 0; i < series.getLength(); i++){
				
				//I\ڂĂ
				System.arraycopy(getReachElement(series.getItem(i)), 0, el, 0, series.getLength());
				ran.rangeCopy(getAlphaNotItemRange(k));
				int count = 0;
				
				//I\ڂ𒲂ׂ
				for(int j = 0; j < series.getLength(); j++){
					if(el[j] && (series.getItem(i) != j)){
						ra.rangeCopy(getAlphaPresumptionRange(series.getItem(i), j, k));
						ran.rangeCopy(ran.getAndRange(ra));
						count++;
					}
				}
				if(count == 0){
					ran.rangeCopy(getAlphaNotItemRange(k));
				}
				
				//Ԃێ
				hashSet.add(new Range(ran.getMin(), ran.getMax(), ran.hasMin(), ran.hasMax()));
				
			}
			return hashSet;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* یɂ鐄肳ꂽAt@̋ԂԂ܂B
* @param k ی
* @return 肵
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getBetaRange(int k)
*/
	public Range getAlphaRange(int k){
		if(inQuadrant(k)){
			RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
			Range ra = new Range();
			Range ran = new Range();
			ran.rangeCopy(getAlphaNotItemRange(k));
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				ran.rangeCopy(ran.getAndRange(ra));
			}
			
			return ran;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* lɂAt@̋Ax֐̒lԂ܂B
* @param k ی
* @param value w肵l
* @return Ax֐̒l
* @exception ValueFormatException w肵ی͎w肵l肦Ȃlłꍇ
* @see #getBetaAttribute(int k, double value)
*/
	public double getAlphaAttribute(int k, double value){
		if(inQuadrant(k)){
			if(isNormalAlpha(value)){
				RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
				int count = 0;
				Range ra = new Range();
				
				Iterator i = hashSet.iterator();
				while(i.hasNext()){
					ra.rangeCopy((Range)i.next());
					if(ra.hasValue(value)){
						count++;
					}
				}
				
				return (count * 1.0) / hashSet.size();
			}
			else{
				throw  new ValueFormatException("alpha(" + value + ")");
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ی̎肤ԓɂċAx֐̒lωAt@̒lWŕԂ܂B
* ی̎肤Ԃ̗[͏WɊ܂܂܂B
* @param k ی
* @return ωAt@̒lꂽW
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getBetaAttributeSet(int k)
*/
	public Set getAlphaAttributeSet(int k){
		if(inQuadrant(k)){
			Set treeSet = new TreeSet();
			
			RangeSet hashSet = new RangeSet(getAlphaRangeSet(k));
			Range ra = new Range();
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				treeSet.add(new Double(ra.getMin()));
				treeSet.add(new Double(ra.getMax()));
				
				if(ra.isSame()){
					if(getSAlpha(k) == 1.0){
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(POSITIVE_NOT_ZERO));
						}
						else if(ra.getMin() == 1.0){
							treeSet.add(new Double(ra.getMin() - PULSE_NUMBER));
						}
						else{
							treeSet.add(new Double(ra.getMin() + PULSE_NUMBER));
							treeSet.add(new Double(ra.getMin() - PULSE_NUMBER));
						}
					}
					else{
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(NEGATIVE_NOT_ZERO));
						}
						else if(ra.getMin() == -1.0){
							treeSet.add(new Double(ra.getMin() + PULSE_NUMBER));
						}
						else{
							treeSet.add(new Double(ra.getMin() + PULSE_NUMBER));
							treeSet.add(new Double(ra.getMin() - PULSE_NUMBER));
						}
					}
				}
			}
			return treeSet;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* یɂ鐄肳ꂽx[^̋Ԃ̏WԂ܂B
* @param k ی
* @return 肵Ԃ̏W
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getAlphaRangeSet(int k)
*/
	public RangeSet getBetaRangeSet(int k){
		if(inQuadrant(k)){
			//vZʂ Range
			Range ra = new Range();
			
			//ʈꎞێp Range
			Range ran = new Range();
			
			//Wێ RangeSet
			RangeSet hashSet = new RangeSet();
			
			//I\ڂz
			boolean[] el = new boolean[series.getLength()];
			
			for(int i = 0; i < series.getLength(); i++){
				
				//I\ڂĂ
				System.arraycopy(getReachElement(series.getItem(i)), 0, el, 0, series.getLength());
				ran.rangeCopy(getBetaNotItemRange(k));
				int count = 0;
				
				//I\ڂ𒲂ׂ
				for(int j = 0; j < series.getLength(); j++){
					if(el[j] && (series.getItem(i) != j)){
						ra.rangeCopy(getBetaPresumptionRange(series.getItem(i), j, k));
						ran.rangeCopy(ran.getAndRange(ra));
						count++;
					}
				}
				if(count == 0){
					ran.rangeCopy(getBetaNotItemRange(k));
				}
				
				//Ԃێ
				hashSet.add(new Range(ran.getMin(), ran.getMax(), ran.hasMin(), ran.hasMax()));
				
			}
			return hashSet;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* یɂ鐄肳ꂽx[^̋ԂԂ܂B
* @param k ی
* @return 肵
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getAlphaRange(int k)
*/
	public Range getBetaRange(int k){
		if(inQuadrant(k)){
			RangeSet hashSet = new RangeSet(getBetaRangeSet(k));
			Range ra = new Range();
			Range ran = new Range();
			ran.rangeCopy(getBetaNotItemRange(k));
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				ran.rangeCopy(ran.getAndRange(ra));
			}
			
			return ran;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* lɂx[^̋Ax֐̒lԂ܂B
* @param k ی
* @param value w肵l
* @return Ax֐̒l
* @exception ValueFormatException w肵ی͎w肵l肦Ȃlłꍇ
* @see #getAlphaAttribute(int k, double value)
*/
	public double getBetaAttribute(int k, double value){
		if(inQuadrant(k)){
			if(isNormalAlpha(value)){
				RangeSet hashSet = new RangeSet(getBetaRangeSet(k));
				int count = 0;
				Range ra = new Range();
				
				Iterator i = hashSet.iterator();
				while(i.hasNext()){
					ra.rangeCopy((Range)i.next());
					if(ra.hasValue(value)){
						count++;
					}
				}
				
				return (count * 1.0) / hashSet.size();
			}
			else{
				throw  new ValueFormatException("alpha(" + value + ")");
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ی̎肤ԓɂċAx֐̒lωx[^̒lWŕԂ܂B
* ی̎肤Ԃ̗[͏WɊ܂܂܂B
* @param k ی
* @return ωx[^̒lꂽW
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getAlphaAttributeSet(int k)
*/
	public Set getBetaAttributeSet(int k){
		if(inQuadrant(k)){
			Set treeSet = new TreeSet();
			
			RangeSet hashSet = new RangeSet(getBetaRangeSet(k));
			Range ra = new Range();
			
			Iterator i = hashSet.iterator();
			while(i.hasNext()){
				ra.rangeCopy((Range)i.next());
				treeSet.add(new Double(ra.getMin()));
				treeSet.add(new Double(ra.getMax()));
				
				if(ra.isSame()){
					if(getSBeta(k) == 1.0){
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(POSITIVE_NOT_ZERO));
						}
						else if(ra.getMin() == 1.0){
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
						else{
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
					}
					else{
						if(ra.getMin() == 0.0){
							treeSet.add(new Double(NEGATIVE_NOT_ZERO));
						}
						else if(ra.getMin() == -1.0){
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
						}
						else{
							treeSet.add(new Double(POSITIVE_NOT_ZERO + ra.getMin()));
							treeSet.add(new Double(NEGATIVE_NOT_ZERO + ra.getMin()));
						}
					}
				}
			}
			return treeSet;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ɑI\ڂ̖ꍇ̃At@̐肳ꂽԂԂ܂B
* @param k ی
* @return 肵
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getBetaNotItemRange(int k)
*/
	private Range getAlphaNotItemRange(int k){
		if(inQuadrant(k)){
			if(getSAlpha(k) == 1.0){
				return new Range(0.0, 1.0, true, true);
			}
			else{
				return new Range(-1.0, 0.0, true, true);
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* ɑI\ڂ̖ꍇ̃x[^̐肳ꂽԂԂ܂B
* @param k ی
* @return 肵
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getAlphaNotItemRange(int k)
*/
	private Range getBetaNotItemRange(int k){
		if(inQuadrant(k)){
			if(getSBeta(k) == 1.0){
				return new Range(0.0, 1.0, true, true);
			}
			else{
				return new Range(-1.0, 0.0, true, true);
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* 2ڊԂ琄肵At@̋ԂԂ܂B
* vi  vj ͐ݒ肵אڃ}gNX̍ڂ̍sԍݒ肵܂B(0͉zڂł͂܂B)
* @param vi ۂɑIꂽ
* @param vj ̑I\
* @param k ی(At@̎肤ԁj
* @return ł
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getBetaPresumptionRange(int vi, int vj, int k)
*/
	public Range getAlphaPresumptionRange(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					if(inQuadrant(k)){
						double expressionOne = getDiscriminantOneAlpha(vi, vj, k);		//(1)
						double expressionTwo = getDiscriminantTwoAlpha(vi, vj, k);		//(2)
						double expression = getDiscriminantAlpha(vi, vj, k);		//(2)/(1)
						
						return getPresumptionRange(expressionOne, expressionTwo, expression, getSAlpha(k));
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* 2ڊԂ琄肵x[^̋ԂԂ܂B
* vi  vj ͐ݒ肵אڃ}gNX̍ڂ̍sԍݒ肵܂B(0͉zڂł͂܂B)
* @param vi ۂɑIꂽ
* @param vj ̑I\
* @param k ی(x[^̎肤ԁj
* @return ł
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getAlphaPresumptionRange(int vi, int vj, int k)
*/
	public Range getBetaPresumptionRange(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					if(inQuadrant(k)){
						double expressionOne = getDiscriminantOneBeta(vi, vj, k);		//(1)
						double expressionTwo = getDiscriminantTwoBeta(vi, vj, k);		//(2)
						double expression = getDiscriminantBeta(vi, vj, k);		//(2)/(1)
						
						return getPresumptionRange(expressionOne, expressionTwo, expression, getSBeta(k));
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* 2ڊԂŐ肵ԂԂ܂B
* @param expressionOne (1)̌vZ
* @param expressionTwo (2)̌vZ
* @param expression (2) / (1)̌vZ
* @param k w肵ی̏
* @return 肵
*/
	private Range getPresumptionRange(double expressionOne, double expressionTwo, double expression, double k){
		if(expressionOne == 0.0){
			if(expressionTwo > 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionZeroPlusPlusOut(expression);
					}
					else{
						return calPresumptionZeroPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionZeroPlusMinusOut(expression);
					}
					else{
						return calPresumptionZeroPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionZeroMinusPlusOut(expression);
					}
					else{
						return calPresumptionZeroMinusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionZeroMinusMinusOut(expression);
					}
					else{
						return calPresumptionZeroMinusMinusIn(expression);
					}
				}
			}
		}
		else if(expressionOne > 0.0){
			if(expressionTwo >= 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionPlusPlusPlusOut(expression);
					}
					else{
						return calPresumptionPlusPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionPlusPlusMinusOut(expression);
					}
					else if(expression == 0){
						return calPresumptionPlusPlusMinusZero(expression);
					}
					else{
						return calPresumptionPlusPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionPlusMinusPlusOut(expression);
					}
					else{
						return calPresumptionPlusMinusPlusIn(expression);
					}
				}
				else{
					if(expression <= -1){
						return calPresumptionPlusMinusMinusOut(expression);
					}
					else{
						return calPresumptionPlusMinusMinusIn(expression);
					}
				}
			}
		}
		else{
			if(expressionTwo >= 0.0){
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionMinusPlusPlusOut(expression);
					}
					else if(expression == 0.0){
						return calPresumptionMinusPlusPlusZero(expression);
					}
					else{
						return calPresumptionMinusPlusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionMinusPlusMinusOut(expression);
					}
					else{
						return calPresumptionMinusPlusMinusIn(expression);
					}
				}
			}
			else{
				if(k == 1.0){
					if(expression > 1){
						return calPresumptionMinusMinusPlusOut(expression);
					}
					else{
						return calPresumptionMinusMinusPlusIn(expression);
					}
				}
				else{
					if(expression < -1){
						return calPresumptionMinusMinusMinusOut(expression);
					}
					else{
						return calPresumptionMinusMinusMinusIn(expression);
					}
				}
			}
		}
	}
	
/**
* vi1O̊IڂԂ܂B
* Ԃ鍀ڔԍviIO̍ڂłB
* zڂ̕t^Kvȗאڃ}gNXłꍇAIڂ^0Ԃ܂B
* @param vi I
* @return 1O̊I
* @exception NotItemException w肵ڂ݂Ȃꍇ
*/
	public int getBeforeItem(int vi){
		if(matrix.isRowNumber(vi)){
			int va = series.getNumber(vi) -1;		//vȉԁAviȂꍇŗO
			int v;		//IڂT
			
			if(isDummy()){		//zڂ̂ꍇ
				if(va < 0){
					v = 0;
				}
				else{
					v = series.getItem(va) + 1;
				}
			}
			else{
				v = series.getItem(va);
			}
			return v;
		}
		else{
			throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* At@ɂ(1)̌vZʂԂ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantOneBeta(int vi, int vj, int k)
*/
	public double getDiscriminantOneAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
				
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantOneAlpha(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* At@ɂ(1)̌vZʂԂ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantOneBeta(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantOneAlpha(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			double sb = getSBeta(k);
			return fVi - sa * sb * gVi - fVj + sa * sb * gVj;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* At@ɂ(2)̌vZʂԂ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantTwoBeta(int vi, int vj, int k)
*/
	public double getDiscriminantTwoAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
					
						return getDiscriminantTwoAlpha(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* At@ɂ(2)̌vZʂԂ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantTwoBeta(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantTwoAlpha(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			double sb = getSBeta(k);
			return sb * gVj - sb * gVi;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* At@ɂ(2) / (1)̌vZʂԂ܂B
* (1)0̏ꍇ0Ԃ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantBeta(int vi, int vj, int k)
*/
	public double getDiscriminantAlpha(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantAlpha(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* At@ɂ(2) / (1)̌vZʂԂ܂B
* (1)0̏ꍇ0Ԃ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantBeta(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantAlpha(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			if(getDiscriminantOneAlpha(fVi, gVi, fVj, gVj, k) != 0){
				return getDiscriminantTwoAlpha(fVi, gVi, fVj, gVj, k) / getDiscriminantOneAlpha(fVi, gVi, fVj, gVj, k);
			}
			else{
				return 0;
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* x[^ɂ(1)̌vZʂԂ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantOneAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantOneBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
				
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantOneBeta(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* x[^ɂ(1)̌vZʂԂ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantOneAlpha(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantOneBeta(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			double sb = getSBeta(k);
			return gVi - sa * sb * fVi - gVj + sa * sb * fVj;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* x[^ɂ(2)̌vZʂԂ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantTwoAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantTwoBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
					
						return getDiscriminantTwoBeta(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* x[^ɂ(2)̌vZʂԂ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantTwoAlpha(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantTwoBeta(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			double sa = getSAlpha(k);
			return sa * fVj - sa * fVi;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* x[^ɂ(2) / (1)̌vZʂԂ܂B
* (1)0̏ꍇ0Ԃ܂B
* @param vi ۂ̑I
* @param vj IsȂI\
* @param k ی
* @return vZ
* @exception NotItemException w肵ڂ݂Ȃꍇ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @exception IllegalRelationValuesException ۂɑIꂽڂƑI\ڂ̊֌WقȂꍇ
* @see #getDiscriminantAlpha(int vi, int vj, int k)
*/
	public double getDiscriminantBeta(int vi, int vj, int k){
		if(matrix.isRowNumber(vi)){
			if(matrix.isRowNumber(vj)){
				if(isNomalChoice(vi,vj)){
					//k͈͂
					if(inQuadrant(k)){
						
						int v = getBeforeItem(vi);
						if(isDummy()){		//zڂ̂ꍇ
							vi = vi + 1;
							vj = vj + 1;
						}
						
						return getDiscriminantBeta(getF(v, vi), getG(v, vi), getF(v, vj), getG(v, vj), k);
					}
					else{
						throw new ValueFormatException("quadrant(" + k + ")");
					}
				}
				else{
					throw new IllegalRelationValuesException("relation(" + vi + "," + vj + ")");
				}
			}
			else{
				throw new NotItemException("vj("+ vj+")");
			}
		}
		else{
				throw new NotItemException("vi("+ vi+")");
		}
	}
	
/**
* x[^ɂ(2) / (1)̌vZʂԂ܂B
* (1)0̏ꍇ0Ԃ܂B
* @param fVi ۂ̑Iڂ̍O
* @param gVi ۂ̑Iڂ̍ڕW
* @param fVj IsȂI\ڂ̍O
* @param gVj IsȂI\ڂ̍ڕW
* @param k ی
* @return vZ
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getDiscriminantAlpha(double fVi, double gVi, double fVj, double gVj, int k)
*/
	public double getDiscriminantBeta(double fVi, double gVi, double fVj, double gVj, int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			if(getDiscriminantOneBeta(fVi, gVi, fVj, gVj, k) != 0){
				return getDiscriminantTwoBeta(fVi, gVi, fVj, gVj, k) / getDiscriminantOneBeta(fVi, gVi, fVj, gVj, k);
			}
			else{
				return 0;
			}
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* w肳ꂽی̒ls_a̒lԂ܂B
* @param k ی
* @return s_a̒l
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getSBeta(int k)
*/
	private double getSAlpha(int k){
		
		//k͈͂
		if(inQuadrant(k)){
			
			double value;
			if(k == 1 || k == 4){
				value = 1.0;
			}
			else{
				value = -1.0;
			}
			return value;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* w肳ꂽی̒ls_b̒lԂ܂B
* @param k ی
* @return s_b̒l
* @exception ValueFormatException w肵ی肦Ȃlłꍇ
* @see #getSAlpha(int k)
*/
	private double getSBeta(int k){
		
		//k͈͂
		if(inQuadrant(k)){
		
			double value;
			if(k == 1 || k == 2){
				value = 1.0;
			}
			else{
				value = -1.0;
			}
			return value;
		}
		else{
			throw new ValueFormatException("quadrant(" + k + ")");
		}
	}
	
/**
* (1) = 0  (2) > 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0<= (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroPlusPlusIn(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) < -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) > 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1 <= (2)/(1) <= 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroPlusMinusIn(double expression){
		return new Range();
	}
	
/**
* (1) = 0  (2) <= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) = 0  (2) <= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0 <= (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroMinusPlusIn(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) = 0  (2) <= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) < -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, false);
	}
	
/**
* (1) = 0  (2) <= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1<= (2)/(1) <= 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionZeroMinusMinusIn(double expression){
		return new Range( -1.0, 0.0, true, false);
	}
	
/**
* (1) > 0  (2) >= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0<= (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusPlusPlusIn(double expression){
		return new Range( expression, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) >= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) < -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1<= (2)/(1) < 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusPlusMinusIn(double expression){
		return new Range();
	}
	
/**
* (1) > 0  (2) >= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) = 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusPlusMinusZero(double expression){
		return new Range( 0.0, 0.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0<= (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusMinusPlusIn(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) <= -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* (1) > 0  (2) < 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1 < (2)/(1) <= 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionPlusMinusMinusIn(double expression){
		return new Range( expression, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) >= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusPlusPlusOut(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0< (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusPlusPlusIn(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) = 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusPlusPlusZero(double expression){
		return new Range( 0.0, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) >= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) < -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusPlusMinusOut(double expression){
		return new Range();
	}
	
/**
* (1) < 0  (2) >= 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1 <= (2)/(1) <= 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusPlusMinusIn(double expression){
		return new Range( -1.0, expression, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  (2)/(1) > 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusMinusPlusOut(double expression){
		return new Range( 0.0, 1.0, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ŁA
* At@̏ꍇ1܂4یAx[^̏ꍇ1܂2ی  0<= (2)/(1) <= 1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusMinusPlusIn(double expression){
		return new Range( 0.0, expression, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  (2)/(1) < -1
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusMinusMinusOut(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* (1) < 0  (2) < 0 ŁA
* At@̏ꍇ2܂3یAx[^̏ꍇ3܂4ی  -1 <= (2)/(1) <= 0
* ̂Ƃ̐肵ԂԂ܂B
* @param expression (2) / (1)̓
* @return 肵
*/
	private Range calPresumptionMinusMinusMinusIn(double expression){
		return new Range( -1.0, 0.0, true, true);
	}
	
/**
* nݒ肵܂B
* @param preSequence ݒ肷n
* @exception DisagreementSequenceSizeException łɐݒ肳Ă}gNXSequencẽTCYvȂꍇ
*/
	public void setSequence(Sequence preSequence){
		if(isSameSize(matrix, preSequence)){
			series.sequenceCopy(preSequence);
		}
		else{
			throw new DisagreementSequenceSizeException();
		}
	}
	
/**
* אڃ}gNXݒ肵܂B
* @param graph ݒ肷אڃ}gNX
* @exception NotSquareMatrixException ݒ肵}gNXsł͂Ȃꍇ
*/
	private void setGraph(ArithmeticMatrix graph){
		if(graph.isSquare()){
			matrix.matrixCopy(graph);
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ی͈͂`FbN܂B
* @param k ׂی
* @return ͈͂ł true
*/
	private boolean inQuadrant(int k){
		return 1 <= k && k <= 4;
	}
	
/**
* Iڂ炻̎̑I\ڂԂ܂B
* ʂ̓TCYvf(zڂȂ)boolean^̔zŕԂ܂B
* Iڎg true ƂĕԂ܂B
* @param item I
* @return ʂ̔z
* @exception NotItemException w肵ڂ݂Ȃꍇ
*/
	public boolean[] getReachElement(int item){
		if(matrix.isRowNumber(item)){
			return super.getReachElement(getItemReachMatrix(item, matrix.getReachMatrix()));
		}
		else{
			throw new NotItemException("item("+ item+")");
		}
	}
	
/**
* B}gNXw肵IڂI񂾎̉B}gNX̍\ɂĕԂ܂B
* Iڂw肵ꍇ͎w肵B}gNXƓ̂Ԃ܂B
* @param item I
* @param reachMatrix B}gNX
* @return \ςB}gNX
* @exception NotItemException w肵ڂ݂Ȃꍇ
*/
	private ArithmeticMatrix getItemReachMatrix(int item, ArithmeticMatrix reachMatrix){
		if(matrix.isRowNumber(item)){
			for(int i = 0; series.getItem(i) != item && i < reachMatrix.getRowLength(); i++){
			
				//\珜O
				for(int j = 0; j < reachMatrix.getColLength(); j++){
					reachMatrix.setCell(series.getItem(i), j, 0);
				}
			}
			
			return reachMatrix;
		}
		else{
			throw new NotItemException("item("+ item+")");
		}
	}
/**
* IڂƑI\ڂ̊֌WĂ邩`FbN܂B
* @param v I
* @param vi I\
* @return ֌W true
* @exception NotItemException w肵ڂ݂Ȃꍇ
*/
	private boolean isNomalChoice(int v, int vi){
		if(matrix.isRowNumber(v)){
			if(matrix.isRowNumber(vi)){
				boolean[] el = new boolean[series.getLength()];
				
				//I\ڂĂ
				System.arraycopy(getReachElement(v), 0, el, 0, series.getLength());
				
				return el[vi];
			}
			else{
				throw new NotItemException("vi("+ vi+")");
			}
		}
		else{
				throw new NotItemException("v("+ v+")");
		}
	}
	
/**
* w肵אڃ}gNXSequencẽTCYv邩`FbN܂B
* @param mat אڃ}gNX
* @param seq w肵Sequence
* @return TCYv true
*/
	private boolean isSameSize(ArithmeticMatrix mat, Sequence seq){
		return mat.getRowLength() == seq.getLength() && mat.getColLength() == seq.getLength();
	}
	
}