package jp.ac.takushoku_u.cs;

/**
* ArrangePoint饹ϥդǤ֤(ɸ־)֤饹Ǥ<br>
* ۴ĤλޤΤʤΥ(ܥޥȥꥯ)ޤ
* Ѥ륳󥹥ȥ饯ˤäƤϳƹܤ֤٥ȥ٥Ǥΰ־
* (ܴ֤ξ岼Ӻطξ)ɬפȤʤޤ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0301
*/
public class ArrangePoint{
	
/**
* ܥޥȥꥯ
*/
	private BooleanMatrix matrix;
	
/**
* ãޥȥꥯ
*/
	private BooleanMatrix reachMatrix;
	
/**
* ٥(٥0Ϥޤ뤿ºݤΥ٥Ϻ٥+1)
*/
	private int maxLevel;
	
/**
* 粣
*/
	private int maxWide;
	
/**
* ǿ
*/
	private int elementNumber;
	
/**
* ٥(ǿ)
*/
	private int[] paintLevel;
	
/**
* Ʊ٥Ǥ
*/
	private int[] paintNumber;
	
/**
* (ϥ٥)
*/
	private int[] paintWide;
	
/**
* Ǥx,yɸ
*/
	private int[][] paintPoint;
	
/**
* 󥹥ȥ饯ȴɤ
*/
	private boolean isCon = false;
	
/**
* 褹Ȥ1֥å礭
*/
	private int blockSize = 50;
	
	
/**
* ǤΤʤܥޥȥꥯꤷޤ
*/
	public ArrangePoint(){
		BooleanMatrix mat = new BooleanMatrix();
		setPaintArray();
		point();
		isCon = true;
	}
	
/**
* ܥޥȥꥯꤷ־ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix){
		setMatrix(adjacencyMatrix);
		setPaintArray();
		point();
		isCon = true;
	}
	
/**
* ܥޥȥꥯȥ٥ꤷ־ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @param levelArray ǤɤΥ٥֤뤫٥ֹǼ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
* @see jp.ac.takushoku_u.cs.LFGPoint
* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintLevel()
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix, int[] levelArray){
		setMatrix(adjacencyMatrix);
		setPaintArray(levelArray);
		point();
		isCon = true;
	}
	
/**
* ܥޥȥꥯȥ٥Ʊ٥Ǵ֤Ǥ־ꤷ־ޤ
* 饹jp.ac.takushoku_u.cs.IMMethod ѤϤΥ󥹥ȥ饯Ѥޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @param levelArray ǤɤΥ٥֤뤫٥ֹǼ
* @param wideArray ǤƱ٥Τɤ֤뤫Ǽ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
* @see jp.ac.takushoku_u.cs.IMMethod
* @see jp.ac.takushoku_u.cs.IMMethod#getPaintLevel()
* @see jp.ac.takushoku_u.cs.IMMethod#getPaintWideNumber()
* @see jp.ac.takushoku_u.cs.LFGPoint
* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintLevel()
	* @see jp.ac.takushoku_u.cs.LFGPoint#getPaintWideNumber()
*/
	public ArrangePoint(BooleanMatrix adjacencyMatrix, int[] levelArray, int[] wideArray){
		setMatrix(adjacencyMatrix);
		setPaintArray(levelArray, wideArray);
		point();
		isCon = true;
	}
	
	
/**
* ɸ֤ޤ
*/
	private void point(){
		int center = (maxWide+1) * blockSize / 2;
		
		//ƥ٥Ǵǿ򥫥Ȥޤ
		int[] countArray = new int [maxLevel+1];
		
		//󥿥
		for(int i = 0; i <= maxLevel; i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		
		//Ǥxɸyɸޤ
		for(int i = 0; i < elementNumber; i++){
			//
			if(paintWide[paintLevel[i]]%2 == 0){
				if(paintNumber[i] > paintWide[paintLevel[i]] / 2){
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i] + 1) * blockSize;
				}
				else{
					paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i]) * blockSize;
				}
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + paintNumber[i]) * blockSize;
			}
			
			//yɸι⤵
			paintPoint[i][1] = (paintLevel[i]+1) * blockSize;
		}
	}
	
/**
* ɤ֤뤫ɸ(x,y)ꤷ֤ޤ
* ɸ־Ȥʤޤ
* @return ɸꤷ
*/
	public int[][] getPointArray(){
		point();
		return paintPoint;
	}
	
/**
* Ԥݤκ٥֤ޤ
* @return ٥
*/
	public int getMaxLevel(){
		return maxLevel;
	}
	
/**
* Ԥݤιܤκ粣֤ޤ
* 粣Ʊ٥ˤƹܿ¿Ȥʤޤ
* @return 粣
*/
	public int getMaxWide(){
		return maxWide;
	}
	
/**
* ǿ(ܿ)֤ޤ
* @return ǿ
*/
	public int getElementNumber(){
		return elementNumber;
	}
	
/**
* դݤγǤΥ٥Ȥ֤ޤ
* @return ٥Ǽ
*/
	public int[] getPaintLevel(){
		return paintLevel;
	}
	
/**
* դݤƱ٥ǤΰֹȤ֤ޤ
* Ʊ٥ֹ椬ܤ꺸Ȥޤ
* @return ֤Ǽ
*/
	public int[] getPaintWideNumber(){
		return paintNumber;
	}
	
/**
* ƥ٥βݻ֤ޤ
* ǤϤιֹΥ٥˲ˤĹܤ褹뤫򼨤ޤ
* @return 
*/
	public int[] getPaintWide(){
		return paintWide;
	}
	
/**
* ٥õޤ
* @param levelArray ٥뤬ä
* @return ٥
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* 粣õޤ
* @param levelArray ٥뤬ä
* @return 粣
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* ꤷ٥βõޤ
* @param level ꤹ٥
* @param levelArray ٥뤬ä
* @parama NumberArray ٥Ǥɤ֤뤫Ǽ
* @return 
*/
	private int getColLevel(int level, int[] levelArray, int[] numberArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level && count < numberArray[i]){
				count = numberArray[i];
			}
		}
		
		return count;
	}
	
/**
* ܥޥȥꥯꤷޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public void setMatrix(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			if(isCon){
				setPaintArray();
			}
		}
		else{
			throw new NotSquareMatrixException("row("+ adjacencyMatrix.getRowLength() +
				"),col("+adjacencyMatrix.getColLength()+")");
		}
	}
	
/**
* Τꤷޤ
*/
	private void setPaintArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getLevelArray(), 0, returnArray, 0, matrix.getRowLength());
		
		setPaintArray(returnArray);
	}
	
/**
* դݤΥ٥Ȥ֤ޤ
* @return ٥Ǽ
*/
	private int[] getLevelArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//ν
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//롼Ȥ
		for(int i = 0; i < returnArray.length; i++){
			if(matrix.getRowSum(i) == 0){
				returnArray[i] = 0;
			}
		}
		
		boolean flag = true;
		
		//٥Ǽ
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//٥뤬ꤷƤʤ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//ޤǤϥ٥뤬ꤷƤ뤫
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//롼Ȥΰ֤ѹ
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* Τꤷޤ
* @param levelArray ǤɤΥ٥֤뤫٥ֹǼ
*/
	private void setPaintArray(int[] levelArray){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getWideNumber(levelArray), 0, returnArray, 0, matrix.getRowLength());
		setPaintArray(levelArray, returnArray);
	}
	
/**
* ƥ٥ǤֽȤ֤ޤ
* @param levelArray ٥Ǽ
* @return ֽǼ
*/
	private int[] getWideNumber(int[] levelArray){
		int maxWide = getRowMaxLevel(levelArray);
		int[] wide = new int[maxWide+1];
		for(int i = 0; i < wide.length; i++){
			wide[i] = 1;
		}
		
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < matrix.getRowLength(); i++){
			returnArray[i] = wide[levelArray[i]];
			wide[levelArray[i]]++;
		}
		return returnArray;
	}
	
/**
* Τꤷޤ
* @param levelArray ǤɤΥ٥֤뤫٥ֹǼ
* @param wideArray ǤƱ٥Τɤ֤뤫ֹǼ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
*/
	public void setPaintArray(int[] levelArray, int[] wideArray){
		if(matrix.getRowLength() == levelArray.length){
			maxLevel = getRowMaxLevel(levelArray);
			maxWide = getColMaxLevel(levelArray);
			elementNumber = levelArray.length;
			
			paintLevel = new int[levelArray.length];
			System.arraycopy(levelArray, 0, paintLevel, 0, levelArray.length);
			
			paintNumber = new int[wideArray.length];
			System.arraycopy(wideArray, 0, paintNumber, 0, wideArray.length);
			
			paintWide = new int[maxLevel+1];
			for(int i = 0; i <= maxLevel; i++){
				paintWide[i] = getColLevel(i, levelArray, wideArray);
			}
			
			paintPoint = new int[elementNumber][2];
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+levelArray.length+")");
		}
	}
	
}