package jp.ac.takushoku_u.cs;

/**
* IMMethod饹IMˡѤƱ٥֤ꤹ륯饹Ǥ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0302
*/
public class IMMethod{
	
/**
* ܥޥȥꥯ
*/
	private BooleanMatrix matrix;
	
/**
* ãޥȥꥯ
*/
	private BooleanMatrix reachMatrix;
	
/**
* 롼ȤȤ
*/
	private int rootItem = -1;

/**
* ǤΤʤܥޥȥꥯꤷޤ
*/
	public IMMethod(){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
	}
	
/**
* ܥޥȥꥯ饰դΥ٥(ġ)ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤʤ
*/
	public IMMethod(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
	
/**
* դݤΥ٥Ȥ֤ޤ
* @return ٥Ǽ
*/
	public int[] getPaintLevel(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//ν
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//롼Ȥ
		if(rootItem == -1){
			for(int i = 0; i < returnArray.length; i++){
				if(matrix.getRowSum(i) == 0){
					returnArray[i] = 0;
				}
			}
		}
		else{
			returnArray[rootItem] = 0;
		}
		
		boolean flag = true;
		
		//٥Ǽ
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//٥뤬ꤷƤʤ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//ޤǤϥ٥뤬ꤷƤ뤫
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//롼Ȥΰ֤ѹ
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* IMˡѤƵ᤿ƥ٥ǤֽȤ֤ޤ
* Ʊ٥ǤǤֹ椬Τۤɺ¦褵ޤ
* @return ֽǼ
*/
	public int[] getPaintWideNumber(){
		return getPaintWideNumber(getPaintLevel());
	}
	
/**
* IMˡѤƵ᤿ƥ٥ǤֽȤ֤ޤ
* Ʊ٥ǤǤֹ椬Τۤɺ¦褵ޤ
* @param levelArray ԤǤΥ٥Ǽ
* @return ֽǼ
*/
	public int[] getPaintWideNumber(int[] levelArray){
		int[] returnArray = new int[matrix.getRowLength()];
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = Integer.MAX_VALUE;//(int)Double.NaN;
		}
		
		//٥
		int maxWide = getRowMaxLevel(levelArray);
		
		//ߤޤǤˤΥ٥ϤǤ
		int[] elementWide = new int[maxWide + 1];
		for(int i = 0; i < elementWide.length; i++){
			elementWide[i] = 0;
		}
		
		//ƹܤν٤᤿
		double[] impotant = new double[returnArray.length];
		System.arraycopy(getImportantItemArray(matrix), 0, impotant, 0, impotant.length);
		
		//ǽʹܤ
		boolean[] nextChoice = new boolean[returnArray.length];
		
		//ǽܤʣäθȤʤܤ
		boolean[] choice = new boolean[returnArray.length];
		
		//ʬ
		BooleanMatrix sectionGraph = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		sectionGraph.clearMatrix();
		
		//
		int nextItem = getMaxItem(impotant);
		returnArray[nextItem] = 0;		//濴
		elementWide[levelArray[nextItem]]++;
		
		//ιܤ
		int secondItem = getMaxItem(matrix, impotant, nextItem);
		returnArray[secondItem] = 0;		//濴
		elementWide[levelArray[secondItem]]++;
		
		//ʬդκ
		if(matrix.getCell(nextItem, secondItem)){
			sectionGraph.setCell(nextItem, secondItem, true);
		}
		else{
			sectionGraph.setCell(secondItem, nextItem, true);
		}
		
		//(3)ǽʹܤκ
		for(int i = 0; i < nextChoice.length; i++){
			
			//2ǤܤǤõ
			if(i != nextItem && i != secondItem && 
				(matrix.getCell(i, nextItem) || matrix.getCell(nextItem, i) ||
					matrix.getCell(i, secondItem) || matrix.getCell(secondItem, i))){
						nextChoice[i] = true;
			}
			else{
				nextChoice[i] = false;
			}
		}
		
		//롼(3ܤǰʹߤ)
		for(int k = 2; k < levelArray.length; k++){
			
			//٤Ǥ⤤ܤ
			System.arraycopy(getMaxItemArray(nextChoice, impotant), 0, choice, 0, choice.length);
			
			//¾Ʊ٤Ĺܤʤ
			int num = 0;
			if(isATrue(choice)){
				for(int i = 0; i < choice.length; i++){
					if(choice[i]){
						num = i;
					}
				}
			}
			
			//ޤʤ
			else{
				
				//ʬG'ܤǤ¿Ǥ򤹤᥽å
				num = getChoiceElement(choice, levelArray, returnArray, sectionGraph);
			}
			
			//֤ꤹ(֤ܤnum)
			//濴֤Ǥ
			if(elementWide[levelArray[num]] == 0){
				returnArray[num] = 0;
				elementWide[levelArray[num]]++;
			}
			else{
				returnArray[num] = getPoint(num, levelArray, maxWide, returnArray, sectionGraph, matrix);
				elementWide[levelArray[num]]++;
			}
			
			//ʬդ
			for(int i = 0; i < sectionGraph.getRowLength(); i++){
				if(sectionGraph.getRowSum(i) > 0 || sectionGraph.getColSum(i) > 0){
					if(matrix.getCell(i, num)){
						sectionGraph.setCell(i, num, true);
					}
					else if(matrix.getCell(num, i)){
						sectionGraph.setCell(num, i, true);
					}
				}
			}
			
			//֤ܤܤܤõ
			nextChoice[num] = false;
			for(int i = 0; i < nextChoice.length; i++){
				if(sectionGraph.getRowSum(i) > 0 || sectionGraph.getColSum(i) > 0){
					for(int j = 0; j < matrix.getRowLength(); j++){
						if(i != j && (matrix.getCell(i, j) || matrix.getCell(j, i)) &&
						(sectionGraph.getRowSum(j) == 0 && sectionGraph.getColSum(j) == 0)){
							nextChoice[j] = true;
						}
					}
				}
			}
			
		//롼׽λ
		}
		
		//returnArray0ϤޤΤѤ
		System.arraycopy(getWideArray(levelArray, maxWide, returnArray), 0, returnArray, 0, returnArray.length);
		
		return returnArray;
	}
	
/**
* ٥õޤ
* @param levelArray ٥뤬ä
* @return ٥
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* ꤵ줿ܤν٤֤ޤ<br>
* Ǥν٤ϹitemܤƤiФơI(v_item, v_i) = N[A(v_item)]*N[R(v_i)]<br>
* (âv_itemv_iդξ礢)ᡢ­Τˤʤޤ
* ǡN[]ϤνǿAԽ硢RϲãȤʤޤ
* @param baseMatrix ٤ޥȥꥯ
* @param item ꤹ
* @return ꤷܤν
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public double getImportantItem(BooleanMatrix baseMatrix, int item){
		if(baseMatrix.isSquare()){
			BooleanMatrix temporaryMatrix = new BooleanMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
			temporaryMatrix.matrixCopy(baseMatrix.getReachMatrix());
			double value = 0.0;
			
			for(int i = 0; i < baseMatrix.getRowLength(); i++){
				
				//I(v_i, v_item)
				if(baseMatrix.getCell(i, item)){
					value = temporaryMatrix.getColSum(i) * temporaryMatrix.getRowSum(item) + value;
				}
				
				//I(v_item, v_i)
				if(baseMatrix.getCell(item, i)){
					value = temporaryMatrix.getColSum(item) * temporaryMatrix.getRowSum(i) + value;
				}
			}
			return value;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ܤν٤֤ޤ
* @param baseMatrix ٤ޥȥꥯ
* @return ٤Ǽ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public double[] getImportantItemArray(BooleanMatrix baseMatrix){
		if(baseMatrix.isSquare()){
			double[] returnArray = new double[baseMatrix.getRowLength()];
			for(int i = 0; i < baseMatrix.getRowLength(); i++){
				returnArray[i] = getImportantItem(baseMatrix, i);
			}
			return returnArray;
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ȤǤǤֹ֤ޤ
* @param lookArray õ
* @return ιֹ
*/
	private int getMaxItem(double[] lookArray){
		int value = 0;
		double max;
		max = lookArray[0];
		for(int i = 1; i < lookArray.length; i++){
			if(max < lookArray[i]){
				max = lookArray[i];
				value = i;
			}
		}
		return value;
	}
	
/**
* ꤷǤܤʤΤΤȤǤǤֹ֤ޤ
* @param baseMatrix ܥޥȥꥯ
* @param lookArray õ
* @param item ꤹ
* @return ιֹ
*/
	private int getMaxItem(BooleanMatrix baseMatrix, double[] lookArray, int item){
		int value = 0;
		double max;
		max = 0.0;
		for(int i = 0; i < lookArray.length; i++){
			if(i != item && max < lookArray[i] &&(baseMatrix.getCell(i, item) || baseMatrix.getCell(item, i))){
				max = lookArray[i];
				value = i;
			}
		}
		return value;
	}
	
/**
* ǽܤΤȤǤǸ֤ޤ
* @param choiceArray ǽܤ򼨤
* @param lookArray õ
* @return ȤʤǼ
*/
	private boolean[] getMaxItemArray(boolean[] choiceArray, double[] lookArray){
		boolean[] returnArray = new boolean[choiceArray.length];
		double max = 0.0;
		
		//ͤõ
		for(int i = 0; i < lookArray.length; i++){
			if(choiceArray[i] && lookArray[i] > max){
				max = lookArray[i];
			}
		}
		
		//ͤtrueˤ
		for(int i = 0; i < lookArray.length; i++){
			if(choiceArray[i] && lookArray[i] == max){
				returnArray[i] = true;
			}
			else{
				returnArray[i] = false;
			}
		}
		
		return returnArray;
	}
	
/**
* trueθĿ1Ĥɤõޤ
* @param lookArray õ
* @return true1ĤǤС true
*/
	private boolean isATrue(boolean[] lookArray){
		int count = 0;
		for(int i = 0; i < lookArray.length; i++){
			if(lookArray[i]){
				count++;
			}
		}
		
		return count == 1;
	}
	
/**
* ǤǤʣ򤹤ǤӤޤ
* @param choiceArray ȤʤǤ򼨤
* @param levelArray ǤΥ٥뤬Ǽ줿
* @param wideArray ֤ꤷ
* @param partMatrix ʬ
* @return ֹ
*/
	private int getChoiceElement(boolean[] choiceArray, int[] levelArray, int[] wideArray, BooleanMatrix partMatrix){
		
		//1.濴˶᤯֤ǤǤ򤹤
		int number = -1;
		int value = Integer.MAX_VALUE;
		for(int i =0; i < choiceArray.length; i++){
			if(choiceArray[i]){
				if(getArrangePoint(i, levelArray, wideArray) < value){
					number = i;
					value = getArrangePoint(i, levelArray, wideArray);
				}
			}
		}
		
		//ܤӽ
		for(int i = 0; i < choiceArray.length; i++){
			if(choiceArray[i] && getArrangePoint(i, levelArray, wideArray) > value){
				choiceArray[i] = false;
			}
		}
		
		//ǽܤ1Ĥɤ
		if(!isATrue(choiceArray)){
		
			//2.ʬդܤǤ¿Τ򤹤
			//3.줫Ǥ򤹤(ξֹξ)
			number = 0;
			value = 0;
			for(int i =0; i < choiceArray.length; i++){
				
				//ܤƤĿ
				int count = 0;
				if(choiceArray[i]){
					for(int j = 0; j < choiceArray.length; j++){
						if(1 != j &&(matrix.getCell(i , j) || matrix.getCell(j, i))){
							boolean flag = true;
							for(int k = 0; k < choiceArray.length && flag; k++){
								if(partMatrix.getCell(j ,k) || partMatrix.getCell(k ,j)){
									flag = false;
								}
							}
							if(!flag){
								count++;
							}
						}
					}
				}
				if(count > value){
					number = i;
					value = count;
				}
				
			}
		}
		else{
			for(int i = 0;i < choiceArray.length; i++){
				if(choiceArray[i]){
					number = i;
				}
			}
		}
		
		return number;
	}
	
/**
* ꤷǤ濴餤Ĥ֤Ǥ뤫֤ޤ
* @param item ꤹ
* @param levelArray ǤΥ٥뤬Ǽ줿
* @param wideArray ֤ꤷ
* @return ֤Ǥֹ(濴ʤ0)
*/
	private int getArrangePoint(int item, int[] levelArray, int[] wideArray){
		int max = 0;
		int min = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(i != item && levelArray[i] == levelArray[item]){
				if(wideArray[i] != Integer.MAX_VALUE){
					if(wideArray[i] >= 0){
						if(wideArray[i] > max){
							max = wideArray[i];
						}
					}
					else{
						if(wideArray[i] < min){
							min = wideArray[i];
						}
					}
				}
			}
		}
		
		if(Math.abs(max) > Math.abs(min)){
			return Math.abs(min);
		}
		else{
			return Math.abs(max);
		}
	}
	
/**
* 濴֤Ǥʤ籦üüΤɤ֤뤫ꤷޤ
* @param item ֤Ԥ
* @param levelArray ǤΥ٥뤬Ǽ줿
* @param maxLevel ٥
* @param wideArray ֤ꤷ
* @param partMatrix ʬ
* @param graph Υ
* @return Ԥ(ʤкʤб)
*/
	private int getPoint(int item, int[] levelArray, int maxLevel, int[] wideArray, BooleanMatrix partMatrix, BooleanMatrix graph){
		int returnValue;
		int left = 0;
		int right = 0;
		
		//1.G'κǺüޤϺǱüǤܤǤ¿֤ۤ
		for(int i = 0; i <= maxLevel; i++){
			int max = 0;
			int maxElement = 0;
			int min = 0;
			int minElement = 0;
			
			//ǱüȺǺüõ
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i && wideArray[j] != Integer.MAX_VALUE &&
				(partMatrix.getRowSum(j) > 0 || partMatrix.getColSum(j) > 0)){
					if(wideArray[j] >= max){
						max = wideArray[j];
						maxElement = j;
					}
					if(wideArray[j] <= min){
						min = wideArray[j];
						minElement = j;
					}
				}
				
			}
			
			//ʬդܤƤ뤫
			if((graph.getCell(item, maxElement) || graph.getCell(maxElement, item))&&
			(partMatrix.getRowSum(maxElement) > 0 || partMatrix.getColSum(maxElement) > 0)){
				right++;
			}
			
			if((graph.getCell(item, minElement) || graph.getCell(minElement, item)) && 
			(partMatrix.getRowSum(minElement) > 0 || partMatrix.getColSum(minElement) > 0)){
				left++;
			}
		}
		
		//¿ΤǺ
		if(left > right){
			int min = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
					if(wideArray[j] < min){
						min = wideArray[j];
					}
				}
			}
			returnValue = min - 1;
		}
		
		//¿ΤǱ
		else if(right > left){
			int max = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
					if(wideArray[j] > max){
						max = wideArray[j];
					}
				}
			}
			returnValue = max + 1;
		}
		
		//2.ƱG'ͭޤ褷ȤȺǻޤĹ¤֤ۤ
		else{
			left = 0;
			right = 0;
			
			for(int i = 0; i < levelArray.length; i++){
				if((graph.getCell(item, i) || graph.getCell(i, item)) &&
				(partMatrix.getRowSum(i) > 0)){
					
					if(wideArray[i] >= 0){
							right = right + Math.abs(levelArray[i] - levelArray[item]);
						}
						else if(wideArray[i] <= 0){
							left = left +  Math.abs(levelArray[i] - levelArray[item]);
						}
					
				}
			}
			
			//ΤǺ
			if(left < right){
				int min = 0;
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
						if(wideArray[j] < min){
							min = wideArray[j];
						}
					}
				}
				returnValue = min - 1;
			}
			
			//ΤǱ
			else if(right < left){
				int max = 0;
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
						if(wideArray[j] > max){
							max = wideArray[j];
						}
					}
				}
				returnValue = max + 1;
			}
			
			//3.G'αȺǾʤǤ¦֤
			else{
				right = 0;
				left = 0;
				for(int i = 0; i < levelArray.length; i++){
					if((partMatrix.getRowSum(i) > 0 || partMatrix.getColSum(i) > 0) 
						&& wideArray[i] != Integer.MAX_VALUE){
						if(wideArray[i] > 0){
							right++;
						}
						else if(wideArray[i] < 0){
							left++;
						}
					}
				}
				
				//¦Ǥ¿ΤǺ
				if(left < right){
					int min = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] < min){
								min = wideArray[j];
							}
						}
					}
					returnValue = min - 1;
				}
				
				//¦Ǥ¿ΤǱ
				else if(right < left){
					int max = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] > max){
								max = wideArray[j];
							}
						}
					}
					returnValue = max + 1;
				}
				
				//4.줫֤롣ξϱ
				else{
					//returnValue = 1;
					int max = 0;
					for(int j = 0; j < levelArray.length; j++){
						if(levelArray[j] == levelArray[item] && wideArray[j] != Integer.MAX_VALUE){
							if(wideArray[j] > max){
								max = wideArray[j];
							}
						}
					}
					returnValue = max + 1;
				}
			}
		}
		
		return returnValue;
	}
	
/**
* Ʊ٥֤1ϤޤȤ֤ޤ
* 濴򶭤˺оΤȤʤ褦֤ޤ
* Τ1ʤ⤢ޤ(¦¿)
* @param levelArray ǤΥ٥뤬Ǽ줿
* @param maxLevel ٥
* @param wideArray ֤ꤷ
* @retrun ֤ꤷ
*/
	private int[] getWideArray(int[] levelArray, int maxLevel, int[] wideArray){
		
		
		for(int i = 0; i <= maxLevel; i++){
			
			//ƥ٥κǾͤ͡õ
			int min = Integer.MAX_VALUE;
			int max = Integer.MIN_VALUE;
			
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					if(wideArray[j] < min){
						min = wideArray[j];
					}
					if(wideArray[j] > max){
						max = wideArray[j];
					}
				}
				
			}
			
			//Ȥ
			//¿Ȥ
			if(Math.abs(max) <= Math.abs(min)){
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == i){
						wideArray[j] = wideArray[j] + Math.abs(min) + 1;
					}
				}
			}
			//¿Ȥ
			else if(Math.abs(max) > Math.abs(min)){
				int sa = Math.abs(max) - Math.abs(min);
				for(int j = 0; j < levelArray.length; j++){
					if(levelArray[j] == i){
						wideArray[j] = wideArray[j] + Math.abs(min) + sa + 1;
					}
				}
			}
		}
		
		return wideArray;
	}
	
}