package jp.ac.takushoku_u.cs;

/**
* IRSAnalysis饹IRSʬϤԤΥ饹Ǥ
* @version 1.1.2
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0118
*/
public class IRSAnalysis{

/**
* ʬϸΥޥȥꥯݻޥȥꥯ
*/
	private ArithmeticMatrix matrix;
	
/**
* ͤݻѿ
*/
	private double thresholdValue;
	
/**
* ޥȥꥯ礭ν͡
*/
	private static final int IRSANALYSIS_MATRIX_VALUE = 5;

/**
* ͤν͡
*/
	private static final double IRSANALYSIS_THRESHOLD = 0.5;

/**
* IRSޥȥꥯIRSեޥȥꥯ(Ϣˡ
*/
	private static final int IRSANALYSIS_SEQUENCE_TRUE = 1;

/**
* IRSޥȥꥯIRSեޥȥꥯ(Ϣʤˡ
*/
	private static final int IRSANALYSIS_SEQUENCE_FALSE = 0;

	
/**
* ꤵƤǥեȤΥʬϤԤޥȥꥯꤷޤ
*/
	public IRSAnalysis(){
		ArithmeticMatrix baseMatrix = new ArithmeticMatrix(IRSANALYSIS_MATRIX_VALUE,IRSANALYSIS_MATRIX_VALUE);		//ޥȥꥯκ
		setMatrix(baseMatrix);		//ޥȥꥯ
		matrix.clearMatrix();		//ޥȥꥯǤ
		setThreshold(IRSANALYSIS_THRESHOLD);		//ͤ
	}
	
/**
* 򸵤ʬоݤΥޥȥꥯꤷޤ
* ͤϥǥեͤꤵޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
*/
	public IRSAnalysis(ArithmeticMatrix baseMatrix){
		setMatrix(baseMatrix);
		setThreshold(IRSANALYSIS_THRESHOLD);
	}
	
/**
* 򸵤ʬоݤΥޥȥꥯȤͤꤷޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
* @param threshold ꤹ뤷
*/
	public IRSAnalysis(ArithmeticMatrix baseMatrix, double threshold){
		setMatrix(baseMatrix);
		setThreshold(threshold);
	}
	
/**
* 򸵤ʬоݤΥޥȥꥯꤷޤ
* ͤϥǥեͤꤵޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
*/
	public IRSAnalysis(BooleanMatrix baseMatrix){
		setMatrix(baseMatrix.toArithmeticMatrix());
		setThreshold(IRSANALYSIS_THRESHOLD);
	}
	
/**
* 򸵤ʬоݤΥޥȥꥯȤͤꤷޤ
* @param baseMatrix ʬоݤΥޥȥꥯ
* @param threshold ꤹ뤷
*/
	public IRSAnalysis(BooleanMatrix baseMatrix, double threshold){
		setMatrix(baseMatrix.toArithmeticMatrix());
		setThreshold(threshold);
	}
	
/**
* ʬоݤȤꤵƤޥȥꥯ֤ޤ
* @return ʬоݤΥޥȥꥯ
*/
	public ArithmeticMatrix getMatrix(){
		return matrix;
	}
	
/**
* IRSޥȥꥯ֤ޤ
* @return IRSޥȥꥯ
*/
	public ArithmeticMatrix getIRSMatrix(){
		
		//ޥȥꥯμ
		ArithmeticMatrix coefficientMatrix = new ArithmeticMatrix();
		coefficientMatrix.matrixCopy(getCoefficientMatrix());
		
		ArithmeticMatrix irsMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		int value;
		for (int i = 0; i <  irsMatrix.getRowLength(); i++){
			for (int j = 0; j <  irsMatrix.getColLength(); j++){
				if (thresholdValue <= coefficientMatrix.getCell(i, j)){	//뤫ɤĴ0,1ꤹ
					value = IRSANALYSIS_SEQUENCE_TRUE;
				}
				else{
					value = IRSANALYSIS_SEQUENCE_FALSE;
				}
				irsMatrix.setCell(i, j, value);
			}
		}
		return irsMatrix;
	}
	
/**
* ޥȥꥯޤ
* @return ޥȥꥯ
*/
	public ArithmeticMatrix getCoefficientMatrix(){
		ArithmeticMatrix coefficientMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		for (int i = 0; i < coefficientMatrix.getRowLength(); i++){
			for (int j = 0; j < coefficientMatrix.getColLength(); j++){
				coefficientMatrix.setCell(i, j, getCoefficient(i, j));
			}
		}
		return coefficientMatrix;
	}
	
/**
* IjȹIk֤ٿʬɽޤ
* @param Ij Ij
* @param Ik Ik
* @return IjIkؤٿʬɽ
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	public ArithmeticMatrix getFrequencyMatrix(int Ij, int Ik){
		if (matrix.isColNumber(Ij) && matrix.isColNumber(Ik)){
		ArithmeticMatrix returnTable = new ArithmeticMatrix(2,2);	//0,12ͤΤ
		returnTable.clearMatrix();
		for (int i = 0; i < matrix.getRowLength(); i++){		//ٿʬɽκ
			double value = returnTable.getCell((int) matrix.getCell(i, Ij),
				(int) matrix.getCell(i, Ik)) +1;
			returnTable.setCell((int) matrix.getCell(i, Ij),
				(int) matrix.getCell(i, Ik), value);
		}
		 return returnTable;
			}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}

/**
* IjIkؤνޤ
* @param Ij Ij
* @param Ik Ik
* @return IjIkؤν
* @exception NotElementException ꤷֹ椬¸ߤʤ
*/
	private double getCoefficient(int Ij, int Ik){
		
		if (matrix.isColNumber(Ij) && matrix.isColNumber(Ik)){
			double value;
			ArithmeticMatrix frequencyMatrix = new ArithmeticMatrix(2,2);
			frequencyMatrix = getFrequencyMatrix(Ij, Ik);	//ٿʬɽ
			
			//
			value = (frequencyMatrix.getCell(0,1) * (frequencyMatrix.getRowSum(0) +
			frequencyMatrix.getRowSum(1))) / (frequencyMatrix.getRowSum(0) * frequencyMatrix.getColSum(1));
			return 1 - value;
		}
		else{
			throw new NotElementException
				("point(" + Ij + "," + Ik + ")");
		}
	}
	
/**
* IRSդΥȥޥȥꥯ֤ޤ
* @return ȥޥȥꥯ
*/
	public ArithmeticMatrix getSkeletonMatrix(){
		
		//IRSޥȥꥯμ
		ArithmeticMatrix irsMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		irsMatrix.matrixCopy(getIRSMatrix());
		
		//ȥޥȥꥯ
		ArithmeticMatrix SkeletonMatrix = new ArithmeticMatrix(matrix.getColLength(), matrix.getColLength(),
			matrix.getColNameArray(), matrix.getColNameArray());
		
		//ǽμ
		int[] order = new int[matrix.getColLength()];
		System.arraycopy(getGraphElementArray(), 0, order, 0, order.length);
		SkeletonMatrix.clearMatrix();
		
		for (int i = 0; i < SkeletonMatrix.getRowLength(); i++){
			int searchRow = order[i];	 //ºݤ˸Ԥԡʿͤ㤤ǡ
			int branchCount = 0;		//Ǥ¾ǤˤĻޤ
			boolean isUnder = true;		//Ǥʿͤ⤤(֤)Ǥ򸡺椫

			for (int j = SkeletonMatrix.getRowLength() - 1; j >= 0; j--){
				int searchCol = order[j];	//ºݤ˸Ԥǡ

				if (searchRow == searchCol){		//ƱǤĴ٤褦ȤƤ뤫
					isUnder = false;
					branchCount = 0;		//⤦ٽ
				}
				else{
				//¾ǤȽط뤫ɤ
					if (irsMatrix.getCell(searchRow, searchCol) == IRSANALYSIS_SEQUENCE_TRUE){

						// ޤǤ뤫
						// 1.̤Ǥʿͤ⤤Ǥ򸡺Ƥ뤫
						// 2.Ǥ¾Ǥ˻ޤޤƤʤ
						// 3.ǤǤޤƤ뤫 
						if ((branchCount == 0) || (isUnder)||
							(SkeletonMatrix.getCell(searchCol,searchRow) == IRSANALYSIS_SEQUENCE_TRUE)){
								SkeletonMatrix.setCell(searchRow, searchCol, IRSANALYSIS_SEQUENCE_TRUE);
									
								//ƱʿǤʤϻޤ󥿤ʤ
								if(matrix.getColAverage(searchRow) != matrix.getColAverage(searchCol)){
									branchCount = branchCount + 1;
								}
						}
						else{		//¾Ǥ˻ޤƤ硢ɤǤ˻ޤõ
							int counter = 0;	//󥿡
							for (int k = irsMatrix.getRowLength() - 1; k > j; k--){
								
								//ޤǤĴ٤ƤǤ˴Ϣʤ
								if ((SkeletonMatrix.getCell(searchRow, order[k]) == IRSANALYSIS_SEQUENCE_TRUE) &&
									(irsMatrix.getCell(order[k], searchCol) == IRSANALYSIS_SEQUENCE_FALSE)){
										counter = counter + 1;		//ʤϥ󥿡䤹
								}
							}

							//Ƥ¾λޤ褫餽ǤؽϢʤϻޤ
							if (branchCount == counter){
								SkeletonMatrix.setCell(searchRow, searchCol, IRSANALYSIS_SEQUENCE_TRUE);
								
								//ƱʿǤʤϻޤ󥿤ʤ
								if(matrix.getColAverage(searchRow) != matrix.getColAverage(searchCol)){
										branchCount = branchCount + 1;
								}
							}
						}
					}
				}
			}
		}
		return SkeletonMatrix;
	}
	
/**
* ƹܤɾʿ֤ͤޤ
* @return ʿͤä
*/
	public double[] getGraphAverageArray(){
		double[]  returnArray = new double[matrix.getColLength()];		//ƹܤʿͤǼ
		System.arraycopy(matrix.getColAverageArray(), 0, returnArray, 0, returnArray.length);
		return returnArray;
	}

/**
* ܤ򥰥դ¤ؤֹ֤ޤ
* ʿΨ㤤˹ֹ¤Ѥޤ
* @return դ¤ٴֹʹܡˤä
*/
	public int[] getGraphElementArray(){
		double[]  averageRating = new double[matrix.getColLength()];		//ƹܤʿͤǼ
		int[] returnArray = new int[matrix.getColLength()];		//ʿɾͤ㤤¤٤ֹʹܡˤ
		System.arraycopy(getGraphAverageArray(), 0, averageRating, 0, averageRating.length);
		
		for (int i = 0; i < averageRating.length; i++){
			double minAverage = averageRating[0];		//
			int minNumber = 0;
			for (int j = 1; j <  averageRating.length; j++){		//ӤԤ
				if (minAverage > averageRating[j]){
					minAverage = averageRating[j];
					minNumber = j;
				}
			}
			averageRating[minNumber] = Integer.MAX_VALUE;	 //оݤϤ
			returnArray[i] = minNumber;
		}
		return returnArray;
	}
	
/**
* ֤ͤޤ
* @return 
*/
	public double getThreshold(){
		return thresholdValue;
	}

/**
* IRSʬϤоݤȤʤޥȥꥯꤷޤ
* @param baseMatrix ꤹʬоݤΥޥȥꥯ
*/
	public void setMatrix(ArithmeticMatrix baseMatrix){
		matrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength());
		matrix.matrixCopy(baseMatrix);		//ޥȥꥯ
	}
	
/**
* IRSʬϤоݤȤʤޥȥꥯǤޤ
* @param row Ǥι
* @param col Ǥ
* @param value 
* @exception NotElementException ꤷǤ¸ߤʤ
* @exception ValueFormatException ͤ0ޤ1ʳͤǤ
* @see #setMatrix(ArithmeticMatrix baseMatrix)
*/
	public void setElement(int row, int col, int value){
		if (matrix.isMatrixEntityPoint(row, col)){
			if(value == 0.0 || value == 1.0){
				matrix.setCell(row, col, value);
			}
			else{
				throw new ValueFormatException("value("+value+")");
			}
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* ͤꤷޤ<BR>
* ͤ01ޤǤδ֤ꤷޤ
* @param threshold ꤹ뤷
* @exception SetValueOutOfBoundsException ͤǤϰϳξ
*/
	public void setThreshold(double threshold){
		if(isThreshold(threshold)){
			thresholdValue = threshold;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("Threshold(" + threshold + ")");
		}
	}
	
/**
* ͤϰ⤫åޤ
* @param checkThreshold å뤷
* @return ͤϰǤtrueϰϳǤfalse֤ޤ
*/
	private boolean isThreshold(double checkThreshold){
		return ((0 <= checkThreshold) && (checkThreshold <= 1));
	}

}