package jp.ac.takushoku_u.cs;

/**
* Matrix饹2μºݤǡ̾̾ݻޤ<BR>
* @version 1.1.1
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1211
*/
public class Matrix {

/**
* ԤΥݻѿ
*/
    private int matrixRowSize;
	
/**
* Υݻѿ
*/
	private int matrixColSize;

/**
* ̾Ǽ
*/
	private String[ ] matrixRowName;

/**
* ̾Ǽ
*/
	private String[ ] matrixColName;
	
/**
* ǡ¸2
*/
	private Object[ ][ ] matrix;
	
/**
* 2Υǥե͡ʹԥ
*/
	private static final int MATRIX_INIT_ROW_SIZE = 5;
	
/**
* 2Υǥե͡󥵥
*/
	private static final int MATRIX_INIT_COL_SIZE = 5;


/**
* ꤵƤ륵ι̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
*/
	public Matrix(){
		setSizeMatrix(MATRIX_INIT_ROW_SIZE,MATRIX_INIT_COL_SIZE);
		setRowNameNumber();
		setColNameNumber();
	}

/**
* ꤵ줿ԥ󥵥򸵤˹̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public Matrix(int rowSize, int colSize){
		setSizeMatrix(rowSize,colSize);
		setRowNameNumber();
		setColNameNumber();
	}
	
/**
* ꤵ줿ԥ󥵥򸵤˹̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param nameNumber ̾̾γֹ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public Matrix(int rowSize, int colSize, int nameNumber){
		setSizeMatrix(rowSize,colSize);
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
	}

/**
* ꤵ줿ԥ󥵥̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿20ǽޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException  rowName ޤ colName  null ξ
*/
	public Matrix(int rowSize, int colSize, String[] rowName, String[] colName){
		if(isSameArraySize(rowSize, rowName) && isSameArraySize(colSize, colName)){
			setSizeMatrix(rowSize,colSize);
			
			//̾̾Υԡ
			nameRowCopy(rowName);
			nameColCopy(colName);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param originalMatrix ꤹ2
* @exception NullPointerException  originalMatrix  null ξ
*/
	public Matrix(Object[][] originalMatrix){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		setRowNameNumber();
		setColNameNumber();
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param originalMatrix ꤹ2
* @param nameNumber ̾̾γֹ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public Matrix(Object[][] originalMatrix, int nameNumber){
		setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
		setRowNameNumber(nameNumber);
		setColNameNumber(nameNumber);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2󡢹̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ
* @param originalMatrix ꤹ2
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException  rowName , colName ޤ originalMatrix  null ξ
*/
	public Matrix(Object[][] originalMatrix, String[] rowName, String[] colName){
		if(isSameArraySize(originalMatrix, rowName, colName)){
			setSizeMatrix(originalMatrix.length, originalMatrix[0].length);
			
			//ޥȥꥯΥԡ
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
					setCell(i, j, originalMatrix[i][j]);
				}
			}
			
			//̾̾Υԡ
			nameRowCopy(rowName);
			nameColCopy(colName);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}

/**
* ꤷ̾Ȥƥޥȥꥯ˥ԡޤ
* @param rowName ԡι̾
* @exception DisagreementArraySizeException ޥȥꥯΥȹ̾Ѥȥۤʤ
* @exception NullPointerException rowName  null ξ
*/
	public void nameRowCopy(String rowName[]){
		
		//ǧޤ
		if (getRowLength() == rowName.length){
		
		//ԡ򤷤ޤ
		System.arraycopy(rowName, 0, matrixRowName, 0, rowName.length);
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* ꤷ̾Ȥƥޥȥꥯ˥ԡޤ
* @param colName ԡ̾
* @exception DisagreementArraySizeException ޥȥꥯΥȹ̾Ѥȥۤʤ
* @exception NullPointerException colName  null ξ
*/
	public void nameColCopy(String colName[]){
		
		//ǧפʤϥѹޤ
		if (getColLength() == colName.length){
		
		//ԡ򤷤ޤ
		System.arraycopy(colName, 0, matrixColName, 0, colName.length);
			}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
/**
* ޥȥꥯ¾Υޥȥꥯǡ̾̾Ƥ򥳥ԡޤ<BR>
* ԡΥޥȥꥯȰפʤϥԡΥޥȥꥯѹԡԤޤ
* @param originalMatrix ԡΥޥȥꥯ
* @see #matrixCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(Matrix originalMatrix){
		
		//ǧפʤϥѹޤ
		if ((getRowLength() != originalMatrix.getRowLength()) ||
			(getColLength() != originalMatrix.getColLength())){
				setSizeMatrix(originalMatrix.getRowLength(), originalMatrix.getColLength());
		}
		
		//ԡ򤷤ޤ
			for (int i = 0; i < getRowLength(); i++){
				setRowName(i, originalMatrix.getRowName(i));
				for (int j = 0; j < getColLength(); j++){
					if (i == 0){
						setColName(j, originalMatrix.getColName(j));
					}
					setCell(i, j, originalMatrix.getObjectCell(i, j));
				}
			}
	}
	
/**
* ֤ǳϤǤ饳ԡΥޥȥꥯλ֤Ǥ򥳥ԡޤ<BR>
* ԡ( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˥ԡԤޤ
* ԡϰϤƤϤޤʤǤȹ̾̾ѹޤ
* @param originalMatrix ԡΥޥȥꥯ
* @param baseRow ԡΥޥȥꥯФ륳ԡιԳϰ
* @param baseCol ԡΥޥȥꥯФ륳ԡ󳫻ϰ
* @param copyRow ԡԳϰ
* @param copyCol ԡ󳫻ϰ
* @param rowLength ԡԤԤǿ
* @param colLength ԡԤǿ
* @exception SetValueOutOfBoundsException ԡ褬¸ߤʤϰϤˤ
* @see #matrixCopy(Matrix originalMatrix)
*/
	public void matrixCopy(Matrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
		
		//ԡΥǧޤ
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(originalMatrix.getRowLength() >= (rowLength + baseRow)) &&
			(originalMatrix.getColLength() >= (colLength + baseCol))){
			for (int i = 0; i < rowLength; i++){
				for (int j = 0; j < colLength; j++){
					setCell(i + copyRow, j + copyCol, 
						originalMatrix.getObjectCell(i + baseRow, j + baseCol));
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ꤷϰϤˤǤưޤ
* ư( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˰ưԤޤ
* ̾̾ѹޤ
* ޤưǤͤϾ񤭤졢ưǤͤѹޤ
* @param baseRow ưǤФưԳϰ
* @param baseCol ưǤФư󳫻ϰ
* @param copyRow ưǤιԳϰ
* @param copyCol ưǤ󳫻ϰ
* @param rowLength ưԤԤǿ
* @param colLength ưԤǿ
* @exception SetValueOutOfBoundsException ư褬¸ߤʤϰϤˤ
*/
	public void matrixMove(int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			
		//ԡΥǧޤ
		if ((getRowLength() - copyRow >= rowLength) &&
			(getColLength() - copyCol >= colLength) &&
			(getRowLength() >= (rowLength + baseRow)) &&
			(getColLength() >= (colLength + baseCol))){
				
				//ԡΥ֥Ȥݻ
				Object[][] o = new Object[getRowLength()][getColLength()];
				for(int i = 0; i < getRowLength(); i++){
					for(int j = 0; j < getColLength(); j++){
						o[i][j] = getObjectCell(i, j);
					}
				}
				
			for (int i = 0; i < rowLength; i++){
				for (int j = 0; j < colLength; j++){
					setCell(i + copyRow, j + copyCol, o[i + baseRow][j + baseCol]);
				}
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ꤷϰϤˤ̾ưޤ
* ư baseRow ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength Ԥ
*  copyRow ꤵǤϤޤǤ˰ưԤޤ
* ޤưǤ̾Ͼ񤭤졢ưǤ̾ѹޤ
* @param baseRow ưǤФưԳϰ
* @param copyRow ưǤιԳϰ
* @param rowLength ưԤԤǿ
* @exception SetValueOutOfBoundsException ư褬¸ߤʤϰϤˤ
*/
	public void rowNameMove(int baseRow, int copyRow, int rowLength){
			
		//ԡΥǧޤ
		if ((getRowLength() - copyRow >= rowLength) &&
			(getRowLength() >= (rowLength + baseRow))){
				
			//ԡΥ֥Ȥݻ
			String[] s = getRowNameArray();
			for (int i = 0; i < rowLength; i++){
				setRowName(i + copyRow, s[i + baseRow]);
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ꤷϰϤˤ̾ưޤ
* ư baseCol ǻꤵ줿Ǥ򳫻ϰ֤Ȥ colLength ʬ
*  copyCol ꤵǤϤޤǤ˰ưԤޤ
* ޤưǤ̾Ͼ񤭤졢ưǤ̾ѹޤ
* @param baseCol ưǤФư󳫻ϰ
* @param copyCol ưǤ󳫻ϰ
* @param colLength ưԤǿ
* @exception SetValueOutOfBoundsException ư褬¸ߤʤϰϤˤ
*/
	public void colNameMove(int baseCol, int copyCol, int colLength){
			
		//ԡΥǧޤ
		if ((getColLength() - copyCol >= colLength) &&
			(getColLength() >= (colLength + baseCol))){
				
			//ԡΥ֥Ȥݻ
			String[] s = getColNameArray();
			for (int j = 0; j < colLength; j++){
				setColName(j + copyCol, s[j + baseCol]);
			}
		}
		else{
			throw new SetValueOutOfBoundsException();
		}
	}
	
/**
* ݻ줿Ǥѹ˥ޥȥꥯ礭ѹޤ
* ޥȥꥯ򾮤ϻꤷǤ礭ʬʤʤޤ
* 礭礭줿ʬϲ⤵ޤ
* @param rowLength ԥ
* @param colLength 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		
		
		int r = getRowLength();
		int c = getColLength();
		Object[][] o = getObjectMatrix();
		String[] sr = getRowNameArray();
		String[] sc = getColNameArray();
		setSizeMatrix(rowLength, colLength);
		
		int row;
		int col;
		if(r>=rowLength){
			row = rowLength;
		}
		else{
			row = r;
		}
		if(c>=colLength){
			col = colLength;
		}
		else{
			col = c;
		}
		
		//ޥȥꥯǤ᤹
		for (int i = 0; i < row; i++){
			setRowName(i, sr[i]);
			for (int j = 0; j < col; j++){
				if(i == 0){
					setColName(j, sc[j]);
				}
				setCell(i, j, o[i][j]);
			}
		}
		
	}
	
/**
* Ԥι̾դޤ
* @param row ֹ
* @param rowName ̾
* @exception NotItemException ꤵ줿Ԥ¸ߤʤ
* @see #setColName(int col,String colName)
*/
	public void setRowName(int row,String rowName){
		if (isRowNumber(row)){
			matrixRowName[row] = rowName;
		}
		else{
			throw new NotItemException("row("+ row + ")");
		}
	}
	
/**
* ̾դޤ
* @param col ֹ
* @param colName ̾
* @exception NotItemException ꤵ줿¸ߤʤ
* @see #setRowName(int row,String rowName)
*/
	public void setColName(int col,String colName){
		if (isColNumber(col)){
			matrixColName[col] = colName;
		}
		else{
			throw new NotItemException("col("+ col+")");
		}
	}
	
/**
* ޥȥꥯιԥ֤ޤ
* @return ԥ
* @see #getColLength()
*/
	public int getRowLength(){
		return matrixRowSize;
	}
	
/**
* ޥȥꥯ󥵥֤ޤ
* @return 󥵥
* @see #getRowLength()
*/
	public int getColLength(){
		return matrixColSize;
	}

	
/**
* ꤷԤι֤̾ޤ
* @param  row 
* @return Ԥι̾
* @exception NotItemException ꤵ줿Ԥ¸ߤʤ
* @see #getColName(int col)
* @see #getRowNameArray()
*/
	public String getRowName(int row){
		if (isRowNumber(row)){
			return matrixRowName[row];
		}
		else{
			throw new NotItemException("row("+ row +")");
		}
	}
	
/**
* ޥȥꥯˤƤι֤̾ޤ
* @return ̾ä
* @see #getColNameArray()
* @see #getRowName(int row)
*/
	public String[] getRowNameArray(){
		String[] returnArray = new String[getRowLength()];
		for (int i = 0; i < getRowLength(); i++){
			returnArray[i] = getRowName(i);
		}
		return returnArray;
	}
	
/**
* ꤷι֤̾ޤ
* @param  col 
* @return Ԥ̾
* @exception NotItemException ꤵ줿¸ߤʤ
* @see #getRowName(int row)
* @see #getColNameArray()
*/
	public String getColName(int col){
		if (isColNumber(col)){
			return matrixColName[col];
		}
		else{
			throw new NotItemException("col("+ col +")");
		}
	}
	
/**
* ޥȥꥯˤƤ֤̾ޤ
* @return ̾ä
* @see #getRowNameArray()
* @see #getColName(int col)
*/
	public String[] getColNameArray(){
		String[] returnArray = new String[getColLength()];
		for (int i = 0; i < getColLength(); i++){
			returnArray[i] = getColName(i);
		}
		return returnArray;
	}
	
/**
* ꤷ̾ιֹ֤ޤ
* @param rowName ̾
* @return Ԥιֹ
* @exception NotItemException ꤵ줿̾¸ߤʤ
* @see #getColNumber(String colName)
*/
	public int getRowNumber(String rowName){
		for (int i = 0; i < getRowLength(); i++){
			if (rowName.equals(matrixRowName[i])){
				return i;
			}
		}
		
		//¸ߤʤ
		throw new NotItemException("rowName(" + rowName + ")");
	}
	
/**
* ꤷֹ֤̾ޤ
* @param colName ̾
* @return Ԥֹ
* @exception NotItemException ꤷ̾¸ߤʤ
* @see #getRowNumber(String rowName)
*/
	public int getColNumber(String colName){
		for (int i = 0; i < getColLength(); i++){
			if (colName.equals(matrixColName[i])){
				return i;
			}
		}
		
		//¸ߤʤ
		throw new NotItemException("colName(" + colName + ")");
	}
	
/**
* ޥȥꥯ˻ꤷǤ¸ߤ뤫åޤ
* @param row ֹ
* @param col ֹ
* @return Υޥȥꥯ˻ꤷǤ¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isMatrixEntityPoint(int row, int col){
		return ((0 <= row && row < this.getRowLength()) &&
			(0 <= col && col < this.getColLength()));
	}

/**
* ޥȥꥯ˻ꤷֹ椬¸ߤ뤫åޤ
* @param row ֹ
* @return Υޥȥꥯ˻ꤷֹ椬¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isRowNumber(int row){
		return ((0 <= row) && (row < this.getRowLength()));
	}
	
/**
* ޥȥꥯ˻ꤷֹ椬¸ߤ뤫åޤ
* @param col ֹ
* @return Υޥȥꥯ˻ꤷֹ椬¸ߤtrue¸ߤʤfalse֤ޤ
*/
	public boolean isColNumber(int col){
		return ((0 <= col) && (col < this.getColLength()));
	}
	
/**
* 2Ǥ礭ѹޤ
* @param rowSize ԥ
* @param colSize 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	private void setSizeMatrix(int rowSize, int colSize){
		
		//ǤϤʤ
		if((rowSize >= 0) && ( colSize >= 0)){
			setSizeRow(rowSize);
			setSizeCol(colSize);
			matrix = new Object[rowSize][colSize];
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* 2ǤιԤ礭ѹޤ
* @param rowSize ԥ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	private void setSizeRow(int rowSize){
		
		//ǤϤʤ
		if(rowSize >= 0){
			matrixRowSize = rowSize;		//ԥ
			matrixRowName = new String[matrixRowSize];		//̾
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* 2Ǥ礭ѹޤ
* @param colSize 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	private void setSizeCol(int colSize){
		
		//ǤϤʤ
		if(colSize >= 0){
			matrixColSize = colSize;		//󥵥
			matrixColName = new String[matrixColSize];		//̾
		}
		else{
			throw new NegativeMatrixSizeException();
		}
	}
	
/**
* ̾˹ֹ̾Ȥꤷޤ<BR>
* ֹ0Ϥޤ뤿ᡢ0˹ֹ̾椬ƱֹȤʤޤ 
* @see #setColNameNumber()
* @see #setRowNameNumber(int start)
*/
	public void setRowNameNumber(){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i +"");
		}
	}
	
/**
* ̾startϤޤֹ̾Ȥꤷޤ
* @param start ǽιֹ̾
* @see #setColNameNumber(int start)
* @see #setRowNameNumber()
*/
	public void setRowNameNumber(int start){
		for (int i = 0; i < getRowLength(); i++){
			setRowName(i, i + start +"");
		}
	}
	
/**
* ֹ̾̾Ȥꤷޤ<BR>
* ֹ0Ϥޤ뤿ᡢ0ֹ̾椬ƱֹȤʤޤ 
* @see #setRowNameNumber()
* @see #setColNameNumber(int start)
*/
	public void setColNameNumber(){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i +"");
		}
	}
	
/**
* ̾startϤޤֹ̾Ȥꤷޤ
* @param start ǽֹ̾
* @see #setRowNameNumber(int start)
* @see #setColNameNumber()
*/
	public void setColNameNumber(int start){
		for (int i = 0; i < getColLength(); i++){
			setColName(i, i + start +"");
		}
	}
	
/**
* Υޥȥꥯ󤫥åޤ
* @return ʤtrue򡢰㤦false֤ޤ
*/
	public boolean isSquare(){
		return getRowLength() == getColLength();
	}
	
/**
* ꤵ줿1ͤꤷޤ
* @param row ֹ
* @param col ֹ
* @param value 
* @exception NotElementException ꤷ¸ߤʤ
*/
	public void setCell(int row,int col, Object value){
		if (isMatrixEntityPoint(row, col)){
			matrix[row][col] = value;
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}
	
/**
* ꤵ줿1֤ͤޤ
* @param row ֹ
* @param col ֹ
* @return ꤷ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public Object getObjectCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			return matrix[row][col];
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* Ǥ2֤ޤ
* @return Ǥ2
*/
	public Object[][] getObjectMatrix(){
		return matrix;
	}
	
/**
* ̾Ȥƻꤵ줿̾ϻꤵ줿ȰפƤ뤫åޤ
* @param value ꤷ
* @param name ꤷ
* @return ƱǤ true
*/
	private boolean isSameArraySize(int value, String[] name){
		return name.length == value;
	}
	
/**
* ̾Ȥƻꤵ줿ǤȤƻꤵ줿2ΥפƤ뤫åޤ
* @param array ꤷǤ
* @param rowName ꤷ̾
* @param colName ꤷ̾
* @return ƱǤ true
*/
	private boolean isSameArraySize(Object[][] array, String[] rowName, String[] colName){
		return array.length == rowName.length && array[0].length == colName.length;
	}
}