package jp.ac.takushoku_u.cs;

/**
* Sequence饹Ϸ󲽤줿ݻ륯饹Ǥ
* ȤݻƤֹܥޥȥꥯˤݤιԤޤֹǤ
* @version 1.01
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2004ǯ1206
*/
public class Sequence{
	
/**
* ݻ
*/
	private int[] queue;
	
/**
* 󤵤줿ǤդƤ̾ݻ
*/
	private String[] queueName;
	
/**
* ǿ0Sequenceޤ
* ֹ̾ꤵޤ
*/
	public Sequence(){
		setLength(0);
		setItemNameNumber();
	}
	
/**
* ǿvolumeSequenceޤ
* ֹ̾ꤵޤ
* @param volume ǿ
* @exception NegativeSequenceSizeException ΥSequence褦Ȥ
*/
	public Sequence(int volume){
		setLength(volume);
		setItemNameNumber();
	}
	
/**
* ꤷǤȤƻSequenceޤ
* ֹ̾ꤵޤ
* @param baseArray Ǥˤ
* @exception NegativeValueException ǤꤵƤ
* @exception IllegalRelationValuesException Ʊֹ椬2İʾ夢ä
* @exception NullPointerException  baseArray  null ξ
*/
	public Sequence(int[] baseArray){
		if(isNotPositive(baseArray)){
			if(isNotSameItem(baseArray)){
				setLength(baseArray.length);
				System.arraycopy(baseArray, 0, queue, 0, baseArray.length);
				setItemNameNumber();
			}
			else{
				throw new IllegalRelationValuesException();
			}
		}
		else{
			throw new NegativeValueException();
		}
	}
	
/**
* ꤷǤ̾ȤƻSequenceޤ
* @param baseArray Ǥˤ
* @param baseNameArray ̾ˤ
* @exception DisagreementArraySizeException Ǥˤ̾ˤΥפʤ
* @exception NegativeValueException ǤꤵƤ
* @exception IllegalRelationValuesException Ʊֹ椬2İʾ夢ä
* @exception NullPointerException  baseArray ޤ baseNameArray  null ξ
*/
	public Sequence(int[] baseArray, String[] baseNameArray){
		if(baseArray.length == baseNameArray.length){
			if(isNotPositive(baseArray)){
				if(isNotSameItem(baseArray)){
					setLength(baseArray.length);
					System.arraycopy(baseArray, 0, queue, 0, baseArray.length);
					System.arraycopy(baseNameArray, 0, queueName, 0, baseNameArray.length);
				}
				else{
					throw new IllegalRelationValuesException();
				}
			}
			else{
				throw new NegativeValueException();
			}
		}
		else{
			throw new DisagreementArraySizeException();
		}
	}
	
	
/**
* ꤵ줿ֹǤ֤ޤ
* @param index ꤹֹ
* @return 
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public int getItem(int index){
		if(isSequenceEntityPoint(index)){
			return queue[index];
		}
		else{
			throw new NotItemException("index(" + index + ")");
		}
	}
	
/**
* ꤷֹǤꤷޤ
* @param index ꤹֹ(Sequqnceν)
* @param number ꤹ
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public void setItem(int index, int number){
		if(isSequenceEntityPoint(index)){
			queue[index] = number;
		}
		else{
			throw new NotItemException("index(" + index + ")");
		}
	}
	
/**
* ꤵ줿ֹ֤̾ޤ
* @param index ꤹֹ
* @return ̾
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public String getItemName(int index){
		if(isSequenceEntityPoint(index)){
			return queueName[index];
		}
		else{
			throw new NotItemException("index(" + index + ")");
		}
	}
	
/**
* ꤷֹ̾ꤷޤ
* @param index ꤹֹ(Sequqnceν)
* @param name ꤹ̾
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public void setItemName(int index, String name){
		if(isSequenceEntityPoint(index)){
			queueName[index] = name;
		}
		else{
			throw new NotItemException("index(" + index + ")");
		}
	}
	
/**
* ꤷǤֹ()֤ޤ
* @param element ꤷ
* @return ֹ
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public int getNumber(int element){
		for(int i = 0; i < getLength(); i++){
			if(getItem(i) == element){
				return i;
			}
		}
	
		throw new NotItemException("element(" + element + ")");
	}
	
/**
* ꤷֹ̾()֤ޤ
* @param element ꤷ̾
* @return ֹ
* @exception NotItemException ꤷܤ¸ߤʤ
*/
	public int getNumberName(String element){
		for(int i= 0; i < getLength(); i++){
			if(getItemName(i).equals(element)){
				return i;
			}
		}
	
		throw new NotItemException("element(" + element + ")");
	}
	
/**
* Sequence¾Sequence򥳥ԡޤ
* @param copySequence ԡSequence
*/
	public void sequenceCopy(Sequence copySequence){
		if(copySequence.getLength() != getLength()){
			setLength(copySequence.getLength());
		}
		for(int i = 0; i < copySequence.getLength(); i++){
			setItem(i , copySequence.getItem(i));
			setItemName(i , copySequence.getItemName(i));
		}
	}
	
/**
* ֹ̾ꤷޤ<BR>
* ֹ0Ϥޤ뤿ᡢ0ꤵޤ 
*/
	public void setItemNameNumber(){
		for (int i = 0; i < getLength(); i++){
			setItemName(i, i +"");
		}
	}
	
/**
* ̾startϤޤֹꤷޤ<BR>
* @param start ǽ̾դֹ
*/
	public void setItemNameNumber(int start){
		for (int i = 0; i < getLength(); i++){
			setItemName(i, i + start +"");
		}
	}
	
/**
* SequenceΥ֤ޤ
* @return 
*/
	public int getLength(){
		return queue.length;
	}
	
/**
* SequenceΥꤷޤ
* @param volume ꤹ륵
* @exception NegativeSequenceSizeException ΥSequence褦Ȥ
*/
	private void setLength(int volume){
		if(volume >= 0){
			queue = new int[volume];
			queueName = new String[volume];
		}
		else{
			throw new NegativeSequenceSizeException();
		}
	}
	
/**
* ꤵ줿Ǥ¸ߤ뤫åޤ
* @param index ꤹ
* @return ¸ߤ true
*/
	public boolean isSequenceEntityPoint(int index){
		return (0 <= index) && (index < getLength());
	}
	
/**
* ǤȤƻꤷǤοʤåޤ
* @param å
* @return Ǥʤ true
* @exception NullPointerException  array  null ξ
*/
	private boolean isNotPositive(int[] array){
		boolean flag = true;
		for(int i= 0; i < array.length; i++){
			if(array[i] < 0){
				flag = false;
			}
		}
		return flag;
	}
/**
* ǤȤƻꤷǤƱֹ椬ʤåޤ
* @param å
* @return ƱǤʤ true
* @exception NullPointerException  array  null ξ
*/
	private boolean isNotSameItem(int[] array){
		boolean flag = true;
		for(int i = 0; i < array.length; i++){
			for(int j = 0; j < array.length; j++){
				if(i != j && array[i] == array[j]){
					flag = false;
				}
			}
		}
		return flag;
	}
}