package jp.sourceforge.projects.ee2e.core.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import junit.framework.TestCase;
import junit.framework.Assert;
import jp.sourceforge.projects.ee2e.core.relax.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EDependCompletentTest extends TestCase {

	/**
	 * Constructor for EE2EDependCompletentTest.
	 * @param name
	 */
	public EE2EDependCompletentTest(String name) {
		super(name);
	}

	public void testEE2EDependCompletent() {
		EE2EDependCompletent completent =
			new EE2EDependCompletent(null, null, null);
		Assert.assertNotNull(completent);
	}

	public void testDoBehavior() throws BadLocationException {
		EE2EDependCompletent completent =
			new EE2EDependCompletent(null, null, null);
		Assert.assertNotNull(completent);
		completent.doBehavior(null, null);
		//
		EE2RStructureList list = new EE2RStructureList();
		String dummy = "dummy";
		list.setTagref(dummy);
		completent = new EE2EDependCompletent(list, null, null);
		Assert.assertNotNull(completent);
		completent.doBehavior(null, null);
	}

	public void testGetTitleText() {
		EE2RStructureList list = new EE2RStructureList();
		String dummy = "dummy";
		list.setTagref(dummy);
		EE2EDependCompletent completent =
			new EE2EDependCompletent(list, null, null);
		Assert.assertNotNull(completent);
		Assert.assertNotNull(completent.getTitleText());
	}
	public void testGetElementSet() {
        EE2EDependCompletent moc = new MocEE2EDependCompletent(null,null,null);
        EE2REnumeration [] enum = new EE2REnumeration[1];
        enum[0] = new EE2REnumeration();
        enum[0].setName("enumDummy");
        enum[0].setRef(null);
        EE2RAttribute attr = new EE2RAttribute();
        attr.setName("dummy");
        attr.setEnumeration(enum);
        AbstractTextEditor editor = null;
        String string = null;
		java.util.Collection col = moc.getElementSet(attr,editor,string);
        Assert.assertEquals(col.size(),1);
    }

	protected class MocEE2EDependCompletent extends EE2EDependCompletent {
		/** constractor */
		public MocEE2EDependCompletent(
			EE2RStructureList structureList,
			EE2EIndentBehavior indentBehavior,
			String oneString) {
			super(structureList, indentBehavior, oneString);
		}
        public java.util.Collection getElementSet(
            EE2RAttribute attr,
            AbstractTextEditor editor,
            String string) {
            return super.getElementSet(attr,editor,string);
        }
	};
}
