package jp.sourceforge.projects.ee2e.core.editors;

import junit.framework.Assert;
import jp.sourceforge.projects.ee2e.core.indent.*;

/**
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentLispTest extends EE2EIndentBaseTest {

    /**
     * Constructor for EE2EIndentLispTest.
     * @param name
     */
    public EE2EIndentLispTest(String name) {
        super(name);
    }

    /** 1st */
    public void testDocPublicClass() {
        String base =
            "(defun aaa\n";
        String now = "(progn (+ 1 1)))";
        String answer = base + "  " + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentLisp();
    }

    public void testGetLispCalculateIndent() throws EE2EIndentException {
        EE2EIndentLisp target = (EE2EIndentLisp) this.createEE2EIndent();
        String base = "(a b\n";
        EE2EDocument document = new EE2EEclipseDocument(base);
        int ans = target.getLispCalculateIndent(document.getLength(),document);
        Assert.assertEquals(3,ans);
        //
        ans = target.getLispCalculateIndent(document.getLength() - 1,document);
        Assert.assertEquals(0,ans);
        //
        base = "(a b\n";
        document = new EE2EEclipseDocument(base + ";; foobar");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(0,ans);
        //
        base = "(a b\n";
        document = new EE2EEclipseDocument(base + "   ;; foobar");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(0,ans);
        //
        base = "  ";
        document = new EE2EEclipseDocument(base);
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(0,ans);
        //
        base = "(a\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(1,ans);
        //
        base = "(\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(1,ans);
        //
        base = "(aa;\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(1,ans);
        //
        base = "(aa ;\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(1,ans);
        //
        base = "(aa\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(1,ans);
        //
        base = "(123 56\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(5,ans);
        //
        base = "(123 56\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(5,ans);
        //
        base = "(123 56\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(5,ans);
        //
        base = "(123 (6)\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(5,ans);
        //
        base = "(12) (6 ()\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(8,ans);
        //
        base = "(12) (6 ;; (\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(6,ans);
        //
        base = "(intractive)\n" + "(12345 aaa (+ \"(\" d)\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(7,ans);
        //
        base = "(intractive)\n" + " (defun aaa\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.getLispCalculateIndent(document.getLength() -1,document);
        Assert.assertEquals(3,ans);
    }

    public void testIsComment() throws EE2EIndentException {
        EE2EIndentLisp target = (EE2EIndentLisp) this.createEE2EIndent();
        //
        String base = "aaaa";
        EE2EDocument document = new EE2EEclipseDocument(base + "  ");
        boolean ans = target.isComment(base.length() -1,document);
        Assert.assertTrue(!ans);
        //
        base = "\naaa;ccc\nddddd\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isComment(base.length() -2,document);
        Assert.assertTrue(!ans);
        //
        base = "bbb ;; abcdefg\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isComment(base.length() -2,document);
        Assert.assertTrue(ans);
        //
        base = "bbb ;";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isComment(base.length() -1,document);
        Assert.assertTrue(ans);
    }

    public void testIsNowTroiger() throws EE2EIndentException {
        EE2EIndentLisp target = (EE2EIndentLisp) this.createEE2EIndent();
        //
        String base = "aaaa\n";
        EE2EDocument document = new EE2EEclipseDocument(base + "  ");
        boolean ans = target.isNowTroiger(base.length() -1,document);
        Assert.assertTrue(!ans);
        //
        base = "\"aaa\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isNowTroiger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "\"\n  ;  \"\n\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isNowTroiger(base.length() -1,document);
        Assert.assertTrue(!ans);
        //
        base = "\"\n  ;  \"\n";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isNowTroiger(base.length() -1,document);
        Assert.assertTrue(!ans);
    }

    public void testIsQuoteToriger() throws EE2EIndentException {
        EE2EIndentLisp target = (EE2EIndentLisp) this.createEE2EIndent();
        //
        EE2EDocument document = new EE2EEclipseDocument("");
        boolean ans = target.isQuoteToriger(5,document);
        Assert.assertTrue(!ans);
        //
        document = new EE2EEclipseDocument("");
        ans = target.isQuoteToriger(-1,document);
        Assert.assertTrue(!ans);
        //
        String base = "\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\\\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(!ans);
        //
        base = "aaa\\\\\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\\\\\\\"";
        document = new EE2EEclipseDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(!ans);        
    }
}
