package jp.sourceforge.projects.ee2e.core.editors;
import jp.sourceforge.projects.ee2e.core.relax.*;
import junit.framework.TestCase;
import junit.framework.Assert;

/**
 * Test for EE2EToolkit.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EToolkitTest extends TestCase {

    /**
     * Constructor for EE2EToolkitTest.
     * @param arg0
     */
    public EE2EToolkitTest(String arg0) {
        super(arg0);
    }

    /**
    *
    */
    public void testgetEe2eNull() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e(null);
        Assert.assertNull(ee2e);
    }
    /**
    *
    */
    public void testgetEe2eWrong() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("hogehoge");
        Assert.assertNull(ee2e);
    }
    /**
    *
    */
    public void testgetEe2e() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        Assert.assertNotNull(ee2e);
    }
    /**
    *
    */
    public void testgetEe2eTwo() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        EE2REe2e ee3e = EE2EToolkit.get().getEe2e("ee2e");
        Assert.assertEquals(ee2e,ee3e);
    }

    /**
    *
    */
    public void testgetStructureList() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        EE2RStructureList list =
            EE2EToolkit.get().getStructureList(ee2e, EE2EDependCompletent.SECTION);
        Assert.assertNotNull(list);
    }
    /**
    *
    */
    public void testgetStructureListNull() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        EE2RStructureList list = EE2EToolkit.get().getStructureList(ee2e, null);
        Assert.assertNull(list);
    }

    /**
    *
    */
    public void testgetStructureListWrong() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        EE2RStructureList list =
            EE2EToolkit.get().getStructureList(ee2e, "hogehoge");
        Assert.assertNull(list);
    }

    /**
    *
    */
    public void testgetAttributeNull() {
        EE2RAttribute attr = EE2EToolkit.get().getAttribute(null);
        Assert.assertNull(attr);
    }

    /**
    *
    */
    public void testgetAttributeIndexNull() {
        EE2RAttribute attr = EE2EToolkit.get().getAttribute(null, 0);
        Assert.assertNull(attr);
    }

    public void testgetAttributeIndex() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        Assert.assertNotNull(ee2e);
        EE2RStructureList list =
            EE2EToolkit.get().getStructureList(ee2e, EE2EDependCompletent.SECTION);
        Assert.assertNotNull(list);
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar("ee2e-basic-table");
        Assert.assertNotNull(defvar);
        EE2RTag tag = EE2EToolkit.get().getTag(defvar, null);
        Assert.assertNull(tag);
        tag = EE2EToolkit.get().getTag(defvar, "hogehoge");
        Assert.assertNull(tag);
        tag = EE2EToolkit.get().getTag(defvar, "structureList");
        Assert.assertNotNull(tag);
        EE2RAttribute attr = EE2EToolkit.get().getAttribute(tag, -1);
        Assert.assertNull(attr);
        attr = EE2EToolkit.get().getAttribute(tag, Integer.MAX_VALUE);
        Assert.assertNull(attr);
        attr = EE2EToolkit.get().getAttribute(tag, 0);
        Assert.assertNotNull(attr);
    }

    /**
    *
    */
    public void testgetDefvarNull() {
        EE2RDefvar defvar =
            EE2EToolkit.get().getDefvar((EE2RStructureList) null);
        Assert.assertNull(defvar);
        defvar = EE2EToolkit.get().getDefvar((String) null);
        Assert.assertNull(defvar);
    }

    /**
    *
    */
    public void testgetDefvarWrong() {
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar("hogehoge");
        Assert.assertNull(defvar);
    }

    /**
    *
    */
    public void testgetAttribute() {
        EE2REe2e ee2e = EE2EToolkit.get().getEe2e("ee2e");
        Assert.assertNotNull(ee2e);
        EE2RStructureList list =
            EE2EToolkit.get().getStructureList(ee2e, EE2EDependCompletent.SECTION);
        Assert.assertNotNull(list);
        EE2RDefvar defvar = EE2EToolkit.get().getDefvar("ee2e-basic-table");
        Assert.assertNotNull(defvar);
        java.util.Collection tagSet = EE2EToolkit.get().getTagSet(defvar);
        Assert.assertNotNull(tagSet);
    }
}
