package jp.sourceforge.projects.ee2e.core.indent;

/**
 * The basic test of an indent.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJavaBasicTest extends EE2EIndentJavaTest {

	/**
	 * Constructor for EE2EIndentXHtmlTest.
	 * @param name
	 */
	public EE2EIndentJavaBasicTest(String name) {
		super(name);
	}
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentJava(4,true);
    }

    /** If a line number is 0, spaceing may vibrate. */
    public void testimportSindou1() {
        String base =
            "package bbb;\n"
            + "\n";
        String now = "import aaa";
        String answer = base + "" + now;
        // now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** If a line number is 0, spaceing may vibrate. */
    public void testimportSindou2() {
        String base =
            "package bbb;\n"
            + "\n";
        String now = "import aaa";
        String answer = base + "" + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** It is the measure of "#" */
    public void testSharpTest() {
        String base =
            "    hogehoge();\n"
            + "    herohero();\n";
        String now = "#if 0\n";
        String answer = base + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** A blank line ignores. */
    public void testIgnoreSpace() {
        String base =
            "    abcd\n"
            + "    + efgh;\n"
            + "\n"
            + "   \n";
        String now = "ijkl\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** The line of only a blank is tested. */
    public void testEmptyLine() {
        String base =
            "    abcd();\n"
            + "    efgh();\n"
            + "\n"
            + "   \n";
        String now = "";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** "#" ignore. */
    public void testSharpAfterTest() {
        String base =
            "    abcdef;\n"
            + "#if 0\n";
        String now = "ghjk\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** Head line '/','/' ignore.*/
    public void testCommentHead() {
        String base =
            "    hogehoge();\n"
            + "// hogehoge\n";
        String now = "hogehoge\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** Between '/','/' ignore */
    public void testCommentMiddle() {
        String base =
            "    hogehoge();\n"
            + "        // hogehoge\n";
        String now = "hogehoge\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** Last '/''/' ignore too. */
    public void testCommentBack() {
        String base =
            "    hogehoge();\n"
            + "    herohero(); // hogehoge\n";
        String now = "hogehoge\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** # surrounded by the quart does not check. */
    public void testForation() {
        String base =
            "    public EE2EPreferencePage() {\n"
            + "    super(GRID);\n"
            + "        EE2EDebug.printf(3, \"a#b\");\n";
        String now = "EE2EPlugin.getDefault().initializeDefaults();";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** ꕶ'}'s̎`FbN */
    public void testRightKakkoAfter() {
        String base =
            "        abc();\n"
            + "    }\n";
        String now = "efg\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** ':' is minus 4 */
    public void testCoronMinus4() {
        String base =
            "    switch(c) {\n"
            + "    HOGE_HERO:\n"
            + "        break;\n";
        String now = "MOE_MOE:\n";
        String answer = base + "    "  + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** '}' is minus 4 */
    public void testRightKakkoMinus4() {
        String base =
            "    switch(c) {\n"
            + "    HOGE_HERO:\n"
            + "        break;\n"
            + "    MOE_MOE:\n"
            + "        herohero();\n";
        String now = "}";
        String answer = base + "    "  + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** ';'`FbN悤Ƃ擪s */
    public void testTopCoron() {
        String base =
            "//\n"
            + "#include \"stdio.h\"\n"
            + "    \n"
            + "\n";
        String now = "int main() {";
        String answer = base + ""  + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** OsɂCfgǉ */
    public void testMaeGyouIndent() {
        String base =
            "    switch(c) {\n"
            + "    HOGE_HERO:\n"
            + "\n";
        String now = "break;";
        String answer = base + "        "  + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** The check of a standard indent line(space ignore) */
    public void testIgnoreDoubleSpace() {
        String base =
            "    switch(c) {\n"
            + "\n"
            + "    HOGE_HERO:\n"
            + "  \n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** The check of a standard indent line(comment ignore) */
    public void testIgnoreComment() {
        String base =
            "    switch(c) { //\n"
            + "    HOGE_HERO:\n"
            + "    //\n"
            + "  \n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** The check of a standard indent line(# ignore) */
    public void testIgnoreSharpe() {
        String base =
            "    switch(c) { //\n"
            + "    HOGE_HERO:\n"
            + "#if 0\n"
            + "  \n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** The check of a standard indent line(# ignore) */
    public void testIgnore2Sharpe() {
        String base =
            "    switch(c) { //\n"
            + "    HOGE_HERO:\n"
            + "#endif\n"
            + "#if 0\n"
            + "  \n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** The check of a standard indent line
     * (Introduction "//" ignore) */
    public void testIgnoreHeadComment() {
        String base =
            "    switch(c) {\n"
            + "        //\n"
            + "    HOGE_HERO:\n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** The check of a standard indent line
     * (Introduction "//" ignore) */
    public void testIgnoreHead2Comment() {
        String base =
            "    switch(c) {\n"
            + "//\n"
            + "        //\n"
            + "    HOGE_HERO:\n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** The check of a standard indent line
     * (Introduction "#" ignore) */
    public void testIgnoreHeadSharpe() {
        String base =
            "    switch(c) {\n"
            + "#if 0\n"
            + "        //\n"
            + "    HOGE_HERO:\n";
        String now = "break;\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** The check of a standard indent line
     * (Check the base indent) */
    public void testBaseIndentCheck() {
        String base =
            "    HOGE_HERO:\n"
            + "        a = hogehoge\n";
        String now = "+ herohero;\n";
        String answer = base + "            " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** The check of a standard indent line
     * (CfgmF) */
    public void testFarBaseIndentCheck() {
        String base =
            "    HOGE_HERO:\n"
            + "    //\n"
            + "        a = hogehoge +\n"
            + "            + hogehoge //\n"
            + "//\n";
        String now = "+ herohero;\n";
        String answer = base + "            " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** Detailed check */
    public void testDoIndentComment() {
        String base =
            "\tpublic class EE2EIndentJava extends EE2EIndentBehavior {\n"
                + "\t\t/** constractor */\n"
                + "\t\tpublic EE2EIndentJava(int indentLen) {\n"
                + "        //\n";
        String now = "this.indentLen = indentLen;\n";
        String answer = base + "            " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** Next indent check. */
    public void testDoIndentNextStringTab() {
        String base =
            "\t\tString base = \"abcd\"\n"
            + "\t\t\t+ \"efg\"\n";
        String now = "+ \"hij\";\n";
        String answer = base + "            " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** Next indent check(Detailed).*/
    public void testDoIndentNextString() {
        String base =
            "\t\tString base = \"abcd\"\n"
            + "            + \"efg\"\n";
        String now = "+ \"hij\";\n";
        String answer = base + "            " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** There is two "#". */
    public void testDoubleSharpAfterTest() {
        String base =
            "    hogehoge();\n"
            + "#endif\n"
            + "#if 0\n";
        String now = "hogehoge\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** C MACRO */
    public void testCMacro() {
        String base =
            "#define hogehoge \\\n"
            + "    herohero(); \\\n";
        String now = "moemoe();\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** after comment */
    public void testAffterComment() {
        String base =
            "        this.method();\n" +
            "        this.method();\n" +
            "    } /* hoge */\n";
        String now = "moemoe();\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** after comment */
    public void testAftorCommentFor() {
        String base =
            "    this.method();\n" +
            "    this.method();\n" +
            "    for() { /*hogehoge*/\n";
        String now = "moemoe();\n";
        String answer = base + "        " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    /** after comment */
    public void testAftorCommentSwitchCase() {
        String base =
            "    this.method();\n" +
            "    this.method();\n" +
            "    /*abcdefg\n" +
            "     *hijklmn*/\n";
        String now = "moemoe();\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
}
