/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.display;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import jp.sourceforge.projects.ee2e.core.EE2EDebug;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.display.EE2EDisplayCompletion;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class EE2EMiniBufferView
extends ViewPart {
    private static EE2EMiniBufferView eE2EMiniBufferView;
    private KeyListener keyListener = new KeyListener(){
        private String oldString = "";

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            char chInt = e.character;
            if (chInt == '\u0007' && (e.stateMask & 0x40000) != 0) {
                EE2EMiniBufferView.removeEE2EDisplayCompletion();
                return;
            }
            if (e.character == ' ' && (e.stateMask & 0x40000) == 0 && (e.stateMask & 0x20000) == 0) {
                EE2EMiniBufferView.this.doCompletentAction(this.oldString);
            } else if (e.character == '\r' || e.character == '\n') {
                EE2EMiniBufferView.this.doReturnAction();
            }
        }
    };
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int index = EE2EMiniBufferView.this.list.getSelectionIndex();
            String string = EE2EMiniBufferView.this.list.getItem(index);
            if (string == null || string.equals("")) {
                return;
            }
            String ans = string;
            EE2EMiniBufferView.this.text.setText("");
            EE2EMiniBufferView.this.text.insert(ans);
            EE2EMiniBufferView.this.text.forceFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private EE2EDisplayCompletion completention;
    private Text text;
    private List list;
    private List tagList;

    public EE2EMiniBufferView() {
        EE2EDebug.printf(3, "EE2EMiniBufferView");
    }

    public static EE2EMiniBufferView showEE2EDisplayCompletion(EE2EDisplayCompletion completention) {
        IViewPart part = null;
        IWorkbenchPage page = EE2EMiniBufferView.getIWorkbenchPage();
        if (page == null) {
            return null;
        }
        try {
            part = page.showView("jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView");
        }
        catch (PartInitException partInitException) {
            EE2EDebug.printf(1, "not IViewPart id=jp.sourceforge.projects.ee2e.core.display.EE2EMiniBufferView");
        }
        if (part == null) {
            EE2EDebug.printf(1, "not part");
            return null;
        }
        if (!(part instanceof EE2EMiniBufferView)) {
            EE2EDebug.printf(1, "not EE2EMiniBufferView");
            return null;
        }
        EE2EMiniBufferView miniBufferView = (EE2EMiniBufferView)part;
        miniBufferView.setEE2EDisplayCompletion(completention);
        miniBufferView.setFocus();
        eE2EMiniBufferView = miniBufferView;
        return miniBufferView;
    }

    public static void removeEE2EDisplayCompletion() {
        EE2EDebug.printf(3, "not removeEE2EDisplayCompletion");
        if (eE2EMiniBufferView != null) {
            EE2EDebug.printf(3, "dispose");
            eE2EMiniBufferView.dataClearAndDisable();
            IWorkbenchPage page = EE2EMiniBufferView.getIWorkbenchPage();
            if (page != null) {
                page.hideView((IViewPart)eE2EMiniBufferView);
            }
        }
    }

    protected static IWorkbenchPage getIWorkbenchPage() {
        EE2EPlugin plugin = EE2EPlugin.getDefault();
        if (plugin == null) {
            EE2EDebug.printf(1, "not EE2EPlugin");
            return null;
        }
        IWorkbench bentch = plugin.getWorkbench();
        if (bentch == null) {
            EE2EDebug.printf(1, "not IWorkbench");
            return null;
        }
        IWorkbenchWindow window = bentch.getActiveWorkbenchWindow();
        if (window == null) {
            EE2EDebug.printf(1, "not IWorkbenchWindow");
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            EE2EDebug.printf(1, "not IWorkbenchPage");
            return null;
        }
        return page;
    }

    protected void setEE2EDisplayCompletion(EE2EDisplayCompletion completention) {
        EE2EDisplayCompletion work = this.completention;
        this.completention = completention;
        if (work != null) {
            work.dispose();
        }
        if (this.completention != null) {
            this.setPartName(this.completention.getTitleText());
            this.text.setText("");
            this.text.setEnabled(true);
            this.list.removeAll();
            this.list.setEnabled(true);
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)layout);
        this.setPartName("start");
        this.text = new Text(parent, 260);
        this.text.addKeyListener(this.keyListener);
        GridData grid1 = new GridData();
        grid1.horizontalAlignment = 4;
        grid1.verticalAlignment = 4;
        grid1.horizontalIndent = 1;
        grid1.horizontalSpan = layout.numColumns;
        grid1.verticalSpan = 1;
        grid1.grabExcessHorizontalSpace = true;
        grid1.grabExcessVerticalSpace = false;
        this.text.setLayoutData((Object)grid1);
        this.list = new List(parent, 770);
        this.list.addSelectionListener(this.selectionListener);
        GridData grid2 = new GridData();
        grid2.horizontalAlignment = 4;
        grid2.verticalAlignment = 4;
        grid2.horizontalIndent = 1;
        grid2.horizontalSpan = layout.numColumns - 1;
        grid2.verticalSpan = 1;
        grid2.grabExcessHorizontalSpace = false;
        grid2.grabExcessVerticalSpace = true;
        this.list.setLayoutData((Object)grid2);
        this.tagList = new List(parent, 770);
        GridData grid3 = new GridData();
        grid3.horizontalAlignment = 4;
        grid3.verticalAlignment = 4;
        grid3.horizontalIndent = 1;
        grid3.horizontalSpan = 1;
        grid3.verticalSpan = 1;
        grid3.grabExcessHorizontalSpace = false;
        grid3.grabExcessVerticalSpace = true;
        this.tagList.setLayoutData((Object)grid3);
        this.text.setEnabled(false);
        this.list.setEnabled(false);
    }

    public void setFocus() {
        this.text.setFocus();
    }

    private void doCompletentAction(String oldString) {
        Collection set;
        String miniBuffer = this.text.getText();
        if ((miniBuffer = miniBuffer.substring(0, miniBuffer.length() - 1)).length() > 0 && oldString.equals(miniBuffer)) {
            this.text.setText("");
            this.text.insert(miniBuffer);
            return;
        }
        oldString = miniBuffer;
        this.list.removeAll();
        if (this.completention != null) {
            set = this.completention.allCompletions(miniBuffer);
            if ((set = EE2EMiniBufferView.subCompletions(miniBuffer, set)) != null) {
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    String string = (String)ite.next();
                    this.list.add(string);
                }
            }
        } else {
            set = null;
        }
        miniBuffer = EE2EMiniBufferView.tryCompletion(miniBuffer, set);
        this.text.setText("");
        this.text.insert(miniBuffer);
    }

    private void doReturnAction() {
        String miniBuffer = this.text.getText();
        if (this.completention == null) {
            return;
        }
        this.completention.returnAction(miniBuffer);
        if (this.completention != null) {
            String title = this.completention.getTitleText();
            if (title != null) {
                this.setPartName(title);
            }
            this.setTagLIst(this.completention.getTagList(), this.completention.getTagListSelect());
        }
        if (this.text != null) {
            this.text.setText("");
        }
        if (this.list != null) {
            this.list.removeAll();
        }
    }

    protected static final String tryCompletion(String string, Collection set) {
        if (set == null || set.size() <= 0) {
            return string;
        }
        if (string == null) {
            string = "";
        }
        String topString = (String)set.iterator().next();
        int i = -1;
        boolean flag = true;
        block0: while (flag) {
            Iterator ite = set.iterator();
            String top = (String)ite.next();
            if (top.length() <= ++i) break;
            if (i < string.length() && EE2EMiniBufferView.getLower(string.charAt(i)) != EE2EMiniBufferView.getLower(top.charAt(i))) {
                return string;
            }
            char old = EE2EMiniBufferView.getLower(top.charAt(i));
            while (ite.hasNext()) {
                String nextStr = (String)ite.next();
                char next = EE2EMiniBufferView.getLower(nextStr.charAt(i));
                if (next == old) continue;
                flag = false;
                continue block0;
            }
        }
        if (i < string.length()) {
            return string;
        }
        return topString.substring(0, i);
    }

    protected static final Collection subCompletions(String string, Collection allList) {
        if (allList == null) {
            return null;
        }
        if (string == null) {
            return allList;
        }
        if (string.length() <= 0) {
            return allList;
        }
        TreeSet<String> set = new TreeSet<String>();
        char[] stringCh = string.toLowerCase().toCharArray();
        Iterator ite = allList.iterator();
        while (ite.hasNext()) {
            String next = (String)ite.next();
            if (next.length() < string.length()) continue;
            boolean flag = true;
            char[] listCh = next.toLowerCase().toCharArray();
            int j = 0;
            while (j < stringCh.length) {
                if (stringCh[j] != listCh[j]) {
                    flag = false;
                    break;
                }
                ++j;
            }
            if (!flag) continue;
            set.add(next);
        }
        return set;
    }

    protected static final char getLower(char old) {
        if ('A' <= old && old <= 'Z') {
            char next = (char)(old - 65);
            return (char)(next + 97);
        }
        if (old == '\\') {
            return '/';
        }
        return old;
    }

    protected void dataClearAndDisable() {
        EE2EDisplayCompletion work = this.completention;
        this.completention = null;
        if (work != null) {
            work.dispose();
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setText("");
            this.text.setEnabled(false);
        }
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.list.setEnabled(false);
        }
    }

    public void setTagLIst(Collection text, int selection) {
        if (text == null) {
            return;
        }
        Iterator ite = text.iterator();
        this.tagList.removeAll();
        this.tagList.setEnabled(false);
        while (ite.hasNext()) {
            String ans = (String)ite.next();
            this.tagList.add(ans);
        }
        if (selection >= 0) {
            this.tagList.setSelection(selection);
        }
    }

    public void dispose() {
        super.dispose();
        this.dataClearAndDisable();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
        }
        this.text = null;
        if (this.list != null && !this.list.isDisposed()) {
            this.list.dispose();
        }
        this.list = null;
    }
}

