/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.relax.RStack;
import jp.sourceforge.projects.ee2e.core.relax.UJAXP;
import jp.sourceforge.projects.ee2e.core.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RStructure
implements Serializable {
    private String value_;
    private String type_;

    public EE2RStructure() {
    }

    public EE2RStructure(RStack stack) {
        this.setup(stack);
    }

    public EE2RStructure(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RStructure(Element element) {
        this.setup(element);
    }

    public EE2RStructure(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RStructure(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RStructure(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RStructure(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RStructure(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RStructure(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        this.value_ = URelaxer.getAttributePropertyAsString(element, "value");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("structure");
        if (this.value_ != null) {
            URelaxer.setAttributePropertyByString(element, "value", this.value_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getValue() {
        return this.value_;
    }

    public final void setValue(String value) {
        this.value_ = value;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<structure");
        if (this.value_ != null) {
            buffer.append(" value=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getValue()));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</structure>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<structure");
        if (this.value_ != null) {
            buffer.print(" value=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getValue()));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</structure>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "structure")) {
            return false;
        }
        RStack target = new RStack(element);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RStructure.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RStructure.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

