/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.relax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.projects.ee2e.core.relax.EE2RTemplate;
import jp.sourceforge.projects.ee2e.core.relax.RStack;
import jp.sourceforge.projects.ee2e.core.relax.UJAXP;
import jp.sourceforge.projects.ee2e.core.relax.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EE2RTemplateList
implements Serializable {
    private String index_;
    private String extention_;
    private String name_;
    private String type_;
    private List template_ = new ArrayList();

    public EE2RTemplateList() {
    }

    public EE2RTemplateList(RStack stack) {
        this.setup(stack);
    }

    public EE2RTemplateList(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EE2RTemplateList(Element element) {
        this.setup(element);
    }

    public EE2RTemplateList(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EE2RTemplateList(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EE2RTemplateList(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EE2RTemplateList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EE2RTemplateList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EE2RTemplateList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.setup(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.index_ = URelaxer.getAttributePropertyAsString(element, "index");
        this.extention_ = URelaxer.getAttributePropertyAsString(element, "extention");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
        this.template_.clear();
        while (!stack.isEmptyElement()) {
            if (!EE2RTemplate.isMatch(stack)) break;
            this.addTemplate(new EE2RTemplate(stack));
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("templateList");
        if (this.index_ != null) {
            URelaxer.setAttributePropertyByString(element, "index", this.index_);
        }
        if (this.extention_ != null) {
            URelaxer.setAttributePropertyByString(element, "extention", this.extention_);
        }
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        int size = this.template_.size();
        int i = 0;
        while (i < size) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeElement(element);
            ++i;
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(uri));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(url));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(in));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(is));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getValidDocument(reader));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getIndex() {
        return this.index_;
    }

    public final void setIndex(String index) {
        this.index_ = index;
    }

    public final String getExtention() {
        return this.extention_;
    }

    public final void setExtention(String extention) {
        this.extention_ = extention;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public final EE2RTemplate[] getTemplate() {
        EE2RTemplate[] array = new EE2RTemplate[this.template_.size()];
        return this.template_.toArray(array);
    }

    public final void setTemplate(EE2RTemplate[] template) {
        this.template_.clear();
        this.template_.addAll(Arrays.asList(template));
    }

    public final void setTemplate(EE2RTemplate template) {
        this.template_.clear();
        this.template_.add(template);
    }

    public final void addTemplate(EE2RTemplate template) {
        this.template_.add(template);
    }

    public final int getTemplateCount() {
        return this.template_.size();
    }

    public final EE2RTemplate getTemplate(int index) {
        return (EE2RTemplate)this.template_.get(index);
    }

    public final void setTemplate(int index, EE2RTemplate template) {
        this.template_.set(index, template);
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<templateList");
        if (this.index_ != null) {
            buffer.append(" index=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getIndex()));
            buffer.append("\"");
        }
        if (this.extention_ != null) {
            buffer.append(" extention=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getExtention()));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getName()));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(this.getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        int size = this.template_.size();
        int i = 0;
        while (i < size) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.append("</templateList>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<templateList");
        if (this.index_ != null) {
            buffer.print(" index=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getIndex()));
            buffer.print("\"");
        }
        if (this.extention_ != null) {
            buffer.print(" extention=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getExtention()));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getName()));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(this.getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        int size = this.template_.size();
        int i = 0;
        while (i < size) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeTextElement(buffer);
            ++i;
        }
        buffer.print("</templateList>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "templateList")) {
            return false;
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RTemplate.isMatchHungry(target)) break;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EE2RTemplateList.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EE2RTemplateList.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

