package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ETranslateRegion implements EE2EMenuBehavior {
	public EE2ETranslateRegion() {
	}
	public static final String LEFT_BEFOR = "<";
    public static final String RIGHT_BEFOR = ">";
    public static final String DOUBLE_BEFOR = "\"";
	public static final String AMP_BEFOR = "&";
	public static final String LEFT_AFTER = "&lt;";
	public static final String RIGHT_AFTER = "&gt;";
	public static final String AMP_AFTER = "&amp;";
    public static final String DOUBLE_AFTER = "&quot;";

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.translateR") + "(&:)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.translateR.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
	public void doBehavior(
		AbstractTextEditor editor,
		ITextSelection textSelection)
		throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
		String text = textSelection.getText();
		if ((textSelection.getLength() <= 0) && (text.equals(""))) {
			return;
		}
		String oldText = "";
		while (true) {
			int ltInt = text.indexOf(EE2ETranslateRegion.LEFT_BEFOR);
			int gtInt = text.indexOf(EE2ETranslateRegion.RIGHT_BEFOR);
            int ampInt = text.indexOf(EE2ETranslateRegion.AMP_BEFOR);
            int doubleInt = -1;
            if(this.isDouble()) {
                doubleInt = text.indexOf(EE2ETranslateRegion.DOUBLE_BEFOR);
            }
			if ((ltInt < 0) && (gtInt < 0) && (ampInt < 0) && (doubleInt < 0)) {
				break;
			}
			if (ltInt < 0) {
				ltInt = Integer.MAX_VALUE;
			}
			if (gtInt < 0) {
				gtInt = Integer.MAX_VALUE;
			}
			if (ampInt < 0) {
				ampInt = Integer.MAX_VALUE;
			}
            if ( doubleInt < 0) {
                doubleInt = Integer.MAX_VALUE;
            }
			String before = EE2ETranslateRegion.LEFT_BEFOR;
			String result = EE2ETranslateRegion.LEFT_AFTER;
			int min = ltInt;
			if (gtInt < min) {
				min = gtInt;
				before = EE2ETranslateRegion.RIGHT_BEFOR;
				result = EE2ETranslateRegion.RIGHT_AFTER;
			}
			if (ampInt < min) {
				min = ampInt;
				before = EE2ETranslateRegion.AMP_BEFOR;
				result = EE2ETranslateRegion.AMP_AFTER;
			}
            if(this.isDouble()) {
                if (doubleInt < min) {
                    min = doubleInt;
                    before = EE2ETranslateRegion.DOUBLE_BEFOR;
                    result = EE2ETranslateRegion.DOUBLE_AFTER;
                }
            }
			oldText += text.substring(0, min);
			oldText += result;
			text = text.substring(min + before.length());
		}
		text = oldText + text;
		document.replace(
			textSelection.getOffset(),
			textSelection.getLength(),
			text);
	}
    public boolean isDouble() {
        return false;
    }
}