package jp.sourceforge.projects.ee2e.core.indent;



/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECppMiniFormatBehavior {
    public EE2ECppMiniFormatBehavior() {
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
    public String doBehavior(
        String document)
        throws java.io.IOException {
        java.io.StringReader sReader = new java.io.StringReader(document);
        java.io.BufferedReader bReader = new java.io.BufferedReader(sReader);
        java.io.StringWriter sWriter = new java.io.StringWriter();
        boolean is1st = false;
        while (true) {
            String line = bReader.readLine();
            if (line == null) {
                break;
            }
            this.getFormat(line, sWriter, is1st);
            is1st = true;
        }
        sWriter.write("\n");
        bReader.close();
        sWriter.close();
        return sWriter.toString();
    }
    protected boolean getFormat(
        String line,
        java.io.StringWriter sWriter,
        boolean is1st) {
        line = doPlusSpace("if", line);
        line = doPlusSpace("while", line);
        line = doPlusSpace("switch", line);
        line = doPlusSpace("for", line);
        //
        boolean nowElse = false;
        int i;
        boolean checkFlag = true;
        for (i = line.length() - 1; 0 <= i; i--) {
            if ((line.charAt(i) == ' ')
                || (line.charAt(i) == '\t')
                || (line.charAt(i) == '\r')
                || (line.charAt(i) == '\n')) {
                continue;
            }
            break;
        }
        if (i < line.length() - 1) {
            line = line.substring(0, i + 1);
        }
        String answer = line;
        for (i = 0; i < line.length(); i++) { // 1st space skip.
            if ((line.charAt(i) == ' ')
                || (line.charAt(i) == '\t')
                || (line.charAt(i) == '\r')
                || (line.charAt(i) == '\n')) {
                continue;
            } else if (line.charAt(i) == '}') { // "} // for" -> "}"
                answer = EE2ECppSharp.deleteSpaceAndComment(line);
            } else if (line.charAt(i) == '#') { // "   #if" -> "#if"
                answer = line.substring(i);
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                nowElse = false;
            } else if (
                (this.prependElse
                    || (prependChar == ')')
                    || (prependChar == '=')
                    || (prependChar == '{')
                    || (prependChar == ':'))
                    && (line.charAt(i) == '{')) {
                answer = " " + line.substring(i);
                checkFlag = false;
            } else if (
                ((i + 4) < line.length())
                    && (this.prependChar == '}')
                    && (line.charAt(i) == 'c')
                    && (line.charAt(i + 1) == 'a')
                    && (line.charAt(i + 2) == 't')
                    && (line.charAt(i + 3) == 'c')
                    && (line.charAt(i + 4) == 'h')
                    && (((i + 5) == line.length())
                        || (line.charAt(i + 5) == '(')
                        || (line.charAt(i + 5) == ' ')
                        || (line.charAt(i + 5) == '\t')
                        || (line.charAt(i + 5) == '\r')
                        || (line.charAt(i + 5) == '\n'))) {
                answer = "\n" + line;
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                checkFlag = false;
            } else if (
                ((i + 2) < line.length())
                    && (line.charAt(i) == 't')
                    && (line.charAt(i + 1) == 'r')
                    && (line.charAt(i + 2) == 'y')
                    && (((i + 3) == line.length())
                        || (line.charAt(i + 3) == ' ')
                        || (line.charAt(i + 3) == '\t')
                        || (line.charAt(i + 3) == '\r')
                        || (line.charAt(i + 3) == '\n'))) {
                answer = "\n" + line;
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                nowElse = true;
                checkFlag = false;
            } else if (
                ((i + 1) < line.length())
                    && (line.charAt(i) == 'd')
                    && (line.charAt(i + 1) == 'o')
                    && (((i + 2) == line.length())
                        || (line.charAt(i + 2) == ' ')
                        || (line.charAt(i + 2) == '\t')
                        || (line.charAt(i + 2) == '\r')
                        || (line.charAt(i + 2) == '\n'))) {
                answer = "\n" + line;
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                nowElse = true;
                checkFlag = false;
            } else if (
                (0 <= line.length() - 5)
                    && ((line.charAt(line.length() - 5) == ' ')
                        || (line.charAt(line.length() - 5) == '\t')
                        || (line.charAt(line.length() - 5) == '\r')
                        || (line.charAt(line.length() - 5) == '\n')
                        || (line.charAt(line.length() - 5) == '}'))
                    && (line.charAt(line.length() - 4) == 'e')
                    && (line.charAt(line.length() - 3) == 'l')
                    && (line.charAt(line.length() - 2) == 's')
                    && (line.charAt(line.length() - 1) == 'e')) {
                answer = " " + line.substring(i);
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                nowElse = true;
                checkFlag = false;
            } else if (
                ((i + 3) < line.length())
                    && (this.prependChar == '}')
                    && (line.charAt(i) == 'e')
                    && (line.charAt(i + 1) == 'l')
                    && (line.charAt(i + 2) == 's')
                    && (line.charAt(i + 3) == 'e')
                    && (((i + 3) == line.length())
                        || (line.charAt(i + 4) == '{')
                        || (line.charAt(i + 4) == ' ')
                        || (line.charAt(i + 4) == '\t')
                        || (line.charAt(i + 4) == '\r')
                        || (line.charAt(i + 4) == '\n'))) {
                answer = " " + line.substring(i);
                answer = EE2ECppSharp.deleteSpaceAndComment(answer);
                nowElse = true;
                checkFlag = false;
            }
            break;
        }
        if (0 < answer.length()) {
            this.prependChar = answer.charAt(answer.length() - 1);
        } else {
            this.prependChar = ' ';
        }
        if (is1st && checkFlag) {
            sWriter.write("\n");
        }
        this.prependElse = nowElse;
        sWriter.write(answer);
        return true;
    }
    private boolean prependElse = false;
    private char prependChar = ' ';
    protected String doPlusSpace(String target, String anser) {
        anser = this.doPlusSpaceOne(" ", target, anser);
        anser = this.doPlusSpaceOne("\r", target, anser);
        anser = this.doPlusSpaceOne("\n", target, anser);
        anser = this.doPlusSpaceOne("\t", target, anser);
        return anser;
    }
    protected String doPlusSpaceOne(
        String space,
        String target,
        String anser) {
        while (true) {
            String realTarget = space + target + "(";
            int index = anser.indexOf(realTarget);
            if (index <= 0) {
                break;
            }
            anser =
                anser.substring(0, index + 1)
                    + target
                    + " ("
                    + anser.substring(index + target.length() + 2);
        }
        return anser;
    }
}
