package jp.sourceforge.projects.ee2e.core.relax;

import java.io.*;
import java.net.URL;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>EE2RTemplateList</b> is generated by Relaxer based on ee2e.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="templateList">
 *   <tag>
 *     <attribute name="index" type="string"/>
 *     <attribute name="extention" type="string"/>
 *     <attribute name="name" type="string"/>
 *     <attribute name="type" type="string"/>
 *   </tag>
 *   <sequence>
 *     <ref label="template" occurs="*"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="templateList"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="index" type="string"/&gt;
 *     &lt;attribute name="extention" type="string"/&gt;
 *     &lt;attribute name="name" type="string"/&gt;
 *     &lt;attribute name="type" type="string"/&gt;
 *   &lt;/tag&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="template" occurs="*"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version ee2e.rlx 1.2 (Tue Apr 29 23:33:18 JST 2003)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class EE2RTemplateList implements java.io.Serializable {
    private String index_;
    private String extention_;
    private String name_;
    private String type_;
    // List<EE2RTemplate>
    private java.util.List template_ = new java.util.ArrayList();

    /**
     * Creates a <code>EE2RTemplateList</code>.
     *
     */
    public EE2RTemplateList() {
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EE2RTemplateList(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EE2RTemplateList(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EE2RTemplateList(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EE2RTemplateList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EE2RTemplateList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EE2RTemplateList(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        index_ = URelaxer.getAttributePropertyAsString(element, "index");
        extention_ = URelaxer.getAttributePropertyAsString(element, "extention");
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        template_.clear();
        while (!stack.isEmptyElement()) {
            if (EE2RTemplate.isMatch(stack)) {
                addTemplate(new EE2RTemplate(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("templateList");
        int size;
        if (this.index_ != null) {
            URelaxer.setAttributePropertyByString(element, "index", this.index_);
        }
        if (this.extention_ != null) {
            URelaxer.setAttributePropertyByString(element, "extention", this.extention_);
        }
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        size = this.template_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EE2RTemplateList</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>EE2RTemplateList</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>index</b>.
     *
     * @return String
     */
    public final String getIndex() {
        return (index_);
    }

    /**
     * Sets the String property <b>index</b>.
     *
     * @param index
     */
    public final void setIndex(String index) {
        this.index_ = index;
    }

    /**
     * Gets the String property <b>extention</b>.
     *
     * @return String
     */
    public final String getExtention() {
        return (extention_);
    }

    /**
     * Sets the String property <b>extention</b>.
     *
     * @param extention
     */
    public final void setExtention(String extention) {
        this.extention_ = extention;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the EE2RTemplate property <b>template</b>.
     *
     * @return EE2RTemplate[]
     */
    public final EE2RTemplate[] getTemplate() {
        EE2RTemplate[] array = new EE2RTemplate[template_.size()];
        return ((EE2RTemplate[])template_.toArray(array));
    }

    /**
     * Sets the EE2RTemplate property <b>template</b>.
     *
     * @param template
     */
    public final void setTemplate(EE2RTemplate[] template) {
        this.template_.clear();
        this.template_.addAll(java.util.Arrays.asList(template));
    }

    /**
     * Sets the EE2RTemplate property <b>template</b>.
     *
     * @param template
     */
    public final void setTemplate(EE2RTemplate template) {
        this.template_.clear();
        this.template_.add(template);
    }

    /**
     * Adds the EE2RTemplate property <b>template</b>.
     *
     * @param template
     */
    public final void addTemplate(EE2RTemplate template) {
        this.template_.add(template);
    }

    /**
     * Gets number of the EE2RTemplate property <b>template</b>.
     *
     * @return int
     */
    public final int getTemplateCount() {
        return (template_.size());
    }

    /**
     * Gets the EE2RTemplate property <b>template</b> by index.
     *
     * @param index
     * @return EE2RTemplate
     */
    public final EE2RTemplate getTemplate(int index) {
        return ((EE2RTemplate)template_.get(index));
    }

    /**
     * Sets the EE2RTemplate property <b>template</b> by index.
     *
     * @param index
     * @param template
     */
    public final void setTemplate(int index, EE2RTemplate template) {
        this.template_.set(index, template);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<templateList");
        if (index_ != null) {
            buffer.append(" index=\"");
            buffer.append(URelaxer.escapeAttrQuot(getIndex()));
            buffer.append("\"");
        }
        if (extention_ != null) {
            buffer.append(" extention=\"");
            buffer.append(URelaxer.escapeAttrQuot(getExtention()));
            buffer.append("\"");
        }
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(getName()));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.template_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</templateList>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<templateList");
        if (index_ != null) {
            buffer.print(" index=\"");
            buffer.print(URelaxer.escapeAttrQuot(getIndex()));
            buffer.print("\"");
        }
        if (extention_ != null) {
            buffer.print(" extention=\"");
            buffer.print(URelaxer.escapeAttrQuot(getExtention()));
            buffer.print("\"");
        }
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(getName()));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.template_.size();
        for (int i = 0;i < size;i++) {
            EE2RTemplate value = (EE2RTemplate)this.template_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</templateList>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EE2RTemplateList</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "templateList")) {
            return (false);
        }
        RStack target = new RStack(element);
        while (!target.isEmptyElement()) {
            if (!EE2RTemplate.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTemplateList</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EE2RTemplateList</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
