package jp.sourceforge.projects.ee2e.core.typeset;
import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import jp.sourceforge.projects.ee2e.core.editors.*;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
//
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.*;
import org.eclipse.ui.*;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EPreview implements EE2EMenuBehavior {
    public EE2EPreview() {
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.typeset.preview") + "(&p)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.typeset.preview.tooltip");
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#tabDestroyer(AbstractTextEditor, IDocument, ITextSelection)
     */
    public final void doBehavior(
        AbstractTextEditor editor,
        ITextSelection textSelection)
        throws BadLocationException {
        IWorkbenchPage page =
            PlatformUI
                .getWorkbench()
                .getActiveWorkbenchWindow()
                .getActivePage();

        //
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            System.out.println("Invalid Input: Must be IFileEditorInput");
            return;
        }
        IFileEditorInput fileInput = (IFileEditorInput) editorInput;
        IFile iFile = fileInput.getFile();
        IPath path = iFile.getLocation();
        IWorkspace iWorkSpase = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkSpase.getRoot();
        IFile anserFile = iWorkspaceRoot.getFileForLocation(path);
        try {
            if ((anserFile == null) || (!anserFile.exists())) {
                throw new PartInitException(
                    "File not found (" + path.toFile().toString() + ")");
            }
            this.openEditor(anserFile, page);
            //
        } catch (PartInitException e) {
            DialogUtil.openError(
                page.getWorkbenchWindow().getShell(),
                WorkbenchMessages.getString("OpenWithMenu.dialogTitle"),
                e.getMessage(),
                e);
        }
    }
    protected void openEditor(IFile anserFile, IWorkbenchPage page)
        throws PartInitException {
        IEditorInput input = new FileEditorInput(anserFile);
        page.openEditor(input,IEditorRegistry.SYSTEM_EXTERNAL_EDITOR_ID);
    }
}
