/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.projects.ee2e.core.dedit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class DFileDocumentProvider
extends FileDocumentProvider {
    private static String ascii2native(String srcStr) {
        StringBuffer dstStrBuf = new StringBuffer();
        int i = 0;
        while (i < srcStr.length()) {
            if (srcStr.charAt(i) != '\\') {
                dstStrBuf.append(srcStr.charAt(i));
            } else {
                if (++i >= srcStr.length()) break;
                if (srcStr.charAt(i) != 'u') {
                    dstStrBuf.append('\\').append(srcStr.charAt(i));
                } else {
                    String escStr = srcStr.substring(++i, i + 4);
                    dstStrBuf.append((char)Integer.parseInt(escStr, 16));
                    i += 3;
                }
            }
            ++i;
        }
        return dstStrBuf.toString();
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editorInput).getFile();
            Document doc = new Document();
            super.setDocumentContent((IDocument)doc, file.getContents(false), encoding);
            String srcStr = doc.get();
            String dstStr = DFileDocumentProvider.ascii2native(srcStr);
            document.set(dstStr);
            return true;
        }
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String srcStr = document.get();
        StringBuffer dstStrBuf = new StringBuffer();
        int i = 0;
        while (i < srcStr.length()) {
            char ch = srcStr.charAt(i);
            if (ch <= '\u007f') {
                dstStrBuf.append(ch);
            } else {
                String escStr = "0000" + Integer.toHexString(ch & 0xFFFF);
                dstStrBuf.append("\\u").append(escStr.substring(escStr.length() - 4));
            }
            ++i;
        }
        Document doc = new Document();
        doc.set(dstStrBuf.toString());
        super.doSaveDocument(monitor, element, (IDocument)doc, overwrite);
    }
}

