package jp.sourceforge.projects.ee2e.core.cdt;
import jp.sourceforge.projects.ee2e.core.*;
import jp.sourceforge.projects.ee2e.core.cf.*;
import jp.sourceforge.projects.ee2e.core.editors.*;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECFMake extends EE2ECF implements EE2ECFOterhDistributors {
    public EE2ECFMake() {
        super();
    }
    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#getFactoryName()
     */
    public String getFactoryName() {
        return "make";
    }

	/**
	 * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECFOterhDistributors#isUseable(String)
	 */
    public boolean isUseable(String fileName) {
        EE2EDebug.printf(5, "EE2ECFMake#isUseable");

		if (fileName.indexOf("Makefile") == 0) {
			return true;
		}
		int dotLoc = fileName.indexOf('.');
		String ext;
		if (dotLoc != -1) {
			ext = fileName.substring(dotLoc + 1);
		} else {
			return false;
		}
		if (ext.equalsIgnoreCase("mk")) {
			return true;
		}
		return false;
    }

	/**
	 * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECFOterhDistributors#getEE2ECF()
	 */
    public EE2ECF getEE2ECF() {
        return this;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#tabIndentAction()
     */
    public EE2EIndentBehavior indentAction() {
        if(jb == null) {
            EE2EIndentMake indent = new EE2EIndentMake();
            jb = new EE2EIndentBehavior(indent);
        }
        return jb;
    }
    private EE2EIndentBehavior jb;

	/**
	 * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#tabFormatAction()
	 */
    public EE2EIndentBehavior tabFormatAction() {
    	return null;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#commentRegion()
     */
    public EE2EMenuBehavior commentRegion() {
        return null;
    }
      
    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#unCommentRegion()
     */
    public EE2EMenuBehavior unCommentRegion() {
        return null;
    }
	/**
	 * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#urlJump()
	 */
    public EE2EMenuBehavior urlJump() {
        return null;
    }
}
