package jp.sourceforge.projects.ee2e.core.cf;

import jp.sourceforge.projects.ee2e.core.*;
import jp.sourceforge.projects.ee2e.core.cdt.EE2ECppMiniFormat;
import jp.sourceforge.projects.ee2e.core.editors.*;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentJava;
import jp.sourceforge.projects.ee2e.core.indent.EE2EIndentCppFormat;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates. To enable and disable the
 * creation of type comments go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation.
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECFD extends EE2ECF {
    public EE2ECFD() {
        super();
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#getFactoryName()
     */
    public String getFactoryName() {
        return "d";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#tabIndentAction()
     */
    public EE2EIndentBehavior indentAction() {
        if (jb == null) {
            int indentLen = this.getSize();
            org.eclipse.jface.preference.IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
            boolean isRedundantCircleFlag = store.getBoolean(EE2EPlugin.P_COMPACT_INDENT);
            EE2EIndentJava indent = new EE2EIndentJava(indentLen,isRedundantCircleFlag);
            jb = new EE2EIndentBehavior(indent);
        }
        return jb;
    }

    private EE2EIndentBehavior jb;

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#tabFormatAction()
     */
    public EE2EIndentBehavior tabFormatAction() {
        org.eclipse.jface.preference.IPreferenceStore store = EE2EPlugin.getDefault().getPreferenceStore();
        boolean isRedundantCircleFlag = store.getBoolean(EE2EPlugin.P_COMPACT_INDENT);
        EE2EIndentBehavior behavior = new EE2EIndentCppFormatBehavior(
                new EE2EIndentCppFormat(this.getSize(),isRedundantCircleFlag));
        return behavior;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#commentRegion()
     */
    public EE2EMenuBehavior commentRegion() {
        return null;
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#unCommentRegion()
     */
    public EE2EMenuBehavior unCommentRegion() {
        return new EE2ECppMiniFormat();
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.cdt.editors.EE2ECF#urlJump()
     */
    public EE2EMenuBehavior urlJump() {
        return null;
    }
}