package jp.sourceforge.projects.ee2e.ee.core.preferences;

import java.io.File;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;

import jp.sourceforge.projects.ee2e.ee.core.EEPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class EEPreferencePage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
    public static final String TITLE = "ee.pre.title";
    public static final String P_TAGS_FILE = "ee.pre.file";
    public static final String P_ENCODE = "ee.pre.encode";

	public EEPreferencePage() {
		super(GRID);
		setPreferenceStore(EEPlugin.getDefault().getPreferenceStore());
		setDescription(EEPlugin.getResourceString(TITLE));
		initializeDefaults();
	}
    
    /**
     * Sets the default values of the preferences.
     */
	private void initializeDefaults() {
        initializeStaticDefaults();
	}
    /**
     * Method checkStaticDefaults.
     * @param part
     */
    public static final void checkStaticDefaults() {
        org.eclipse.jface.preference.IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        if ((store.getString(P_TAGS_FILE) == null)
            || store.getString(P_TAGS_FILE).equals("")
            || (store.getString(P_ENCODE) == null)
            || store.getString(P_ENCODE).equals("")) {
            initializeStaticDefaults();
        }
    }
    public static final void initializeStaticDefaults() {
        IPreferenceStore store = EEPlugin.getDefault().getPreferenceStore();
        File fileReal = new File(".");
        String file = fileReal.getAbsolutePath();
        store.setDefault(P_TAGS_FILE,file);
        store.setDefault(P_ENCODE,"ascii");
    }

    /**
     * Creates the field editors. Field editors are abstractions of
     * the common GUI blocks needed to manipulate various types
     * of preferences. Each field editor knows how to save and
     * restore itself.
     */
	public void createFieldEditors() {
        this.addField(new DirectoryFieldEditor(P_TAGS_FILE, 
                EEPlugin.getResourceString(P_TAGS_FILE), getFieldEditorParent()));
        this.addField(new StringFieldEditor(P_ENCODE, 
                EEPlugin.getResourceString(P_ENCODE), getFieldEditorParent()));
	}
	
	public void init(IWorkbench workbench) {
	}
}