/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.QName;
import org.dom4j.io.DispatchHandler;
import xpp.EndTag;
import xpp.StartTag;
import xpp.XmlPullParser;
import xpp.XmlPullParserException;

public class PullParserReader {
    private DocumentFactory factory;
    private XmlPullParser pullParser = new XmlPullParser();
    private StartTag startTag = new StartTag();
    private EndTag endTag = new EndTag();
    private DispatchHandler dispatchHandler;

    public PullParserReader() {
    }

    public PullParserReader(DocumentFactory factory) {
        this.factory = factory;
    }

    protected Element addElement(Branch branch, StartTag startTag) {
        QName qname = this.getQName(startTag.getQName(), startTag.getUri());
        int attributeCount = startTag.getLength();
        Element element = this.factory.createElement(qname);
        int i = 0;
        while (i < attributeCount) {
            String name = startTag.getRawName(i);
            String uri = startTag.getURI(i);
            String value = startTag.getValue(i);
            QName attributeQname = this.getQName(name, uri);
            element.addAttribute(attributeQname, value);
            ++i;
        }
        branch.add(element);
        return element;
    }

    public void addHandler(String path, ElementHandler handler) {
        this.getDispatchHandler().addHandler(path, handler);
    }

    protected void addText(Branch branch, String text) throws DocumentException {
        if (!(branch instanceof Element)) {
            throw new DocumentException("Cannot have text content outside of the root document");
        }
        Element element = (Element)branch;
        element.addText(text);
    }

    protected Reader createReader(InputStream in) throws IOException {
        return new BufferedReader(new InputStreamReader(in));
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    protected QName getQName(String qname, String uri) {
        return this.factory.createQName(qname, uri);
    }

    protected Document parseDocument() throws DocumentException, IOException {
        Document document = this.getDocumentFactory().createDocument();
        try {
            byte type;
            Branch branch = document;
            block8: while (true) {
                type = this.pullParser.next();
                switch (type) {
                    case 1: {
                        return document;
                    }
                    case 4: {
                        String text = this.pullParser.readContent();
                        this.addText(branch, text);
                        continue block8;
                    }
                    case 2: {
                        this.pullParser.readStartTag(this.startTag);
                        branch = this.addElement(branch, this.startTag);
                        continue block8;
                    }
                    case 3: {
                        this.pullParser.readEndTag(this.endTag);
                        if ((branch = branch.getParent()) != null) continue block8;
                        branch = document;
                        continue block8;
                    }
                }
                break;
            }
            throw new DocumentException("Error: unknown PullParser type: " + type);
        }
        catch (XmlPullParserException e) {
            throw new DocumentException(e.getMessage(), e);
        }
    }

    public Document read(File file) throws DocumentException, IOException {
        String systemID = file.getAbsolutePath();
        return this.read(new BufferedReader(new FileReader(file)), systemID);
    }

    public Document read(InputStream in) throws DocumentException, IOException {
        return this.read(this.createReader(in));
    }

    public Document read(InputStream in, String systemID) throws DocumentException, IOException {
        return this.read(this.createReader(in), systemID);
    }

    public Document read(Reader reader) throws DocumentException, IOException {
        this.pullParser.setInput(reader);
        return this.parseDocument();
    }

    public Document read(Reader reader, String systemID) throws DocumentException, IOException {
        Document document = this.read(reader);
        document.setName(systemID);
        return document;
    }

    public Document read(String systemID) throws DocumentException, IOException {
        if (systemID.indexOf(58) >= 0) {
            return this.read(new URL(systemID));
        }
        return this.read(new File(systemID));
    }

    public Document read(URL url) throws DocumentException, IOException {
        String systemID = url.toExternalForm();
        return this.read(this.createReader(url.openStream()), systemID);
    }

    public Document read(char[] text) throws DocumentException, IOException {
        this.pullParser.setInput(text);
        return this.parseDocument();
    }

    public void removeHandler(String path) {
        this.getDispatchHandler().removeHandler(path);
    }

    public void setDefaultHandler(ElementHandler handler) {
        this.getDispatchHandler().setDefaultHandler(handler);
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    public void setDocumentFactory(DocumentFactory factory) {
        this.factory = factory;
    }
}

