/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class ErrorsTool
implements ViewTool {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpSession session;
    protected MessageResources resources;
    protected Locale locale;
    protected ActionErrors errors;

    public void init(Object object) {
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext viewContext = (ViewContext)object;
        this.request = viewContext.getRequest();
        this.session = this.request.getSession(false);
        this.application = viewContext.getServletContext();
        this.resources = StrutsUtils.getMessageResources(this.application);
        this.locale = StrutsUtils.getLocale(this.request, this.session);
        this.errors = StrutsUtils.getActionErrors(this.request);
    }

    public boolean exist() {
        if (this.errors == null) {
            return false;
        }
        return !this.errors.empty();
    }

    public boolean exist(String string) {
        if (this.errors == null) {
            return false;
        }
        return this.errors.size(string) > 0;
    }

    public int getSize() {
        if (this.errors == null) {
            return 0;
        }
        return this.errors.size();
    }

    public int getSize(String string) {
        if (this.errors == null) {
            return 0;
        }
        return this.errors.size(string);
    }

    public ArrayList getGlobal() {
        return this.get(this.getGlobalName());
    }

    public ArrayList getAll() {
        return this.get(null);
    }

    public ArrayList get(String string) {
        if (this.errors == null || this.errors.empty()) {
            return null;
        }
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        Iterator iterator = string == null ? this.errors.get() : this.errors.get(string);
        if (!iterator.hasNext()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            ActionError actionError = (ActionError)iterator.next();
            String string2 = this.resources.getMessage(this.locale, actionError.getKey(), actionError.getValues());
            if (string2 != null) {
                arrayList.add(string2);
                continue;
            }
            Velocity.warn((Object)("Message for key \"" + actionError.getKey() + "\" could not be found."));
            arrayList.add(actionError.getKey());
        }
        return arrayList;
    }

    public String getMsgs() {
        return StrutsUtils.errorMarkup(null, this.request, this.session, this.application);
    }

    public String getMsgs(String string) {
        return StrutsUtils.errorMarkup(string, this.request, this.session, this.application);
    }

    public String getGlobalName() {
        return StrutsUtils.getGlobalErrorName();
    }
}

