package org.j69.eewiki.wiki;

import org.j69.eewiki.util.UtilComparator;

/**
 * WikiListをタイトルでソートする
 * from mobwiki(mobstar)
 *
 */
public class TitleComparator extends UtilComparator {
    public TitleComparator(String order) {
        super.init(order);
    }

    protected int asc(Object data0, Object data1) {
        return String.CASE_INSENSITIVE_ORDER.compare(
            ((WikiFile)data0).getTitlename(), ((WikiFile)data1).getTitlename());
    }

    protected int desc(Object data0, Object data1) {
        return String.CASE_INSENSITIVE_ORDER.compare(
            ((WikiFile)data1).getTitlename(), ((WikiFile)data0).getTitlename());
    }
}
