/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class ImportSupport {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected boolean isAbsoluteUrl;
    protected static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    protected static final String DEFAULT_ENCODING = "ISO-8859-1";

    /*
     * WARNING - void declaration
     */
    protected String acquireString(String url) throws IOException, Exception {
        RequestDispatcher rd;
        this.isAbsoluteUrl = ImportSupport.isAbsoluteUrl(url);
        if (this.isAbsoluteUrl) {
            int i;
            BufferedReader r = new BufferedReader(this.acquireReader(url));
            StringBuffer sb = new StringBuffer();
            while ((i = r.read()) != -1) {
                void var4_6;
                sb.append((char)var4_6);
            }
            return sb.toString();
        }
        if (!(this.request instanceof HttpServletRequest) || !(this.response instanceof HttpServletResponse)) {
            throw new Exception("Relative import from non-HTTP request not allowed");
        }
        if (!url.startsWith("/")) {
            String sp = this.request.getServletPath();
            url = sp.substring(0, sp.lastIndexOf(47)) + '/' + url;
        }
        if ((rd = this.application.getRequestDispatcher(url = ImportSupport.stripSession(url))) == null) {
            throw new Exception("Couldn't get a RequestDispatcher for \"" + url + "\"");
        }
        ImportResponseWrapper irw = new ImportResponseWrapper(this.response);
        try {
            rd.include((ServletRequest)this.request, (ServletResponse)irw);
        }
        catch (IOException ex) {
            throw new Exception("Problem importing the relative URL \"" + url + "\". " + ex);
        }
        catch (RuntimeException ex) {
            throw new Exception("Problem importing the relative URL \"" + url + "\". " + ex);
        }
        if (irw.getStatus() < 200 || irw.getStatus() > 299) {
            throw new Exception("Invalid response code '" + irw.getStatus() + "' for \"" + url + "\"");
        }
        return irw.getString();
    }

    protected Reader acquireReader(String url) throws IOException, Exception {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString(url));
        }
        try {
            int status;
            String charSet;
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            InputStream i = uc.getInputStream();
            InputStreamReader r = null;
            String contentType = uc.getContentType();
            if (contentType != null) {
                charSet = ImportSupport.getContentTypeAttribute(contentType, "charset");
                if (charSet == null) {
                    charSet = DEFAULT_ENCODING;
                }
            } else {
                charSet = DEFAULT_ENCODING;
            }
            try {
                r = new InputStreamReader(i, charSet);
            }
            catch (Exception ex) {
                r = new InputStreamReader(i, DEFAULT_ENCODING);
            }
            if (uc instanceof HttpURLConnection && ((status = ((HttpURLConnection)uc).getResponseCode()) < 200 || status > 299)) {
                throw new Exception(status + " " + url);
            }
            return r;
        }
        catch (IOException ex) {
            throw new Exception("Problem accessing the absolute URL \"" + url + "\". " + ex);
        }
        catch (RuntimeException ex) {
            throw new Exception("Problem accessing the absolute URL \"" + url + "\". " + ex);
        }
    }

    public static boolean isAbsoluteUrl(String url) {
        if (url == null) {
            return false;
        }
        int colonPos = url.indexOf(":");
        if (colonPos == -1) {
            return false;
        }
        int i = 0;
        while (i < colonPos) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static String stripSession(String url) {
        int sessionStart;
        StringBuffer u = new StringBuffer(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1) {
            void var2_2;
            int sessionEnd = u.toString().indexOf(";", (int)(var2_2 + true));
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", (int)(var2_2 + true));
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete((int)var2_2, sessionEnd);
        }
        return u.toString();
    }

    public static String getContentTypeAttribute(String input, String name) {
        int end;
        int begin;
        int index = input.toUpperCase().indexOf(name.toUpperCase());
        if (index == -1) {
            return null;
        }
        index += name.length();
        if ((index = input.indexOf(61, index)) == -1) {
            return null;
        }
        if ((input = input.substring(++index).trim()).charAt(0) == '\"') {
            begin = 1;
            end = input.indexOf(34, begin);
            if (end == -1) {
                return null;
            }
        } else {
            begin = 0;
            end = input.indexOf(59);
            if (end == -1) {
                end = input.indexOf(32);
            }
            if (end == -1) {
                end = input.length();
            }
        }
        return input.substring(begin, end).trim();
    }

    protected class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;

        public ImportResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() {
            if (this.isStreamUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getWriter(), then getOutputStream()");
            }
            this.isWriterUsed = true;
            this.sw = new StringWriter();
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getOutputStream(), then getWriter()");
            }
            this.isStreamUsed = true;
            this.bos = new ByteArrayOutputStream();
            ServletOutputStream sos = new ServletOutputStream(this){
                private final /* synthetic */ ImportResponseWrapper this$1;
                {
                    this.this$1 = this$1;
                }

                public void write(int b) throws IOException {
                    ImportResponseWrapper.access$000(this.this$1).write(b);
                }
            };
            return sos;
        }

        public void setContentType(String x) {
        }

        public void setLocale(Locale x) {
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                return this.bos.toString(ImportSupport.DEFAULT_ENCODING);
            }
            return "";
        }

        static /* synthetic */ ByteArrayOutputStream access$000(ImportResponseWrapper x0) {
            return x0.bos;
        }
    }
}

