/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;
import org.apache.velocity.util.SimplePool;

public class VelocityViewServlet
extends HttpServlet {
    public static final String CONTENT_TYPE = "default.contentType";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String DEFAULT_OUTPUT_ENCODING = "ISO-8859-1";
    public static final String SERVLET_CONTEXT_KEY = (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = VelocityViewServlet.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext).getName();
    protected static final String TOOLBOX_KEY = "org.apache.velocity.toolbox";
    protected static final String INIT_PROPS_KEY = "org.apache.velocity.properties";
    protected ToolboxManager toolboxManager = null;
    private static SimplePool writerPool = new SimplePool(40);
    private String defaultContentType;
    private boolean warnOfOutputStreamDeprecation = true;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$ServletLogger;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$servlet$WebappLoader;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initVelocity(config);
        this.initToolbox(config);
        this.defaultContentType = RuntimeSingleton.getString((String)CONTENT_TYPE, (String)DEFAULT_CONTENT_TYPE);
        String encoding = RuntimeSingleton.getString((String)"output.encoding", (String)DEFAULT_OUTPUT_ENCODING);
        if (!DEFAULT_OUTPUT_ENCODING.equalsIgnoreCase(encoding)) {
            int index = this.defaultContentType.lastIndexOf("charset");
            if (index < 0) {
                this.defaultContentType = this.defaultContentType + "; charset=" + encoding;
            } else {
                Velocity.warn((Object)"VelocityViewServlet: Charset was already specified in the Content-Type property.  Output encoding property will be ignored.");
            }
        }
        Velocity.info((Object)("VelocityViewServlet: Default content-type is: " + this.defaultContentType));
    }

    protected void initToolbox(ServletConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        String file = config.getInitParameter(TOOLBOX_KEY);
        if (file == null || file.length() == 0) {
            file = servletContext.getInitParameter(TOOLBOX_KEY);
        }
        if (file != null) {
            this.toolboxManager = ServletToolboxManager.getInstance(servletContext, file);
        } else {
            Velocity.info((Object)"VelocityViewServlet: No toolbox entry in configuration.");
        }
    }

    protected void initVelocity(ServletConfig config) throws ServletException {
        Velocity.setApplicationAttribute((Object)SERVLET_CONTEXT_KEY, (Object)this.getServletContext());
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)(class$org$apache$velocity$tools$view$servlet$ServletLogger == null ? (class$org$apache$velocity$tools$view$servlet$ServletLogger = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.ServletLogger")) : class$org$apache$velocity$tools$view$servlet$ServletLogger).getName());
        Velocity.setProperty((String)"resource.loader", (Object)"webapp");
        Velocity.setProperty((String)"webapp.resource.loader.class", (Object)(class$org$apache$velocity$tools$view$servlet$WebappLoader == null ? (class$org$apache$velocity$tools$view$servlet$WebappLoader = VelocityViewServlet.class$("org.apache.velocity.tools.view.servlet.WebappLoader")) : class$org$apache$velocity$tools$view$servlet$WebappLoader).getName());
        try {
            ExtendedProperties p = this.loadConfiguration(config);
            Velocity.setExtendedProperties((ExtendedProperties)p);
        }
        catch (Exception e) {
            this.getServletContext().log("VelocityViewServlet: Unable to read Velocity configuration file: " + e);
            this.getServletContext().log("VelocityViewServlet: Using default Velocity configuration.");
        }
        try {
            Velocity.init();
        }
        catch (Exception e) {
            this.getServletContext().log("VelocityViewServlet: PANIC! unable to init() - " + e);
            throw new ServletException((Throwable)e);
        }
    }

    protected ExtendedProperties loadConfiguration(ServletConfig config) throws IOException {
        ServletContext servletContext = config.getServletContext();
        String propsFile = config.getInitParameter(INIT_PROPS_KEY);
        if (propsFile == null || propsFile.length() == 0) {
            propsFile = servletContext.getInitParameter(INIT_PROPS_KEY);
        }
        ExtendedProperties p = new ExtendedProperties();
        if (propsFile != null) {
            p.load(servletContext.getResourceAsStream(propsFile));
            Velocity.info((Object)("VelocityViewServlet: Custom Properties File: " + propsFile));
        } else {
            Velocity.info((Object)"VelocityViewServlet: No custom properties found. Using default Velocity configuration.");
        }
        return p;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context context = null;
        try {
            try {
                context = this.createContext(request, response);
                this.setContentType(request, response);
                Template template = this.handleRequest(request, response, context);
                if (template == null) {
                    Velocity.warn((Object)"VelocityViewServlet: couldn't find template to match request.");
                    Object var6_6 = null;
                    this.requestCleanup(request, response, context);
                    return;
                }
                this.mergeTemplate(template, context, response);
            }
            catch (Exception e) {
                Velocity.error((Object)("VelocityViewServlet: Exception processing the template: " + e));
                this.error(request, response, e);
                Object var6_8 = null;
                this.requestCleanup(request, response, context);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.requestCleanup(request, response, context);
            throw throwable;
        }
        Object var6_7 = null;
        this.requestCleanup(request, response, context);
    }

    protected void requestCleanup(HttpServletRequest request, HttpServletResponse response, Context context) {
    }

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = request.getServletPath();
        }
        return this.getTemplate(path);
    }

    protected void setContentType(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.defaultContentType);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        ChainedContext ctx = new ChainedContext(null, request, response, this.getServletContext());
        if (this.toolboxManager != null) {
            ctx.setToolbox(this.toolboxManager.getToolboxContext(ctx));
        }
        return ctx;
    }

    public Template getTemplate(String name) throws ResourceNotFoundException, ParseErrorException, Exception {
        return RuntimeSingleton.getTemplate((String)name);
    }

    public Template getTemplate(String name, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        return RuntimeSingleton.getTemplate((String)name, (String)encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        VelocityWriter vw = null;
        Writer writer = this.getResponseWriter(response);
        try {
            vw = (VelocityWriter)writerPool.get();
            if (vw == null) {
                vw = new VelocityWriter(writer, 4096, true);
            } else {
                vw.recycle(writer);
            }
            template.merge(context, (Writer)vw);
        }
        finally {
            if (vw != null) {
                try {
                    vw.flush();
                    vw.recycle(null);
                    writerPool.put((Object)vw);
                }
                catch (Exception e) {
                    Velocity.debug((Object)("VelocityViewServlet: Trouble releasing VelocityWriter: " + e.getMessage()));
                }
            }
        }
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException {
        try {
            StringBuffer html = new StringBuffer();
            html.append("<html>\n");
            html.append("<head><title>Error</title></head>\n");
            html.append("<body>\n");
            html.append("<h2>VelocityViewServlet : Error processing the template</h2>\n");
            Throwable cause = e;
            String why = cause.getMessage();
            if (why != null && why.trim().length() > 0) {
                html.append(why);
                html.append("\n<br>\n");
            }
            if (cause instanceof MethodInvocationException) {
                cause = ((MethodInvocationException)cause).getWrappedThrowable();
            }
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            html.append("<pre>\n");
            html.append(sw.toString());
            html.append("</pre>\n");
            html.append("</body>\n");
            html.append("</html>");
            this.getResponseWriter(response).write(html.toString());
        }
        catch (Exception e2) {
            Velocity.error((Object)("VelocityViewServlet: Exception while printing error screen: " + e2));
            throw new ServletException((Throwable)e);
        }
    }

    protected Writer getResponseWriter(HttpServletResponse response) throws UnsupportedEncodingException, IOException {
        Writer writer = null;
        try {
            writer = response.getWriter();
        }
        catch (IllegalStateException e) {
            String encoding;
            if (this.warnOfOutputStreamDeprecation) {
                this.warnOfOutputStreamDeprecation = false;
                Velocity.warn((Object)"VelocityViewServlet: Use of ServletResponse's getOutputStream() method with VelocityViewServlet is deprecated -- support will be removed in an upcoming release");
            }
            if ((encoding = response.getCharacterEncoding()) == null) {
                encoding = DEFAULT_OUTPUT_ENCODING;
            }
            writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
        }
        return writer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

