/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import javax.servlet.ServletRequest;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class ParameterParser
implements ViewTool {
    private ServletRequest request;
    static /* synthetic */ Class class$org$apache$velocity$tools$view$context$ViewContext;
    static /* synthetic */ Class class$javax$servlet$ServletRequest;

    public ParameterParser() {
    }

    public ParameterParser(ServletRequest request) {
        this.setRequest(request);
    }

    public void init(Object obj) {
        if (obj instanceof ViewContext) {
            this.setRequest((ServletRequest)((ViewContext)obj).getRequest());
        } else if (obj instanceof ServletRequest) {
            this.setRequest((ServletRequest)obj);
        } else {
            throw new IllegalArgumentException("Was expecting " + (class$org$apache$velocity$tools$view$context$ViewContext == null ? (class$org$apache$velocity$tools$view$context$ViewContext = ParameterParser.class$("org.apache.velocity.tools.view.context.ViewContext")) : class$org$apache$velocity$tools$view$context$ViewContext) + " or " + (class$javax$servlet$ServletRequest == null ? (class$javax$servlet$ServletRequest = ParameterParser.class$("javax.servlet.ServletRequest")) : class$javax$servlet$ServletRequest));
        }
    }

    protected void setRequest(ServletRequest request) {
        this.request = request;
    }

    protected ServletRequest getRequest() {
        if (this.request == null) {
            throw new UnsupportedOperationException("Request is null. ParameterParser must be initialized first!");
        }
        return this.request;
    }

    public boolean exists(String key) {
        return this.getString(key) != null;
    }

    public String get(String key) {
        return this.getString(key);
    }

    public String getString(String key) {
        return this.getRequest().getParameter(key);
    }

    public String getString(String key, String alternate) {
        String s = this.getString(key);
        return s != null ? s : alternate;
    }

    public Boolean getBoolean(String key) {
        String s = this.getString(key);
        return s != null ? Boolean.valueOf(s) : null;
    }

    public boolean getBoolean(String key, boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Boolean getBoolean(String key, Boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Number getNumber(String key) {
        String s = this.getString(key);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return this.parseNumber(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Number getNumber(String key, Number alternate) {
        Number n = this.getNumber(key);
        return n != null ? (Number)n : (Number)alternate;
    }

    public int getInt(String key, int alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.intValue() : alternate;
    }

    public double getDouble(String key, double alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.doubleValue() : alternate;
    }

    public String[] getStrings(String key) {
        return this.getRequest().getParameterValues(key);
    }

    public Number[] getNumbers(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Number[] nums = new Number[strings.length];
        try {
            int i = 0;
            while (i < nums.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    nums[i] = this.parseNumber(strings[i]);
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return nums;
    }

    public int[] getInts(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        int[] ints = new int[strings.length];
        try {
            int i = 0;
            while (i < ints.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    ints[i] = this.parseNumber(strings[i]).intValue();
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return ints;
    }

    public double[] getDoubles(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        double[] doubles = new double[strings.length];
        try {
            int i = 0;
            while (i < doubles.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    doubles[i] = this.parseNumber(strings[i]).doubleValue();
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return doubles;
    }

    protected Number parseNumber(String value) throws NumberFormatException {
        if (value.indexOf(46) >= 0) {
            return new Double(value);
        }
        return new Long(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

