package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;

/**
 * DiffAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-15-2003
 *
 * XDoclet definition:
 * @struts:action validate="true"
 * @struts:action-forward name="/pages/Viewpage.vm" path="/pages/Viewpage.vm"
 */
public class DiffAction extends Action {

    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //Wiki作成
        String pid = request.getParameter("pid");
        Wiki wiki = new Wiki(pid, request, msg);

        //表示するコンテンツのタイプとコンテンツを設定
        request.setAttribute("contentType", "diff");
        request.setAttribute("content" , wiki);

//TODO　ここのソースなんか汚いので後で整理すること
        String diffResult = wiki.diffWiki();
        if (diffResult.equals(null) || diffResult.equals("")) {
            diffResult = msg.getMessage(request.getLocale(), "error.nodiff", "");
        }
        
        String appendstr = msg.getMessage(request.getLocale(), "caption.append", "");
        String deletestr = msg.getMessage(request.getLocale(), "caption.delete", "");
        String ret = msg.getMessage(request.getLocale(), "caption.return", "");

		String viewPath = request.getContextPath() + "/Viewpage.do";

		//差分
        String tmpHeader = "<ul><li><a href=" + viewPath + "?pid=" + pid + ">"
                                  + WebUtil.getDecodeFileName(pid) + "</a>"+ ret + "</li></ul>";
        tmpHeader = tmpHeader + "<ul><li><span class=\"diff_removed\">" + deletestr + "</span></li></ul>";
        tmpHeader = tmpHeader + "<ul><li><span class=\"diff_added\">" + appendstr + "</span></li></ul><hr>";

        diffResult = tmpHeader + diffResult;

		//生データの取得
        String dum = wiki.getContents();
        String rawdata = WebUtil.escapeChar(wiki.getCachePage(1));
        
        //行番号の追加
		String[] rawdatas = rawdata.split("\n");
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < rawdatas.length; i++) {
			int lineno = i + 1;
			sb.append(lineno + ": " + rawdatas[i] + "\n"); 	        
		}
		
		diffResult = diffResult + "<hr><pre>" + sb.toString() + "</pre>";
		request.setAttribute("diff" , diffResult);

        return mapping.findForward(FORWARD_View);
    }

}
